// components/remote_cocoa/common/application.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/remote_cocoa/common/application.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/application.mojom-params-data.h"
#include "components/remote_cocoa/common/application.mojom-shared-message-ids.h"

#include "components/remote_cocoa/common/application.mojom-import-headers.h"
#include "components/remote_cocoa/common/application.mojom-test-utils.h"


namespace remote_cocoa::mojom {
// The declaration includes the definition on other builds.

StubInterface::IPCStableHashFunction StubInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StubInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

StubInterfaceProxy::StubInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool StubInterfaceStubDispatch::Accept(
    StubInterface* impl,
    mojo::Message* message) {
  return false;
}

// static
bool StubInterfaceStubDispatch::AcceptWithResponder(
    StubInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool StubInterfaceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::remote_cocoa::mojom::StubInterface::Name_,
    {});
}

// The declaration includes the definition on other builds.

Application::IPCStableHashFunction Application::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Application>(message.name())) {
    case messages::Application::kCreateAlert: {
      return &Application::CreateAlert_Sym::IPCStableHash;
    }
    case messages::Application::kCreateNativeWidgetNSWindow: {
      return &Application::CreateNativeWidgetNSWindow_Sym::IPCStableHash;
    }
    case messages::Application::kCreateRenderWidgetHostNSView: {
      return &Application::CreateRenderWidgetHostNSView_Sym::IPCStableHash;
    }
    case messages::Application::kCreateSystemMediaControlsBridge: {
      return &Application::CreateSystemMediaControlsBridge_Sym::IPCStableHash;
    }
    case messages::Application::kCreateWebContentsNSView: {
      return &Application::CreateWebContentsNSView_Sym::IPCStableHash;
    }
    case messages::Application::kForwardCutCopyPaste: {
      return &Application::ForwardCutCopyPaste_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Application::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Application>(message.name())) {
      case messages::Application::kCreateAlert:
            return "Receive remote_cocoa::mojom::Application::CreateAlert";
      case messages::Application::kCreateNativeWidgetNSWindow:
            return "Receive remote_cocoa::mojom::Application::CreateNativeWidgetNSWindow";
      case messages::Application::kCreateRenderWidgetHostNSView:
            return "Receive remote_cocoa::mojom::Application::CreateRenderWidgetHostNSView";
      case messages::Application::kCreateSystemMediaControlsBridge:
            return "Receive remote_cocoa::mojom::Application::CreateSystemMediaControlsBridge";
      case messages::Application::kCreateWebContentsNSView:
            return "Receive remote_cocoa::mojom::Application::CreateWebContentsNSView";
      case messages::Application::kForwardCutCopyPaste:
            return "Receive remote_cocoa::mojom::Application::ForwardCutCopyPaste";
    }
  } else {
    switch (static_cast<messages::Application>(message.name())) {
      case messages::Application::kCreateAlert:
            return "Receive reply remote_cocoa::mojom::Application::CreateAlert";
      case messages::Application::kCreateNativeWidgetNSWindow:
            return "Receive reply remote_cocoa::mojom::Application::CreateNativeWidgetNSWindow";
      case messages::Application::kCreateRenderWidgetHostNSView:
            return "Receive reply remote_cocoa::mojom::Application::CreateRenderWidgetHostNSView";
      case messages::Application::kCreateSystemMediaControlsBridge:
            return "Receive reply remote_cocoa::mojom::Application::CreateSystemMediaControlsBridge";
      case messages::Application::kCreateWebContentsNSView:
            return "Receive reply remote_cocoa::mojom::Application::CreateWebContentsNSView";
      case messages::Application::kForwardCutCopyPaste:
            return "Receive reply remote_cocoa::mojom::Application::ForwardCutCopyPaste";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Application::CreateAlert_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14c55bd7;  // IPCStableHash for remote_cocoa::mojom::Application::CreateAlert
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Application::CreateNativeWidgetNSWindow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60288453;  // IPCStableHash for remote_cocoa::mojom::Application::CreateNativeWidgetNSWindow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Application::CreateRenderWidgetHostNSView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4fd9c66;  // IPCStableHash for remote_cocoa::mojom::Application::CreateRenderWidgetHostNSView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Application::CreateSystemMediaControlsBridge_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97eb96a5;  // IPCStableHash for remote_cocoa::mojom::Application::CreateSystemMediaControlsBridge
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Application::CreateWebContentsNSView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0be3d839;  // IPCStableHash for remote_cocoa::mojom::Application::CreateWebContentsNSView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Application::ForwardCutCopyPaste_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca32c082;  // IPCStableHash for remote_cocoa::mojom::Application::ForwardCutCopyPaste
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ApplicationProxy::ApplicationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ApplicationProxy::CreateAlert(
    ::mojo::PendingReceiver<::remote_cocoa::mojom::AlertBridge> in_alert_bridge_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::Application::CreateAlert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alert_bridge_receiver"), in_alert_bridge_receiver,
                        "<value of type ::mojo::PendingReceiver<::remote_cocoa::mojom::AlertBridge>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Application::kCreateAlert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::Application_CreateAlert_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::remote_cocoa::mojom::AlertBridgeInterfaceBase>>(
    in_alert_bridge_receiver,
    &params->alert_bridge_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->alert_bridge_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid alert_bridge_receiver in Application.CreateAlert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Application::Name_);
  message.set_method_name("CreateAlert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ApplicationProxy::CreateNativeWidgetNSWindow(
    uint64_t in_bridge_id, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::NativeWidgetNSWindow> in_window_receiver, ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::NativeWidgetNSWindowHost> in_host, ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::TextInputHost> in_text_input_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::Application::CreateNativeWidgetNSWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bridge_id"), in_bridge_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_receiver"), in_window_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::NativeWidgetNSWindow>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::NativeWidgetNSWindowHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_input_host"), in_text_input_host,
                        "<value of type ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::TextInputHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Application::kCreateNativeWidgetNSWindow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::Application_CreateNativeWidgetNSWindow_Params_Data> params(
          message);
  params.Allocate();

  params->bridge_id = in_bridge_id;

  
  mojo::internal::Serialize<::remote_cocoa::mojom::NativeWidgetNSWindowAssociatedRequestDataView>(
    in_window_receiver,
    &params->window_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->window_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid window_receiver in Application.CreateNativeWidgetNSWindow request");

  
  mojo::internal::Serialize<::remote_cocoa::mojom::NativeWidgetNSWindowHostAssociatedPtrInfoDataView>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid host in Application.CreateNativeWidgetNSWindow request");

  
  mojo::internal::Serialize<::remote_cocoa::mojom::TextInputHostAssociatedPtrInfoDataView>(
    in_text_input_host,
    &params->text_input_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->text_input_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid text_input_host in Application.CreateNativeWidgetNSWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Application::Name_);
  message.set_method_name("CreateNativeWidgetNSWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ApplicationProxy::CreateRenderWidgetHostNSView(
    uint64_t in_view_id, ::mojo::PendingAssociatedRemote<StubInterface> in_host, ::mojo::PendingAssociatedReceiver<StubInterface> in_view_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::Application::CreateRenderWidgetHostNSView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_id"), in_view_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingAssociatedRemote<StubInterface>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_receiver"), in_view_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<StubInterface>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Application::kCreateRenderWidgetHostNSView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::Application_CreateRenderWidgetHostNSView_Params_Data> params(
          message);
  params.Allocate();

  params->view_id = in_view_id;

  
  mojo::internal::Serialize<::remote_cocoa::mojom::StubInterfaceAssociatedPtrInfoDataView>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid host in Application.CreateRenderWidgetHostNSView request");

  
  mojo::internal::Serialize<::remote_cocoa::mojom::StubInterfaceAssociatedRequestDataView>(
    in_view_receiver,
    &params->view_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->view_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid view_receiver in Application.CreateRenderWidgetHostNSView request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Application::Name_);
  message.set_method_name("CreateRenderWidgetHostNSView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ApplicationProxy::CreateSystemMediaControlsBridge(
    ::mojo::PendingReceiver<::system_media_controls::mojom::SystemMediaControls> in_receiver, ::mojo::PendingRemote<::system_media_controls::mojom::SystemMediaControlsObserver> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::Application::CreateSystemMediaControlsBridge", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::system_media_controls::mojom::SystemMediaControls>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingRemote<::system_media_controls::mojom::SystemMediaControlsObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Application::kCreateSystemMediaControlsBridge), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::Application_CreateSystemMediaControlsBridge_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::system_media_controls::mojom::SystemMediaControlsInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Application.CreateSystemMediaControlsBridge request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::system_media_controls::mojom::SystemMediaControlsObserverInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in Application.CreateSystemMediaControlsBridge request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Application::Name_);
  message.set_method_name("CreateSystemMediaControlsBridge");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ApplicationProxy::CreateWebContentsNSView(
    uint64_t in_view_id, ::mojo::PendingAssociatedRemote<StubInterface> in_host, ::mojo::PendingAssociatedReceiver<StubInterface> in_view_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::Application::CreateWebContentsNSView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_id"), in_view_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingAssociatedRemote<StubInterface>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_receiver"), in_view_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<StubInterface>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Application::kCreateWebContentsNSView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::Application_CreateWebContentsNSView_Params_Data> params(
          message);
  params.Allocate();

  params->view_id = in_view_id;

  
  mojo::internal::Serialize<::remote_cocoa::mojom::StubInterfaceAssociatedPtrInfoDataView>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid host in Application.CreateWebContentsNSView request");

  
  mojo::internal::Serialize<::remote_cocoa::mojom::StubInterfaceAssociatedRequestDataView>(
    in_view_receiver,
    &params->view_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->view_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid view_receiver in Application.CreateWebContentsNSView request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Application::Name_);
  message.set_method_name("CreateWebContentsNSView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ApplicationProxy::ForwardCutCopyPaste(
    CutCopyPasteCommand in_command) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::Application::ForwardCutCopyPaste", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command"), in_command,
                        "<value of type CutCopyPasteCommand>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Application::kForwardCutCopyPaste), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::Application_ForwardCutCopyPaste_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::CutCopyPasteCommand>(
    in_command,
    &params->command);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Application::Name_);
  message.set_method_name("ForwardCutCopyPaste");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ApplicationStubDispatch::Accept(
    Application* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Application>(message->header()->name)) {
    case messages::Application::kCreateAlert: {
      DCHECK(message->is_serialized());
      internal::Application_CreateAlert_Params_Data* params =
          reinterpret_cast<internal::Application_CreateAlert_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Application.0
      bool success = true;
      ::mojo::PendingReceiver<::remote_cocoa::mojom::AlertBridge> p_alert_bridge_receiver{};
      Application_CreateAlert_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_alert_bridge_receiver =
            input_data_view.TakeAlertBridgeReceiver<decltype(p_alert_bridge_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Application::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAlert(        
        std::move(p_alert_bridge_receiver));
      return true;
    }
    case messages::Application::kCreateNativeWidgetNSWindow: {
      DCHECK(message->is_serialized());
      internal::Application_CreateNativeWidgetNSWindow_Params_Data* params =
          reinterpret_cast<internal::Application_CreateNativeWidgetNSWindow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Application.1
      bool success = true;
      uint64_t p_bridge_id{};
      ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::NativeWidgetNSWindow> p_window_receiver{};
      ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::NativeWidgetNSWindowHost> p_host{};
      ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::TextInputHost> p_text_input_host{};
      Application_CreateNativeWidgetNSWindow_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bridge_id = input_data_view.bridge_id();
      if (success) {
        p_window_receiver =
            input_data_view.TakeWindowReceiver<decltype(p_window_receiver)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success) {
        p_text_input_host =
            input_data_view.TakeTextInputHost<decltype(p_text_input_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Application::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNativeWidgetNSWindow(        
        std::move(p_bridge_id), 
        std::move(p_window_receiver), 
        std::move(p_host), 
        std::move(p_text_input_host));
      return true;
    }
    case messages::Application::kCreateRenderWidgetHostNSView: {
      DCHECK(message->is_serialized());
      internal::Application_CreateRenderWidgetHostNSView_Params_Data* params =
          reinterpret_cast<internal::Application_CreateRenderWidgetHostNSView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Application.2
      bool success = true;
      uint64_t p_view_id{};
      ::mojo::PendingAssociatedRemote<StubInterface> p_host{};
      ::mojo::PendingAssociatedReceiver<StubInterface> p_view_receiver{};
      Application_CreateRenderWidgetHostNSView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_view_id = input_data_view.view_id();
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success) {
        p_view_receiver =
            input_data_view.TakeViewReceiver<decltype(p_view_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Application::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRenderWidgetHostNSView(        
        std::move(p_view_id), 
        std::move(p_host), 
        std::move(p_view_receiver));
      return true;
    }
    case messages::Application::kCreateSystemMediaControlsBridge: {
      DCHECK(message->is_serialized());
      internal::Application_CreateSystemMediaControlsBridge_Params_Data* params =
          reinterpret_cast<internal::Application_CreateSystemMediaControlsBridge_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Application.3
      bool success = true;
      ::mojo::PendingReceiver<::system_media_controls::mojom::SystemMediaControls> p_receiver{};
      ::mojo::PendingRemote<::system_media_controls::mojom::SystemMediaControlsObserver> p_host{};
      Application_CreateSystemMediaControlsBridge_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Application::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSystemMediaControlsBridge(        
        std::move(p_receiver), 
        std::move(p_host));
      return true;
    }
    case messages::Application::kCreateWebContentsNSView: {
      DCHECK(message->is_serialized());
      internal::Application_CreateWebContentsNSView_Params_Data* params =
          reinterpret_cast<internal::Application_CreateWebContentsNSView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Application.4
      bool success = true;
      uint64_t p_view_id{};
      ::mojo::PendingAssociatedRemote<StubInterface> p_host{};
      ::mojo::PendingAssociatedReceiver<StubInterface> p_view_receiver{};
      Application_CreateWebContentsNSView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_view_id = input_data_view.view_id();
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success) {
        p_view_receiver =
            input_data_view.TakeViewReceiver<decltype(p_view_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Application::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebContentsNSView(        
        std::move(p_view_id), 
        std::move(p_host), 
        std::move(p_view_receiver));
      return true;
    }
    case messages::Application::kForwardCutCopyPaste: {
      DCHECK(message->is_serialized());
      internal::Application_ForwardCutCopyPaste_Params_Data* params =
          reinterpret_cast<internal::Application_ForwardCutCopyPaste_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Application.5
      bool success = true;
      CutCopyPasteCommand p_command{};
      Application_ForwardCutCopyPaste_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommand(&p_command))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Application::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardCutCopyPaste(        
        std::move(p_command));
      return true;
    }
  }
  return false;
}

// static
bool ApplicationStubDispatch::AcceptWithResponder(
    Application* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Application>(message->header()->name)) {
    case messages::Application::kCreateAlert: {
      break;
    }
    case messages::Application::kCreateNativeWidgetNSWindow: {
      break;
    }
    case messages::Application::kCreateRenderWidgetHostNSView: {
      break;
    }
    case messages::Application::kCreateSystemMediaControlsBridge: {
      break;
    }
    case messages::Application::kCreateWebContentsNSView: {
      break;
    }
    case messages::Application::kForwardCutCopyPaste: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kApplicationValidationInfo[] = {
    { &internal::Application_CreateAlert_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Application_CreateNativeWidgetNSWindow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Application_CreateRenderWidgetHostNSView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Application_CreateSystemMediaControlsBridge_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Application_CreateWebContentsNSView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Application_ForwardCutCopyPaste_Params_Data::Validate,
     nullptr /* no response */},
};

bool ApplicationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::Application::Name_,
    kApplicationValidationInfo);
}



}  // remote_cocoa::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {


StubInterfaceAsyncWaiter::StubInterfaceAsyncWaiter(
    StubInterface* proxy) : proxy_(proxy) {}

StubInterfaceAsyncWaiter::~StubInterfaceAsyncWaiter() = default;





void ApplicationInterceptorForTesting::CreateAlert(::mojo::PendingReceiver<::remote_cocoa::mojom::AlertBridge> alert_bridge_receiver) {
  GetForwardingInterface()->CreateAlert(
    std::move(alert_bridge_receiver)
    );
}
void ApplicationInterceptorForTesting::CreateNativeWidgetNSWindow(uint64_t bridge_id, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::NativeWidgetNSWindow> window_receiver, ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::NativeWidgetNSWindowHost> host, ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::TextInputHost> text_input_host) {
  GetForwardingInterface()->CreateNativeWidgetNSWindow(
    std::move(bridge_id)
    , 
    std::move(window_receiver)
    , 
    std::move(host)
    , 
    std::move(text_input_host)
    );
}
void ApplicationInterceptorForTesting::CreateRenderWidgetHostNSView(uint64_t view_id, ::mojo::PendingAssociatedRemote<StubInterface> host, ::mojo::PendingAssociatedReceiver<StubInterface> view_receiver) {
  GetForwardingInterface()->CreateRenderWidgetHostNSView(
    std::move(view_id)
    , 
    std::move(host)
    , 
    std::move(view_receiver)
    );
}
void ApplicationInterceptorForTesting::CreateSystemMediaControlsBridge(::mojo::PendingReceiver<::system_media_controls::mojom::SystemMediaControls> receiver, ::mojo::PendingRemote<::system_media_controls::mojom::SystemMediaControlsObserver> host) {
  GetForwardingInterface()->CreateSystemMediaControlsBridge(
    std::move(receiver)
    , 
    std::move(host)
    );
}
void ApplicationInterceptorForTesting::CreateWebContentsNSView(uint64_t view_id, ::mojo::PendingAssociatedRemote<StubInterface> host, ::mojo::PendingAssociatedReceiver<StubInterface> view_receiver) {
  GetForwardingInterface()->CreateWebContentsNSView(
    std::move(view_id)
    , 
    std::move(host)
    , 
    std::move(view_receiver)
    );
}
void ApplicationInterceptorForTesting::ForwardCutCopyPaste(CutCopyPasteCommand command) {
  GetForwardingInterface()->ForwardCutCopyPaste(
    std::move(command)
    );
}
ApplicationAsyncWaiter::ApplicationAsyncWaiter(
    Application* proxy) : proxy_(proxy) {}

ApplicationAsyncWaiter::~ApplicationAsyncWaiter() = default;







}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif