import 'chrome://resources/js/action_link.js';
import './policy_conflict.js';
import '/strings.m.js';
import { CustomElement } from 'chrome://resources/js/custom_element.js';
import type { Conflict } from './policy_conflict.js';
export interface Policy {
    ignored?: boolean;
    name: string;
    level: string;
    link?: string;
    scope: string;
    source: string;
    error: string;
    warning: string;
    info: string;
    value: any;
    deprecated?: boolean;
    future?: boolean;
    allSourcesMerged?: boolean;
    conflicts?: Conflict[];
    superseded?: Conflict[];
    forSigninScreen: boolean;
    isExtension: boolean;
    status: string;
}
export declare class PolicyRowElement extends CustomElement {
    static get template(): string | TrustedHTML;
    policy: Policy;
    private unset_;
    private hasErrors_;
    private hasWarnings_;
    private hasInfos_;
    private hasConflicts_;
    private hasSuperseded_;
    private isMergedValue_;
    private deprecated_;
    private future_;
    connectedCallback(): void;
    initialize(policy: Policy): void;
    private copyValue_;
    private toggleExpanded;
}
declare global {
    interface HTMLElementTagNameMap {
        'policy-row': PolicyRowElement;
    }
}
