import '/strings.m.js';
import 'chrome://resources/js/action_link.js';
import './status_box.js';
import './policy_table.js';
import './policy_promotion.js';
import type { Policy } from './policy_row.js';
import type { PolicyTableElement, PolicyTableModel } from './policy_table.js';
export interface PolicyNamesResponse {
    [id: string]: {
        name: string;
        policyNames: NonNullable<string[]>;
    };
}
export interface PolicyValues {
    [id: string]: {
        name: string;
        policies: {
            [name: string]: Policy;
        };
        precedenceOrder?: string[];
    };
}
export interface PolicyValuesResponse {
    policyIds: string[];
    policyValues: PolicyValues;
}
export declare class Page {
    mainSection: Element;
    policyTables: {
        [id: string]: PolicyTableElement;
    };
    constructor();
    /**
     * Main initialization function. Called by the browser on page load.
     */
    initialize(): void;
    private onPoliciesReceived_;
    /**
     * Sets up event listeners for the more actions dropdown menu.
     *
     * The dropdown menu is opened when the more actions button is clicked.
     * The menu items are focused in order when the arrow keys are pressed.
     * HOME and END keys are used to focus the first and last menu items
     * respectively.
     * The menu is closed when the escape key is pressed.
     */
    private setupMoreActionsMenuNavigation_;
    /**
     * Creates a toast notification with 2 second timeout at bottom of the page.
     * The notification is also announced to screen readers.
     */
    createToast(content: string): void;
    downloadJson(json: string): void;
    createOrUpdatePolicyTable(dataModel: PolicyTableModel): void;
    /**
     * Update the status section of the page to show the current cloud policy
     * status.
     * Status is the dictionary containing the current policy status.
     */
    setStatus(status: {
        [key: string]: any;
    }): void;
    /**
     * Re-enable the reload policies button when the previous request to reload
     * policies values has completed.
     */
    reloadPoliciesDone(): void;
    /**
     * Show report button if it's `enabled` by the policy. Exclude CrOS as there
     * are multiple report on CrOS but the button doesn't support all of them so
     * far.
     */
    updateReportButton(enabled: boolean): void;
    static getInstance(): Page;
}
