// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{sanitizeInnerHtml}from"chrome://resources/js/parse_html_subset.js";import{getTemplate}from"./status_box.html.js";export class StatusBoxElement extends CustomElement{static get template(){return getTemplate()}setLabelAndShow(labelName,labelValue,needsToBeShown=true){const labelElement=this.shadowRoot.querySelector(labelName);labelElement.textContent=labelValue?" "+labelValue:"";if(needsToBeShown){labelElement.parentElement.hidden=false}}setLabelInnerHtmlAndShow(labelName,labelValue,needsToBeShown=true){const labelElement=this.shadowRoot.querySelector(labelName);labelElement.innerHTML=sanitizeInnerHtml(` ${labelValue}`);if(needsToBeShown){labelElement.parentElement.hidden=false}}initialize(scope,status){const notSpecifiedString=loadTimeData.getString("notSpecified");this.shadowRoot.querySelector(".status-box-heading").textContent=loadTimeData.getString(status.policyDescriptionKey);if(status.flexOrgWarning){this.setLabelInnerHtmlAndShow(".warning",loadTimeData.getString("statusFlexOrgNoPolicy"),true);return}if(scope==="device"){this.setLabelAndShow(".asset-id",status.assetId||notSpecifiedString);this.setLabelAndShow(".location",status.location||notSpecifiedString);this.setLabelAndShow(".directory-api-id",status.directoryApiId||notSpecifiedString);this.setLabelAndShow(".client-id",status.clientId);if(status.isOffHoursActive!=null){this.setLabelAndShow(".is-offhours-active",loadTimeData.getString(status.isOffHoursActive?"offHoursActive":"offHoursNotActive"))}}else if(scope==="machine"){this.setLabelAndShow(".machine-enrollment-device-id",status.deviceId);this.setLabelAndShow(".machine-enrollment-token",status.enrollmentToken);if(status.machine){this.setLabelAndShow(".machine-enrollment-name",status.machine)}this.setLabelAndShow(".machine-enrollment-domain",status.domain)}else if(scope==="updater"){if(status.version){this.setLabelAndShow(".version",status.version)}if(status.domain){this.setLabelAndShow(".machine-enrollment-domain",status.domain)}}else if(status.enrollmentToken){this.setLabelAndShow(".machine-enrollment-domain",status.domain);this.setLabelAndShow(".machine-enrollment-token",status.enrollmentToken);this.setLabelAndShow(".client-id",status.clientId);this.setLabelAndShow(".profile-id",status.profileId)}else{this.setLabelAndShow(".username",status.username);this.setLabelAndShow(".gaia-id",status.gaiaId||notSpecifiedString);this.setLabelAndShow(".client-id",status.clientId);this.setLabelAndShow(".profile-id",status.profileId);if(status.isAffiliated!=null){this.setLabelAndShow(".is-affiliated",loadTimeData.getString(status.isAffiliated?"isAffiliatedYes":"isAffiliatedNo"))}}if(status.enterpriseDomainManager){this.setLabelAndShow(".managed-by",status.enterpriseDomainManager)}if(status.timeSinceLastFetchAttempt){this.setLabelAndShow(".time-since-last-fetch-attempt",status.timeSinceLastFetchAttempt)}if(status.timeSinceLastRefresh){this.setLabelAndShow(".time-since-last-refresh",status.timeSinceLastRefresh)}if(scope!=="updater"){if(status.refreshInterval){this.setLabelAndShow(".refresh-interval",status.refreshInterval)}this.setLabelAndShow(".status",status.status);this.setLabelAndShow(".policy-push",loadTimeData.getString(status.policiesPushAvailable?"policiesPushOn":"policiesPushOff"))}if(status.lastCloudReportSentTimestamp){this.setLabelAndShow(".last-cloud-report-sent-timestamp",status.lastCloudReportSentTimestamp+" ("+status.timeSinceLastCloudReportSent+")")}if(status.error){this.setLabelAndShow(".error",loadTimeData.getString("statusErrorManagedNoPolicy"))}}}customElements.define("status-box",StatusBoxElement);