// components/persistent_cache/mojom/persistent_cache.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/persistent_cache/mojom/persistent_cache.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('persistentCache.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../mojo/public/mojom/base/file.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }



  function PendingReadOnlyBackend(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PendingReadOnlyBackend.prototype.initDefaults_ = function() {
    this.dbFile = null;
    this.journalFile = null;
    this.sharedLock = null;
  };
  PendingReadOnlyBackend.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PendingReadOnlyBackend.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingReadOnlyBackend.dbFile
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.ReadOnlyFile, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingReadOnlyBackend.journalFile
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file$.ReadOnlyFile, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingReadOnlyBackend.sharedLock
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, shared_memory$.UnsafeSharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PendingReadOnlyBackend.encodedSize = codec.kStructHeaderSize + 24;

  PendingReadOnlyBackend.decode = function(decoder) {
    var packed;
    var val = new PendingReadOnlyBackend();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dbFile =
        decoder.decodeStructPointer(file$.ReadOnlyFile);
    val.journalFile =
        decoder.decodeStructPointer(file$.ReadOnlyFile);
    val.sharedLock =
        decoder.decodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion);
    return val;
  };

  PendingReadOnlyBackend.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PendingReadOnlyBackend.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.ReadOnlyFile, val.dbFile);
    encoder.encodeStructPointer(file$.ReadOnlyFile, val.journalFile);
    encoder.encodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion, val.sharedLock);
  };
  function PendingReadWriteBackend(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PendingReadWriteBackend.prototype.initDefaults_ = function() {
    this.dbFile = null;
    this.journalFile = null;
    this.walFile = null;
    this.sharedLock = null;
  };
  PendingReadWriteBackend.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PendingReadWriteBackend.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingReadWriteBackend.dbFile
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingReadWriteBackend.journalFile
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingReadWriteBackend.walFile
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, file$.File, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingReadWriteBackend.sharedLock
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, shared_memory$.UnsafeSharedMemoryRegion, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PendingReadWriteBackend.encodedSize = codec.kStructHeaderSize + 32;

  PendingReadWriteBackend.decode = function(decoder) {
    var packed;
    var val = new PendingReadWriteBackend();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dbFile =
        decoder.decodeStructPointer(file$.File);
    val.journalFile =
        decoder.decodeStructPointer(file$.File);
    val.walFile =
        decoder.decodeStructPointer(file$.File);
    val.sharedLock =
        decoder.decodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion);
    return val;
  };

  PendingReadWriteBackend.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PendingReadWriteBackend.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.dbFile);
    encoder.encodeStructPointer(file$.File, val.journalFile);
    encoder.encodeStructPointer(file$.File, val.walFile);
    encoder.encodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion, val.sharedLock);
  };
  exports.PendingReadOnlyBackend = PendingReadOnlyBackend;
  exports.PendingReadWriteBackend = PendingReadWriteBackend;
})();