// components/persistent_cache/mojom/persistent_cache.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/persistent_cache/mojom/persistent_cache.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"


namespace persistent_cache::mojom {
class PendingReadOnlyBackendDataView;

class PendingReadWriteBackendDataView;



}  // persistent_cache::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::persistent_cache::mojom::PendingReadOnlyBackendDataView> {
  using Data = ::persistent_cache::mojom::internal::PendingReadOnlyBackend_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::persistent_cache::mojom::PendingReadWriteBackendDataView> {
  using Data = ::persistent_cache::mojom::internal::PendingReadWriteBackend_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace persistent_cache::mojom {


class PendingReadOnlyBackendDataView {
 public:
  PendingReadOnlyBackendDataView() = default;

  PendingReadOnlyBackendDataView(
      internal::PendingReadOnlyBackend_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDbFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDbFile(UserType* output) {
    
    auto* pointer = data_->db_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetJournalFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJournalFile(UserType* output) {
    
    auto* pointer = data_->journal_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetSharedLockDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedLock(UserType* output) {
    
    auto* pointer = data_->shared_lock.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PendingReadOnlyBackend_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PendingReadWriteBackendDataView {
 public:
  PendingReadWriteBackendDataView() = default;

  PendingReadWriteBackendDataView(
      internal::PendingReadWriteBackend_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDbFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDbFile(UserType* output) {
    
    auto* pointer = data_->db_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  inline void GetJournalFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJournalFile(UserType* output) {
    
    auto* pointer = data_->journal_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  inline void GetWalFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWalFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `wal_file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWalFile` instead "
    "of `ReadWalFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wal_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  inline void GetSharedLockDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedLock(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `shared_lock` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedLock` instead "
    "of `ReadSharedLock if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shared_lock.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PendingReadWriteBackend_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // persistent_cache::mojom

#endif  // COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_DATA_VIEW_H_