// components/performance_manager/public/mojom/web_memory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_SHARED_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/performance_manager/public/mojom/web_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"




#include "components/performance_manager/public/mojom/web_memory.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::performance_manager::mojom::WebMemoryAttribution_Scope>
    : public mojo::internal::EnumHashImpl<::performance_manager::mojom::WebMemoryAttribution_Scope> {};

template <>
struct hash<::performance_manager::mojom::WebMemoryMeasurement_Mode>
    : public mojo::internal::EnumHashImpl<::performance_manager::mojom::WebMemoryMeasurement_Mode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryAttribution_Scope, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::performance_manager::mojom::WebMemoryAttribution_Scope, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::performance_manager::mojom::WebMemoryAttribution_Scope>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryMeasurement_Mode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::performance_manager::mojom::WebMemoryMeasurement_Mode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::performance_manager::mojom::WebMemoryMeasurement_Mode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryAttributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::performance_manager::mojom::WebMemoryAttributionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::performance_manager::mojom::internal::WebMemoryAttribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::performance_manager::mojom::WebMemoryAttribution_Scope>(
      Traits::scope(input),
      &fragment->scope);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    decltype(Traits::src(input)) in_src = Traits::src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->src)::BaseType> src_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_src,
      src_fragment);

    fragment->src.Set(
        src_fragment.is_null() ? nullptr : src_fragment.data());

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
  }

  static bool Deserialize(::performance_manager::mojom::internal::WebMemoryAttribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::performance_manager::mojom::WebMemoryAttributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryBreakdownEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::performance_manager::mojom::WebMemoryBreakdownEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::performance_manager::mojom::internal::WebMemoryBreakdownEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::memory(input)) in_memory = Traits::memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->memory)::BaseType> memory_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_memory,
      memory_fragment);

    fragment->memory.Set(
        memory_fragment.is_null() ? nullptr : memory_fragment.data());

    decltype(Traits::canvas_memory(input)) in_canvas_memory = Traits::canvas_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->canvas_memory)::BaseType> canvas_memory_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_canvas_memory,
      canvas_memory_fragment);

    fragment->canvas_memory.Set(
        canvas_memory_fragment.is_null() ? nullptr : canvas_memory_fragment.data());

    decltype(Traits::attribution(input)) in_attribution = Traits::attribution(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution)::BaseType>
        attribution_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& attribution_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::performance_manager::mojom::WebMemoryAttributionDataView>>(
      in_attribution,
      attribution_fragment,
      &attribution_validate_params);

    fragment->attribution.Set(
        attribution_fragment.is_null() ? nullptr : attribution_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attribution.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attribution in WebMemoryBreakdownEntry struct");
  }

  static bool Deserialize(::performance_manager::mojom::internal::WebMemoryBreakdownEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::performance_manager::mojom::WebMemoryBreakdownEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryMeasurementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::performance_manager::mojom::WebMemoryMeasurementDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::performance_manager::mojom::internal::WebMemoryMeasurement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::breakdown(input)) in_breakdown = Traits::breakdown(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->breakdown)::BaseType>
        breakdown_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& breakdown_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::performance_manager::mojom::WebMemoryBreakdownEntryDataView>>(
      in_breakdown,
      breakdown_fragment,
      &breakdown_validate_params);

    fragment->breakdown.Set(
        breakdown_fragment.is_null() ? nullptr : breakdown_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->breakdown.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null breakdown in WebMemoryMeasurement struct");

    decltype(Traits::detached_memory(input)) in_detached_memory = Traits::detached_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->detached_memory)::BaseType> detached_memory_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_detached_memory,
      detached_memory_fragment);

    fragment->detached_memory.Set(
        detached_memory_fragment.is_null() ? nullptr : detached_memory_fragment.data());

    decltype(Traits::shared_memory(input)) in_shared_memory = Traits::shared_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_memory)::BaseType> shared_memory_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_shared_memory,
      shared_memory_fragment);

    fragment->shared_memory.Set(
        shared_memory_fragment.is_null() ? nullptr : shared_memory_fragment.data());

    decltype(Traits::blink_memory(input)) in_blink_memory = Traits::blink_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blink_memory)::BaseType> blink_memory_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_blink_memory,
      blink_memory_fragment);

    fragment->blink_memory.Set(
        blink_memory_fragment.is_null() ? nullptr : blink_memory_fragment.data());
  }

  static bool Deserialize(::performance_manager::mojom::internal::WebMemoryMeasurement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::performance_manager::mojom::WebMemoryMeasurementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace performance_manager::mojom {

inline void WebMemoryAttributionDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebMemoryAttributionDataView::GetSrcDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->src.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebMemoryAttributionDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebMemoryBreakdownEntryDataView::GetMemoryDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->memory.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void WebMemoryBreakdownEntryDataView::GetCanvasMemoryDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->canvas_memory.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void WebMemoryBreakdownEntryDataView::GetAttributionDataView(
    mojo::ArrayDataView<WebMemoryAttributionDataView>* output) {
  auto pointer = data_->attribution.Get();
  *output = mojo::ArrayDataView<WebMemoryAttributionDataView>(pointer, message_);
}


inline void WebMemoryMeasurementDataView::GetBreakdownDataView(
    mojo::ArrayDataView<WebMemoryBreakdownEntryDataView>* output) {
  auto pointer = data_->breakdown.Get();
  *output = mojo::ArrayDataView<WebMemoryBreakdownEntryDataView>(pointer, message_);
}
inline void WebMemoryMeasurementDataView::GetDetachedMemoryDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->detached_memory.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void WebMemoryMeasurementDataView::GetSharedMemoryDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->shared_memory.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void WebMemoryMeasurementDataView::GetBlinkMemoryDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->blink_memory.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}



}  // performance_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::performance_manager::mojom::WebMemoryAttribution_Scope> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::performance_manager::mojom::WebMemoryAttribution_Scope value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::performance_manager::mojom::WebMemoryMeasurement_Mode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::performance_manager::mojom::WebMemoryMeasurement_Mode value);
};

} // namespace perfetto

#endif  // COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_SHARED_H_