// components/performance_manager/public/mojom/web_memory.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/performance_manager/public/mojom/web_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"


namespace performance_manager::mojom {
class WebMemoryAttributionDataView;

class WebMemoryBreakdownEntryDataView;

class WebMemoryMeasurementDataView;



}  // performance_manager::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::performance_manager::mojom::WebMemoryAttributionDataView> {
  using Data = ::performance_manager::mojom::internal::WebMemoryAttribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::performance_manager::mojom::WebMemoryBreakdownEntryDataView> {
  using Data = ::performance_manager::mojom::internal::WebMemoryBreakdownEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::performance_manager::mojom::WebMemoryMeasurementDataView> {
  using Data = ::performance_manager::mojom::internal::WebMemoryMeasurement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace performance_manager::mojom {


enum class WebMemoryAttribution_Scope : int32_t {
  
  kCrossOriginAggregated = 0,
  
  kWindow = 1,
  
  kDedicatedWorker = 2,
  
  kServiceWorker = 3,
  
  kSharedWorker = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, WebMemoryAttribution_Scope value);
inline bool IsKnownEnumValue(WebMemoryAttribution_Scope value) {
  return internal::WebMemoryAttribution_Scope_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebMemoryMeasurement_Mode : int32_t {
  
  kDefault = 0,
  
  kEager = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, WebMemoryMeasurement_Mode value);
inline bool IsKnownEnumValue(WebMemoryMeasurement_Mode value) {
  return internal::WebMemoryMeasurement_Mode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class WebMemoryAttributionDataView {
 public:
  WebMemoryAttributionDataView() = default;

  WebMemoryAttributionDataView(
      internal::WebMemoryAttribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) const {
    auto data_value = data_->scope;
    return mojo::internal::Deserialize<::performance_manager::mojom::WebMemoryAttribution_Scope>(
        data_value, output);
  }
  WebMemoryAttribution_Scope scope() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::performance_manager::mojom::WebMemoryAttribution_Scope>(data_->scope));
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSrcDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `src` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSrc` instead "
    "of `ReadSrc if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebMemoryAttribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebMemoryBreakdownEntryDataView {
 public:
  WebMemoryBreakdownEntryDataView() = default;

  WebMemoryBreakdownEntryDataView(
      internal::WebMemoryBreakdownEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMemoryDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ByteCountDataView, UserType>(),
    "Attempting to read the optional `memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMemory` instead "
    "of `ReadMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->memory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetCanvasMemoryDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCanvasMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ByteCountDataView, UserType>(),
    "Attempting to read the optional `canvas_memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCanvasMemory` instead "
    "of `ReadCanvasMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->canvas_memory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetAttributionDataView(
      mojo::ArrayDataView<WebMemoryAttributionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttribution(UserType* output) {
    
    auto* pointer = data_->attribution.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::performance_manager::mojom::WebMemoryAttributionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::WebMemoryBreakdownEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebMemoryMeasurementDataView {
 public:
  WebMemoryMeasurementDataView() = default;

  WebMemoryMeasurementDataView(
      internal::WebMemoryMeasurement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBreakdownDataView(
      mojo::ArrayDataView<WebMemoryBreakdownEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBreakdown(UserType* output) {
    
    auto* pointer = data_->breakdown.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::performance_manager::mojom::WebMemoryBreakdownEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetDetachedMemoryDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetachedMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ByteCountDataView, UserType>(),
    "Attempting to read the optional `detached_memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetachedMemory` instead "
    "of `ReadDetachedMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->detached_memory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetSharedMemoryDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ByteCountDataView, UserType>(),
    "Attempting to read the optional `shared_memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedMemory` instead "
    "of `ReadSharedMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shared_memory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetBlinkMemoryDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlinkMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ByteCountDataView, UserType>(),
    "Attempting to read the optional `blink_memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlinkMemory` instead "
    "of `ReadBlinkMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blink_memory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebMemoryMeasurement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // performance_manager::mojom

#endif  // COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_DATA_VIEW_H_