// components/performance_manager/public/mojom/web_memory.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_BLINK_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/performance_manager/public/mojom/web_memory.mojom-features.h"  // IWYU pragma: export
#include "components/performance_manager/public/mojom/web_memory.mojom-shared.h"  // IWYU pragma: export
#include "components/performance_manager/public/mojom/web_memory.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_count.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace performance_manager::mojom::blink {





class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) WebMemoryAttribution {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebMemoryAttribution, T>::value>;
  using DataView = WebMemoryAttributionDataView;
  using Data_ = internal::WebMemoryAttribution_Data;
  using Scope = WebMemoryAttribution_Scope;

  template <typename... Args>
  static WebMemoryAttributionPtr New(Args&&... args) {
    return WebMemoryAttributionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebMemoryAttributionPtr From(const U& u) {
    return mojo::TypeConverter<WebMemoryAttributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebMemoryAttribution>::Convert(*this);
  }


  WebMemoryAttribution();

  WebMemoryAttribution(
      WebMemoryAttribution::Scope scope,
      const ::blink::String& url,
      const ::blink::String& src,
      const ::blink::String& id);


  ~WebMemoryAttribution();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebMemoryAttributionPtr>
  WebMemoryAttributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryAttribution::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryAttribution::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebMemoryAttribution::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebMemoryAttribution_UnserializedMessageContext<
            UserType, WebMemoryAttribution::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebMemoryAttribution::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebMemoryAttribution::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebMemoryAttribution_UnserializedMessageContext<
            UserType, WebMemoryAttribution::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebMemoryAttribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebMemoryAttribution::Scope scope;
  
  ::blink::String url;
  
  ::blink::String src;
  
  ::blink::String id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) WebMemoryBreakdownEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebMemoryBreakdownEntry, T>::value>;
  using DataView = WebMemoryBreakdownEntryDataView;
  using Data_ = internal::WebMemoryBreakdownEntry_Data;

  template <typename... Args>
  static WebMemoryBreakdownEntryPtr New(Args&&... args) {
    return WebMemoryBreakdownEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebMemoryBreakdownEntryPtr From(const U& u) {
    return mojo::TypeConverter<WebMemoryBreakdownEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebMemoryBreakdownEntry>::Convert(*this);
  }


  WebMemoryBreakdownEntry();

  WebMemoryBreakdownEntry(
      std::optional<::base::ByteCount> memory,
      std::optional<::base::ByteCount> canvas_memory,
      ::blink::Vector<WebMemoryAttributionPtr> attribution);

WebMemoryBreakdownEntry(const WebMemoryBreakdownEntry&) = delete;
WebMemoryBreakdownEntry& operator=(const WebMemoryBreakdownEntry&) = delete;

  ~WebMemoryBreakdownEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebMemoryBreakdownEntryPtr>
  WebMemoryBreakdownEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryBreakdownEntry::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryBreakdownEntry::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebMemoryBreakdownEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebMemoryBreakdownEntry_UnserializedMessageContext<
            UserType, WebMemoryBreakdownEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebMemoryBreakdownEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebMemoryBreakdownEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebMemoryBreakdownEntry_UnserializedMessageContext<
            UserType, WebMemoryBreakdownEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebMemoryBreakdownEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::ByteCount> memory;
  
  std::optional<::base::ByteCount> canvas_memory;
  
  ::blink::Vector<WebMemoryAttributionPtr> attribution;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) WebMemoryMeasurement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebMemoryMeasurement, T>::value>;
  using DataView = WebMemoryMeasurementDataView;
  using Data_ = internal::WebMemoryMeasurement_Data;
  using Mode = WebMemoryMeasurement_Mode;

  template <typename... Args>
  static WebMemoryMeasurementPtr New(Args&&... args) {
    return WebMemoryMeasurementPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebMemoryMeasurementPtr From(const U& u) {
    return mojo::TypeConverter<WebMemoryMeasurementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebMemoryMeasurement>::Convert(*this);
  }


  WebMemoryMeasurement();

  WebMemoryMeasurement(
      ::blink::Vector<WebMemoryBreakdownEntryPtr> breakdown,
      std::optional<::base::ByteCount> detached_memory,
      std::optional<::base::ByteCount> shared_memory,
      std::optional<::base::ByteCount> blink_memory);

WebMemoryMeasurement(const WebMemoryMeasurement&) = delete;
WebMemoryMeasurement& operator=(const WebMemoryMeasurement&) = delete;

  ~WebMemoryMeasurement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebMemoryMeasurementPtr>
  WebMemoryMeasurementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryMeasurement::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryMeasurement::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebMemoryMeasurement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebMemoryMeasurement_UnserializedMessageContext<
            UserType, WebMemoryMeasurement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebMemoryMeasurement::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebMemoryMeasurement::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebMemoryMeasurement_UnserializedMessageContext<
            UserType, WebMemoryMeasurement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebMemoryMeasurement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<WebMemoryBreakdownEntryPtr> breakdown;
  
  std::optional<::base::ByteCount> detached_memory;
  
  std::optional<::base::ByteCount> shared_memory;
  
  std::optional<::base::ByteCount> blink_memory;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebMemoryAttributionPtr WebMemoryAttribution::Clone() const {
  return New(
      mojo::Clone(scope),
      mojo::Clone(url),
      mojo::Clone(src),
      mojo::Clone(id)
  );
}

template <typename T, WebMemoryAttribution::EnableIfSame<T>*>
bool WebMemoryAttribution::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, WebMemoryAttribution::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.src < rhs.src)
    return true;
  if (rhs.src < lhs.src)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
WebMemoryBreakdownEntryPtr WebMemoryBreakdownEntry::Clone() const {
  return New(
      mojo::Clone(memory),
      mojo::Clone(canvas_memory),
      mojo::Clone(attribution)
  );
}

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>*>
bool WebMemoryBreakdownEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->memory, other_struct.memory))
    return false;
  if (!mojo::Equals(this->canvas_memory, other_struct.canvas_memory))
    return false;
  if (!mojo::Equals(this->attribution, other_struct.attribution))
    return false;
  return true;
}

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.memory < rhs.memory)
    return true;
  if (rhs.memory < lhs.memory)
    return false;
  if (lhs.canvas_memory < rhs.canvas_memory)
    return true;
  if (rhs.canvas_memory < lhs.canvas_memory)
    return false;
  if (lhs.attribution < rhs.attribution)
    return true;
  if (rhs.attribution < lhs.attribution)
    return false;
  return false;
}
template <typename StructPtrType>
WebMemoryMeasurementPtr WebMemoryMeasurement::Clone() const {
  return New(
      mojo::Clone(breakdown),
      mojo::Clone(detached_memory),
      mojo::Clone(shared_memory),
      mojo::Clone(blink_memory)
  );
}

template <typename T, WebMemoryMeasurement::EnableIfSame<T>*>
bool WebMemoryMeasurement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->breakdown, other_struct.breakdown))
    return false;
  if (!mojo::Equals(this->detached_memory, other_struct.detached_memory))
    return false;
  if (!mojo::Equals(this->shared_memory, other_struct.shared_memory))
    return false;
  if (!mojo::Equals(this->blink_memory, other_struct.blink_memory))
    return false;
  return true;
}

template <typename T, WebMemoryMeasurement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.breakdown < rhs.breakdown)
    return true;
  if (rhs.breakdown < lhs.breakdown)
    return false;
  if (lhs.detached_memory < rhs.detached_memory)
    return true;
  if (rhs.detached_memory < lhs.detached_memory)
    return false;
  if (lhs.shared_memory < rhs.shared_memory)
    return true;
  if (rhs.shared_memory < lhs.shared_memory)
    return false;
  if (lhs.blink_memory < rhs.blink_memory)
    return true;
  if (rhs.blink_memory < lhs.blink_memory)
    return false;
  return false;
}


}  // performance_manager::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) StructTraits<::performance_manager::mojom::blink::WebMemoryAttribution::DataView,
                                         ::performance_manager::mojom::blink::WebMemoryAttributionPtr> {
  static bool IsNull(const ::performance_manager::mojom::blink::WebMemoryAttributionPtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::blink::WebMemoryAttributionPtr* output) { output->reset(); }

  static decltype(::performance_manager::mojom::blink::WebMemoryAttribution::scope) scope(
      const ::performance_manager::mojom::blink::WebMemoryAttributionPtr& input) {
    return input->scope;
  }

  static const decltype(::performance_manager::mojom::blink::WebMemoryAttribution::url)& url(
      const ::performance_manager::mojom::blink::WebMemoryAttributionPtr& input) {
    return input->url;
  }

  static const decltype(::performance_manager::mojom::blink::WebMemoryAttribution::src)& src(
      const ::performance_manager::mojom::blink::WebMemoryAttributionPtr& input) {
    return input->src;
  }

  static const decltype(::performance_manager::mojom::blink::WebMemoryAttribution::id)& id(
      const ::performance_manager::mojom::blink::WebMemoryAttributionPtr& input) {
    return input->id;
  }

  static bool Read(::performance_manager::mojom::blink::WebMemoryAttribution::DataView input, ::performance_manager::mojom::blink::WebMemoryAttributionPtr* output);
};


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) StructTraits<::performance_manager::mojom::blink::WebMemoryBreakdownEntry::DataView,
                                         ::performance_manager::mojom::blink::WebMemoryBreakdownEntryPtr> {
  static bool IsNull(const ::performance_manager::mojom::blink::WebMemoryBreakdownEntryPtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::blink::WebMemoryBreakdownEntryPtr* output) { output->reset(); }

  static const decltype(::performance_manager::mojom::blink::WebMemoryBreakdownEntry::memory)& memory(
      const ::performance_manager::mojom::blink::WebMemoryBreakdownEntryPtr& input) {
    return input->memory;
  }

  static const decltype(::performance_manager::mojom::blink::WebMemoryBreakdownEntry::canvas_memory)& canvas_memory(
      const ::performance_manager::mojom::blink::WebMemoryBreakdownEntryPtr& input) {
    return input->canvas_memory;
  }

  static const decltype(::performance_manager::mojom::blink::WebMemoryBreakdownEntry::attribution)& attribution(
      const ::performance_manager::mojom::blink::WebMemoryBreakdownEntryPtr& input) {
    return input->attribution;
  }

  static bool Read(::performance_manager::mojom::blink::WebMemoryBreakdownEntry::DataView input, ::performance_manager::mojom::blink::WebMemoryBreakdownEntryPtr* output);
};


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) StructTraits<::performance_manager::mojom::blink::WebMemoryMeasurement::DataView,
                                         ::performance_manager::mojom::blink::WebMemoryMeasurementPtr> {
  static bool IsNull(const ::performance_manager::mojom::blink::WebMemoryMeasurementPtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::blink::WebMemoryMeasurementPtr* output) { output->reset(); }

  static const decltype(::performance_manager::mojom::blink::WebMemoryMeasurement::breakdown)& breakdown(
      const ::performance_manager::mojom::blink::WebMemoryMeasurementPtr& input) {
    return input->breakdown;
  }

  static const decltype(::performance_manager::mojom::blink::WebMemoryMeasurement::detached_memory)& detached_memory(
      const ::performance_manager::mojom::blink::WebMemoryMeasurementPtr& input) {
    return input->detached_memory;
  }

  static const decltype(::performance_manager::mojom::blink::WebMemoryMeasurement::shared_memory)& shared_memory(
      const ::performance_manager::mojom::blink::WebMemoryMeasurementPtr& input) {
    return input->shared_memory;
  }

  static const decltype(::performance_manager::mojom::blink::WebMemoryMeasurement::blink_memory)& blink_memory(
      const ::performance_manager::mojom::blink::WebMemoryMeasurementPtr& input) {
    return input->blink_memory;
  }

  static bool Read(::performance_manager::mojom::blink::WebMemoryMeasurement::DataView input, ::performance_manager::mojom::blink::WebMemoryMeasurementPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_BLINK_H_