// components/performance_manager/public/mojom/v8_contexts.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_V8_CONTEXTS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_V8_CONTEXTS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/performance_manager/public/mojom/v8_contexts.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace performance_manager::mojom {
class IframeAttributionDataDataView;

class V8ContextDescriptionDataView;



}  // performance_manager::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::performance_manager::mojom::IframeAttributionDataDataView> {
  using Data = ::performance_manager::mojom::internal::IframeAttributionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::performance_manager::mojom::V8ContextDescriptionDataView> {
  using Data = ::performance_manager::mojom::internal::V8ContextDescription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace performance_manager::mojom {


enum class V8ContextWorldType : int32_t {
  
  kMain = 0,
  
  kWorkerOrWorklet = 1,
  
  kShadowRealm = 2,
  
  kExtension = 3,
  
  kIsolated = 4,
  
  kInspector = 5,
  
  kRegExp = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, V8ContextWorldType value);
inline bool IsKnownEnumValue(V8ContextWorldType value) {
  return internal::V8ContextWorldType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class IframeAttributionDataDataView {
 public:
  IframeAttributionDataDataView() = default;

  IframeAttributionDataDataView(
      internal::IframeAttributionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSrcDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `src` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSrc` instead "
    "of `ReadSrc if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::IframeAttributionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class V8ContextDescriptionDataView {
 public:
  V8ContextDescriptionDataView() = default;

  V8ContextDescriptionDataView(
      internal::V8ContextDescription_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::V8ContextTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::blink::mojom::V8ContextTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWorldType(UserType* output) const {
    auto data_value = data_->world_type;
    return mojo::internal::Deserialize<::performance_manager::mojom::V8ContextWorldType>(
        data_value, output);
  }
  V8ContextWorldType world_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::performance_manager::mojom::V8ContextWorldType>(data_->world_type));
  }
  inline void GetWorldNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorldName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `world_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWorldName` instead "
    "of `ReadWorldName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->world_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExecutionContextTokenDataView(
      ::blink::mojom::ExecutionContextTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExecutionContextToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ExecutionContextTokenDataView, UserType>(),
    "Attempting to read the optional `execution_context_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExecutionContextToken` instead "
    "of `ReadExecutionContextToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->execution_context_token.is_null() ? &data_->execution_context_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::ExecutionContextTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::V8ContextDescription_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // performance_manager::mojom

#endif  // COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_V8_CONTEXTS_MOJOM_DATA_VIEW_H_