// components/performance_manager/public/mojom/v8_contexts.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_V8_CONTEXTS_MOJOM_BLINK_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_V8_CONTEXTS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/performance_manager/public/mojom/v8_contexts.mojom-features.h"  // IWYU pragma: export
#include "components/performance_manager/public/mojom/v8_contexts.mojom-shared.h"  // IWYU pragma: export
#include "components/performance_manager/public/mojom/v8_contexts.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace performance_manager::mojom::blink {





class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) IframeAttributionData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IframeAttributionData, T>::value>;
  using DataView = IframeAttributionDataDataView;
  using Data_ = internal::IframeAttributionData_Data;

  template <typename... Args>
  static IframeAttributionDataPtr New(Args&&... args) {
    return IframeAttributionDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IframeAttributionDataPtr From(const U& u) {
    return mojo::TypeConverter<IframeAttributionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IframeAttributionData>::Convert(*this);
  }


  IframeAttributionData();

  IframeAttributionData(
      const ::blink::String& id,
      const ::blink::String& src);


  ~IframeAttributionData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IframeAttributionDataPtr>
  IframeAttributionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IframeAttributionData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IframeAttributionData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IframeAttributionData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IframeAttributionData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IframeAttributionData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IframeAttributionData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IframeAttributionData_UnserializedMessageContext<
            UserType, IframeAttributionData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IframeAttributionData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IframeAttributionData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IframeAttributionData_UnserializedMessageContext<
            UserType, IframeAttributionData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IframeAttributionData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String id;
  
  ::blink::String src;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IframeAttributionData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IframeAttributionData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IframeAttributionData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IframeAttributionData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) V8ContextDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<V8ContextDescription, T>::value>;
  using DataView = V8ContextDescriptionDataView;
  using Data_ = internal::V8ContextDescription_Data;

  template <typename... Args>
  static V8ContextDescriptionPtr New(Args&&... args) {
    return V8ContextDescriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static V8ContextDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<V8ContextDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, V8ContextDescription>::Convert(*this);
  }


  V8ContextDescription();

  V8ContextDescription(
      const ::blink::V8ContextToken& token,
      V8ContextWorldType world_type,
      const ::blink::String& world_name,
      const std::optional<::blink::ExecutionContextToken>& execution_context_token);


  ~V8ContextDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = V8ContextDescriptionPtr>
  V8ContextDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, V8ContextDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, V8ContextDescription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, V8ContextDescription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        V8ContextDescription::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        V8ContextDescription::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        V8ContextDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::V8ContextDescription_UnserializedMessageContext<
            UserType, V8ContextDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<V8ContextDescription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return V8ContextDescription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::V8ContextDescription_UnserializedMessageContext<
            UserType, V8ContextDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<V8ContextDescription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::V8ContextToken token;
  
  V8ContextWorldType world_type;
  
  ::blink::String world_name;
  
  std::optional<::blink::ExecutionContextToken> execution_context_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, V8ContextDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, V8ContextDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, V8ContextDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, V8ContextDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IframeAttributionDataPtr IframeAttributionData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(src)
  );
}

template <typename T, IframeAttributionData::EnableIfSame<T>*>
bool IframeAttributionData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  return true;
}

template <typename T, IframeAttributionData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.src < rhs.src)
    return true;
  if (rhs.src < lhs.src)
    return false;
  return false;
}
template <typename StructPtrType>
V8ContextDescriptionPtr V8ContextDescription::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(world_type),
      mojo::Clone(world_name),
      mojo::Clone(execution_context_token)
  );
}

template <typename T, V8ContextDescription::EnableIfSame<T>*>
bool V8ContextDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->world_type, other_struct.world_type))
    return false;
  if (!mojo::Equals(this->world_name, other_struct.world_name))
    return false;
  if (!mojo::Equals(this->execution_context_token, other_struct.execution_context_token))
    return false;
  return true;
}

template <typename T, V8ContextDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.world_type < rhs.world_type)
    return true;
  if (rhs.world_type < lhs.world_type)
    return false;
  if (lhs.world_name < rhs.world_name)
    return true;
  if (rhs.world_name < lhs.world_name)
    return false;
  if (lhs.execution_context_token < rhs.execution_context_token)
    return true;
  if (rhs.execution_context_token < lhs.execution_context_token)
    return false;
  return false;
}


}  // performance_manager::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) StructTraits<::performance_manager::mojom::blink::IframeAttributionData::DataView,
                                         ::performance_manager::mojom::blink::IframeAttributionDataPtr> {
  static bool IsNull(const ::performance_manager::mojom::blink::IframeAttributionDataPtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::blink::IframeAttributionDataPtr* output) { output->reset(); }

  static const decltype(::performance_manager::mojom::blink::IframeAttributionData::id)& id(
      const ::performance_manager::mojom::blink::IframeAttributionDataPtr& input) {
    return input->id;
  }

  static const decltype(::performance_manager::mojom::blink::IframeAttributionData::src)& src(
      const ::performance_manager::mojom::blink::IframeAttributionDataPtr& input) {
    return input->src;
  }

  static bool Read(::performance_manager::mojom::blink::IframeAttributionData::DataView input, ::performance_manager::mojom::blink::IframeAttributionDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_BLINK) StructTraits<::performance_manager::mojom::blink::V8ContextDescription::DataView,
                                         ::performance_manager::mojom::blink::V8ContextDescriptionPtr> {
  static bool IsNull(const ::performance_manager::mojom::blink::V8ContextDescriptionPtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::blink::V8ContextDescriptionPtr* output) { output->reset(); }

  static const decltype(::performance_manager::mojom::blink::V8ContextDescription::token)& token(
      const ::performance_manager::mojom::blink::V8ContextDescriptionPtr& input) {
    return input->token;
  }

  static decltype(::performance_manager::mojom::blink::V8ContextDescription::world_type) world_type(
      const ::performance_manager::mojom::blink::V8ContextDescriptionPtr& input) {
    return input->world_type;
  }

  static const decltype(::performance_manager::mojom::blink::V8ContextDescription::world_name)& world_name(
      const ::performance_manager::mojom::blink::V8ContextDescriptionPtr& input) {
    return input->world_name;
  }

  static const decltype(::performance_manager::mojom::blink::V8ContextDescription::execution_context_token)& execution_context_token(
      const ::performance_manager::mojom::blink::V8ContextDescriptionPtr& input) {
    return input->execution_context_token;
  }

  static bool Read(::performance_manager::mojom::blink::V8ContextDescription::DataView input, ::performance_manager::mojom::blink::V8ContextDescriptionPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_V8_CONTEXTS_MOJOM_BLINK_H_