// components/performance_manager/public/mojom/coordination_unit.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_COORDINATION_UNIT_MOJOM_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_COORDINATION_UNIT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-features.h"  // IWYU pragma: export
#include "components/performance_manager/public/mojom/coordination_unit.mojom-shared.h"  // IWYU pragma: export
#include "components/performance_manager/public/mojom/coordination_unit.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/process_id.mojom-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "components/performance_manager/public/mojom/lifecycle.mojom-forward.h"
#include "components/performance_manager/public/mojom/v8_contexts.mojom-forward.h"
#include "components/performance_manager/public/mojom/web_memory.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace performance_manager::mojom {

class DocumentCoordinationUnitProxy;

template <typename ImplRefTraits>
class DocumentCoordinationUnitStub;

class DocumentCoordinationUnitRequestValidator;
class DocumentCoordinationUnitResponseValidator;


class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) DocumentCoordinationUnit
    : public DocumentCoordinationUnitInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "performance_manager.mojom.DocumentCoordinationUnit";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DocumentCoordinationUnitInterfaceBase;
  using Proxy_ = DocumentCoordinationUnitProxy;

  template <typename ImplRefTraits>
  using Stub_ = DocumentCoordinationUnitStub<ImplRefTraits>;

  using RequestValidator_ = DocumentCoordinationUnitRequestValidator;
  using ResponseValidator_ = DocumentCoordinationUnitResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetNetworkAlmostIdleMinVersion = 0,
    kSetLifecycleStateMinVersion = 0,
    kSetHasNonEmptyBeforeUnloadMinVersion = 0,
    kSetHadFormInteractionMinVersion = 0,
    kSetHadUserEditsMinVersion = 0,
    kOnStartedUsingWebRTCMinVersion = 0,
    kOnStoppedUsingWebRTCMinVersion = 0,
    kSetIsAdFrameMinVersion = 0,
    kOnNonPersistentNotificationCreatedMinVersion = 0,
    kOnFirstContentfulPaintMinVersion = 0,
    kOnWebMemoryMeasurementRequestedMinVersion = 0,
    kOnFreezingOriginTrialOptOutMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetNetworkAlmostIdle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLifecycleState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHasNonEmptyBeforeUnload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHadFormInteraction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHadUserEdits_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStartedUsingWebRTC_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStoppedUsingWebRTC_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsAdFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNonPersistentNotificationCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFirstContentfulPaint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWebMemoryMeasurementRequested_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFreezingOriginTrialOptOut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DocumentCoordinationUnit() = default;

  virtual void SetNetworkAlmostIdle() = 0;

  virtual void SetLifecycleState(::performance_manager::mojom::LifecycleState state) = 0;

  virtual void SetHasNonEmptyBeforeUnload(bool has_nonempty_beforeunload) = 0;

  virtual void SetHadFormInteraction() = 0;

  virtual void SetHadUserEdits() = 0;

  virtual void OnStartedUsingWebRTC() = 0;

  virtual void OnStoppedUsingWebRTC() = 0;

  virtual void SetIsAdFrame(bool is_ad_frame) = 0;

  virtual void OnNonPersistentNotificationCreated() = 0;

  virtual void OnFirstContentfulPaint(::base::TimeDelta time_since_navigation_start) = 0;

  using OnWebMemoryMeasurementRequestedCallback = base::OnceCallback<void(::performance_manager::mojom::WebMemoryMeasurementPtr)>;
  using OnWebMemoryMeasurementRequestedMojoCallback = base::OnceCallback<void(::performance_manager::mojom::WebMemoryMeasurementPtr)>;

  virtual void OnWebMemoryMeasurementRequested(::performance_manager::mojom::WebMemoryMeasurement::Mode mode, OnWebMemoryMeasurementRequestedCallback callback) = 0;

  virtual void OnFreezingOriginTrialOptOut() = 0;
};

class ProcessCoordinationUnitProxy;

template <typename ImplRefTraits>
class ProcessCoordinationUnitStub;

class ProcessCoordinationUnitRequestValidator;


class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ProcessCoordinationUnit
    : public ProcessCoordinationUnitInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "performance_manager.mojom.ProcessCoordinationUnit";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProcessCoordinationUnitInterfaceBase;
  using Proxy_ = ProcessCoordinationUnitProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProcessCoordinationUnitStub<ImplRefTraits>;

  using RequestValidator_ = ProcessCoordinationUnitRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetMainThreadTaskLoadIsLowMinVersion = 0,
    kOnV8ContextCreatedMinVersion = 0,
    kOnV8ContextDetachedMinVersion = 0,
    kOnV8ContextDestroyedMinVersion = 0,
    kOnRemoteIframeAttachedMinVersion = 0,
    kOnRemoteIframeDetachedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetMainThreadTaskLoadIsLow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnV8ContextCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnV8ContextDetached_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnV8ContextDestroyed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRemoteIframeAttached_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRemoteIframeDetached_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProcessCoordinationUnit() = default;

  virtual void SetMainThreadTaskLoadIsLow(bool main_thread_task_load_is_low) = 0;

  virtual void OnV8ContextCreated(::performance_manager::mojom::V8ContextDescriptionPtr description, ::performance_manager::mojom::IframeAttributionDataPtr iframe_attribution_data) = 0;

  virtual void OnV8ContextDetached(const ::blink::V8ContextToken& v8_context_token) = 0;

  virtual void OnV8ContextDestroyed(const ::blink::V8ContextToken& v8_context_token) = 0;

  virtual void OnRemoteIframeAttached(const ::blink::LocalFrameToken& parent_frame_token, const ::blink::RemoteFrameToken& remote_frame_token, ::performance_manager::mojom::IframeAttributionDataPtr iframe_attribution_data) = 0;

  virtual void OnRemoteIframeDetached(const ::blink::LocalFrameToken& parent_frame_token, const ::blink::RemoteFrameToken& remote_frame_token) = 0;
};

class ChildProcessCoordinationUnitProxy;

template <typename ImplRefTraits>
class ChildProcessCoordinationUnitStub;

class ChildProcessCoordinationUnitRequestValidator;
class ChildProcessCoordinationUnitResponseValidator;


class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ChildProcessCoordinationUnit
    : public ChildProcessCoordinationUnitInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "performance_manager.mojom.ChildProcessCoordinationUnit";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChildProcessCoordinationUnitInterfaceBase;
  using Proxy_ = ChildProcessCoordinationUnitProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChildProcessCoordinationUnitStub<ImplRefTraits>;

  using RequestValidator_ = ChildProcessCoordinationUnitRequestValidator;
  using ResponseValidator_ = ChildProcessCoordinationUnitResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeChildProcessCoordinationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct InitializeChildProcessCoordination_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChildProcessCoordinationUnit() = default;

  using InitializeChildProcessCoordinationCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion, ::base::ReadOnlySharedMemoryRegion)>;
  using InitializeChildProcessCoordinationMojoCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion, ::base::ReadOnlySharedMemoryRegion)>;

  virtual void InitializeChildProcessCoordination(InitializeChildProcessCoordinationCallback callback) = 0;
};



class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) DocumentCoordinationUnitProxy
    : public DocumentCoordinationUnit {
 public:
  using InterfaceType = DocumentCoordinationUnit;

  explicit DocumentCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetNetworkAlmostIdle() final;
  
  void SetLifecycleState(::performance_manager::mojom::LifecycleState state) final;
  
  void SetHasNonEmptyBeforeUnload(bool has_nonempty_beforeunload) final;
  
  void SetHadFormInteraction() final;
  
  void SetHadUserEdits() final;
  
  void OnStartedUsingWebRTC() final;
  
  void OnStoppedUsingWebRTC() final;
  
  void SetIsAdFrame(bool is_ad_frame) final;
  
  void OnNonPersistentNotificationCreated() final;
  
  void OnFirstContentfulPaint(::base::TimeDelta time_since_navigation_start) final;
  
  void OnWebMemoryMeasurementRequested(::performance_manager::mojom::WebMemoryMeasurement::Mode mode, OnWebMemoryMeasurementRequestedCallback callback) final;
  
  void OnFreezingOriginTrialOptOut() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ProcessCoordinationUnitProxy
    : public ProcessCoordinationUnit {
 public:
  using InterfaceType = ProcessCoordinationUnit;

  explicit ProcessCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetMainThreadTaskLoadIsLow(bool main_thread_task_load_is_low) final;
  
  void OnV8ContextCreated(::performance_manager::mojom::V8ContextDescriptionPtr description, ::performance_manager::mojom::IframeAttributionDataPtr iframe_attribution_data) final;
  
  void OnV8ContextDetached(const ::blink::V8ContextToken& v8_context_token) final;
  
  void OnV8ContextDestroyed(const ::blink::V8ContextToken& v8_context_token) final;
  
  void OnRemoteIframeAttached(const ::blink::LocalFrameToken& parent_frame_token, const ::blink::RemoteFrameToken& remote_frame_token, ::performance_manager::mojom::IframeAttributionDataPtr iframe_attribution_data) final;
  
  void OnRemoteIframeDetached(const ::blink::LocalFrameToken& parent_frame_token, const ::blink::RemoteFrameToken& remote_frame_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ChildProcessCoordinationUnitProxy
    : public ChildProcessCoordinationUnit {
 public:
  using InterfaceType = ChildProcessCoordinationUnit;

  explicit ChildProcessCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InitializeChildProcessCoordination(InitializeChildProcessCoordinationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) DocumentCoordinationUnitStubDispatch {
 public:
  static bool Accept(DocumentCoordinationUnit* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DocumentCoordinationUnit* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DocumentCoordinationUnit>>
class DocumentCoordinationUnitStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DocumentCoordinationUnitStub() = default;
  ~DocumentCoordinationUnitStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DocumentCoordinationUnitStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DocumentCoordinationUnitStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ProcessCoordinationUnitStubDispatch {
 public:
  static bool Accept(ProcessCoordinationUnit* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProcessCoordinationUnit* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProcessCoordinationUnit>>
class ProcessCoordinationUnitStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProcessCoordinationUnitStub() = default;
  ~ProcessCoordinationUnitStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProcessCoordinationUnitStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProcessCoordinationUnitStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ChildProcessCoordinationUnitStubDispatch {
 public:
  static bool Accept(ChildProcessCoordinationUnit* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChildProcessCoordinationUnit* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChildProcessCoordinationUnit>>
class ChildProcessCoordinationUnitStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChildProcessCoordinationUnitStub() = default;
  ~ChildProcessCoordinationUnitStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessCoordinationUnitStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessCoordinationUnitStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) DocumentCoordinationUnitRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ProcessCoordinationUnitRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ChildProcessCoordinationUnitRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) DocumentCoordinationUnitResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) ChildProcessCoordinationUnitResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // performance_manager::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_COORDINATION_UNIT_MOJOM_H_