// components/payments/mojom/payment_request_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAYMENTS_MOJOM_PAYMENT_REQUEST_DATA_MOJOM_SHARED_H_
#define COMPONENTS_PAYMENTS_MOJOM_PAYMENT_REQUEST_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/payments/mojom/payment_request_data.mojom-shared-internal.h"




#include "components/payments/mojom/payment_request_data.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentAddressDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentAddressDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentAddress_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::country(input)) in_country = Traits::country(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->country)::BaseType> country_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_country,
      country_fragment);

    fragment->country.Set(
        country_fragment.is_null() ? nullptr : country_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->country.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null country in PaymentAddress struct");

    decltype(Traits::address_line(input)) in_address_line = Traits::address_line(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->address_line)::BaseType>
        address_line_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& address_line_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_address_line,
      address_line_fragment,
      &address_line_validate_params);

    fragment->address_line.Set(
        address_line_fragment.is_null() ? nullptr : address_line_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->address_line.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null address_line in PaymentAddress struct");

    decltype(Traits::region(input)) in_region = Traits::region(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->region)::BaseType> region_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_region,
      region_fragment);

    fragment->region.Set(
        region_fragment.is_null() ? nullptr : region_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->region.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in PaymentAddress struct");

    decltype(Traits::city(input)) in_city = Traits::city(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->city)::BaseType> city_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_city,
      city_fragment);

    fragment->city.Set(
        city_fragment.is_null() ? nullptr : city_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->city.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null city in PaymentAddress struct");

    decltype(Traits::dependent_locality(input)) in_dependent_locality = Traits::dependent_locality(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dependent_locality)::BaseType> dependent_locality_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_dependent_locality,
      dependent_locality_fragment);

    fragment->dependent_locality.Set(
        dependent_locality_fragment.is_null() ? nullptr : dependent_locality_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dependent_locality.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dependent_locality in PaymentAddress struct");

    decltype(Traits::postal_code(input)) in_postal_code = Traits::postal_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->postal_code)::BaseType> postal_code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_postal_code,
      postal_code_fragment);

    fragment->postal_code.Set(
        postal_code_fragment.is_null() ? nullptr : postal_code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->postal_code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null postal_code in PaymentAddress struct");

    decltype(Traits::sorting_code(input)) in_sorting_code = Traits::sorting_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sorting_code)::BaseType> sorting_code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sorting_code,
      sorting_code_fragment);

    fragment->sorting_code.Set(
        sorting_code_fragment.is_null() ? nullptr : sorting_code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sorting_code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sorting_code in PaymentAddress struct");

    decltype(Traits::organization(input)) in_organization = Traits::organization(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->organization)::BaseType> organization_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_organization,
      organization_fragment);

    fragment->organization.Set(
        organization_fragment.is_null() ? nullptr : organization_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->organization.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null organization in PaymentAddress struct");

    decltype(Traits::recipient(input)) in_recipient = Traits::recipient(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recipient)::BaseType> recipient_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_recipient,
      recipient_fragment);

    fragment->recipient.Set(
        recipient_fragment.is_null() ? nullptr : recipient_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recipient.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recipient in PaymentAddress struct");

    decltype(Traits::phone(input)) in_phone = Traits::phone(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->phone)::BaseType> phone_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_phone,
      phone_fragment);

    fragment->phone.Set(
        phone_fragment.is_null() ? nullptr : phone_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->phone.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null phone in PaymentAddress struct");
  }

  static bool Deserialize(::payments::mojom::internal::PaymentAddress_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentAddressDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentCurrencyAmountDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentCurrencyAmountDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentCurrencyAmount_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::currency(input)) in_currency = Traits::currency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->currency)::BaseType> currency_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_currency,
      currency_fragment);

    fragment->currency.Set(
        currency_fragment.is_null() ? nullptr : currency_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->currency.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null currency in PaymentCurrencyAmount struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in PaymentCurrencyAmount struct");
  }

  static bool Deserialize(::payments::mojom::internal::PaymentCurrencyAmount_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentCurrencyAmountDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentValidationErrorsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentValidationErrorsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentValidationErrors_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::error(input)) in_error = Traits::error(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error)::BaseType> error_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_error,
      error_fragment);

    fragment->error.Set(
        error_fragment.is_null() ? nullptr : error_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->error.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in PaymentValidationErrors struct");

    decltype(Traits::payer(input)) in_payer = Traits::payer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payer)::BaseType> payer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PayerErrorsDataView>(
      in_payer,
      payer_fragment);

    fragment->payer.Set(
        payer_fragment.is_null() ? nullptr : payer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payer in PaymentValidationErrors struct");

    decltype(Traits::shipping_address(input)) in_shipping_address = Traits::shipping_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_address)::BaseType> shipping_address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::AddressErrorsDataView>(
      in_shipping_address,
      shipping_address_fragment);

    fragment->shipping_address.Set(
        shipping_address_fragment.is_null() ? nullptr : shipping_address_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shipping_address.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shipping_address in PaymentValidationErrors struct");
  }

  static bool Deserialize(::payments::mojom::internal::PaymentValidationErrors_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentValidationErrorsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PayerErrorsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PayerErrorsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PayerErrors_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::email(input)) in_email = Traits::email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->email)::BaseType> email_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_email,
      email_fragment);

    fragment->email.Set(
        email_fragment.is_null() ? nullptr : email_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->email.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null email in PayerErrors struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in PayerErrors struct");

    decltype(Traits::phone(input)) in_phone = Traits::phone(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->phone)::BaseType> phone_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_phone,
      phone_fragment);

    fragment->phone.Set(
        phone_fragment.is_null() ? nullptr : phone_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->phone.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null phone in PayerErrors struct");
  }

  static bool Deserialize(::payments::mojom::internal::PayerErrors_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PayerErrorsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::AddressErrorsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::AddressErrorsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::AddressErrors_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::address_line(input)) in_address_line = Traits::address_line(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->address_line)::BaseType> address_line_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_address_line,
      address_line_fragment);

    fragment->address_line.Set(
        address_line_fragment.is_null() ? nullptr : address_line_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->address_line.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null address_line in AddressErrors struct");

    decltype(Traits::city(input)) in_city = Traits::city(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->city)::BaseType> city_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_city,
      city_fragment);

    fragment->city.Set(
        city_fragment.is_null() ? nullptr : city_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->city.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null city in AddressErrors struct");

    decltype(Traits::country(input)) in_country = Traits::country(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->country)::BaseType> country_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_country,
      country_fragment);

    fragment->country.Set(
        country_fragment.is_null() ? nullptr : country_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->country.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null country in AddressErrors struct");

    decltype(Traits::dependent_locality(input)) in_dependent_locality = Traits::dependent_locality(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dependent_locality)::BaseType> dependent_locality_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_dependent_locality,
      dependent_locality_fragment);

    fragment->dependent_locality.Set(
        dependent_locality_fragment.is_null() ? nullptr : dependent_locality_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dependent_locality.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dependent_locality in AddressErrors struct");

    decltype(Traits::organization(input)) in_organization = Traits::organization(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->organization)::BaseType> organization_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_organization,
      organization_fragment);

    fragment->organization.Set(
        organization_fragment.is_null() ? nullptr : organization_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->organization.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null organization in AddressErrors struct");

    decltype(Traits::phone(input)) in_phone = Traits::phone(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->phone)::BaseType> phone_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_phone,
      phone_fragment);

    fragment->phone.Set(
        phone_fragment.is_null() ? nullptr : phone_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->phone.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null phone in AddressErrors struct");

    decltype(Traits::postal_code(input)) in_postal_code = Traits::postal_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->postal_code)::BaseType> postal_code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_postal_code,
      postal_code_fragment);

    fragment->postal_code.Set(
        postal_code_fragment.is_null() ? nullptr : postal_code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->postal_code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null postal_code in AddressErrors struct");

    decltype(Traits::recipient(input)) in_recipient = Traits::recipient(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recipient)::BaseType> recipient_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_recipient,
      recipient_fragment);

    fragment->recipient.Set(
        recipient_fragment.is_null() ? nullptr : recipient_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recipient.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recipient in AddressErrors struct");

    decltype(Traits::region(input)) in_region = Traits::region(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->region)::BaseType> region_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_region,
      region_fragment);

    fragment->region.Set(
        region_fragment.is_null() ? nullptr : region_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->region.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in AddressErrors struct");

    decltype(Traits::sorting_code(input)) in_sorting_code = Traits::sorting_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sorting_code)::BaseType> sorting_code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sorting_code,
      sorting_code_fragment);

    fragment->sorting_code.Set(
        sorting_code_fragment.is_null() ? nullptr : sorting_code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sorting_code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sorting_code in AddressErrors struct");
  }

  static bool Deserialize(::payments::mojom::internal::AddressErrors_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::AddressErrorsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace payments::mojom {

inline void PaymentAddressDataView::GetCountryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->country.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentAddressDataView::GetAddressLineDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->address_line.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void PaymentAddressDataView::GetRegionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->region.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentAddressDataView::GetCityDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->city.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentAddressDataView::GetDependentLocalityDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->dependent_locality.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentAddressDataView::GetPostalCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->postal_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentAddressDataView::GetSortingCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sorting_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentAddressDataView::GetOrganizationDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->organization.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentAddressDataView::GetRecipientDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->recipient.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentAddressDataView::GetPhoneDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->phone.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PaymentCurrencyAmountDataView::GetCurrencyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->currency.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentCurrencyAmountDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PaymentValidationErrorsDataView::GetErrorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentValidationErrorsDataView::GetPayerDataView(
    PayerErrorsDataView* output) {
  auto pointer = data_->payer.Get();
  *output = PayerErrorsDataView(pointer, message_);
}
inline void PaymentValidationErrorsDataView::GetShippingAddressDataView(
    AddressErrorsDataView* output) {
  auto pointer = data_->shipping_address.Get();
  *output = AddressErrorsDataView(pointer, message_);
}


inline void PayerErrorsDataView::GetEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->email.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PayerErrorsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PayerErrorsDataView::GetPhoneDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->phone.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AddressErrorsDataView::GetAddressLineDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->address_line.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetCityDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->city.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetCountryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->country.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetDependentLocalityDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->dependent_locality.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetOrganizationDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->organization.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetPhoneDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->phone.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetPostalCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->postal_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetRecipientDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->recipient.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetRegionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->region.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AddressErrorsDataView::GetSortingCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sorting_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // payments::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_PAYMENTS_MOJOM_PAYMENT_REQUEST_DATA_MOJOM_SHARED_H_