// components/payments/mojom/payment_request_data.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAYMENTS_MOJOM_PAYMENT_REQUEST_DATA_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PAYMENTS_MOJOM_PAYMENT_REQUEST_DATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/payments/mojom/payment_request_data.mojom-shared-internal.h"


namespace payments::mojom {
class PaymentAddressDataView;

class PaymentCurrencyAmountDataView;

class PaymentValidationErrorsDataView;

class PayerErrorsDataView;

class AddressErrorsDataView;



}  // payments::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::payments::mojom::PaymentAddressDataView> {
  using Data = ::payments::mojom::internal::PaymentAddress_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentCurrencyAmountDataView> {
  using Data = ::payments::mojom::internal::PaymentCurrencyAmount_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentValidationErrorsDataView> {
  using Data = ::payments::mojom::internal::PaymentValidationErrors_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PayerErrorsDataView> {
  using Data = ::payments::mojom::internal::PayerErrors_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::AddressErrorsDataView> {
  using Data = ::payments::mojom::internal::AddressErrors_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace payments::mojom {


class PaymentAddressDataView {
 public:
  PaymentAddressDataView() = default;

  PaymentAddressDataView(
      internal::PaymentAddress_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCountryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCountry(UserType* output) {
    
    auto* pointer = data_->country.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAddressLineDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddressLine(UserType* output) {
    
    auto* pointer = data_->address_line.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetRegionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegion(UserType* output) {
    
    auto* pointer = data_->region.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCityDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCity(UserType* output) {
    
    auto* pointer = data_->city.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDependentLocalityDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDependentLocality(UserType* output) {
    
    auto* pointer = data_->dependent_locality.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPostalCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostalCode(UserType* output) {
    
    auto* pointer = data_->postal_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSortingCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSortingCode(UserType* output) {
    
    auto* pointer = data_->sorting_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOrganizationDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrganization(UserType* output) {
    
    auto* pointer = data_->organization.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRecipientDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecipient(UserType* output) {
    
    auto* pointer = data_->recipient.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPhoneDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhone(UserType* output) {
    
    auto* pointer = data_->phone.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentAddress_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentCurrencyAmountDataView {
 public:
  PaymentCurrencyAmountDataView() = default;

  PaymentCurrencyAmountDataView(
      internal::PaymentCurrencyAmount_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCurrencyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrency(UserType* output) {
    
    auto* pointer = data_->currency.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentCurrencyAmount_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentValidationErrorsDataView {
 public:
  PaymentValidationErrorsDataView() = default;

  PaymentValidationErrorsDataView(
      internal::PaymentValidationErrors_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetErrorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) {
    
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPayerDataView(
      PayerErrorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayer(UserType* output) {
    
    auto* pointer = data_->payer.Get();
    return mojo::internal::Deserialize<::payments::mojom::PayerErrorsDataView>(
        pointer, output, message_);
  }
  inline void GetShippingAddressDataView(
      AddressErrorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingAddress(UserType* output) {
    
    auto* pointer = data_->shipping_address.Get();
    return mojo::internal::Deserialize<::payments::mojom::AddressErrorsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentValidationErrors_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PayerErrorsDataView {
 public:
  PayerErrorsDataView() = default;

  PayerErrorsDataView(
      internal::PayerErrors_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPhoneDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhone(UserType* output) {
    
    auto* pointer = data_->phone.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PayerErrors_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AddressErrorsDataView {
 public:
  AddressErrorsDataView() = default;

  AddressErrorsDataView(
      internal::AddressErrors_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressLineDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddressLine(UserType* output) {
    
    auto* pointer = data_->address_line.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCityDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCity(UserType* output) {
    
    auto* pointer = data_->city.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCountryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCountry(UserType* output) {
    
    auto* pointer = data_->country.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDependentLocalityDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDependentLocality(UserType* output) {
    
    auto* pointer = data_->dependent_locality.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOrganizationDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrganization(UserType* output) {
    
    auto* pointer = data_->organization.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPhoneDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhone(UserType* output) {
    
    auto* pointer = data_->phone.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPostalCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostalCode(UserType* output) {
    
    auto* pointer = data_->postal_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRecipientDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecipient(UserType* output) {
    
    auto* pointer = data_->recipient.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRegionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegion(UserType* output) {
    
    auto* pointer = data_->region.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSortingCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSortingCode(UserType* output) {
    
    auto* pointer = data_->sorting_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AddressErrors_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // payments::mojom

#endif  // COMPONENTS_PAYMENTS_MOJOM_PAYMENT_REQUEST_DATA_MOJOM_DATA_VIEW_H_