// components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PASSWORD_MANAGER_SERVICES_CSV_PASSWORD_PUBLIC_MOJOM_CSV_PASSWORD_PARSER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PASSWORD_MANAGER_SERVICES_CSV_PASSWORD_PUBLIC_MOJOM_CSV_PASSWORD_PARSER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-shared-internal.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace password_manager::mojom {
class CSVPasswordSequenceDataView;

class CSVPasswordDataView;



}  // password_manager::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::password_manager::mojom::CSVPasswordSequenceDataView> {
  using Data = ::password_manager::mojom::internal::CSVPasswordSequence_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::password_manager::mojom::CSVPasswordDataView> {
  using Data = ::password_manager::mojom::internal::CSVPassword_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace password_manager::mojom {


enum class CSVPassword_Status : int32_t {
  
  kOK = 0,
  
  kSyntaxError = 1,
  
  kSemanticError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CSVPassword_Status value);
inline bool IsKnownEnumValue(CSVPassword_Status value) {
  return internal::CSVPassword_Status_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CSVPasswordParserInterfaceBase {};

using CSVPasswordParserPtrDataView =
    mojo::InterfacePtrDataView<CSVPasswordParserInterfaceBase>;
using CSVPasswordParserRequestDataView =
    mojo::InterfaceRequestDataView<CSVPasswordParserInterfaceBase>;
using CSVPasswordParserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CSVPasswordParserInterfaceBase>;
using CSVPasswordParserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CSVPasswordParserInterfaceBase>;


class CSVPasswordSequenceDataView {
 public:
  CSVPasswordSequenceDataView() = default;

  CSVPasswordSequenceDataView(
      internal::CSVPasswordSequence_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCsvPasswordsDataView(
      mojo::ArrayDataView<CSVPasswordDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCsvPasswords(UserType* output) {
    
    auto* pointer = data_->csv_passwords.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::password_manager::mojom::CSVPasswordDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CSVPasswordSequence_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSVPasswordDataView {
 public:
  CSVPasswordDataView() = default;

  CSVPasswordDataView(
      internal::CSVPassword_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::password_manager::mojom::CSVPassword_Status>(
        data_value, output);
  }
  CSVPassword_Status status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::password_manager::mojom::CSVPassword_Status>(data_->status));
  }
  inline void GetUsernameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsername(UserType* output) {
    
    auto* pointer = data_->username.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPasswordDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPassword(UserType* output) {
    
    auto* pointer = data_->password.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNoteDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNote(UserType* output) {
    
    auto* pointer = data_->note.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInvalidUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInvalidUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `invalid_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInvalidUrl` instead "
    "of `ReadInvalidUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->invalid_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CSVPassword_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // password_manager::mojom

#endif  // COMPONENTS_PASSWORD_MANAGER_SERVICES_CSV_PASSWORD_PUBLIC_MOJOM_CSV_PASSWORD_PARSER_MOJOM_DATA_VIEW_H_