// components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-params-data.h"
namespace paint_preview {
namespace mojom {

NOINLINE static const char* PaintPreviewStatusToStringHelper(PaintPreviewStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaintPreviewStatus::kOk:
      return "kOk";
    case PaintPreviewStatus::kAlreadyCapturing:
      return "kAlreadyCapturing";
    case PaintPreviewStatus::kCaptureFailed:
      return "kCaptureFailed";
    case PaintPreviewStatus::kGuidCollision:
      return "kGuidCollision";
    case PaintPreviewStatus::kFileCreationError:
      return "kFileCreationError";
    case PaintPreviewStatus::kPartialSuccess:
      return "kPartialSuccess";
    case PaintPreviewStatus::kFailed:
      return "kFailed";
    default:
      return nullptr;
  }
}

std::string PaintPreviewStatusToString(PaintPreviewStatus value) {
  const char *str = PaintPreviewStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaintPreviewStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaintPreviewStatus value) {
  return os << PaintPreviewStatusToString(value);
}

namespace internal {
// static
bool PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Data* object = static_cast<const PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Tag::kFailure: {


      if (!::paint_preview::mojom::internal::PaintPreviewStatus_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool PaintPreviewCaptureParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCaptureParams_Data* object =
      static_cast<const PaintPreviewCaptureParams_Data*>(data);


  if (!::paint_preview::mojom::internal::RecordingPersistence_Data
        ::Validate(object->persistence, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->guid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->geometry_metadata_params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->geometry_metadata_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

PaintPreviewCaptureParams_Data::PaintPreviewCaptureParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LinkData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LinkData_Data* object =
      static_cast<const LinkData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  return true;
}

LinkData_Data::LinkData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCaptureResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCaptureResponse_Data* object =
      static_cast<const PaintPreviewCaptureResponse_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->embedding_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_id_to_embedding_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_id_to_embedding_token_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->content_id_to_embedding_token, validation_context,
                                         &content_id_to_embedding_token_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->links, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& links_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->links, validation_context,
                                         &links_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blink_recording_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blink_recording_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->geometry_metadata, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->geometry_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->skp, validation_context))
    return false;

  return true;
}

PaintPreviewCaptureResponse_Data::PaintPreviewCaptureResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeometryMetadataParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeometryMetadataParams_Data* object =
      static_cast<const GeometryMetadataParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;


  if (!::paint_preview::mojom::internal::ClipCoordOverride_Data
        ::Validate(object->clip_x_coord_override, validation_context))
    return false;


  if (!::paint_preview::mojom::internal::ClipCoordOverride_Data
        ::Validate(object->clip_y_coord_override, validation_context))
    return false;

  return true;
}

GeometryMetadataParams_Data::GeometryMetadataParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeometryMetadataResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeometryMetadataResponse_Data* object =
      static_cast<const GeometryMetadataResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_offsets, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_offsets, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_offsets, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_offsets, validation_context))
    return false;

  return true;
}

GeometryMetadataResponse_Data::GeometryMetadataResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewRecorder_CapturePaintPreview_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewRecorder_CapturePaintPreview_Params_Data* object =
      static_cast<const PaintPreviewRecorder_CapturePaintPreview_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

PaintPreviewRecorder_CapturePaintPreview_Params_Data::PaintPreviewRecorder_CapturePaintPreview_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data* object =
      static_cast<const PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewRecorder_GetGeometryMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewRecorder_GetGeometryMetadata_Params_Data* object =
      static_cast<const PaintPreviewRecorder_GetGeometryMetadata_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

PaintPreviewRecorder_GetGeometryMetadata_Params_Data::PaintPreviewRecorder_GetGeometryMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewRecorder_GetGeometryMetadata_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewRecorder_GetGeometryMetadata_ResponseParams_Data* object =
      static_cast<const PaintPreviewRecorder_GetGeometryMetadata_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

PaintPreviewRecorder_GetGeometryMetadata_ResponseParams_Data::PaintPreviewRecorder_GetGeometryMetadata_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace paint_preview

namespace perfetto {

// static
void TraceFormatTraits<::paint_preview::mojom::PaintPreviewStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::paint_preview::mojom::PaintPreviewStatus value) {
  return std::move(context).WriteString(::paint_preview::mojom::PaintPreviewStatusToString(value));
}

} // namespace perfetto