// components/paint_preview/common/mojom/paint_preview_recorder.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared-internal.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace paint_preview::mojom {
class PaintPreviewCaptureParamsDataView;

class LinkDataDataView;

class PaintPreviewCaptureResponseDataView;

class GeometryMetadataParamsDataView;

class GeometryMetadataResponseDataView;

class PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultDataView;


}  // paint_preview::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewCaptureParamsDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewCaptureParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::LinkDataDataView> {
  using Data = ::paint_preview::mojom::internal::LinkData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewCaptureResponseDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewCaptureResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::GeometryMetadataParamsDataView> {
  using Data = ::paint_preview::mojom::internal::GeometryMetadataParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::GeometryMetadataResponseDataView> {
  using Data = ::paint_preview::mojom::internal::GeometryMetadataResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace paint_preview::mojom {


enum class PaintPreviewStatus : int32_t {
  
  kOk = 0,
  
  kAlreadyCapturing = 1,
  
  kCaptureFailed = 2,
  
  kGuidCollision = 3,
  
  kFileCreationError = 4,
  
  kPartialSuccess = 5,
  
  kFailed = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, PaintPreviewStatus value);
inline bool IsKnownEnumValue(PaintPreviewStatus value) {
  return internal::PaintPreviewStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PaintPreviewRecorderInterfaceBase {};

using PaintPreviewRecorderPtrDataView =
    mojo::InterfacePtrDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderRequestDataView =
    mojo::InterfaceRequestDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaintPreviewRecorderInterfaceBase>;
using PaintPreviewRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaintPreviewRecorderInterfaceBase>;


class PaintPreviewCaptureParamsDataView {
 public:
  PaintPreviewCaptureParamsDataView() = default;

  PaintPreviewCaptureParamsDataView(
      internal::PaintPreviewCaptureParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPersistence(UserType* output) const {
    auto data_value = data_->persistence;
    return mojo::internal::Deserialize<::paint_preview::mojom::RecordingPersistence>(
        data_value, output);
  }
  ::paint_preview::mojom::RecordingPersistence persistence() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::paint_preview::mojom::RecordingPersistence>(data_->persistence));
  }
  inline void GetGuidDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGuid(UserType* output) {
    
    auto* pointer = data_->guid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetGeometryMetadataParamsDataView(
      GeometryMetadataParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeometryMetadataParams(UserType* output) {
    
    auto* pointer = data_->geometry_metadata_params.Get();
    return mojo::internal::Deserialize<::paint_preview::mojom::GeometryMetadataParamsDataView>(
        pointer, output, message_);
  }
  bool is_main_frame() const {
    return data_->is_main_frame;
  }
  bool capture_links() const {
    return data_->capture_links;
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFile` instead "
    "of `ReadFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  uint64_t max_capture_size() const {
    return data_->max_capture_size;
  }
  uint64_t max_decoded_image_size_bytes() const {
    return data_->max_decoded_image_size_bytes;
  }
  bool skip_accelerated_content() const {
    return data_->skip_accelerated_content;
  }
 private:
  internal::PaintPreviewCaptureParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LinkDataDataView {
 public:
  LinkDataDataView() = default;

  LinkDataDataView(
      internal::LinkData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::LinkData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaintPreviewCaptureResponseDataView {
 public:
  PaintPreviewCaptureResponseDataView() = default;

  PaintPreviewCaptureResponseDataView(
      internal::PaintPreviewCaptureResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmbeddingTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmbeddingToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `embedding_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEmbeddingToken` instead "
    "of `ReadEmbeddingToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->embedding_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetContentIdToEmbeddingTokenDataView(
      mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentIdToEmbeddingToken(UserType* output) {
    
    auto* pointer = data_->content_id_to_embedding_token.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        pointer, output, message_);
  }
  inline void GetLinksDataView(
      mojo::ArrayDataView<LinkDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinks(UserType* output) {
    
    auto* pointer = data_->links.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::paint_preview::mojom::LinkDataDataView>>(
        pointer, output, message_);
  }
  inline void GetBlinkRecordingTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlinkRecordingTime(UserType* output) {
    
    auto* pointer = data_->blink_recording_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t serialized_size() const {
    return data_->serialized_size;
  }
  inline void GetGeometryMetadataDataView(
      GeometryMetadataResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeometryMetadata(UserType* output) {
    
    auto* pointer = data_->geometry_metadata.Get();
    return mojo::internal::Deserialize<::paint_preview::mojom::GeometryMetadataResponseDataView>(
        pointer, output, message_);
  }
  inline void GetSkpDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSkp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::BigBufferDataView, UserType>(),
    "Attempting to read the optional `skp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSkp` instead "
    "of `ReadSkp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->skp.is_null() ? &data_->skp : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaintPreviewCaptureResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeometryMetadataParamsDataView {
 public:
  GeometryMetadataParamsDataView() = default;

  GeometryMetadataParamsDataView(
      internal::GeometryMetadataParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetClipRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClipRect(UserType* output) {
    
    auto* pointer = data_->clip_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadClipXCoordOverride(UserType* output) const {
    auto data_value = data_->clip_x_coord_override;
    return mojo::internal::Deserialize<::paint_preview::mojom::ClipCoordOverride>(
        data_value, output);
  }
  ::paint_preview::mojom::ClipCoordOverride clip_x_coord_override() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::paint_preview::mojom::ClipCoordOverride>(data_->clip_x_coord_override));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadClipYCoordOverride(UserType* output) const {
    auto data_value = data_->clip_y_coord_override;
    return mojo::internal::Deserialize<::paint_preview::mojom::ClipCoordOverride>(
        data_value, output);
  }
  ::paint_preview::mojom::ClipCoordOverride clip_y_coord_override() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::paint_preview::mojom::ClipCoordOverride>(data_->clip_y_coord_override));
  }
  bool clip_rect_is_hint() const {
    return data_->clip_rect_is_hint;
  }
 private:
  internal::GeometryMetadataParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeometryMetadataResponseDataView {
 public:
  GeometryMetadataResponseDataView() = default;

  GeometryMetadataResponseDataView(
      internal::GeometryMetadataResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScrollOffsetsDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollOffsets(UserType* output) {
    
    auto* pointer = data_->scroll_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetFrameOffsetsDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameOffsets(UserType* output) {
    
    auto* pointer = data_->frame_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
 private:
  internal::GeometryMetadataResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultDataView {
 public:
  using Tag = internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Data::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Tag;

  PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultDataView() = default;

  PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultDataView(
      internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      PaintPreviewCaptureResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::paint_preview::mojom::PaintPreviewCaptureResponseDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::paint_preview::mojom::PaintPreviewStatus>(
        data_->data.f_failure, output);
  }
  PaintPreviewStatus failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::paint_preview::mojom::PaintPreviewStatus>(data_->data.f_failure));
  }

 private:
  internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // paint_preview::mojom

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_DATA_VIEW_H_