// components/page_load_metrics/common/page_load_metrics.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_H_
#define COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/page_load_metrics/common/page_load_metrics.mojom-features.h"  // IWYU pragma: export
#include "components/page_load_metrics/common/page_load_metrics.mojom-shared.h"  // IWYU pragma: export
#include "components/page_load_metrics/common/page_load_metrics.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_count.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/request_priority.mojom.h"
#include "third_party/blink/public/mojom/loader/javascript_framework_detection.mojom.h"
#include "third_party/blink/public/mojom/use_counter/use_counter_feature.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/page_load_metrics/common/page_load_metrics_mojom_traits.h"




namespace page_load_metrics::mojom {

class PageLoadMetricsProxy;

template <typename ImplRefTraits>
class PageLoadMetricsStub;

class PageLoadMetricsRequestValidator;


class PageLoadMetrics
    : public PageLoadMetricsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "page_load_metrics.mojom.PageLoadMetrics";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageLoadMetricsInterfaceBase;
  using Proxy_ = PageLoadMetricsProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageLoadMetricsStub<ImplRefTraits>;

  using RequestValidator_ = PageLoadMetricsRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateTimingMinVersion = 0,
    kSetUpSharedMemoryForDroppedFramesMinVersion = 0,
    kAddCustomUserTimingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateTiming_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUpSharedMemoryForDroppedFrames_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddCustomUserTiming_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageLoadMetrics() = default;

  virtual void UpdateTiming(PageLoadTimingPtr page_load_timing, FrameMetadataPtr frame_metadata, const std::vector<::blink::UseCounterFeature>& new_features, std::vector<ResourceDataUpdatePtr> resources, FrameRenderDataUpdatePtr render_data, CpuTimingPtr cpu_load_timing, InputTimingPtr input_timing_delta, const std::optional<::blink::SubresourceLoadMetrics>& subresource_load_metrics, SoftNavigationMetricsPtr soft_navigation_metrics) = 0;

  virtual void SetUpSharedMemoryForDroppedFrames(::base::ReadOnlySharedMemoryRegion dropped_frames_memory) = 0;

  virtual void AddCustomUserTiming(CustomUserTimingMarkPtr custom_user_timing) = 0;
};



class  PageLoadMetricsProxy
    : public PageLoadMetrics {
 public:
  using InterfaceType = PageLoadMetrics;

  explicit PageLoadMetricsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateTiming(PageLoadTimingPtr page_load_timing, FrameMetadataPtr frame_metadata, const std::vector<::blink::UseCounterFeature>& new_features, std::vector<ResourceDataUpdatePtr> resources, FrameRenderDataUpdatePtr render_data, CpuTimingPtr cpu_load_timing, InputTimingPtr input_timing_delta, const std::optional<::blink::SubresourceLoadMetrics>& subresource_load_metrics, SoftNavigationMetricsPtr soft_navigation_metrics) final;
  
  void SetUpSharedMemoryForDroppedFrames(::base::ReadOnlySharedMemoryRegion dropped_frames_memory) final;
  
  void AddCustomUserTiming(CustomUserTimingMarkPtr custom_user_timing) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageLoadMetricsStubDispatch {
 public:
  static bool Accept(PageLoadMetrics* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageLoadMetrics* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageLoadMetrics>>
class PageLoadMetricsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageLoadMetricsStub() = default;
  ~PageLoadMetricsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageLoadMetricsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageLoadMetricsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageLoadMetricsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};




























class  DocumentTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DocumentTiming, T>::value>;
  using DataView = DocumentTimingDataView;
  using Data_ = internal::DocumentTiming_Data;

  template <typename... Args>
  static DocumentTimingPtr New(Args&&... args) {
    return DocumentTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DocumentTimingPtr From(const U& u) {
    return mojo::TypeConverter<DocumentTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DocumentTiming>::Convert(*this);
  }


  DocumentTiming();

  DocumentTiming(
      std::optional<::base::TimeDelta> dom_content_loaded_event_start,
      std::optional<::base::TimeDelta> load_event_start);


  ~DocumentTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DocumentTimingPtr>
  DocumentTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DocumentTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DocumentTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DocumentTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DocumentTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DocumentTiming_UnserializedMessageContext<
            UserType, DocumentTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DocumentTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DocumentTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DocumentTiming_UnserializedMessageContext<
            UserType, DocumentTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DocumentTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> dom_content_loaded_event_start;
  
  std::optional<::base::TimeDelta> load_event_start;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DocumentTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DocumentTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DocumentTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DocumentTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LcpResourceLoadTimings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LcpResourceLoadTimings, T>::value>;
  using DataView = LcpResourceLoadTimingsDataView;
  using Data_ = internal::LcpResourceLoadTimings_Data;

  template <typename... Args>
  static LcpResourceLoadTimingsPtr New(Args&&... args) {
    return LcpResourceLoadTimingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LcpResourceLoadTimingsPtr From(const U& u) {
    return mojo::TypeConverter<LcpResourceLoadTimingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LcpResourceLoadTimings>::Convert(*this);
  }


  LcpResourceLoadTimings();

  LcpResourceLoadTimings(
      std::optional<::base::TimeDelta> discovery_time,
      std::optional<::base::TimeDelta> load_start,
      std::optional<::base::TimeDelta> load_end);


  ~LcpResourceLoadTimings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LcpResourceLoadTimingsPtr>
  LcpResourceLoadTimingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LcpResourceLoadTimings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LcpResourceLoadTimings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LcpResourceLoadTimings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LcpResourceLoadTimings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LcpResourceLoadTimings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LcpResourceLoadTimings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LcpResourceLoadTimings_UnserializedMessageContext<
            UserType, LcpResourceLoadTimings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LcpResourceLoadTimings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LcpResourceLoadTimings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LcpResourceLoadTimings_UnserializedMessageContext<
            UserType, LcpResourceLoadTimings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LcpResourceLoadTimings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> discovery_time;
  
  std::optional<::base::TimeDelta> load_start;
  
  std::optional<::base::TimeDelta> load_end;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LcpResourceLoadTimings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LcpResourceLoadTimings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LcpResourceLoadTimings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LcpResourceLoadTimings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LargestContentfulPaintTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LargestContentfulPaintTiming, T>::value>;
  using DataView = LargestContentfulPaintTimingDataView;
  using Data_ = internal::LargestContentfulPaintTiming_Data;

  template <typename... Args>
  static LargestContentfulPaintTimingPtr New(Args&&... args) {
    return LargestContentfulPaintTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LargestContentfulPaintTimingPtr From(const U& u) {
    return mojo::TypeConverter<LargestContentfulPaintTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LargestContentfulPaintTiming>::Convert(*this);
  }


  LargestContentfulPaintTiming();

  LargestContentfulPaintTiming(
      std::optional<::base::TimeDelta> largest_image_paint,
      uint64_t largest_image_paint_size,
      std::optional<::base::TimeDelta> largest_text_paint,
      uint64_t largest_text_paint_size,
      LcpResourceLoadTimingsPtr resource_load_timings,
      uint64_t type,
      double image_bpp,
      bool image_request_priority_valid,
      ::net::RequestPriority image_request_priority_value);

LargestContentfulPaintTiming(const LargestContentfulPaintTiming&) = delete;
LargestContentfulPaintTiming& operator=(const LargestContentfulPaintTiming&) = delete;

  ~LargestContentfulPaintTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LargestContentfulPaintTimingPtr>
  LargestContentfulPaintTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LargestContentfulPaintTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LargestContentfulPaintTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LargestContentfulPaintTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LargestContentfulPaintTiming_UnserializedMessageContext<
            UserType, LargestContentfulPaintTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LargestContentfulPaintTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LargestContentfulPaintTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LargestContentfulPaintTiming_UnserializedMessageContext<
            UserType, LargestContentfulPaintTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LargestContentfulPaintTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> largest_image_paint;
  
  uint64_t largest_image_paint_size;
  
  std::optional<::base::TimeDelta> largest_text_paint;
  
  uint64_t largest_text_paint_size;
  
  LcpResourceLoadTimingsPtr resource_load_timings;
  
  uint64_t type;
  
  double image_bpp;
  
  bool image_request_priority_valid;
  
  ::net::RequestPriority image_request_priority_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PaintTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintTiming, T>::value>;
  using DataView = PaintTimingDataView;
  using Data_ = internal::PaintTiming_Data;

  template <typename... Args>
  static PaintTimingPtr New(Args&&... args) {
    return PaintTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintTimingPtr From(const U& u) {
    return mojo::TypeConverter<PaintTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintTiming>::Convert(*this);
  }


  PaintTiming();

  PaintTiming(
      std::optional<::base::TimeDelta> first_paint,
      std::optional<::base::TimeDelta> first_image_paint,
      std::optional<::base::TimeDelta> first_contentful_paint,
      std::optional<::base::TimeDelta> first_meaningful_paint,
      LargestContentfulPaintTimingPtr largest_contentful_paint,
      LargestContentfulPaintTimingPtr experimental_largest_contentful_paint,
      std::optional<::base::TimeDelta> first_eligible_to_paint,
      std::optional<::base::TimeDelta> first_input_or_scroll_notified_timestamp);

PaintTiming(const PaintTiming&) = delete;
PaintTiming& operator=(const PaintTiming&) = delete;

  ~PaintTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintTimingPtr>
  PaintTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaintTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaintTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintTiming_UnserializedMessageContext<
            UserType, PaintTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintTiming_UnserializedMessageContext<
            UserType, PaintTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> first_paint;
  
  std::optional<::base::TimeDelta> first_image_paint;
  
  std::optional<::base::TimeDelta> first_contentful_paint;
  
  std::optional<::base::TimeDelta> first_meaningful_paint;
  
  LargestContentfulPaintTimingPtr largest_contentful_paint;
  
  LargestContentfulPaintTimingPtr experimental_largest_contentful_paint;
  
  std::optional<::base::TimeDelta> first_eligible_to_paint;
  
  std::optional<::base::TimeDelta> first_input_or_scroll_notified_timestamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MonotonicPaintTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MonotonicPaintTiming, T>::value>;
  using DataView = MonotonicPaintTimingDataView;
  using Data_ = internal::MonotonicPaintTiming_Data;

  template <typename... Args>
  static MonotonicPaintTimingPtr New(Args&&... args) {
    return MonotonicPaintTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MonotonicPaintTimingPtr From(const U& u) {
    return mojo::TypeConverter<MonotonicPaintTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MonotonicPaintTiming>::Convert(*this);
  }


  MonotonicPaintTiming();

  MonotonicPaintTiming(
      std::optional<::base::TimeTicks> first_paint,
      std::optional<::base::TimeTicks> first_contentful_paint);


  ~MonotonicPaintTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MonotonicPaintTimingPtr>
  MonotonicPaintTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MonotonicPaintTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MonotonicPaintTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MonotonicPaintTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MonotonicPaintTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MonotonicPaintTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MonotonicPaintTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MonotonicPaintTiming_UnserializedMessageContext<
            UserType, MonotonicPaintTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MonotonicPaintTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MonotonicPaintTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MonotonicPaintTiming_UnserializedMessageContext<
            UserType, MonotonicPaintTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MonotonicPaintTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeTicks> first_paint;
  
  std::optional<::base::TimeTicks> first_contentful_paint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MonotonicPaintTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MonotonicPaintTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MonotonicPaintTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MonotonicPaintTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ParseTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ParseTiming, T>::value>;
  using DataView = ParseTimingDataView;
  using Data_ = internal::ParseTiming_Data;

  template <typename... Args>
  static ParseTimingPtr New(Args&&... args) {
    return ParseTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParseTimingPtr From(const U& u) {
    return mojo::TypeConverter<ParseTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParseTiming>::Convert(*this);
  }


  ParseTiming();

  ParseTiming(
      std::optional<::base::TimeDelta> parse_start,
      std::optional<::base::TimeDelta> parse_stop,
      std::optional<::base::TimeDelta> parse_blocked_on_script_load_duration,
      std::optional<::base::TimeDelta> parse_blocked_on_script_load_from_document_write_duration,
      std::optional<::base::TimeDelta> parse_blocked_on_script_execution_duration,
      std::optional<::base::TimeDelta> parse_blocked_on_script_execution_from_document_write_duration);


  ~ParseTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParseTimingPtr>
  ParseTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ParseTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ParseTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ParseTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParseTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParseTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParseTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ParseTiming_UnserializedMessageContext<
            UserType, ParseTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ParseTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ParseTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ParseTiming_UnserializedMessageContext<
            UserType, ParseTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ParseTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> parse_start;
  
  std::optional<::base::TimeDelta> parse_stop;
  
  std::optional<::base::TimeDelta> parse_blocked_on_script_load_duration;
  
  std::optional<::base::TimeDelta> parse_blocked_on_script_load_from_document_write_duration;
  
  std::optional<::base::TimeDelta> parse_blocked_on_script_execution_duration;
  
  std::optional<::base::TimeDelta> parse_blocked_on_script_execution_from_document_write_duration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ParseTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ParseTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ParseTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ParseTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InteractiveTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InteractiveTiming, T>::value>;
  using DataView = InteractiveTimingDataView;
  using Data_ = internal::InteractiveTiming_Data;

  template <typename... Args>
  static InteractiveTimingPtr New(Args&&... args) {
    return InteractiveTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InteractiveTimingPtr From(const U& u) {
    return mojo::TypeConverter<InteractiveTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InteractiveTiming>::Convert(*this);
  }


  InteractiveTiming();

  InteractiveTiming(
      std::optional<::base::TimeDelta> first_input_delay,
      std::optional<::base::TimeDelta> first_input_timestamp,
      std::optional<::base::TimeDelta> first_scroll_delay,
      std::optional<::base::TimeDelta> first_scroll_timestamp);


  ~InteractiveTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InteractiveTimingPtr>
  InteractiveTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InteractiveTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InteractiveTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InteractiveTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InteractiveTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InteractiveTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InteractiveTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InteractiveTiming_UnserializedMessageContext<
            UserType, InteractiveTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InteractiveTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InteractiveTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InteractiveTiming_UnserializedMessageContext<
            UserType, InteractiveTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InteractiveTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> first_input_delay;
  
  std::optional<::base::TimeDelta> first_input_timestamp;
  
  std::optional<::base::TimeDelta> first_scroll_delay;
  
  std::optional<::base::TimeDelta> first_scroll_timestamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InteractiveTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InteractiveTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InteractiveTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InteractiveTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CustomUserTimingMark {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CustomUserTimingMark, T>::value>;
  using DataView = CustomUserTimingMarkDataView;
  using Data_ = internal::CustomUserTimingMark_Data;

  template <typename... Args>
  static CustomUserTimingMarkPtr New(Args&&... args) {
    return CustomUserTimingMarkPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CustomUserTimingMarkPtr From(const U& u) {
    return mojo::TypeConverter<CustomUserTimingMarkPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CustomUserTimingMark>::Convert(*this);
  }


  CustomUserTimingMark();

  CustomUserTimingMark(
      const std::string& mark_name,
      ::base::TimeDelta start_time);


  ~CustomUserTimingMark();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CustomUserTimingMarkPtr>
  CustomUserTimingMarkPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CustomUserTimingMark::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CustomUserTimingMark::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CustomUserTimingMark::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CustomUserTimingMark::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CustomUserTimingMark::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CustomUserTimingMark::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CustomUserTimingMark_UnserializedMessageContext<
            UserType, CustomUserTimingMark::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CustomUserTimingMark::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CustomUserTimingMark::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CustomUserTimingMark_UnserializedMessageContext<
            UserType, CustomUserTimingMark::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CustomUserTimingMark::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string mark_name;
  
  ::base::TimeDelta start_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CustomUserTimingMark::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CustomUserTimingMark::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CustomUserTimingMark::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CustomUserTimingMark::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DomainLookupTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DomainLookupTiming, T>::value>;
  using DataView = DomainLookupTimingDataView;
  using Data_ = internal::DomainLookupTiming_Data;

  template <typename... Args>
  static DomainLookupTimingPtr New(Args&&... args) {
    return DomainLookupTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DomainLookupTimingPtr From(const U& u) {
    return mojo::TypeConverter<DomainLookupTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DomainLookupTiming>::Convert(*this);
  }


  DomainLookupTiming();

  DomainLookupTiming(
      std::optional<::base::TimeDelta> domain_lookup_start,
      std::optional<::base::TimeDelta> domain_lookup_end);


  ~DomainLookupTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DomainLookupTimingPtr>
  DomainLookupTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DomainLookupTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DomainLookupTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DomainLookupTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DomainLookupTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DomainLookupTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DomainLookupTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DomainLookupTiming_UnserializedMessageContext<
            UserType, DomainLookupTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DomainLookupTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DomainLookupTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DomainLookupTiming_UnserializedMessageContext<
            UserType, DomainLookupTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DomainLookupTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> domain_lookup_start;
  
  std::optional<::base::TimeDelta> domain_lookup_end;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DomainLookupTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DomainLookupTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DomainLookupTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DomainLookupTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PageLoadTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageLoadTiming, T>::value>;
  using DataView = PageLoadTimingDataView;
  using Data_ = internal::PageLoadTiming_Data;

  template <typename... Args>
  static PageLoadTimingPtr New(Args&&... args) {
    return PageLoadTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageLoadTimingPtr From(const U& u) {
    return mojo::TypeConverter<PageLoadTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageLoadTiming>::Convert(*this);
  }


  PageLoadTiming();

  PageLoadTiming(
      ::base::Time navigation_start,
      std::optional<::base::TimeDelta> connect_start,
      std::optional<::base::TimeDelta> connect_end,
      std::optional<::base::TimeDelta> response_start,
      DocumentTimingPtr document_timing,
      InteractiveTimingPtr interactive_timing,
      PaintTimingPtr paint_timing,
      ParseTimingPtr parse_timing,
      DomainLookupTimingPtr domain_lookup_timing,
      std::vector<BackForwardCacheTimingPtr> back_forward_cache_timings,
      std::optional<::base::TimeDelta> activation_start,
      std::optional<::base::TimeDelta> input_to_navigation_start,
      std::optional<::base::TimeDelta> user_timing_mark_fully_loaded,
      std::optional<::base::TimeDelta> user_timing_mark_fully_visible,
      std::optional<::base::TimeDelta> user_timing_mark_interactive,
      MonotonicPaintTimingPtr monotonic_paint_timing);

PageLoadTiming(const PageLoadTiming&) = delete;
PageLoadTiming& operator=(const PageLoadTiming&) = delete;

  ~PageLoadTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageLoadTimingPtr>
  PageLoadTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageLoadTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageLoadTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageLoadTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageLoadTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageLoadTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageLoadTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageLoadTiming_UnserializedMessageContext<
            UserType, PageLoadTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageLoadTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageLoadTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageLoadTiming_UnserializedMessageContext<
            UserType, PageLoadTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageLoadTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Time navigation_start;
  
  std::optional<::base::TimeDelta> connect_start;
  
  std::optional<::base::TimeDelta> connect_end;
  
  std::optional<::base::TimeDelta> response_start;
  
  DocumentTimingPtr document_timing;
  
  InteractiveTimingPtr interactive_timing;
  
  PaintTimingPtr paint_timing;
  
  ParseTimingPtr parse_timing;
  
  DomainLookupTimingPtr domain_lookup_timing;
  
  std::vector<BackForwardCacheTimingPtr> back_forward_cache_timings;
  
  std::optional<::base::TimeDelta> activation_start;
  
  std::optional<::base::TimeDelta> input_to_navigation_start;
  
  std::optional<::base::TimeDelta> user_timing_mark_fully_loaded;
  
  std::optional<::base::TimeDelta> user_timing_mark_fully_visible;
  
  std::optional<::base::TimeDelta> user_timing_mark_interactive;
  
  MonotonicPaintTimingPtr monotonic_paint_timing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageLoadTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageLoadTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageLoadTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageLoadTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameMetadata, T>::value>;
  using DataView = FrameMetadataDataView;
  using Data_ = internal::FrameMetadata_Data;

  template <typename... Args>
  static FrameMetadataPtr New(Args&&... args) {
    return FrameMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<FrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameMetadata>::Convert(*this);
  }


  FrameMetadata();

  FrameMetadata(
      int32_t behavior_flags,
      const std::optional<::gfx::Rect>& main_frame_intersection_rect,
      const std::optional<::gfx::Rect>& main_frame_viewport_rect,
      const base::flat_map<int32_t, ::gfx::Rect>& main_frame_ad_rects,
      const ::blink::JavaScriptFrameworkDetectionResult& framework_detection_result);


  ~FrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameMetadataPtr>
  FrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameMetadata_UnserializedMessageContext<
            UserType, FrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameMetadata_UnserializedMessageContext<
            UserType, FrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t behavior_flags;
  
  std::optional<::gfx::Rect> main_frame_intersection_rect;
  
  std::optional<::gfx::Rect> main_frame_viewport_rect;
  
  base::flat_map<int32_t, ::gfx::Rect> main_frame_ad_rects;
  
  ::blink::JavaScriptFrameworkDetectionResult framework_detection_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SubresourceLoadMetrics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubresourceLoadMetrics, T>::value>;
  using DataView = SubresourceLoadMetricsDataView;
  using Data_ = internal::SubresourceLoadMetrics_Data;

  template <typename... Args>
  static SubresourceLoadMetricsPtr New(Args&&... args) {
    return SubresourceLoadMetricsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubresourceLoadMetricsPtr From(const U& u) {
    return mojo::TypeConverter<SubresourceLoadMetricsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubresourceLoadMetrics>::Convert(*this);
  }


  SubresourceLoadMetrics();

  SubresourceLoadMetrics(
      uint32_t number_of_subresources_loaded,
      uint32_t number_of_subresource_loads_handled_by_service_worker,
      const std::optional<::blink::ServiceWorkerSubresourceLoadMetrics>& service_worker_subresource_load_metrics);


  ~SubresourceLoadMetrics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubresourceLoadMetricsPtr>
  SubresourceLoadMetricsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubresourceLoadMetrics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubresourceLoadMetrics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubresourceLoadMetrics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubresourceLoadMetrics_UnserializedMessageContext<
            UserType, SubresourceLoadMetrics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubresourceLoadMetrics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubresourceLoadMetrics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubresourceLoadMetrics_UnserializedMessageContext<
            UserType, SubresourceLoadMetrics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubresourceLoadMetrics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t number_of_subresources_loaded;
  
  uint32_t number_of_subresource_loads_handled_by_service_worker;
  
  std::optional<::blink::ServiceWorkerSubresourceLoadMetrics> service_worker_subresource_load_metrics;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ServiceWorkerSubresourceLoadMetrics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerSubresourceLoadMetrics, T>::value>;
  using DataView = ServiceWorkerSubresourceLoadMetricsDataView;
  using Data_ = internal::ServiceWorkerSubresourceLoadMetrics_Data;

  template <typename... Args>
  static ServiceWorkerSubresourceLoadMetricsPtr New(Args&&... args) {
    return ServiceWorkerSubresourceLoadMetricsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerSubresourceLoadMetricsPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerSubresourceLoadMetricsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerSubresourceLoadMetrics>::Convert(*this);
  }


  ServiceWorkerSubresourceLoadMetrics();

  ServiceWorkerSubresourceLoadMetrics(
      bool image_handled,
      bool image_fallback,
      bool css_handled,
      bool css_fallback,
      bool script_handled,
      bool script_fallback,
      bool font_handled,
      bool font_fallback,
      bool raw_handled,
      bool raw_fallback,
      bool svg_handled,
      bool svg_fallback,
      bool xsl_handled,
      bool xsl_fallback,
      bool link_prefetch_handled,
      bool link_prefetch_fallback,
      bool text_track_handled,
      bool text_track_fallback,
      bool audio_handled,
      bool audio_fallback,
      bool video_handled,
      bool video_fallback,
      bool manifest_handled,
      bool manifest_fallback,
      bool speculation_rules_handled,
      bool speculation_rules_fallback,
      bool mock_handled,
      bool mock_fallback,
      bool dictionary_handled,
      bool dictionary_fallback,
      uint32_t matched_cache_router_source_count,
      uint32_t matched_fetch_event_router_source_count,
      uint32_t matched_network_router_source_count,
      uint32_t matched_race_network_and_fetch_router_source_count,
      uint32_t matched_race_network_and_cache_router_source_count,
      ::base::TimeDelta total_router_evaluation_time_for_subresources,
      ::base::TimeDelta total_cache_lookup_time_for_subresources);


  ~ServiceWorkerSubresourceLoadMetrics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerSubresourceLoadMetricsPtr>
  ServiceWorkerSubresourceLoadMetricsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerSubresourceLoadMetrics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerSubresourceLoadMetrics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerSubresourceLoadMetrics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerSubresourceLoadMetrics_UnserializedMessageContext<
            UserType, ServiceWorkerSubresourceLoadMetrics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerSubresourceLoadMetrics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerSubresourceLoadMetrics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerSubresourceLoadMetrics_UnserializedMessageContext<
            UserType, ServiceWorkerSubresourceLoadMetrics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerSubresourceLoadMetrics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool image_handled;
  
  bool image_fallback;
  
  bool css_handled;
  
  bool css_fallback;
  
  bool script_handled;
  
  bool script_fallback;
  
  bool font_handled;
  
  bool font_fallback;
  
  bool raw_handled;
  
  bool raw_fallback;
  
  bool svg_handled;
  
  bool svg_fallback;
  
  bool xsl_handled;
  
  bool xsl_fallback;
  
  bool link_prefetch_handled;
  
  bool link_prefetch_fallback;
  
  bool text_track_handled;
  
  bool text_track_fallback;
  
  bool audio_handled;
  
  bool audio_fallback;
  
  bool video_handled;
  
  bool video_fallback;
  
  bool manifest_handled;
  
  bool manifest_fallback;
  
  bool speculation_rules_handled;
  
  bool speculation_rules_fallback;
  
  bool mock_handled;
  
  bool mock_fallback;
  
  bool dictionary_handled;
  
  bool dictionary_fallback;
  
  uint32_t matched_cache_router_source_count;
  
  uint32_t matched_fetch_event_router_source_count;
  
  uint32_t matched_network_router_source_count;
  
  uint32_t matched_race_network_and_fetch_router_source_count;
  
  uint32_t matched_race_network_and_cache_router_source_count;
  
  ::base::TimeDelta total_router_evaluation_time_for_subresources;
  
  ::base::TimeDelta total_cache_lookup_time_for_subresources;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ResourceDataUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResourceDataUpdate, T>::value>;
  using DataView = ResourceDataUpdateDataView;
  using Data_ = internal::ResourceDataUpdate_Data;

  template <typename... Args>
  static ResourceDataUpdatePtr New(Args&&... args) {
    return ResourceDataUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResourceDataUpdatePtr From(const U& u) {
    return mojo::TypeConverter<ResourceDataUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResourceDataUpdate>::Convert(*this);
  }


  ResourceDataUpdate();

  ResourceDataUpdate(
      int32_t request_id,
      ::base::ByteCount delta_bytes,
      ::base::ByteCount received_data_length,
      ::base::ByteCount encoded_body_length,
      ::base::ByteCount decoded_body_length,
      bool is_complete,
      bool reported_as_ad_resource,
      bool is_main_frame_resource,
      CacheType cache_type,
      bool is_primary_frame_resource,
      const std::string& mime_type,
      bool is_secure_scheme,
      bool proxy_used);


  ~ResourceDataUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResourceDataUpdatePtr>
  ResourceDataUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResourceDataUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResourceDataUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResourceDataUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceDataUpdate::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceDataUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResourceDataUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResourceDataUpdate_UnserializedMessageContext<
            UserType, ResourceDataUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResourceDataUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResourceDataUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResourceDataUpdate_UnserializedMessageContext<
            UserType, ResourceDataUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResourceDataUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t request_id;
  
  ::base::ByteCount delta_bytes;
  
  ::base::ByteCount received_data_length;
  
  ::base::ByteCount encoded_body_length;
  
  ::base::ByteCount decoded_body_length;
  
  bool is_complete;
  
  bool reported_as_ad_resource;
  
  bool is_main_frame_resource;
  
  CacheType cache_type;
  
  bool is_primary_frame_resource;
  
  std::string mime_type;
  
  bool is_secure_scheme;
  
  bool proxy_used;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResourceDataUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResourceDataUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResourceDataUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResourceDataUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LayoutShift {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayoutShift, T>::value>;
  using DataView = LayoutShiftDataView;
  using Data_ = internal::LayoutShift_Data;

  template <typename... Args>
  static LayoutShiftPtr New(Args&&... args) {
    return LayoutShiftPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayoutShiftPtr From(const U& u) {
    return mojo::TypeConverter<LayoutShiftPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayoutShift>::Convert(*this);
  }


  LayoutShift();

  LayoutShift(
      ::base::TimeTicks layout_shift_time,
      double layout_shift_score);


  ~LayoutShift();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayoutShiftPtr>
  LayoutShiftPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayoutShift::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayoutShift::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayoutShift::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayoutShift::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayoutShift::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayoutShift::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayoutShift_UnserializedMessageContext<
            UserType, LayoutShift::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayoutShift::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayoutShift::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayoutShift_UnserializedMessageContext<
            UserType, LayoutShift::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayoutShift::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks layout_shift_time;
  
  double layout_shift_score;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayoutShift::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayoutShift::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayoutShift::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayoutShift::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FrameRenderDataUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameRenderDataUpdate, T>::value>;
  using DataView = FrameRenderDataUpdateDataView;
  using Data_ = internal::FrameRenderDataUpdate_Data;

  template <typename... Args>
  static FrameRenderDataUpdatePtr New(Args&&... args) {
    return FrameRenderDataUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameRenderDataUpdatePtr From(const U& u) {
    return mojo::TypeConverter<FrameRenderDataUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameRenderDataUpdate>::Convert(*this);
  }


  FrameRenderDataUpdate();

  FrameRenderDataUpdate(
      float layout_shift_delta,
      float layout_shift_delta_before_input_or_scroll,
      std::vector<LayoutShiftPtr> new_layout_shifts);

FrameRenderDataUpdate(const FrameRenderDataUpdate&) = delete;
FrameRenderDataUpdate& operator=(const FrameRenderDataUpdate&) = delete;

  ~FrameRenderDataUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameRenderDataUpdatePtr>
  FrameRenderDataUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameRenderDataUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameRenderDataUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameRenderDataUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameRenderDataUpdate::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameRenderDataUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameRenderDataUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameRenderDataUpdate_UnserializedMessageContext<
            UserType, FrameRenderDataUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameRenderDataUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameRenderDataUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameRenderDataUpdate_UnserializedMessageContext<
            UserType, FrameRenderDataUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameRenderDataUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float layout_shift_delta;
  
  float layout_shift_delta_before_input_or_scroll;
  
  std::vector<LayoutShiftPtr> new_layout_shifts;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameRenderDataUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameRenderDataUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameRenderDataUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameRenderDataUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CpuTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CpuTiming, T>::value>;
  using DataView = CpuTimingDataView;
  using Data_ = internal::CpuTiming_Data;

  template <typename... Args>
  static CpuTimingPtr New(Args&&... args) {
    return CpuTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CpuTimingPtr From(const U& u) {
    return mojo::TypeConverter<CpuTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CpuTiming>::Convert(*this);
  }


  CpuTiming();

  explicit CpuTiming(
      ::base::TimeDelta task_time);


  ~CpuTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CpuTimingPtr>
  CpuTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CpuTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CpuTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CpuTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CpuTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CpuTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CpuTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CpuTiming_UnserializedMessageContext<
            UserType, CpuTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CpuTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CpuTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CpuTiming_UnserializedMessageContext<
            UserType, CpuTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CpuTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta task_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CpuTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CpuTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CpuTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CpuTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InputTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InputTiming, T>::value>;
  using DataView = InputTimingDataView;
  using Data_ = internal::InputTiming_Data;

  template <typename... Args>
  static InputTimingPtr New(Args&&... args) {
    return InputTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InputTimingPtr From(const U& u) {
    return mojo::TypeConverter<InputTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InputTiming>::Convert(*this);
  }


  InputTiming();

  explicit InputTiming(
      std::vector<UserInteractionLatencyPtr> user_interaction_latencies);

InputTiming(const InputTiming&) = delete;
InputTiming& operator=(const InputTiming&) = delete;

  ~InputTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InputTimingPtr>
  InputTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InputTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InputTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InputTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InputTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InputTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InputTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InputTiming_UnserializedMessageContext<
            UserType, InputTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InputTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InputTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InputTiming_UnserializedMessageContext<
            UserType, InputTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InputTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<UserInteractionLatencyPtr> user_interaction_latencies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InputTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InputTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InputTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InputTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UserInteractionLatency {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserInteractionLatency, T>::value>;
  using DataView = UserInteractionLatencyDataView;
  using Data_ = internal::UserInteractionLatency_Data;

  template <typename... Args>
  static UserInteractionLatencyPtr New(Args&&... args) {
    return UserInteractionLatencyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserInteractionLatencyPtr From(const U& u) {
    return mojo::TypeConverter<UserInteractionLatencyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserInteractionLatency>::Convert(*this);
  }


  UserInteractionLatency();

  UserInteractionLatency(
      ::base::TimeDelta interaction_latency,
      uint64_t interaction_offset,
      ::base::TimeTicks interaction_time);


  ~UserInteractionLatency();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserInteractionLatencyPtr>
  UserInteractionLatencyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserInteractionLatency::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserInteractionLatency::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserInteractionLatency::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserInteractionLatency::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserInteractionLatency::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserInteractionLatency::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserInteractionLatency_UnserializedMessageContext<
            UserType, UserInteractionLatency::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserInteractionLatency::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserInteractionLatency::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserInteractionLatency_UnserializedMessageContext<
            UserType, UserInteractionLatency::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserInteractionLatency::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta interaction_latency;
  
  uint64_t interaction_offset;
  
  ::base::TimeTicks interaction_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserInteractionLatency::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserInteractionLatency::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserInteractionLatency::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserInteractionLatency::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BackForwardCacheTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackForwardCacheTiming, T>::value>;
  using DataView = BackForwardCacheTimingDataView;
  using Data_ = internal::BackForwardCacheTiming_Data;

  template <typename... Args>
  static BackForwardCacheTimingPtr New(Args&&... args) {
    return BackForwardCacheTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackForwardCacheTimingPtr From(const U& u) {
    return mojo::TypeConverter<BackForwardCacheTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackForwardCacheTiming>::Convert(*this);
  }


  BackForwardCacheTiming();

  BackForwardCacheTiming(
      ::base::TimeDelta first_paint_after_back_forward_cache_restore,
      std::vector<::base::TimeDelta> request_animation_frames_after_back_forward_cache_restore,
      std::optional<::base::TimeDelta> first_input_delay_after_back_forward_cache_restore);


  ~BackForwardCacheTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackForwardCacheTimingPtr>
  BackForwardCacheTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackForwardCacheTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackForwardCacheTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackForwardCacheTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackForwardCacheTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackForwardCacheTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackForwardCacheTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackForwardCacheTiming_UnserializedMessageContext<
            UserType, BackForwardCacheTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackForwardCacheTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackForwardCacheTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackForwardCacheTiming_UnserializedMessageContext<
            UserType, BackForwardCacheTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackForwardCacheTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta first_paint_after_back_forward_cache_restore;
  
  std::vector<::base::TimeDelta> request_animation_frames_after_back_forward_cache_restore;
  
  std::optional<::base::TimeDelta> first_input_delay_after_back_forward_cache_restore;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackForwardCacheTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackForwardCacheTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackForwardCacheTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackForwardCacheTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SoftNavigationMetrics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SoftNavigationMetrics, T>::value>;
  using DataView = SoftNavigationMetricsDataView;
  using Data_ = internal::SoftNavigationMetrics_Data;

  template <typename... Args>
  static SoftNavigationMetricsPtr New(Args&&... args) {
    return SoftNavigationMetricsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SoftNavigationMetricsPtr From(const U& u) {
    return mojo::TypeConverter<SoftNavigationMetricsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SoftNavigationMetrics>::Convert(*this);
  }


  SoftNavigationMetrics();

  SoftNavigationMetrics(
      uint64_t count,
      ::base::TimeDelta start_time,
      uint32_t navigation_id,
      const std::optional<::base::UnguessableToken>& same_document_metrics_token,
      LargestContentfulPaintTimingPtr largest_contentful_paint);

SoftNavigationMetrics(const SoftNavigationMetrics&) = delete;
SoftNavigationMetrics& operator=(const SoftNavigationMetrics&) = delete;

  ~SoftNavigationMetrics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SoftNavigationMetricsPtr>
  SoftNavigationMetricsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SoftNavigationMetrics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SoftNavigationMetrics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SoftNavigationMetrics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SoftNavigationMetrics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SoftNavigationMetrics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SoftNavigationMetrics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SoftNavigationMetrics_UnserializedMessageContext<
            UserType, SoftNavigationMetrics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SoftNavigationMetrics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SoftNavigationMetrics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SoftNavigationMetrics_UnserializedMessageContext<
            UserType, SoftNavigationMetrics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SoftNavigationMetrics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t count;
  
  ::base::TimeDelta start_time;
  
  uint32_t navigation_id;
  
  std::optional<::base::UnguessableToken> same_document_metrics_token;
  
  LargestContentfulPaintTimingPtr largest_contentful_paint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SoftNavigationMetrics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SoftNavigationMetrics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SoftNavigationMetrics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SoftNavigationMetrics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DocumentTimingPtr DocumentTiming::Clone() const {
  return New(
      mojo::Clone(dom_content_loaded_event_start),
      mojo::Clone(load_event_start)
  );
}

template <typename T, DocumentTiming::EnableIfSame<T>*>
bool DocumentTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dom_content_loaded_event_start, other_struct.dom_content_loaded_event_start))
    return false;
  if (!mojo::Equals(this->load_event_start, other_struct.load_event_start))
    return false;
  return true;
}

template <typename T, DocumentTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dom_content_loaded_event_start < rhs.dom_content_loaded_event_start)
    return true;
  if (rhs.dom_content_loaded_event_start < lhs.dom_content_loaded_event_start)
    return false;
  if (lhs.load_event_start < rhs.load_event_start)
    return true;
  if (rhs.load_event_start < lhs.load_event_start)
    return false;
  return false;
}
template <typename StructPtrType>
LcpResourceLoadTimingsPtr LcpResourceLoadTimings::Clone() const {
  return New(
      mojo::Clone(discovery_time),
      mojo::Clone(load_start),
      mojo::Clone(load_end)
  );
}

template <typename T, LcpResourceLoadTimings::EnableIfSame<T>*>
bool LcpResourceLoadTimings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->discovery_time, other_struct.discovery_time))
    return false;
  if (!mojo::Equals(this->load_start, other_struct.load_start))
    return false;
  if (!mojo::Equals(this->load_end, other_struct.load_end))
    return false;
  return true;
}

template <typename T, LcpResourceLoadTimings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.discovery_time < rhs.discovery_time)
    return true;
  if (rhs.discovery_time < lhs.discovery_time)
    return false;
  if (lhs.load_start < rhs.load_start)
    return true;
  if (rhs.load_start < lhs.load_start)
    return false;
  if (lhs.load_end < rhs.load_end)
    return true;
  if (rhs.load_end < lhs.load_end)
    return false;
  return false;
}
template <typename StructPtrType>
LargestContentfulPaintTimingPtr LargestContentfulPaintTiming::Clone() const {
  return New(
      mojo::Clone(largest_image_paint),
      mojo::Clone(largest_image_paint_size),
      mojo::Clone(largest_text_paint),
      mojo::Clone(largest_text_paint_size),
      mojo::Clone(resource_load_timings),
      mojo::Clone(type),
      mojo::Clone(image_bpp),
      mojo::Clone(image_request_priority_valid),
      mojo::Clone(image_request_priority_value)
  );
}

template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>*>
bool LargestContentfulPaintTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->largest_image_paint, other_struct.largest_image_paint))
    return false;
  if (!mojo::Equals(this->largest_image_paint_size, other_struct.largest_image_paint_size))
    return false;
  if (!mojo::Equals(this->largest_text_paint, other_struct.largest_text_paint))
    return false;
  if (!mojo::Equals(this->largest_text_paint_size, other_struct.largest_text_paint_size))
    return false;
  if (!mojo::Equals(this->resource_load_timings, other_struct.resource_load_timings))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->image_bpp, other_struct.image_bpp))
    return false;
  if (!mojo::Equals(this->image_request_priority_valid, other_struct.image_request_priority_valid))
    return false;
  if (!mojo::Equals(this->image_request_priority_value, other_struct.image_request_priority_value))
    return false;
  return true;
}

template <typename T, LargestContentfulPaintTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.largest_image_paint < rhs.largest_image_paint)
    return true;
  if (rhs.largest_image_paint < lhs.largest_image_paint)
    return false;
  if (lhs.largest_image_paint_size < rhs.largest_image_paint_size)
    return true;
  if (rhs.largest_image_paint_size < lhs.largest_image_paint_size)
    return false;
  if (lhs.largest_text_paint < rhs.largest_text_paint)
    return true;
  if (rhs.largest_text_paint < lhs.largest_text_paint)
    return false;
  if (lhs.largest_text_paint_size < rhs.largest_text_paint_size)
    return true;
  if (rhs.largest_text_paint_size < lhs.largest_text_paint_size)
    return false;
  if (lhs.resource_load_timings < rhs.resource_load_timings)
    return true;
  if (rhs.resource_load_timings < lhs.resource_load_timings)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.image_bpp < rhs.image_bpp)
    return true;
  if (rhs.image_bpp < lhs.image_bpp)
    return false;
  if (lhs.image_request_priority_valid < rhs.image_request_priority_valid)
    return true;
  if (rhs.image_request_priority_valid < lhs.image_request_priority_valid)
    return false;
  if (lhs.image_request_priority_value < rhs.image_request_priority_value)
    return true;
  if (rhs.image_request_priority_value < lhs.image_request_priority_value)
    return false;
  return false;
}
template <typename StructPtrType>
PaintTimingPtr PaintTiming::Clone() const {
  return New(
      mojo::Clone(first_paint),
      mojo::Clone(first_image_paint),
      mojo::Clone(first_contentful_paint),
      mojo::Clone(first_meaningful_paint),
      mojo::Clone(largest_contentful_paint),
      mojo::Clone(experimental_largest_contentful_paint),
      mojo::Clone(first_eligible_to_paint),
      mojo::Clone(first_input_or_scroll_notified_timestamp)
  );
}

template <typename T, PaintTiming::EnableIfSame<T>*>
bool PaintTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->first_paint, other_struct.first_paint))
    return false;
  if (!mojo::Equals(this->first_image_paint, other_struct.first_image_paint))
    return false;
  if (!mojo::Equals(this->first_contentful_paint, other_struct.first_contentful_paint))
    return false;
  if (!mojo::Equals(this->first_meaningful_paint, other_struct.first_meaningful_paint))
    return false;
  if (!mojo::Equals(this->largest_contentful_paint, other_struct.largest_contentful_paint))
    return false;
  if (!mojo::Equals(this->experimental_largest_contentful_paint, other_struct.experimental_largest_contentful_paint))
    return false;
  if (!mojo::Equals(this->first_eligible_to_paint, other_struct.first_eligible_to_paint))
    return false;
  if (!mojo::Equals(this->first_input_or_scroll_notified_timestamp, other_struct.first_input_or_scroll_notified_timestamp))
    return false;
  return true;
}

template <typename T, PaintTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.first_paint < rhs.first_paint)
    return true;
  if (rhs.first_paint < lhs.first_paint)
    return false;
  if (lhs.first_image_paint < rhs.first_image_paint)
    return true;
  if (rhs.first_image_paint < lhs.first_image_paint)
    return false;
  if (lhs.first_contentful_paint < rhs.first_contentful_paint)
    return true;
  if (rhs.first_contentful_paint < lhs.first_contentful_paint)
    return false;
  if (lhs.first_meaningful_paint < rhs.first_meaningful_paint)
    return true;
  if (rhs.first_meaningful_paint < lhs.first_meaningful_paint)
    return false;
  if (lhs.largest_contentful_paint < rhs.largest_contentful_paint)
    return true;
  if (rhs.largest_contentful_paint < lhs.largest_contentful_paint)
    return false;
  if (lhs.experimental_largest_contentful_paint < rhs.experimental_largest_contentful_paint)
    return true;
  if (rhs.experimental_largest_contentful_paint < lhs.experimental_largest_contentful_paint)
    return false;
  if (lhs.first_eligible_to_paint < rhs.first_eligible_to_paint)
    return true;
  if (rhs.first_eligible_to_paint < lhs.first_eligible_to_paint)
    return false;
  if (lhs.first_input_or_scroll_notified_timestamp < rhs.first_input_or_scroll_notified_timestamp)
    return true;
  if (rhs.first_input_or_scroll_notified_timestamp < lhs.first_input_or_scroll_notified_timestamp)
    return false;
  return false;
}
template <typename StructPtrType>
MonotonicPaintTimingPtr MonotonicPaintTiming::Clone() const {
  return New(
      mojo::Clone(first_paint),
      mojo::Clone(first_contentful_paint)
  );
}

template <typename T, MonotonicPaintTiming::EnableIfSame<T>*>
bool MonotonicPaintTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->first_paint, other_struct.first_paint))
    return false;
  if (!mojo::Equals(this->first_contentful_paint, other_struct.first_contentful_paint))
    return false;
  return true;
}

template <typename T, MonotonicPaintTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.first_paint < rhs.first_paint)
    return true;
  if (rhs.first_paint < lhs.first_paint)
    return false;
  if (lhs.first_contentful_paint < rhs.first_contentful_paint)
    return true;
  if (rhs.first_contentful_paint < lhs.first_contentful_paint)
    return false;
  return false;
}
template <typename StructPtrType>
ParseTimingPtr ParseTiming::Clone() const {
  return New(
      mojo::Clone(parse_start),
      mojo::Clone(parse_stop),
      mojo::Clone(parse_blocked_on_script_load_duration),
      mojo::Clone(parse_blocked_on_script_load_from_document_write_duration),
      mojo::Clone(parse_blocked_on_script_execution_duration),
      mojo::Clone(parse_blocked_on_script_execution_from_document_write_duration)
  );
}

template <typename T, ParseTiming::EnableIfSame<T>*>
bool ParseTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->parse_start, other_struct.parse_start))
    return false;
  if (!mojo::Equals(this->parse_stop, other_struct.parse_stop))
    return false;
  if (!mojo::Equals(this->parse_blocked_on_script_load_duration, other_struct.parse_blocked_on_script_load_duration))
    return false;
  if (!mojo::Equals(this->parse_blocked_on_script_load_from_document_write_duration, other_struct.parse_blocked_on_script_load_from_document_write_duration))
    return false;
  if (!mojo::Equals(this->parse_blocked_on_script_execution_duration, other_struct.parse_blocked_on_script_execution_duration))
    return false;
  if (!mojo::Equals(this->parse_blocked_on_script_execution_from_document_write_duration, other_struct.parse_blocked_on_script_execution_from_document_write_duration))
    return false;
  return true;
}

template <typename T, ParseTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.parse_start < rhs.parse_start)
    return true;
  if (rhs.parse_start < lhs.parse_start)
    return false;
  if (lhs.parse_stop < rhs.parse_stop)
    return true;
  if (rhs.parse_stop < lhs.parse_stop)
    return false;
  if (lhs.parse_blocked_on_script_load_duration < rhs.parse_blocked_on_script_load_duration)
    return true;
  if (rhs.parse_blocked_on_script_load_duration < lhs.parse_blocked_on_script_load_duration)
    return false;
  if (lhs.parse_blocked_on_script_load_from_document_write_duration < rhs.parse_blocked_on_script_load_from_document_write_duration)
    return true;
  if (rhs.parse_blocked_on_script_load_from_document_write_duration < lhs.parse_blocked_on_script_load_from_document_write_duration)
    return false;
  if (lhs.parse_blocked_on_script_execution_duration < rhs.parse_blocked_on_script_execution_duration)
    return true;
  if (rhs.parse_blocked_on_script_execution_duration < lhs.parse_blocked_on_script_execution_duration)
    return false;
  if (lhs.parse_blocked_on_script_execution_from_document_write_duration < rhs.parse_blocked_on_script_execution_from_document_write_duration)
    return true;
  if (rhs.parse_blocked_on_script_execution_from_document_write_duration < lhs.parse_blocked_on_script_execution_from_document_write_duration)
    return false;
  return false;
}
template <typename StructPtrType>
InteractiveTimingPtr InteractiveTiming::Clone() const {
  return New(
      mojo::Clone(first_input_delay),
      mojo::Clone(first_input_timestamp),
      mojo::Clone(first_scroll_delay),
      mojo::Clone(first_scroll_timestamp)
  );
}

template <typename T, InteractiveTiming::EnableIfSame<T>*>
bool InteractiveTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->first_input_delay, other_struct.first_input_delay))
    return false;
  if (!mojo::Equals(this->first_input_timestamp, other_struct.first_input_timestamp))
    return false;
  if (!mojo::Equals(this->first_scroll_delay, other_struct.first_scroll_delay))
    return false;
  if (!mojo::Equals(this->first_scroll_timestamp, other_struct.first_scroll_timestamp))
    return false;
  return true;
}

template <typename T, InteractiveTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.first_input_delay < rhs.first_input_delay)
    return true;
  if (rhs.first_input_delay < lhs.first_input_delay)
    return false;
  if (lhs.first_input_timestamp < rhs.first_input_timestamp)
    return true;
  if (rhs.first_input_timestamp < lhs.first_input_timestamp)
    return false;
  if (lhs.first_scroll_delay < rhs.first_scroll_delay)
    return true;
  if (rhs.first_scroll_delay < lhs.first_scroll_delay)
    return false;
  if (lhs.first_scroll_timestamp < rhs.first_scroll_timestamp)
    return true;
  if (rhs.first_scroll_timestamp < lhs.first_scroll_timestamp)
    return false;
  return false;
}
template <typename StructPtrType>
CustomUserTimingMarkPtr CustomUserTimingMark::Clone() const {
  return New(
      mojo::Clone(mark_name),
      mojo::Clone(start_time)
  );
}

template <typename T, CustomUserTimingMark::EnableIfSame<T>*>
bool CustomUserTimingMark::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mark_name, other_struct.mark_name))
    return false;
  if (!mojo::Equals(this->start_time, other_struct.start_time))
    return false;
  return true;
}

template <typename T, CustomUserTimingMark::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mark_name < rhs.mark_name)
    return true;
  if (rhs.mark_name < lhs.mark_name)
    return false;
  if (lhs.start_time < rhs.start_time)
    return true;
  if (rhs.start_time < lhs.start_time)
    return false;
  return false;
}
template <typename StructPtrType>
DomainLookupTimingPtr DomainLookupTiming::Clone() const {
  return New(
      mojo::Clone(domain_lookup_start),
      mojo::Clone(domain_lookup_end)
  );
}

template <typename T, DomainLookupTiming::EnableIfSame<T>*>
bool DomainLookupTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->domain_lookup_start, other_struct.domain_lookup_start))
    return false;
  if (!mojo::Equals(this->domain_lookup_end, other_struct.domain_lookup_end))
    return false;
  return true;
}

template <typename T, DomainLookupTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.domain_lookup_start < rhs.domain_lookup_start)
    return true;
  if (rhs.domain_lookup_start < lhs.domain_lookup_start)
    return false;
  if (lhs.domain_lookup_end < rhs.domain_lookup_end)
    return true;
  if (rhs.domain_lookup_end < lhs.domain_lookup_end)
    return false;
  return false;
}
template <typename StructPtrType>
PageLoadTimingPtr PageLoadTiming::Clone() const {
  return New(
      mojo::Clone(navigation_start),
      mojo::Clone(connect_start),
      mojo::Clone(connect_end),
      mojo::Clone(response_start),
      mojo::Clone(document_timing),
      mojo::Clone(interactive_timing),
      mojo::Clone(paint_timing),
      mojo::Clone(parse_timing),
      mojo::Clone(domain_lookup_timing),
      mojo::Clone(back_forward_cache_timings),
      mojo::Clone(activation_start),
      mojo::Clone(input_to_navigation_start),
      mojo::Clone(user_timing_mark_fully_loaded),
      mojo::Clone(user_timing_mark_fully_visible),
      mojo::Clone(user_timing_mark_interactive),
      mojo::Clone(monotonic_paint_timing)
  );
}

template <typename T, PageLoadTiming::EnableIfSame<T>*>
bool PageLoadTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->navigation_start, other_struct.navigation_start))
    return false;
  if (!mojo::Equals(this->connect_start, other_struct.connect_start))
    return false;
  if (!mojo::Equals(this->connect_end, other_struct.connect_end))
    return false;
  if (!mojo::Equals(this->response_start, other_struct.response_start))
    return false;
  if (!mojo::Equals(this->document_timing, other_struct.document_timing))
    return false;
  if (!mojo::Equals(this->interactive_timing, other_struct.interactive_timing))
    return false;
  if (!mojo::Equals(this->paint_timing, other_struct.paint_timing))
    return false;
  if (!mojo::Equals(this->parse_timing, other_struct.parse_timing))
    return false;
  if (!mojo::Equals(this->domain_lookup_timing, other_struct.domain_lookup_timing))
    return false;
  if (!mojo::Equals(this->back_forward_cache_timings, other_struct.back_forward_cache_timings))
    return false;
  if (!mojo::Equals(this->activation_start, other_struct.activation_start))
    return false;
  if (!mojo::Equals(this->input_to_navigation_start, other_struct.input_to_navigation_start))
    return false;
  if (!mojo::Equals(this->user_timing_mark_fully_loaded, other_struct.user_timing_mark_fully_loaded))
    return false;
  if (!mojo::Equals(this->user_timing_mark_fully_visible, other_struct.user_timing_mark_fully_visible))
    return false;
  if (!mojo::Equals(this->user_timing_mark_interactive, other_struct.user_timing_mark_interactive))
    return false;
  if (!mojo::Equals(this->monotonic_paint_timing, other_struct.monotonic_paint_timing))
    return false;
  return true;
}

template <typename T, PageLoadTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.navigation_start < rhs.navigation_start)
    return true;
  if (rhs.navigation_start < lhs.navigation_start)
    return false;
  if (lhs.connect_start < rhs.connect_start)
    return true;
  if (rhs.connect_start < lhs.connect_start)
    return false;
  if (lhs.connect_end < rhs.connect_end)
    return true;
  if (rhs.connect_end < lhs.connect_end)
    return false;
  if (lhs.response_start < rhs.response_start)
    return true;
  if (rhs.response_start < lhs.response_start)
    return false;
  if (lhs.document_timing < rhs.document_timing)
    return true;
  if (rhs.document_timing < lhs.document_timing)
    return false;
  if (lhs.interactive_timing < rhs.interactive_timing)
    return true;
  if (rhs.interactive_timing < lhs.interactive_timing)
    return false;
  if (lhs.paint_timing < rhs.paint_timing)
    return true;
  if (rhs.paint_timing < lhs.paint_timing)
    return false;
  if (lhs.parse_timing < rhs.parse_timing)
    return true;
  if (rhs.parse_timing < lhs.parse_timing)
    return false;
  if (lhs.domain_lookup_timing < rhs.domain_lookup_timing)
    return true;
  if (rhs.domain_lookup_timing < lhs.domain_lookup_timing)
    return false;
  if (lhs.back_forward_cache_timings < rhs.back_forward_cache_timings)
    return true;
  if (rhs.back_forward_cache_timings < lhs.back_forward_cache_timings)
    return false;
  if (lhs.activation_start < rhs.activation_start)
    return true;
  if (rhs.activation_start < lhs.activation_start)
    return false;
  if (lhs.input_to_navigation_start < rhs.input_to_navigation_start)
    return true;
  if (rhs.input_to_navigation_start < lhs.input_to_navigation_start)
    return false;
  if (lhs.user_timing_mark_fully_loaded < rhs.user_timing_mark_fully_loaded)
    return true;
  if (rhs.user_timing_mark_fully_loaded < lhs.user_timing_mark_fully_loaded)
    return false;
  if (lhs.user_timing_mark_fully_visible < rhs.user_timing_mark_fully_visible)
    return true;
  if (rhs.user_timing_mark_fully_visible < lhs.user_timing_mark_fully_visible)
    return false;
  if (lhs.user_timing_mark_interactive < rhs.user_timing_mark_interactive)
    return true;
  if (rhs.user_timing_mark_interactive < lhs.user_timing_mark_interactive)
    return false;
  if (lhs.monotonic_paint_timing < rhs.monotonic_paint_timing)
    return true;
  if (rhs.monotonic_paint_timing < lhs.monotonic_paint_timing)
    return false;
  return false;
}
template <typename StructPtrType>
FrameMetadataPtr FrameMetadata::Clone() const {
  return New(
      mojo::Clone(behavior_flags),
      mojo::Clone(main_frame_intersection_rect),
      mojo::Clone(main_frame_viewport_rect),
      mojo::Clone(main_frame_ad_rects),
      mojo::Clone(framework_detection_result)
  );
}

template <typename T, FrameMetadata::EnableIfSame<T>*>
bool FrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->behavior_flags, other_struct.behavior_flags))
    return false;
  if (!mojo::Equals(this->main_frame_intersection_rect, other_struct.main_frame_intersection_rect))
    return false;
  if (!mojo::Equals(this->main_frame_viewport_rect, other_struct.main_frame_viewport_rect))
    return false;
  if (!mojo::Equals(this->main_frame_ad_rects, other_struct.main_frame_ad_rects))
    return false;
  if (!mojo::Equals(this->framework_detection_result, other_struct.framework_detection_result))
    return false;
  return true;
}

template <typename T, FrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.behavior_flags < rhs.behavior_flags)
    return true;
  if (rhs.behavior_flags < lhs.behavior_flags)
    return false;
  if (lhs.main_frame_intersection_rect < rhs.main_frame_intersection_rect)
    return true;
  if (rhs.main_frame_intersection_rect < lhs.main_frame_intersection_rect)
    return false;
  if (lhs.main_frame_viewport_rect < rhs.main_frame_viewport_rect)
    return true;
  if (rhs.main_frame_viewport_rect < lhs.main_frame_viewport_rect)
    return false;
  if (lhs.main_frame_ad_rects < rhs.main_frame_ad_rects)
    return true;
  if (rhs.main_frame_ad_rects < lhs.main_frame_ad_rects)
    return false;
  if (lhs.framework_detection_result < rhs.framework_detection_result)
    return true;
  if (rhs.framework_detection_result < lhs.framework_detection_result)
    return false;
  return false;
}
template <typename StructPtrType>
SubresourceLoadMetricsPtr SubresourceLoadMetrics::Clone() const {
  return New(
      mojo::Clone(number_of_subresources_loaded),
      mojo::Clone(number_of_subresource_loads_handled_by_service_worker),
      mojo::Clone(service_worker_subresource_load_metrics)
  );
}

template <typename T, SubresourceLoadMetrics::EnableIfSame<T>*>
bool SubresourceLoadMetrics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->number_of_subresources_loaded, other_struct.number_of_subresources_loaded))
    return false;
  if (!mojo::Equals(this->number_of_subresource_loads_handled_by_service_worker, other_struct.number_of_subresource_loads_handled_by_service_worker))
    return false;
  if (!mojo::Equals(this->service_worker_subresource_load_metrics, other_struct.service_worker_subresource_load_metrics))
    return false;
  return true;
}

template <typename T, SubresourceLoadMetrics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.number_of_subresources_loaded < rhs.number_of_subresources_loaded)
    return true;
  if (rhs.number_of_subresources_loaded < lhs.number_of_subresources_loaded)
    return false;
  if (lhs.number_of_subresource_loads_handled_by_service_worker < rhs.number_of_subresource_loads_handled_by_service_worker)
    return true;
  if (rhs.number_of_subresource_loads_handled_by_service_worker < lhs.number_of_subresource_loads_handled_by_service_worker)
    return false;
  if (lhs.service_worker_subresource_load_metrics < rhs.service_worker_subresource_load_metrics)
    return true;
  if (rhs.service_worker_subresource_load_metrics < lhs.service_worker_subresource_load_metrics)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerSubresourceLoadMetricsPtr ServiceWorkerSubresourceLoadMetrics::Clone() const {
  return New(
      mojo::Clone(image_handled),
      mojo::Clone(image_fallback),
      mojo::Clone(css_handled),
      mojo::Clone(css_fallback),
      mojo::Clone(script_handled),
      mojo::Clone(script_fallback),
      mojo::Clone(font_handled),
      mojo::Clone(font_fallback),
      mojo::Clone(raw_handled),
      mojo::Clone(raw_fallback),
      mojo::Clone(svg_handled),
      mojo::Clone(svg_fallback),
      mojo::Clone(xsl_handled),
      mojo::Clone(xsl_fallback),
      mojo::Clone(link_prefetch_handled),
      mojo::Clone(link_prefetch_fallback),
      mojo::Clone(text_track_handled),
      mojo::Clone(text_track_fallback),
      mojo::Clone(audio_handled),
      mojo::Clone(audio_fallback),
      mojo::Clone(video_handled),
      mojo::Clone(video_fallback),
      mojo::Clone(manifest_handled),
      mojo::Clone(manifest_fallback),
      mojo::Clone(speculation_rules_handled),
      mojo::Clone(speculation_rules_fallback),
      mojo::Clone(mock_handled),
      mojo::Clone(mock_fallback),
      mojo::Clone(dictionary_handled),
      mojo::Clone(dictionary_fallback),
      mojo::Clone(matched_cache_router_source_count),
      mojo::Clone(matched_fetch_event_router_source_count),
      mojo::Clone(matched_network_router_source_count),
      mojo::Clone(matched_race_network_and_fetch_router_source_count),
      mojo::Clone(matched_race_network_and_cache_router_source_count),
      mojo::Clone(total_router_evaluation_time_for_subresources),
      mojo::Clone(total_cache_lookup_time_for_subresources)
  );
}

template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>*>
bool ServiceWorkerSubresourceLoadMetrics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_handled, other_struct.image_handled))
    return false;
  if (!mojo::Equals(this->image_fallback, other_struct.image_fallback))
    return false;
  if (!mojo::Equals(this->css_handled, other_struct.css_handled))
    return false;
  if (!mojo::Equals(this->css_fallback, other_struct.css_fallback))
    return false;
  if (!mojo::Equals(this->script_handled, other_struct.script_handled))
    return false;
  if (!mojo::Equals(this->script_fallback, other_struct.script_fallback))
    return false;
  if (!mojo::Equals(this->font_handled, other_struct.font_handled))
    return false;
  if (!mojo::Equals(this->font_fallback, other_struct.font_fallback))
    return false;
  if (!mojo::Equals(this->raw_handled, other_struct.raw_handled))
    return false;
  if (!mojo::Equals(this->raw_fallback, other_struct.raw_fallback))
    return false;
  if (!mojo::Equals(this->svg_handled, other_struct.svg_handled))
    return false;
  if (!mojo::Equals(this->svg_fallback, other_struct.svg_fallback))
    return false;
  if (!mojo::Equals(this->xsl_handled, other_struct.xsl_handled))
    return false;
  if (!mojo::Equals(this->xsl_fallback, other_struct.xsl_fallback))
    return false;
  if (!mojo::Equals(this->link_prefetch_handled, other_struct.link_prefetch_handled))
    return false;
  if (!mojo::Equals(this->link_prefetch_fallback, other_struct.link_prefetch_fallback))
    return false;
  if (!mojo::Equals(this->text_track_handled, other_struct.text_track_handled))
    return false;
  if (!mojo::Equals(this->text_track_fallback, other_struct.text_track_fallback))
    return false;
  if (!mojo::Equals(this->audio_handled, other_struct.audio_handled))
    return false;
  if (!mojo::Equals(this->audio_fallback, other_struct.audio_fallback))
    return false;
  if (!mojo::Equals(this->video_handled, other_struct.video_handled))
    return false;
  if (!mojo::Equals(this->video_fallback, other_struct.video_fallback))
    return false;
  if (!mojo::Equals(this->manifest_handled, other_struct.manifest_handled))
    return false;
  if (!mojo::Equals(this->manifest_fallback, other_struct.manifest_fallback))
    return false;
  if (!mojo::Equals(this->speculation_rules_handled, other_struct.speculation_rules_handled))
    return false;
  if (!mojo::Equals(this->speculation_rules_fallback, other_struct.speculation_rules_fallback))
    return false;
  if (!mojo::Equals(this->mock_handled, other_struct.mock_handled))
    return false;
  if (!mojo::Equals(this->mock_fallback, other_struct.mock_fallback))
    return false;
  if (!mojo::Equals(this->dictionary_handled, other_struct.dictionary_handled))
    return false;
  if (!mojo::Equals(this->dictionary_fallback, other_struct.dictionary_fallback))
    return false;
  if (!mojo::Equals(this->matched_cache_router_source_count, other_struct.matched_cache_router_source_count))
    return false;
  if (!mojo::Equals(this->matched_fetch_event_router_source_count, other_struct.matched_fetch_event_router_source_count))
    return false;
  if (!mojo::Equals(this->matched_network_router_source_count, other_struct.matched_network_router_source_count))
    return false;
  if (!mojo::Equals(this->matched_race_network_and_fetch_router_source_count, other_struct.matched_race_network_and_fetch_router_source_count))
    return false;
  if (!mojo::Equals(this->matched_race_network_and_cache_router_source_count, other_struct.matched_race_network_and_cache_router_source_count))
    return false;
  if (!mojo::Equals(this->total_router_evaluation_time_for_subresources, other_struct.total_router_evaluation_time_for_subresources))
    return false;
  if (!mojo::Equals(this->total_cache_lookup_time_for_subresources, other_struct.total_cache_lookup_time_for_subresources))
    return false;
  return true;
}

template <typename T, ServiceWorkerSubresourceLoadMetrics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_handled < rhs.image_handled)
    return true;
  if (rhs.image_handled < lhs.image_handled)
    return false;
  if (lhs.image_fallback < rhs.image_fallback)
    return true;
  if (rhs.image_fallback < lhs.image_fallback)
    return false;
  if (lhs.css_handled < rhs.css_handled)
    return true;
  if (rhs.css_handled < lhs.css_handled)
    return false;
  if (lhs.css_fallback < rhs.css_fallback)
    return true;
  if (rhs.css_fallback < lhs.css_fallback)
    return false;
  if (lhs.script_handled < rhs.script_handled)
    return true;
  if (rhs.script_handled < lhs.script_handled)
    return false;
  if (lhs.script_fallback < rhs.script_fallback)
    return true;
  if (rhs.script_fallback < lhs.script_fallback)
    return false;
  if (lhs.font_handled < rhs.font_handled)
    return true;
  if (rhs.font_handled < lhs.font_handled)
    return false;
  if (lhs.font_fallback < rhs.font_fallback)
    return true;
  if (rhs.font_fallback < lhs.font_fallback)
    return false;
  if (lhs.raw_handled < rhs.raw_handled)
    return true;
  if (rhs.raw_handled < lhs.raw_handled)
    return false;
  if (lhs.raw_fallback < rhs.raw_fallback)
    return true;
  if (rhs.raw_fallback < lhs.raw_fallback)
    return false;
  if (lhs.svg_handled < rhs.svg_handled)
    return true;
  if (rhs.svg_handled < lhs.svg_handled)
    return false;
  if (lhs.svg_fallback < rhs.svg_fallback)
    return true;
  if (rhs.svg_fallback < lhs.svg_fallback)
    return false;
  if (lhs.xsl_handled < rhs.xsl_handled)
    return true;
  if (rhs.xsl_handled < lhs.xsl_handled)
    return false;
  if (lhs.xsl_fallback < rhs.xsl_fallback)
    return true;
  if (rhs.xsl_fallback < lhs.xsl_fallback)
    return false;
  if (lhs.link_prefetch_handled < rhs.link_prefetch_handled)
    return true;
  if (rhs.link_prefetch_handled < lhs.link_prefetch_handled)
    return false;
  if (lhs.link_prefetch_fallback < rhs.link_prefetch_fallback)
    return true;
  if (rhs.link_prefetch_fallback < lhs.link_prefetch_fallback)
    return false;
  if (lhs.text_track_handled < rhs.text_track_handled)
    return true;
  if (rhs.text_track_handled < lhs.text_track_handled)
    return false;
  if (lhs.text_track_fallback < rhs.text_track_fallback)
    return true;
  if (rhs.text_track_fallback < lhs.text_track_fallback)
    return false;
  if (lhs.audio_handled < rhs.audio_handled)
    return true;
  if (rhs.audio_handled < lhs.audio_handled)
    return false;
  if (lhs.audio_fallback < rhs.audio_fallback)
    return true;
  if (rhs.audio_fallback < lhs.audio_fallback)
    return false;
  if (lhs.video_handled < rhs.video_handled)
    return true;
  if (rhs.video_handled < lhs.video_handled)
    return false;
  if (lhs.video_fallback < rhs.video_fallback)
    return true;
  if (rhs.video_fallback < lhs.video_fallback)
    return false;
  if (lhs.manifest_handled < rhs.manifest_handled)
    return true;
  if (rhs.manifest_handled < lhs.manifest_handled)
    return false;
  if (lhs.manifest_fallback < rhs.manifest_fallback)
    return true;
  if (rhs.manifest_fallback < lhs.manifest_fallback)
    return false;
  if (lhs.speculation_rules_handled < rhs.speculation_rules_handled)
    return true;
  if (rhs.speculation_rules_handled < lhs.speculation_rules_handled)
    return false;
  if (lhs.speculation_rules_fallback < rhs.speculation_rules_fallback)
    return true;
  if (rhs.speculation_rules_fallback < lhs.speculation_rules_fallback)
    return false;
  if (lhs.mock_handled < rhs.mock_handled)
    return true;
  if (rhs.mock_handled < lhs.mock_handled)
    return false;
  if (lhs.mock_fallback < rhs.mock_fallback)
    return true;
  if (rhs.mock_fallback < lhs.mock_fallback)
    return false;
  if (lhs.dictionary_handled < rhs.dictionary_handled)
    return true;
  if (rhs.dictionary_handled < lhs.dictionary_handled)
    return false;
  if (lhs.dictionary_fallback < rhs.dictionary_fallback)
    return true;
  if (rhs.dictionary_fallback < lhs.dictionary_fallback)
    return false;
  if (lhs.matched_cache_router_source_count < rhs.matched_cache_router_source_count)
    return true;
  if (rhs.matched_cache_router_source_count < lhs.matched_cache_router_source_count)
    return false;
  if (lhs.matched_fetch_event_router_source_count < rhs.matched_fetch_event_router_source_count)
    return true;
  if (rhs.matched_fetch_event_router_source_count < lhs.matched_fetch_event_router_source_count)
    return false;
  if (lhs.matched_network_router_source_count < rhs.matched_network_router_source_count)
    return true;
  if (rhs.matched_network_router_source_count < lhs.matched_network_router_source_count)
    return false;
  if (lhs.matched_race_network_and_fetch_router_source_count < rhs.matched_race_network_and_fetch_router_source_count)
    return true;
  if (rhs.matched_race_network_and_fetch_router_source_count < lhs.matched_race_network_and_fetch_router_source_count)
    return false;
  if (lhs.matched_race_network_and_cache_router_source_count < rhs.matched_race_network_and_cache_router_source_count)
    return true;
  if (rhs.matched_race_network_and_cache_router_source_count < lhs.matched_race_network_and_cache_router_source_count)
    return false;
  if (lhs.total_router_evaluation_time_for_subresources < rhs.total_router_evaluation_time_for_subresources)
    return true;
  if (rhs.total_router_evaluation_time_for_subresources < lhs.total_router_evaluation_time_for_subresources)
    return false;
  if (lhs.total_cache_lookup_time_for_subresources < rhs.total_cache_lookup_time_for_subresources)
    return true;
  if (rhs.total_cache_lookup_time_for_subresources < lhs.total_cache_lookup_time_for_subresources)
    return false;
  return false;
}
template <typename StructPtrType>
ResourceDataUpdatePtr ResourceDataUpdate::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(delta_bytes),
      mojo::Clone(received_data_length),
      mojo::Clone(encoded_body_length),
      mojo::Clone(decoded_body_length),
      mojo::Clone(is_complete),
      mojo::Clone(reported_as_ad_resource),
      mojo::Clone(is_main_frame_resource),
      mojo::Clone(cache_type),
      mojo::Clone(is_primary_frame_resource),
      mojo::Clone(mime_type),
      mojo::Clone(is_secure_scheme),
      mojo::Clone(proxy_used)
  );
}

template <typename T, ResourceDataUpdate::EnableIfSame<T>*>
bool ResourceDataUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->delta_bytes, other_struct.delta_bytes))
    return false;
  if (!mojo::Equals(this->received_data_length, other_struct.received_data_length))
    return false;
  if (!mojo::Equals(this->encoded_body_length, other_struct.encoded_body_length))
    return false;
  if (!mojo::Equals(this->decoded_body_length, other_struct.decoded_body_length))
    return false;
  if (!mojo::Equals(this->is_complete, other_struct.is_complete))
    return false;
  if (!mojo::Equals(this->reported_as_ad_resource, other_struct.reported_as_ad_resource))
    return false;
  if (!mojo::Equals(this->is_main_frame_resource, other_struct.is_main_frame_resource))
    return false;
  if (!mojo::Equals(this->cache_type, other_struct.cache_type))
    return false;
  if (!mojo::Equals(this->is_primary_frame_resource, other_struct.is_primary_frame_resource))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->is_secure_scheme, other_struct.is_secure_scheme))
    return false;
  if (!mojo::Equals(this->proxy_used, other_struct.proxy_used))
    return false;
  return true;
}

template <typename T, ResourceDataUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.delta_bytes < rhs.delta_bytes)
    return true;
  if (rhs.delta_bytes < lhs.delta_bytes)
    return false;
  if (lhs.received_data_length < rhs.received_data_length)
    return true;
  if (rhs.received_data_length < lhs.received_data_length)
    return false;
  if (lhs.encoded_body_length < rhs.encoded_body_length)
    return true;
  if (rhs.encoded_body_length < lhs.encoded_body_length)
    return false;
  if (lhs.decoded_body_length < rhs.decoded_body_length)
    return true;
  if (rhs.decoded_body_length < lhs.decoded_body_length)
    return false;
  if (lhs.is_complete < rhs.is_complete)
    return true;
  if (rhs.is_complete < lhs.is_complete)
    return false;
  if (lhs.reported_as_ad_resource < rhs.reported_as_ad_resource)
    return true;
  if (rhs.reported_as_ad_resource < lhs.reported_as_ad_resource)
    return false;
  if (lhs.is_main_frame_resource < rhs.is_main_frame_resource)
    return true;
  if (rhs.is_main_frame_resource < lhs.is_main_frame_resource)
    return false;
  if (lhs.cache_type < rhs.cache_type)
    return true;
  if (rhs.cache_type < lhs.cache_type)
    return false;
  if (lhs.is_primary_frame_resource < rhs.is_primary_frame_resource)
    return true;
  if (rhs.is_primary_frame_resource < lhs.is_primary_frame_resource)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.is_secure_scheme < rhs.is_secure_scheme)
    return true;
  if (rhs.is_secure_scheme < lhs.is_secure_scheme)
    return false;
  if (lhs.proxy_used < rhs.proxy_used)
    return true;
  if (rhs.proxy_used < lhs.proxy_used)
    return false;
  return false;
}
template <typename StructPtrType>
LayoutShiftPtr LayoutShift::Clone() const {
  return New(
      mojo::Clone(layout_shift_time),
      mojo::Clone(layout_shift_score)
  );
}

template <typename T, LayoutShift::EnableIfSame<T>*>
bool LayoutShift::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layout_shift_time, other_struct.layout_shift_time))
    return false;
  if (!mojo::Equals(this->layout_shift_score, other_struct.layout_shift_score))
    return false;
  return true;
}

template <typename T, LayoutShift::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layout_shift_time < rhs.layout_shift_time)
    return true;
  if (rhs.layout_shift_time < lhs.layout_shift_time)
    return false;
  if (lhs.layout_shift_score < rhs.layout_shift_score)
    return true;
  if (rhs.layout_shift_score < lhs.layout_shift_score)
    return false;
  return false;
}
template <typename StructPtrType>
FrameRenderDataUpdatePtr FrameRenderDataUpdate::Clone() const {
  return New(
      mojo::Clone(layout_shift_delta),
      mojo::Clone(layout_shift_delta_before_input_or_scroll),
      mojo::Clone(new_layout_shifts)
  );
}

template <typename T, FrameRenderDataUpdate::EnableIfSame<T>*>
bool FrameRenderDataUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layout_shift_delta, other_struct.layout_shift_delta))
    return false;
  if (!mojo::Equals(this->layout_shift_delta_before_input_or_scroll, other_struct.layout_shift_delta_before_input_or_scroll))
    return false;
  if (!mojo::Equals(this->new_layout_shifts, other_struct.new_layout_shifts))
    return false;
  return true;
}

template <typename T, FrameRenderDataUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layout_shift_delta < rhs.layout_shift_delta)
    return true;
  if (rhs.layout_shift_delta < lhs.layout_shift_delta)
    return false;
  if (lhs.layout_shift_delta_before_input_or_scroll < rhs.layout_shift_delta_before_input_or_scroll)
    return true;
  if (rhs.layout_shift_delta_before_input_or_scroll < lhs.layout_shift_delta_before_input_or_scroll)
    return false;
  if (lhs.new_layout_shifts < rhs.new_layout_shifts)
    return true;
  if (rhs.new_layout_shifts < lhs.new_layout_shifts)
    return false;
  return false;
}
template <typename StructPtrType>
CpuTimingPtr CpuTiming::Clone() const {
  return New(
      mojo::Clone(task_time)
  );
}

template <typename T, CpuTiming::EnableIfSame<T>*>
bool CpuTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_time, other_struct.task_time))
    return false;
  return true;
}

template <typename T, CpuTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_time < rhs.task_time)
    return true;
  if (rhs.task_time < lhs.task_time)
    return false;
  return false;
}
template <typename StructPtrType>
InputTimingPtr InputTiming::Clone() const {
  return New(
      mojo::Clone(user_interaction_latencies)
  );
}

template <typename T, InputTiming::EnableIfSame<T>*>
bool InputTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->user_interaction_latencies, other_struct.user_interaction_latencies))
    return false;
  return true;
}

template <typename T, InputTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.user_interaction_latencies < rhs.user_interaction_latencies)
    return true;
  if (rhs.user_interaction_latencies < lhs.user_interaction_latencies)
    return false;
  return false;
}
template <typename StructPtrType>
UserInteractionLatencyPtr UserInteractionLatency::Clone() const {
  return New(
      mojo::Clone(interaction_latency),
      mojo::Clone(interaction_offset),
      mojo::Clone(interaction_time)
  );
}

template <typename T, UserInteractionLatency::EnableIfSame<T>*>
bool UserInteractionLatency::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interaction_latency, other_struct.interaction_latency))
    return false;
  if (!mojo::Equals(this->interaction_offset, other_struct.interaction_offset))
    return false;
  if (!mojo::Equals(this->interaction_time, other_struct.interaction_time))
    return false;
  return true;
}

template <typename T, UserInteractionLatency::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interaction_latency < rhs.interaction_latency)
    return true;
  if (rhs.interaction_latency < lhs.interaction_latency)
    return false;
  if (lhs.interaction_offset < rhs.interaction_offset)
    return true;
  if (rhs.interaction_offset < lhs.interaction_offset)
    return false;
  if (lhs.interaction_time < rhs.interaction_time)
    return true;
  if (rhs.interaction_time < lhs.interaction_time)
    return false;
  return false;
}
template <typename StructPtrType>
BackForwardCacheTimingPtr BackForwardCacheTiming::Clone() const {
  return New(
      mojo::Clone(first_paint_after_back_forward_cache_restore),
      mojo::Clone(request_animation_frames_after_back_forward_cache_restore),
      mojo::Clone(first_input_delay_after_back_forward_cache_restore)
  );
}

template <typename T, BackForwardCacheTiming::EnableIfSame<T>*>
bool BackForwardCacheTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->first_paint_after_back_forward_cache_restore, other_struct.first_paint_after_back_forward_cache_restore))
    return false;
  if (!mojo::Equals(this->request_animation_frames_after_back_forward_cache_restore, other_struct.request_animation_frames_after_back_forward_cache_restore))
    return false;
  if (!mojo::Equals(this->first_input_delay_after_back_forward_cache_restore, other_struct.first_input_delay_after_back_forward_cache_restore))
    return false;
  return true;
}

template <typename T, BackForwardCacheTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.first_paint_after_back_forward_cache_restore < rhs.first_paint_after_back_forward_cache_restore)
    return true;
  if (rhs.first_paint_after_back_forward_cache_restore < lhs.first_paint_after_back_forward_cache_restore)
    return false;
  if (lhs.request_animation_frames_after_back_forward_cache_restore < rhs.request_animation_frames_after_back_forward_cache_restore)
    return true;
  if (rhs.request_animation_frames_after_back_forward_cache_restore < lhs.request_animation_frames_after_back_forward_cache_restore)
    return false;
  if (lhs.first_input_delay_after_back_forward_cache_restore < rhs.first_input_delay_after_back_forward_cache_restore)
    return true;
  if (rhs.first_input_delay_after_back_forward_cache_restore < lhs.first_input_delay_after_back_forward_cache_restore)
    return false;
  return false;
}
template <typename StructPtrType>
SoftNavigationMetricsPtr SoftNavigationMetrics::Clone() const {
  return New(
      mojo::Clone(count),
      mojo::Clone(start_time),
      mojo::Clone(navigation_id),
      mojo::Clone(same_document_metrics_token),
      mojo::Clone(largest_contentful_paint)
  );
}

template <typename T, SoftNavigationMetrics::EnableIfSame<T>*>
bool SoftNavigationMetrics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->count, other_struct.count))
    return false;
  if (!mojo::Equals(this->start_time, other_struct.start_time))
    return false;
  if (!mojo::Equals(this->navigation_id, other_struct.navigation_id))
    return false;
  if (!mojo::Equals(this->same_document_metrics_token, other_struct.same_document_metrics_token))
    return false;
  if (!mojo::Equals(this->largest_contentful_paint, other_struct.largest_contentful_paint))
    return false;
  return true;
}

template <typename T, SoftNavigationMetrics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.count < rhs.count)
    return true;
  if (rhs.count < lhs.count)
    return false;
  if (lhs.start_time < rhs.start_time)
    return true;
  if (rhs.start_time < lhs.start_time)
    return false;
  if (lhs.navigation_id < rhs.navigation_id)
    return true;
  if (rhs.navigation_id < lhs.navigation_id)
    return false;
  if (lhs.same_document_metrics_token < rhs.same_document_metrics_token)
    return true;
  if (rhs.same_document_metrics_token < lhs.same_document_metrics_token)
    return false;
  if (lhs.largest_contentful_paint < rhs.largest_contentful_paint)
    return true;
  if (rhs.largest_contentful_paint < lhs.largest_contentful_paint)
    return false;
  return false;
}


}  // page_load_metrics::mojom

namespace mojo {


template <>
struct  StructTraits<::page_load_metrics::mojom::DocumentTiming::DataView,
                                         ::page_load_metrics::mojom::DocumentTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::DocumentTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::DocumentTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::DocumentTiming::dom_content_loaded_event_start)& dom_content_loaded_event_start(
      const ::page_load_metrics::mojom::DocumentTimingPtr& input) {
    return input->dom_content_loaded_event_start;
  }

  static const decltype(::page_load_metrics::mojom::DocumentTiming::load_event_start)& load_event_start(
      const ::page_load_metrics::mojom::DocumentTimingPtr& input) {
    return input->load_event_start;
  }

  static bool Read(::page_load_metrics::mojom::DocumentTiming::DataView input, ::page_load_metrics::mojom::DocumentTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::LcpResourceLoadTimings::DataView,
                                         ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::LcpResourceLoadTimingsPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::LcpResourceLoadTimings::discovery_time)& discovery_time(
      const ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr& input) {
    return input->discovery_time;
  }

  static const decltype(::page_load_metrics::mojom::LcpResourceLoadTimings::load_start)& load_start(
      const ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr& input) {
    return input->load_start;
  }

  static const decltype(::page_load_metrics::mojom::LcpResourceLoadTimings::load_end)& load_end(
      const ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr& input) {
    return input->load_end;
  }

  static bool Read(::page_load_metrics::mojom::LcpResourceLoadTimings::DataView input, ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::LargestContentfulPaintTiming::DataView,
                                         ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::LargestContentfulPaintTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::largest_image_paint)& largest_image_paint(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->largest_image_paint;
  }

  static decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::largest_image_paint_size) largest_image_paint_size(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->largest_image_paint_size;
  }

  static const decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::largest_text_paint)& largest_text_paint(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->largest_text_paint;
  }

  static decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::largest_text_paint_size) largest_text_paint_size(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->largest_text_paint_size;
  }

  static const decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::resource_load_timings)& resource_load_timings(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->resource_load_timings;
  }

  static decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::type) type(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->type;
  }

  static decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::image_bpp) image_bpp(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->image_bpp;
  }

  static decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::image_request_priority_valid) image_request_priority_valid(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->image_request_priority_valid;
  }

  static decltype(::page_load_metrics::mojom::LargestContentfulPaintTiming::image_request_priority_value) image_request_priority_value(
      const ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr& input) {
    return input->image_request_priority_value;
  }

  static bool Read(::page_load_metrics::mojom::LargestContentfulPaintTiming::DataView input, ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::PaintTiming::DataView,
                                         ::page_load_metrics::mojom::PaintTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::PaintTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::PaintTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::PaintTiming::first_paint)& first_paint(
      const ::page_load_metrics::mojom::PaintTimingPtr& input) {
    return input->first_paint;
  }

  static const decltype(::page_load_metrics::mojom::PaintTiming::first_image_paint)& first_image_paint(
      const ::page_load_metrics::mojom::PaintTimingPtr& input) {
    return input->first_image_paint;
  }

  static const decltype(::page_load_metrics::mojom::PaintTiming::first_contentful_paint)& first_contentful_paint(
      const ::page_load_metrics::mojom::PaintTimingPtr& input) {
    return input->first_contentful_paint;
  }

  static const decltype(::page_load_metrics::mojom::PaintTiming::first_meaningful_paint)& first_meaningful_paint(
      const ::page_load_metrics::mojom::PaintTimingPtr& input) {
    return input->first_meaningful_paint;
  }

  static const decltype(::page_load_metrics::mojom::PaintTiming::largest_contentful_paint)& largest_contentful_paint(
      const ::page_load_metrics::mojom::PaintTimingPtr& input) {
    return input->largest_contentful_paint;
  }

  static const decltype(::page_load_metrics::mojom::PaintTiming::experimental_largest_contentful_paint)& experimental_largest_contentful_paint(
      const ::page_load_metrics::mojom::PaintTimingPtr& input) {
    return input->experimental_largest_contentful_paint;
  }

  static const decltype(::page_load_metrics::mojom::PaintTiming::first_eligible_to_paint)& first_eligible_to_paint(
      const ::page_load_metrics::mojom::PaintTimingPtr& input) {
    return input->first_eligible_to_paint;
  }

  static const decltype(::page_load_metrics::mojom::PaintTiming::first_input_or_scroll_notified_timestamp)& first_input_or_scroll_notified_timestamp(
      const ::page_load_metrics::mojom::PaintTimingPtr& input) {
    return input->first_input_or_scroll_notified_timestamp;
  }

  static bool Read(::page_load_metrics::mojom::PaintTiming::DataView input, ::page_load_metrics::mojom::PaintTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::MonotonicPaintTiming::DataView,
                                         ::page_load_metrics::mojom::MonotonicPaintTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::MonotonicPaintTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::MonotonicPaintTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::MonotonicPaintTiming::first_paint)& first_paint(
      const ::page_load_metrics::mojom::MonotonicPaintTimingPtr& input) {
    return input->first_paint;
  }

  static const decltype(::page_load_metrics::mojom::MonotonicPaintTiming::first_contentful_paint)& first_contentful_paint(
      const ::page_load_metrics::mojom::MonotonicPaintTimingPtr& input) {
    return input->first_contentful_paint;
  }

  static bool Read(::page_load_metrics::mojom::MonotonicPaintTiming::DataView input, ::page_load_metrics::mojom::MonotonicPaintTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::ParseTiming::DataView,
                                         ::page_load_metrics::mojom::ParseTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::ParseTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::ParseTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::ParseTiming::parse_start)& parse_start(
      const ::page_load_metrics::mojom::ParseTimingPtr& input) {
    return input->parse_start;
  }

  static const decltype(::page_load_metrics::mojom::ParseTiming::parse_stop)& parse_stop(
      const ::page_load_metrics::mojom::ParseTimingPtr& input) {
    return input->parse_stop;
  }

  static const decltype(::page_load_metrics::mojom::ParseTiming::parse_blocked_on_script_load_duration)& parse_blocked_on_script_load_duration(
      const ::page_load_metrics::mojom::ParseTimingPtr& input) {
    return input->parse_blocked_on_script_load_duration;
  }

  static const decltype(::page_load_metrics::mojom::ParseTiming::parse_blocked_on_script_load_from_document_write_duration)& parse_blocked_on_script_load_from_document_write_duration(
      const ::page_load_metrics::mojom::ParseTimingPtr& input) {
    return input->parse_blocked_on_script_load_from_document_write_duration;
  }

  static const decltype(::page_load_metrics::mojom::ParseTiming::parse_blocked_on_script_execution_duration)& parse_blocked_on_script_execution_duration(
      const ::page_load_metrics::mojom::ParseTimingPtr& input) {
    return input->parse_blocked_on_script_execution_duration;
  }

  static const decltype(::page_load_metrics::mojom::ParseTiming::parse_blocked_on_script_execution_from_document_write_duration)& parse_blocked_on_script_execution_from_document_write_duration(
      const ::page_load_metrics::mojom::ParseTimingPtr& input) {
    return input->parse_blocked_on_script_execution_from_document_write_duration;
  }

  static bool Read(::page_load_metrics::mojom::ParseTiming::DataView input, ::page_load_metrics::mojom::ParseTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::InteractiveTiming::DataView,
                                         ::page_load_metrics::mojom::InteractiveTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::InteractiveTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::InteractiveTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::InteractiveTiming::first_input_delay)& first_input_delay(
      const ::page_load_metrics::mojom::InteractiveTimingPtr& input) {
    return input->first_input_delay;
  }

  static const decltype(::page_load_metrics::mojom::InteractiveTiming::first_input_timestamp)& first_input_timestamp(
      const ::page_load_metrics::mojom::InteractiveTimingPtr& input) {
    return input->first_input_timestamp;
  }

  static const decltype(::page_load_metrics::mojom::InteractiveTiming::first_scroll_delay)& first_scroll_delay(
      const ::page_load_metrics::mojom::InteractiveTimingPtr& input) {
    return input->first_scroll_delay;
  }

  static const decltype(::page_load_metrics::mojom::InteractiveTiming::first_scroll_timestamp)& first_scroll_timestamp(
      const ::page_load_metrics::mojom::InteractiveTimingPtr& input) {
    return input->first_scroll_timestamp;
  }

  static bool Read(::page_load_metrics::mojom::InteractiveTiming::DataView input, ::page_load_metrics::mojom::InteractiveTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::CustomUserTimingMark::DataView,
                                         ::page_load_metrics::mojom::CustomUserTimingMarkPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::CustomUserTimingMarkPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::CustomUserTimingMarkPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::CustomUserTimingMark::mark_name)& mark_name(
      const ::page_load_metrics::mojom::CustomUserTimingMarkPtr& input) {
    return input->mark_name;
  }

  static const decltype(::page_load_metrics::mojom::CustomUserTimingMark::start_time)& start_time(
      const ::page_load_metrics::mojom::CustomUserTimingMarkPtr& input) {
    return input->start_time;
  }

  static bool Read(::page_load_metrics::mojom::CustomUserTimingMark::DataView input, ::page_load_metrics::mojom::CustomUserTimingMarkPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::DomainLookupTiming::DataView,
                                         ::page_load_metrics::mojom::DomainLookupTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::DomainLookupTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::DomainLookupTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::DomainLookupTiming::domain_lookup_start)& domain_lookup_start(
      const ::page_load_metrics::mojom::DomainLookupTimingPtr& input) {
    return input->domain_lookup_start;
  }

  static const decltype(::page_load_metrics::mojom::DomainLookupTiming::domain_lookup_end)& domain_lookup_end(
      const ::page_load_metrics::mojom::DomainLookupTimingPtr& input) {
    return input->domain_lookup_end;
  }

  static bool Read(::page_load_metrics::mojom::DomainLookupTiming::DataView input, ::page_load_metrics::mojom::DomainLookupTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::PageLoadTiming::DataView,
                                         ::page_load_metrics::mojom::PageLoadTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::PageLoadTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::PageLoadTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::navigation_start)& navigation_start(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->navigation_start;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::connect_start)& connect_start(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->connect_start;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::connect_end)& connect_end(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->connect_end;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::response_start)& response_start(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->response_start;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::document_timing)& document_timing(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->document_timing;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::interactive_timing)& interactive_timing(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->interactive_timing;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::paint_timing)& paint_timing(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->paint_timing;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::parse_timing)& parse_timing(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->parse_timing;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::domain_lookup_timing)& domain_lookup_timing(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->domain_lookup_timing;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::back_forward_cache_timings)& back_forward_cache_timings(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->back_forward_cache_timings;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::activation_start)& activation_start(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->activation_start;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::input_to_navigation_start)& input_to_navigation_start(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->input_to_navigation_start;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::user_timing_mark_fully_loaded)& user_timing_mark_fully_loaded(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->user_timing_mark_fully_loaded;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::user_timing_mark_fully_visible)& user_timing_mark_fully_visible(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->user_timing_mark_fully_visible;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::user_timing_mark_interactive)& user_timing_mark_interactive(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->user_timing_mark_interactive;
  }

  static const decltype(::page_load_metrics::mojom::PageLoadTiming::monotonic_paint_timing)& monotonic_paint_timing(
      const ::page_load_metrics::mojom::PageLoadTimingPtr& input) {
    return input->monotonic_paint_timing;
  }

  static bool Read(::page_load_metrics::mojom::PageLoadTiming::DataView input, ::page_load_metrics::mojom::PageLoadTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::FrameMetadata::DataView,
                                         ::page_load_metrics::mojom::FrameMetadataPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::FrameMetadataPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::FrameMetadataPtr* output) { output->reset(); }

  static decltype(::page_load_metrics::mojom::FrameMetadata::behavior_flags) behavior_flags(
      const ::page_load_metrics::mojom::FrameMetadataPtr& input) {
    return input->behavior_flags;
  }

  static const decltype(::page_load_metrics::mojom::FrameMetadata::main_frame_intersection_rect)& main_frame_intersection_rect(
      const ::page_load_metrics::mojom::FrameMetadataPtr& input) {
    return input->main_frame_intersection_rect;
  }

  static const decltype(::page_load_metrics::mojom::FrameMetadata::main_frame_viewport_rect)& main_frame_viewport_rect(
      const ::page_load_metrics::mojom::FrameMetadataPtr& input) {
    return input->main_frame_viewport_rect;
  }

  static const decltype(::page_load_metrics::mojom::FrameMetadata::main_frame_ad_rects)& main_frame_ad_rects(
      const ::page_load_metrics::mojom::FrameMetadataPtr& input) {
    return input->main_frame_ad_rects;
  }

  static const decltype(::page_load_metrics::mojom::FrameMetadata::framework_detection_result)& framework_detection_result(
      const ::page_load_metrics::mojom::FrameMetadataPtr& input) {
    return input->framework_detection_result;
  }

  static bool Read(::page_load_metrics::mojom::FrameMetadata::DataView input, ::page_load_metrics::mojom::FrameMetadataPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::SubresourceLoadMetrics::DataView,
                                         ::page_load_metrics::mojom::SubresourceLoadMetricsPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::SubresourceLoadMetricsPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::SubresourceLoadMetricsPtr* output) { output->reset(); }

  static decltype(::page_load_metrics::mojom::SubresourceLoadMetrics::number_of_subresources_loaded) number_of_subresources_loaded(
      const ::page_load_metrics::mojom::SubresourceLoadMetricsPtr& input) {
    return input->number_of_subresources_loaded;
  }

  static decltype(::page_load_metrics::mojom::SubresourceLoadMetrics::number_of_subresource_loads_handled_by_service_worker) number_of_subresource_loads_handled_by_service_worker(
      const ::page_load_metrics::mojom::SubresourceLoadMetricsPtr& input) {
    return input->number_of_subresource_loads_handled_by_service_worker;
  }

  static const decltype(::page_load_metrics::mojom::SubresourceLoadMetrics::service_worker_subresource_load_metrics)& service_worker_subresource_load_metrics(
      const ::page_load_metrics::mojom::SubresourceLoadMetricsPtr& input) {
    return input->service_worker_subresource_load_metrics;
  }

  static bool Read(::page_load_metrics::mojom::SubresourceLoadMetrics::DataView input, ::page_load_metrics::mojom::SubresourceLoadMetricsPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::DataView,
                                         ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr* output) { output->reset(); }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::image_handled) image_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->image_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::image_fallback) image_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->image_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::css_handled) css_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->css_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::css_fallback) css_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->css_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::script_handled) script_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->script_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::script_fallback) script_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->script_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::font_handled) font_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->font_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::font_fallback) font_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->font_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::raw_handled) raw_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->raw_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::raw_fallback) raw_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->raw_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::svg_handled) svg_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->svg_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::svg_fallback) svg_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->svg_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::xsl_handled) xsl_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->xsl_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::xsl_fallback) xsl_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->xsl_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::link_prefetch_handled) link_prefetch_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->link_prefetch_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::link_prefetch_fallback) link_prefetch_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->link_prefetch_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::text_track_handled) text_track_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->text_track_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::text_track_fallback) text_track_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->text_track_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::audio_handled) audio_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->audio_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::audio_fallback) audio_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->audio_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::video_handled) video_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->video_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::video_fallback) video_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->video_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::manifest_handled) manifest_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->manifest_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::manifest_fallback) manifest_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->manifest_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::speculation_rules_handled) speculation_rules_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->speculation_rules_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::speculation_rules_fallback) speculation_rules_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->speculation_rules_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::mock_handled) mock_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->mock_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::mock_fallback) mock_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->mock_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::dictionary_handled) dictionary_handled(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->dictionary_handled;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::dictionary_fallback) dictionary_fallback(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->dictionary_fallback;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::matched_cache_router_source_count) matched_cache_router_source_count(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->matched_cache_router_source_count;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::matched_fetch_event_router_source_count) matched_fetch_event_router_source_count(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->matched_fetch_event_router_source_count;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::matched_network_router_source_count) matched_network_router_source_count(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->matched_network_router_source_count;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::matched_race_network_and_fetch_router_source_count) matched_race_network_and_fetch_router_source_count(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->matched_race_network_and_fetch_router_source_count;
  }

  static decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::matched_race_network_and_cache_router_source_count) matched_race_network_and_cache_router_source_count(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->matched_race_network_and_cache_router_source_count;
  }

  static const decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::total_router_evaluation_time_for_subresources)& total_router_evaluation_time_for_subresources(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->total_router_evaluation_time_for_subresources;
  }

  static const decltype(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::total_cache_lookup_time_for_subresources)& total_cache_lookup_time_for_subresources(
      const ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr& input) {
    return input->total_cache_lookup_time_for_subresources;
  }

  static bool Read(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::DataView input, ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::ResourceDataUpdate::DataView,
                                         ::page_load_metrics::mojom::ResourceDataUpdatePtr> {
  static bool IsNull(const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::ResourceDataUpdatePtr* output) { output->reset(); }

  static decltype(::page_load_metrics::mojom::ResourceDataUpdate::request_id) request_id(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->request_id;
  }

  static const decltype(::page_load_metrics::mojom::ResourceDataUpdate::delta_bytes)& delta_bytes(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->delta_bytes;
  }

  static const decltype(::page_load_metrics::mojom::ResourceDataUpdate::received_data_length)& received_data_length(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->received_data_length;
  }

  static const decltype(::page_load_metrics::mojom::ResourceDataUpdate::encoded_body_length)& encoded_body_length(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->encoded_body_length;
  }

  static const decltype(::page_load_metrics::mojom::ResourceDataUpdate::decoded_body_length)& decoded_body_length(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->decoded_body_length;
  }

  static decltype(::page_load_metrics::mojom::ResourceDataUpdate::is_complete) is_complete(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->is_complete;
  }

  static decltype(::page_load_metrics::mojom::ResourceDataUpdate::reported_as_ad_resource) reported_as_ad_resource(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->reported_as_ad_resource;
  }

  static decltype(::page_load_metrics::mojom::ResourceDataUpdate::is_main_frame_resource) is_main_frame_resource(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->is_main_frame_resource;
  }

  static decltype(::page_load_metrics::mojom::ResourceDataUpdate::cache_type) cache_type(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->cache_type;
  }

  static decltype(::page_load_metrics::mojom::ResourceDataUpdate::is_primary_frame_resource) is_primary_frame_resource(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->is_primary_frame_resource;
  }

  static const decltype(::page_load_metrics::mojom::ResourceDataUpdate::mime_type)& mime_type(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->mime_type;
  }

  static decltype(::page_load_metrics::mojom::ResourceDataUpdate::is_secure_scheme) is_secure_scheme(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->is_secure_scheme;
  }

  static decltype(::page_load_metrics::mojom::ResourceDataUpdate::proxy_used) proxy_used(
      const ::page_load_metrics::mojom::ResourceDataUpdatePtr& input) {
    return input->proxy_used;
  }

  static bool Read(::page_load_metrics::mojom::ResourceDataUpdate::DataView input, ::page_load_metrics::mojom::ResourceDataUpdatePtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::LayoutShift::DataView,
                                         ::page_load_metrics::mojom::LayoutShiftPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::LayoutShiftPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::LayoutShiftPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::LayoutShift::layout_shift_time)& layout_shift_time(
      const ::page_load_metrics::mojom::LayoutShiftPtr& input) {
    return input->layout_shift_time;
  }

  static decltype(::page_load_metrics::mojom::LayoutShift::layout_shift_score) layout_shift_score(
      const ::page_load_metrics::mojom::LayoutShiftPtr& input) {
    return input->layout_shift_score;
  }

  static bool Read(::page_load_metrics::mojom::LayoutShift::DataView input, ::page_load_metrics::mojom::LayoutShiftPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::FrameRenderDataUpdate::DataView,
                                         ::page_load_metrics::mojom::FrameRenderDataUpdatePtr> {
  static bool IsNull(const ::page_load_metrics::mojom::FrameRenderDataUpdatePtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::FrameRenderDataUpdatePtr* output) { output->reset(); }

  static decltype(::page_load_metrics::mojom::FrameRenderDataUpdate::layout_shift_delta) layout_shift_delta(
      const ::page_load_metrics::mojom::FrameRenderDataUpdatePtr& input) {
    return input->layout_shift_delta;
  }

  static decltype(::page_load_metrics::mojom::FrameRenderDataUpdate::layout_shift_delta_before_input_or_scroll) layout_shift_delta_before_input_or_scroll(
      const ::page_load_metrics::mojom::FrameRenderDataUpdatePtr& input) {
    return input->layout_shift_delta_before_input_or_scroll;
  }

  static const decltype(::page_load_metrics::mojom::FrameRenderDataUpdate::new_layout_shifts)& new_layout_shifts(
      const ::page_load_metrics::mojom::FrameRenderDataUpdatePtr& input) {
    return input->new_layout_shifts;
  }

  static bool Read(::page_load_metrics::mojom::FrameRenderDataUpdate::DataView input, ::page_load_metrics::mojom::FrameRenderDataUpdatePtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::CpuTiming::DataView,
                                         ::page_load_metrics::mojom::CpuTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::CpuTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::CpuTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::CpuTiming::task_time)& task_time(
      const ::page_load_metrics::mojom::CpuTimingPtr& input) {
    return input->task_time;
  }

  static bool Read(::page_load_metrics::mojom::CpuTiming::DataView input, ::page_load_metrics::mojom::CpuTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::InputTiming::DataView,
                                         ::page_load_metrics::mojom::InputTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::InputTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::InputTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::InputTiming::user_interaction_latencies)& user_interaction_latencies(
      const ::page_load_metrics::mojom::InputTimingPtr& input) {
    return input->user_interaction_latencies;
  }

  static bool Read(::page_load_metrics::mojom::InputTiming::DataView input, ::page_load_metrics::mojom::InputTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::UserInteractionLatency::DataView,
                                         ::page_load_metrics::mojom::UserInteractionLatencyPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::UserInteractionLatencyPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::UserInteractionLatencyPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::UserInteractionLatency::interaction_latency)& interaction_latency(
      const ::page_load_metrics::mojom::UserInteractionLatencyPtr& input) {
    return input->interaction_latency;
  }

  static decltype(::page_load_metrics::mojom::UserInteractionLatency::interaction_offset) interaction_offset(
      const ::page_load_metrics::mojom::UserInteractionLatencyPtr& input) {
    return input->interaction_offset;
  }

  static const decltype(::page_load_metrics::mojom::UserInteractionLatency::interaction_time)& interaction_time(
      const ::page_load_metrics::mojom::UserInteractionLatencyPtr& input) {
    return input->interaction_time;
  }

  static bool Read(::page_load_metrics::mojom::UserInteractionLatency::DataView input, ::page_load_metrics::mojom::UserInteractionLatencyPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::BackForwardCacheTiming::DataView,
                                         ::page_load_metrics::mojom::BackForwardCacheTimingPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::BackForwardCacheTimingPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::BackForwardCacheTimingPtr* output) { output->reset(); }

  static const decltype(::page_load_metrics::mojom::BackForwardCacheTiming::first_paint_after_back_forward_cache_restore)& first_paint_after_back_forward_cache_restore(
      const ::page_load_metrics::mojom::BackForwardCacheTimingPtr& input) {
    return input->first_paint_after_back_forward_cache_restore;
  }

  static const decltype(::page_load_metrics::mojom::BackForwardCacheTiming::request_animation_frames_after_back_forward_cache_restore)& request_animation_frames_after_back_forward_cache_restore(
      const ::page_load_metrics::mojom::BackForwardCacheTimingPtr& input) {
    return input->request_animation_frames_after_back_forward_cache_restore;
  }

  static const decltype(::page_load_metrics::mojom::BackForwardCacheTiming::first_input_delay_after_back_forward_cache_restore)& first_input_delay_after_back_forward_cache_restore(
      const ::page_load_metrics::mojom::BackForwardCacheTimingPtr& input) {
    return input->first_input_delay_after_back_forward_cache_restore;
  }

  static bool Read(::page_load_metrics::mojom::BackForwardCacheTiming::DataView input, ::page_load_metrics::mojom::BackForwardCacheTimingPtr* output);
};


template <>
struct  StructTraits<::page_load_metrics::mojom::SoftNavigationMetrics::DataView,
                                         ::page_load_metrics::mojom::SoftNavigationMetricsPtr> {
  static bool IsNull(const ::page_load_metrics::mojom::SoftNavigationMetricsPtr& input) { return !input; }
  static void SetToNull(::page_load_metrics::mojom::SoftNavigationMetricsPtr* output) { output->reset(); }

  static decltype(::page_load_metrics::mojom::SoftNavigationMetrics::count) count(
      const ::page_load_metrics::mojom::SoftNavigationMetricsPtr& input) {
    return input->count;
  }

  static const decltype(::page_load_metrics::mojom::SoftNavigationMetrics::start_time)& start_time(
      const ::page_load_metrics::mojom::SoftNavigationMetricsPtr& input) {
    return input->start_time;
  }

  static decltype(::page_load_metrics::mojom::SoftNavigationMetrics::navigation_id) navigation_id(
      const ::page_load_metrics::mojom::SoftNavigationMetricsPtr& input) {
    return input->navigation_id;
  }

  static const decltype(::page_load_metrics::mojom::SoftNavigationMetrics::same_document_metrics_token)& same_document_metrics_token(
      const ::page_load_metrics::mojom::SoftNavigationMetricsPtr& input) {
    return input->same_document_metrics_token;
  }

  static const decltype(::page_load_metrics::mojom::SoftNavigationMetrics::largest_contentful_paint)& largest_contentful_paint(
      const ::page_load_metrics::mojom::SoftNavigationMetricsPtr& input) {
    return input->largest_contentful_paint;
  }

  static bool Read(::page_load_metrics::mojom::SoftNavigationMetrics::DataView input, ::page_load_metrics::mojom::SoftNavigationMetricsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_H_