// components/page_load_metrics/common/page_load_metrics.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/page_load_metrics/common/page_load_metrics.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/page_load_metrics/common/page_load_metrics.mojom-params-data.h"
#include "components/page_load_metrics/common/page_load_metrics.mojom-shared-message-ids.h"

#include "components/page_load_metrics/common/page_load_metrics.mojom-import-headers.h"
#include "components/page_load_metrics/common/page_load_metrics.mojom-test-utils.h"


namespace page_load_metrics::mojom {
DocumentTiming::DocumentTiming()
    : dom_content_loaded_event_start(),
      load_event_start() {}

DocumentTiming::DocumentTiming(
    std::optional<::base::TimeDelta> dom_content_loaded_event_start_in,
    std::optional<::base::TimeDelta> load_event_start_in)
    : dom_content_loaded_event_start(std::move(dom_content_loaded_event_start_in)),
      load_event_start(std::move(load_event_start_in)) {}

DocumentTiming::~DocumentTiming() = default;

void DocumentTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dom_content_loaded_event_start"), this->dom_content_loaded_event_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_event_start"), this->load_event_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DocumentTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LcpResourceLoadTimings::LcpResourceLoadTimings()
    : discovery_time(),
      load_start(),
      load_end() {}

LcpResourceLoadTimings::LcpResourceLoadTimings(
    std::optional<::base::TimeDelta> discovery_time_in,
    std::optional<::base::TimeDelta> load_start_in,
    std::optional<::base::TimeDelta> load_end_in)
    : discovery_time(std::move(discovery_time_in)),
      load_start(std::move(load_start_in)),
      load_end(std::move(load_end_in)) {}

LcpResourceLoadTimings::~LcpResourceLoadTimings() = default;

void LcpResourceLoadTimings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discovery_time"), this->discovery_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_start"), this->load_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_end"), this->load_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LcpResourceLoadTimings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LargestContentfulPaintTiming::LargestContentfulPaintTiming()
    : largest_image_paint(),
      largest_image_paint_size(),
      largest_text_paint(),
      largest_text_paint_size(),
      resource_load_timings(),
      type(),
      image_bpp(),
      image_request_priority_valid(false),
      image_request_priority_value() {}

LargestContentfulPaintTiming::LargestContentfulPaintTiming(
    std::optional<::base::TimeDelta> largest_image_paint_in,
    uint64_t largest_image_paint_size_in,
    std::optional<::base::TimeDelta> largest_text_paint_in,
    uint64_t largest_text_paint_size_in,
    LcpResourceLoadTimingsPtr resource_load_timings_in,
    uint64_t type_in,
    double image_bpp_in,
    bool image_request_priority_valid_in,
    ::net::RequestPriority image_request_priority_value_in)
    : largest_image_paint(std::move(largest_image_paint_in)),
      largest_image_paint_size(std::move(largest_image_paint_size_in)),
      largest_text_paint(std::move(largest_text_paint_in)),
      largest_text_paint_size(std::move(largest_text_paint_size_in)),
      resource_load_timings(std::move(resource_load_timings_in)),
      type(std::move(type_in)),
      image_bpp(std::move(image_bpp_in)),
      image_request_priority_valid(std::move(image_request_priority_valid_in)),
      image_request_priority_value(std::move(image_request_priority_value_in)) {}

LargestContentfulPaintTiming::~LargestContentfulPaintTiming() = default;

void LargestContentfulPaintTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "largest_image_paint"), this->largest_image_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "largest_image_paint_size"), this->largest_image_paint_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "largest_text_paint"), this->largest_text_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "largest_text_paint_size"), this->largest_text_paint_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_load_timings"), this->resource_load_timings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LcpResourceLoadTimingsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_bpp"), this->image_bpp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_request_priority_valid"), this->image_request_priority_valid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_request_priority_value"), this->image_request_priority_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::RequestPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LargestContentfulPaintTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaintTiming::PaintTiming()
    : first_paint(),
      first_image_paint(),
      first_contentful_paint(),
      first_meaningful_paint(),
      largest_contentful_paint(),
      experimental_largest_contentful_paint(),
      first_eligible_to_paint(),
      first_input_or_scroll_notified_timestamp() {}

PaintTiming::PaintTiming(
    std::optional<::base::TimeDelta> first_paint_in,
    std::optional<::base::TimeDelta> first_image_paint_in,
    std::optional<::base::TimeDelta> first_contentful_paint_in,
    std::optional<::base::TimeDelta> first_meaningful_paint_in,
    LargestContentfulPaintTimingPtr largest_contentful_paint_in,
    LargestContentfulPaintTimingPtr experimental_largest_contentful_paint_in,
    std::optional<::base::TimeDelta> first_eligible_to_paint_in,
    std::optional<::base::TimeDelta> first_input_or_scroll_notified_timestamp_in)
    : first_paint(std::move(first_paint_in)),
      first_image_paint(std::move(first_image_paint_in)),
      first_contentful_paint(std::move(first_contentful_paint_in)),
      first_meaningful_paint(std::move(first_meaningful_paint_in)),
      largest_contentful_paint(std::move(largest_contentful_paint_in)),
      experimental_largest_contentful_paint(std::move(experimental_largest_contentful_paint_in)),
      first_eligible_to_paint(std::move(first_eligible_to_paint_in)),
      first_input_or_scroll_notified_timestamp(std::move(first_input_or_scroll_notified_timestamp_in)) {}

PaintTiming::~PaintTiming() = default;

void PaintTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_paint"), this->first_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_image_paint"), this->first_image_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_contentful_paint"), this->first_contentful_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_meaningful_paint"), this->first_meaningful_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "largest_contentful_paint"), this->largest_contentful_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LargestContentfulPaintTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "experimental_largest_contentful_paint"), this->experimental_largest_contentful_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LargestContentfulPaintTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_eligible_to_paint"), this->first_eligible_to_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_input_or_scroll_notified_timestamp"), this->first_input_or_scroll_notified_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaintTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MonotonicPaintTiming::MonotonicPaintTiming()
    : first_paint(),
      first_contentful_paint() {}

MonotonicPaintTiming::MonotonicPaintTiming(
    std::optional<::base::TimeTicks> first_paint_in,
    std::optional<::base::TimeTicks> first_contentful_paint_in)
    : first_paint(std::move(first_paint_in)),
      first_contentful_paint(std::move(first_contentful_paint_in)) {}

MonotonicPaintTiming::~MonotonicPaintTiming() = default;

void MonotonicPaintTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_paint"), this->first_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_contentful_paint"), this->first_contentful_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MonotonicPaintTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ParseTiming::ParseTiming()
    : parse_start(),
      parse_stop(),
      parse_blocked_on_script_load_duration(),
      parse_blocked_on_script_load_from_document_write_duration(),
      parse_blocked_on_script_execution_duration(),
      parse_blocked_on_script_execution_from_document_write_duration() {}

ParseTiming::ParseTiming(
    std::optional<::base::TimeDelta> parse_start_in,
    std::optional<::base::TimeDelta> parse_stop_in,
    std::optional<::base::TimeDelta> parse_blocked_on_script_load_duration_in,
    std::optional<::base::TimeDelta> parse_blocked_on_script_load_from_document_write_duration_in,
    std::optional<::base::TimeDelta> parse_blocked_on_script_execution_duration_in,
    std::optional<::base::TimeDelta> parse_blocked_on_script_execution_from_document_write_duration_in)
    : parse_start(std::move(parse_start_in)),
      parse_stop(std::move(parse_stop_in)),
      parse_blocked_on_script_load_duration(std::move(parse_blocked_on_script_load_duration_in)),
      parse_blocked_on_script_load_from_document_write_duration(std::move(parse_blocked_on_script_load_from_document_write_duration_in)),
      parse_blocked_on_script_execution_duration(std::move(parse_blocked_on_script_execution_duration_in)),
      parse_blocked_on_script_execution_from_document_write_duration(std::move(parse_blocked_on_script_execution_from_document_write_duration_in)) {}

ParseTiming::~ParseTiming() = default;

void ParseTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parse_start"), this->parse_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parse_stop"), this->parse_stop,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parse_blocked_on_script_load_duration"), this->parse_blocked_on_script_load_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parse_blocked_on_script_load_from_document_write_duration"), this->parse_blocked_on_script_load_from_document_write_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parse_blocked_on_script_execution_duration"), this->parse_blocked_on_script_execution_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parse_blocked_on_script_execution_from_document_write_duration"), this->parse_blocked_on_script_execution_from_document_write_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ParseTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InteractiveTiming::InteractiveTiming()
    : first_input_delay(),
      first_input_timestamp(),
      first_scroll_delay(),
      first_scroll_timestamp() {}

InteractiveTiming::InteractiveTiming(
    std::optional<::base::TimeDelta> first_input_delay_in,
    std::optional<::base::TimeDelta> first_input_timestamp_in,
    std::optional<::base::TimeDelta> first_scroll_delay_in,
    std::optional<::base::TimeDelta> first_scroll_timestamp_in)
    : first_input_delay(std::move(first_input_delay_in)),
      first_input_timestamp(std::move(first_input_timestamp_in)),
      first_scroll_delay(std::move(first_scroll_delay_in)),
      first_scroll_timestamp(std::move(first_scroll_timestamp_in)) {}

InteractiveTiming::~InteractiveTiming() = default;

void InteractiveTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_input_delay"), this->first_input_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_input_timestamp"), this->first_input_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_scroll_delay"), this->first_scroll_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_scroll_timestamp"), this->first_scroll_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InteractiveTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CustomUserTimingMark::CustomUserTimingMark()
    : mark_name(),
      start_time() {}

CustomUserTimingMark::CustomUserTimingMark(
    const std::string& mark_name_in,
    ::base::TimeDelta start_time_in)
    : mark_name(std::move(mark_name_in)),
      start_time(std::move(start_time_in)) {}

CustomUserTimingMark::~CustomUserTimingMark() = default;

void CustomUserTimingMark::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mark_name"), this->mark_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CustomUserTimingMark::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DomainLookupTiming::DomainLookupTiming()
    : domain_lookup_start(),
      domain_lookup_end() {}

DomainLookupTiming::DomainLookupTiming(
    std::optional<::base::TimeDelta> domain_lookup_start_in,
    std::optional<::base::TimeDelta> domain_lookup_end_in)
    : domain_lookup_start(std::move(domain_lookup_start_in)),
      domain_lookup_end(std::move(domain_lookup_end_in)) {}

DomainLookupTiming::~DomainLookupTiming() = default;

void DomainLookupTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain_lookup_start"), this->domain_lookup_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain_lookup_end"), this->domain_lookup_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DomainLookupTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PageLoadTiming::PageLoadTiming()
    : navigation_start(),
      connect_start(),
      connect_end(),
      response_start(),
      document_timing(),
      interactive_timing(),
      paint_timing(),
      parse_timing(),
      domain_lookup_timing(),
      back_forward_cache_timings(),
      activation_start(),
      input_to_navigation_start(),
      user_timing_mark_fully_loaded(),
      user_timing_mark_fully_visible(),
      user_timing_mark_interactive(),
      monotonic_paint_timing() {}

PageLoadTiming::PageLoadTiming(
    ::base::Time navigation_start_in,
    std::optional<::base::TimeDelta> connect_start_in,
    std::optional<::base::TimeDelta> connect_end_in,
    std::optional<::base::TimeDelta> response_start_in,
    DocumentTimingPtr document_timing_in,
    InteractiveTimingPtr interactive_timing_in,
    PaintTimingPtr paint_timing_in,
    ParseTimingPtr parse_timing_in,
    DomainLookupTimingPtr domain_lookup_timing_in,
    std::vector<BackForwardCacheTimingPtr> back_forward_cache_timings_in,
    std::optional<::base::TimeDelta> activation_start_in,
    std::optional<::base::TimeDelta> input_to_navigation_start_in,
    std::optional<::base::TimeDelta> user_timing_mark_fully_loaded_in,
    std::optional<::base::TimeDelta> user_timing_mark_fully_visible_in,
    std::optional<::base::TimeDelta> user_timing_mark_interactive_in,
    MonotonicPaintTimingPtr monotonic_paint_timing_in)
    : navigation_start(std::move(navigation_start_in)),
      connect_start(std::move(connect_start_in)),
      connect_end(std::move(connect_end_in)),
      response_start(std::move(response_start_in)),
      document_timing(std::move(document_timing_in)),
      interactive_timing(std::move(interactive_timing_in)),
      paint_timing(std::move(paint_timing_in)),
      parse_timing(std::move(parse_timing_in)),
      domain_lookup_timing(std::move(domain_lookup_timing_in)),
      back_forward_cache_timings(std::move(back_forward_cache_timings_in)),
      activation_start(std::move(activation_start_in)),
      input_to_navigation_start(std::move(input_to_navigation_start_in)),
      user_timing_mark_fully_loaded(std::move(user_timing_mark_fully_loaded_in)),
      user_timing_mark_fully_visible(std::move(user_timing_mark_fully_visible_in)),
      user_timing_mark_interactive(std::move(user_timing_mark_interactive_in)),
      monotonic_paint_timing(std::move(monotonic_paint_timing_in)) {}

PageLoadTiming::~PageLoadTiming() = default;

void PageLoadTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start"), this->navigation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connect_start"), this->connect_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connect_end"), this->connect_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_start"), this->response_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_timing"), this->document_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DocumentTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interactive_timing"), this->interactive_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InteractiveTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "paint_timing"), this->paint_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaintTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parse_timing"), this->parse_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ParseTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain_lookup_timing"), this->domain_lookup_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DomainLookupTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "back_forward_cache_timings"), this->back_forward_cache_timings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<BackForwardCacheTimingPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activation_start"), this->activation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_to_navigation_start"), this->input_to_navigation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_timing_mark_fully_loaded"), this->user_timing_mark_fully_loaded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_timing_mark_fully_visible"), this->user_timing_mark_fully_visible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_timing_mark_interactive"), this->user_timing_mark_interactive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "monotonic_paint_timing"), this->monotonic_paint_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MonotonicPaintTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageLoadTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameMetadata::FrameMetadata()
    : behavior_flags(0),
      main_frame_intersection_rect(),
      main_frame_viewport_rect(),
      main_frame_ad_rects(),
      framework_detection_result() {}

FrameMetadata::FrameMetadata(
    int32_t behavior_flags_in,
    const std::optional<::gfx::Rect>& main_frame_intersection_rect_in,
    const std::optional<::gfx::Rect>& main_frame_viewport_rect_in,
    const base::flat_map<int32_t, ::gfx::Rect>& main_frame_ad_rects_in,
    const ::blink::JavaScriptFrameworkDetectionResult& framework_detection_result_in)
    : behavior_flags(std::move(behavior_flags_in)),
      main_frame_intersection_rect(std::move(main_frame_intersection_rect_in)),
      main_frame_viewport_rect(std::move(main_frame_viewport_rect_in)),
      main_frame_ad_rects(std::move(main_frame_ad_rects_in)),
      framework_detection_result(std::move(framework_detection_result_in)) {}

FrameMetadata::~FrameMetadata() = default;

void FrameMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "behavior_flags"), this->behavior_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_intersection_rect"), this->main_frame_intersection_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_viewport_rect"), this->main_frame_viewport_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_ad_rects"), this->main_frame_ad_rects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<int32_t, ::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framework_detection_result"), this->framework_detection_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::JavaScriptFrameworkDetectionResult&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubresourceLoadMetrics::SubresourceLoadMetrics()
    : number_of_subresources_loaded(),
      number_of_subresource_loads_handled_by_service_worker(),
      service_worker_subresource_load_metrics() {}

SubresourceLoadMetrics::SubresourceLoadMetrics(
    uint32_t number_of_subresources_loaded_in,
    uint32_t number_of_subresource_loads_handled_by_service_worker_in,
    const std::optional<::blink::ServiceWorkerSubresourceLoadMetrics>& service_worker_subresource_load_metrics_in)
    : number_of_subresources_loaded(std::move(number_of_subresources_loaded_in)),
      number_of_subresource_loads_handled_by_service_worker(std::move(number_of_subresource_loads_handled_by_service_worker_in)),
      service_worker_subresource_load_metrics(std::move(service_worker_subresource_load_metrics_in)) {}

SubresourceLoadMetrics::~SubresourceLoadMetrics() = default;

void SubresourceLoadMetrics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_subresources_loaded"), this->number_of_subresources_loaded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_subresource_loads_handled_by_service_worker"), this->number_of_subresource_loads_handled_by_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_subresource_load_metrics"), this->service_worker_subresource_load_metrics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::ServiceWorkerSubresourceLoadMetrics>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubresourceLoadMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerSubresourceLoadMetrics::ServiceWorkerSubresourceLoadMetrics()
    : image_handled(),
      image_fallback(),
      css_handled(),
      css_fallback(),
      script_handled(),
      script_fallback(),
      font_handled(),
      font_fallback(),
      raw_handled(),
      raw_fallback(),
      svg_handled(),
      svg_fallback(),
      xsl_handled(),
      xsl_fallback(),
      link_prefetch_handled(),
      link_prefetch_fallback(),
      text_track_handled(),
      text_track_fallback(),
      audio_handled(),
      audio_fallback(),
      video_handled(),
      video_fallback(),
      manifest_handled(),
      manifest_fallback(),
      speculation_rules_handled(),
      speculation_rules_fallback(),
      mock_handled(),
      mock_fallback(),
      dictionary_handled(),
      dictionary_fallback(),
      matched_cache_router_source_count(0U),
      matched_fetch_event_router_source_count(0U),
      matched_network_router_source_count(0U),
      matched_race_network_and_fetch_router_source_count(0U),
      matched_race_network_and_cache_router_source_count(0U),
      total_router_evaluation_time_for_subresources(),
      total_cache_lookup_time_for_subresources() {}

ServiceWorkerSubresourceLoadMetrics::ServiceWorkerSubresourceLoadMetrics(
    bool image_handled_in,
    bool image_fallback_in,
    bool css_handled_in,
    bool css_fallback_in,
    bool script_handled_in,
    bool script_fallback_in,
    bool font_handled_in,
    bool font_fallback_in,
    bool raw_handled_in,
    bool raw_fallback_in,
    bool svg_handled_in,
    bool svg_fallback_in,
    bool xsl_handled_in,
    bool xsl_fallback_in,
    bool link_prefetch_handled_in,
    bool link_prefetch_fallback_in,
    bool text_track_handled_in,
    bool text_track_fallback_in,
    bool audio_handled_in,
    bool audio_fallback_in,
    bool video_handled_in,
    bool video_fallback_in,
    bool manifest_handled_in,
    bool manifest_fallback_in,
    bool speculation_rules_handled_in,
    bool speculation_rules_fallback_in,
    bool mock_handled_in,
    bool mock_fallback_in,
    bool dictionary_handled_in,
    bool dictionary_fallback_in,
    uint32_t matched_cache_router_source_count_in,
    uint32_t matched_fetch_event_router_source_count_in,
    uint32_t matched_network_router_source_count_in,
    uint32_t matched_race_network_and_fetch_router_source_count_in,
    uint32_t matched_race_network_and_cache_router_source_count_in,
    ::base::TimeDelta total_router_evaluation_time_for_subresources_in,
    ::base::TimeDelta total_cache_lookup_time_for_subresources_in)
    : image_handled(std::move(image_handled_in)),
      image_fallback(std::move(image_fallback_in)),
      css_handled(std::move(css_handled_in)),
      css_fallback(std::move(css_fallback_in)),
      script_handled(std::move(script_handled_in)),
      script_fallback(std::move(script_fallback_in)),
      font_handled(std::move(font_handled_in)),
      font_fallback(std::move(font_fallback_in)),
      raw_handled(std::move(raw_handled_in)),
      raw_fallback(std::move(raw_fallback_in)),
      svg_handled(std::move(svg_handled_in)),
      svg_fallback(std::move(svg_fallback_in)),
      xsl_handled(std::move(xsl_handled_in)),
      xsl_fallback(std::move(xsl_fallback_in)),
      link_prefetch_handled(std::move(link_prefetch_handled_in)),
      link_prefetch_fallback(std::move(link_prefetch_fallback_in)),
      text_track_handled(std::move(text_track_handled_in)),
      text_track_fallback(std::move(text_track_fallback_in)),
      audio_handled(std::move(audio_handled_in)),
      audio_fallback(std::move(audio_fallback_in)),
      video_handled(std::move(video_handled_in)),
      video_fallback(std::move(video_fallback_in)),
      manifest_handled(std::move(manifest_handled_in)),
      manifest_fallback(std::move(manifest_fallback_in)),
      speculation_rules_handled(std::move(speculation_rules_handled_in)),
      speculation_rules_fallback(std::move(speculation_rules_fallback_in)),
      mock_handled(std::move(mock_handled_in)),
      mock_fallback(std::move(mock_fallback_in)),
      dictionary_handled(std::move(dictionary_handled_in)),
      dictionary_fallback(std::move(dictionary_fallback_in)),
      matched_cache_router_source_count(std::move(matched_cache_router_source_count_in)),
      matched_fetch_event_router_source_count(std::move(matched_fetch_event_router_source_count_in)),
      matched_network_router_source_count(std::move(matched_network_router_source_count_in)),
      matched_race_network_and_fetch_router_source_count(std::move(matched_race_network_and_fetch_router_source_count_in)),
      matched_race_network_and_cache_router_source_count(std::move(matched_race_network_and_cache_router_source_count_in)),
      total_router_evaluation_time_for_subresources(std::move(total_router_evaluation_time_for_subresources_in)),
      total_cache_lookup_time_for_subresources(std::move(total_cache_lookup_time_for_subresources_in)) {}

ServiceWorkerSubresourceLoadMetrics::~ServiceWorkerSubresourceLoadMetrics() = default;

void ServiceWorkerSubresourceLoadMetrics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_handled"), this->image_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_fallback"), this->image_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "css_handled"), this->css_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "css_fallback"), this->css_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_handled"), this->script_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_fallback"), this->script_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_handled"), this->font_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_fallback"), this->font_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_handled"), this->raw_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_fallback"), this->raw_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "svg_handled"), this->svg_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "svg_fallback"), this->svg_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "xsl_handled"), this->xsl_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "xsl_fallback"), this->xsl_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_prefetch_handled"), this->link_prefetch_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_prefetch_fallback"), this->link_prefetch_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_track_handled"), this->text_track_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_track_fallback"), this->text_track_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_handled"), this->audio_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_fallback"), this->audio_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_handled"), this->video_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_fallback"), this->video_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_handled"), this->manifest_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_fallback"), this->manifest_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "speculation_rules_handled"), this->speculation_rules_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "speculation_rules_fallback"), this->speculation_rules_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mock_handled"), this->mock_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mock_fallback"), this->mock_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dictionary_handled"), this->dictionary_handled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dictionary_fallback"), this->dictionary_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matched_cache_router_source_count"), this->matched_cache_router_source_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matched_fetch_event_router_source_count"), this->matched_fetch_event_router_source_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matched_network_router_source_count"), this->matched_network_router_source_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matched_race_network_and_fetch_router_source_count"), this->matched_race_network_and_fetch_router_source_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matched_race_network_and_cache_router_source_count"), this->matched_race_network_and_cache_router_source_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_router_evaluation_time_for_subresources"), this->total_router_evaluation_time_for_subresources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_cache_lookup_time_for_subresources"), this->total_cache_lookup_time_for_subresources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerSubresourceLoadMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResourceDataUpdate::ResourceDataUpdate()
    : request_id(0),
      delta_bytes(),
      received_data_length(),
      encoded_body_length(),
      decoded_body_length(),
      is_complete(),
      reported_as_ad_resource(),
      is_main_frame_resource(),
      cache_type(),
      is_primary_frame_resource(),
      mime_type(),
      is_secure_scheme(),
      proxy_used() {}

ResourceDataUpdate::ResourceDataUpdate(
    int32_t request_id_in,
    ::base::ByteCount delta_bytes_in,
    ::base::ByteCount received_data_length_in,
    ::base::ByteCount encoded_body_length_in,
    ::base::ByteCount decoded_body_length_in,
    bool is_complete_in,
    bool reported_as_ad_resource_in,
    bool is_main_frame_resource_in,
    CacheType cache_type_in,
    bool is_primary_frame_resource_in,
    const std::string& mime_type_in,
    bool is_secure_scheme_in,
    bool proxy_used_in)
    : request_id(std::move(request_id_in)),
      delta_bytes(std::move(delta_bytes_in)),
      received_data_length(std::move(received_data_length_in)),
      encoded_body_length(std::move(encoded_body_length_in)),
      decoded_body_length(std::move(decoded_body_length_in)),
      is_complete(std::move(is_complete_in)),
      reported_as_ad_resource(std::move(reported_as_ad_resource_in)),
      is_main_frame_resource(std::move(is_main_frame_resource_in)),
      cache_type(std::move(cache_type_in)),
      is_primary_frame_resource(std::move(is_primary_frame_resource_in)),
      mime_type(std::move(mime_type_in)),
      is_secure_scheme(std::move(is_secure_scheme_in)),
      proxy_used(std::move(proxy_used_in)) {}

ResourceDataUpdate::~ResourceDataUpdate() = default;

void ResourceDataUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_bytes"), this->delta_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "received_data_length"), this->received_data_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_body_length"), this->encoded_body_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoded_body_length"), this->decoded_body_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ByteCount>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_complete"), this->is_complete,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reported_as_ad_resource"), this->reported_as_ad_resource,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_main_frame_resource"), this->is_main_frame_resource,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_type"), this->cache_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CacheType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_primary_frame_resource"), this->is_primary_frame_resource,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_secure_scheme"), this->is_secure_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_used"), this->proxy_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResourceDataUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LayoutShift::LayoutShift()
    : layout_shift_time(),
      layout_shift_score() {}

LayoutShift::LayoutShift(
    ::base::TimeTicks layout_shift_time_in,
    double layout_shift_score_in)
    : layout_shift_time(std::move(layout_shift_time_in)),
      layout_shift_score(std::move(layout_shift_score_in)) {}

LayoutShift::~LayoutShift() = default;

void LayoutShift::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout_shift_time"), this->layout_shift_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout_shift_score"), this->layout_shift_score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LayoutShift::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameRenderDataUpdate::FrameRenderDataUpdate()
    : layout_shift_delta(),
      layout_shift_delta_before_input_or_scroll(),
      new_layout_shifts() {}

FrameRenderDataUpdate::FrameRenderDataUpdate(
    float layout_shift_delta_in,
    float layout_shift_delta_before_input_or_scroll_in,
    std::vector<LayoutShiftPtr> new_layout_shifts_in)
    : layout_shift_delta(std::move(layout_shift_delta_in)),
      layout_shift_delta_before_input_or_scroll(std::move(layout_shift_delta_before_input_or_scroll_in)),
      new_layout_shifts(std::move(new_layout_shifts_in)) {}

FrameRenderDataUpdate::~FrameRenderDataUpdate() = default;

void FrameRenderDataUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout_shift_delta"), this->layout_shift_delta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout_shift_delta_before_input_or_scroll"), this->layout_shift_delta_before_input_or_scroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_layout_shifts"), this->new_layout_shifts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<LayoutShiftPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameRenderDataUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CpuTiming::CpuTiming()
    : task_time() {}

CpuTiming::CpuTiming(
    ::base::TimeDelta task_time_in)
    : task_time(std::move(task_time_in)) {}

CpuTiming::~CpuTiming() = default;

void CpuTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_time"), this->task_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CpuTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InputTiming::InputTiming()
    : user_interaction_latencies() {}

InputTiming::InputTiming(
    std::vector<UserInteractionLatencyPtr> user_interaction_latencies_in)
    : user_interaction_latencies(std::move(user_interaction_latencies_in)) {}

InputTiming::~InputTiming() = default;

void InputTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_interaction_latencies"), this->user_interaction_latencies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<UserInteractionLatencyPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InputTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UserInteractionLatency::UserInteractionLatency()
    : interaction_latency(),
      interaction_offset(),
      interaction_time() {}

UserInteractionLatency::UserInteractionLatency(
    ::base::TimeDelta interaction_latency_in,
    uint64_t interaction_offset_in,
    ::base::TimeTicks interaction_time_in)
    : interaction_latency(std::move(interaction_latency_in)),
      interaction_offset(std::move(interaction_offset_in)),
      interaction_time(std::move(interaction_time_in)) {}

UserInteractionLatency::~UserInteractionLatency() = default;

void UserInteractionLatency::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interaction_latency"), this->interaction_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interaction_offset"), this->interaction_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interaction_time"), this->interaction_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserInteractionLatency::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackForwardCacheTiming::BackForwardCacheTiming()
    : first_paint_after_back_forward_cache_restore(),
      request_animation_frames_after_back_forward_cache_restore(),
      first_input_delay_after_back_forward_cache_restore() {}

BackForwardCacheTiming::BackForwardCacheTiming(
    ::base::TimeDelta first_paint_after_back_forward_cache_restore_in,
    std::vector<::base::TimeDelta> request_animation_frames_after_back_forward_cache_restore_in,
    std::optional<::base::TimeDelta> first_input_delay_after_back_forward_cache_restore_in)
    : first_paint_after_back_forward_cache_restore(std::move(first_paint_after_back_forward_cache_restore_in)),
      request_animation_frames_after_back_forward_cache_restore(std::move(request_animation_frames_after_back_forward_cache_restore_in)),
      first_input_delay_after_back_forward_cache_restore(std::move(first_input_delay_after_back_forward_cache_restore_in)) {}

BackForwardCacheTiming::~BackForwardCacheTiming() = default;

void BackForwardCacheTiming::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_paint_after_back_forward_cache_restore"), this->first_paint_after_back_forward_cache_restore,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_animation_frames_after_back_forward_cache_restore"), this->request_animation_frames_after_back_forward_cache_restore,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::base::TimeDelta>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_input_delay_after_back_forward_cache_restore"), this->first_input_delay_after_back_forward_cache_restore,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackForwardCacheTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SoftNavigationMetrics::SoftNavigationMetrics()
    : count(),
      start_time(),
      navigation_id(),
      same_document_metrics_token(),
      largest_contentful_paint() {}

SoftNavigationMetrics::SoftNavigationMetrics(
    uint64_t count_in,
    ::base::TimeDelta start_time_in,
    uint32_t navigation_id_in,
    const std::optional<::base::UnguessableToken>& same_document_metrics_token_in,
    LargestContentfulPaintTimingPtr largest_contentful_paint_in)
    : count(std::move(count_in)),
      start_time(std::move(start_time_in)),
      navigation_id(std::move(navigation_id_in)),
      same_document_metrics_token(std::move(same_document_metrics_token_in)),
      largest_contentful_paint(std::move(largest_contentful_paint_in)) {}

SoftNavigationMetrics::~SoftNavigationMetrics() = default;

void SoftNavigationMetrics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "count"), this->count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_id"), this->navigation_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_document_metrics_token"), this->same_document_metrics_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "largest_contentful_paint"), this->largest_contentful_paint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LargestContentfulPaintTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SoftNavigationMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageLoadMetrics::IPCStableHashFunction PageLoadMetrics::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageLoadMetrics>(message.name())) {
    case messages::PageLoadMetrics::kUpdateTiming: {
      return &PageLoadMetrics::UpdateTiming_Sym::IPCStableHash;
    }
    case messages::PageLoadMetrics::kSetUpSharedMemoryForDroppedFrames: {
      return &PageLoadMetrics::SetUpSharedMemoryForDroppedFrames_Sym::IPCStableHash;
    }
    case messages::PageLoadMetrics::kAddCustomUserTiming: {
      return &PageLoadMetrics::AddCustomUserTiming_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageLoadMetrics::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageLoadMetrics>(message.name())) {
      case messages::PageLoadMetrics::kUpdateTiming:
            return "Receive page_load_metrics::mojom::PageLoadMetrics::UpdateTiming";
      case messages::PageLoadMetrics::kSetUpSharedMemoryForDroppedFrames:
            return "Receive page_load_metrics::mojom::PageLoadMetrics::SetUpSharedMemoryForDroppedFrames";
      case messages::PageLoadMetrics::kAddCustomUserTiming:
            return "Receive page_load_metrics::mojom::PageLoadMetrics::AddCustomUserTiming";
    }
  } else {
    switch (static_cast<messages::PageLoadMetrics>(message.name())) {
      case messages::PageLoadMetrics::kUpdateTiming:
            return "Receive reply page_load_metrics::mojom::PageLoadMetrics::UpdateTiming";
      case messages::PageLoadMetrics::kSetUpSharedMemoryForDroppedFrames:
            return "Receive reply page_load_metrics::mojom::PageLoadMetrics::SetUpSharedMemoryForDroppedFrames";
      case messages::PageLoadMetrics::kAddCustomUserTiming:
            return "Receive reply page_load_metrics::mojom::PageLoadMetrics::AddCustomUserTiming";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageLoadMetrics::UpdateTiming_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9dc7409e;  // IPCStableHash for page_load_metrics::mojom::PageLoadMetrics::UpdateTiming
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageLoadMetrics::SetUpSharedMemoryForDroppedFrames_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc954c520;  // IPCStableHash for page_load_metrics::mojom::PageLoadMetrics::SetUpSharedMemoryForDroppedFrames
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageLoadMetrics::AddCustomUserTiming_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6415a65;  // IPCStableHash for page_load_metrics::mojom::PageLoadMetrics::AddCustomUserTiming
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageLoadMetricsProxy::PageLoadMetricsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageLoadMetricsProxy::UpdateTiming(
    PageLoadTimingPtr in_page_load_timing, FrameMetadataPtr in_frame_metadata, const std::vector<::blink::UseCounterFeature>& in_new_features, std::vector<ResourceDataUpdatePtr> in_resources, FrameRenderDataUpdatePtr in_render_data, CpuTimingPtr in_cpu_load_timing, InputTimingPtr in_input_timing_delta, const std::optional<::blink::SubresourceLoadMetrics>& in_subresource_load_metrics, SoftNavigationMetricsPtr in_soft_navigation_metrics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send page_load_metrics::mojom::PageLoadMetrics::UpdateTiming", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_load_timing"), in_page_load_timing,
                        "<value of type PageLoadTimingPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_metadata"), in_frame_metadata,
                        "<value of type FrameMetadataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_features"), in_new_features,
                        "<value of type const std::vector<::blink::UseCounterFeature>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type std::vector<ResourceDataUpdatePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_data"), in_render_data,
                        "<value of type FrameRenderDataUpdatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cpu_load_timing"), in_cpu_load_timing,
                        "<value of type CpuTimingPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_timing_delta"), in_input_timing_delta,
                        "<value of type InputTimingPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_load_metrics"), in_subresource_load_metrics,
                        "<value of type const std::optional<::blink::SubresourceLoadMetrics>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("soft_navigation_metrics"), in_soft_navigation_metrics,
                        "<value of type SoftNavigationMetricsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageLoadMetrics::kUpdateTiming), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::page_load_metrics::mojom::internal::PageLoadMetrics_UpdateTiming_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_load_timing)::BaseType> page_load_timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_load_metrics::mojom::PageLoadTimingDataView>(
    in_page_load_timing,
    page_load_timing_fragment);

  params->page_load_timing.Set(
      page_load_timing_fragment.is_null() ? nullptr : page_load_timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_load_timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_load_timing in PageLoadMetrics.UpdateTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_metadata)::BaseType> frame_metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_load_metrics::mojom::FrameMetadataDataView>(
    in_frame_metadata,
    frame_metadata_fragment);

  params->frame_metadata.Set(
      frame_metadata_fragment.is_null() ? nullptr : frame_metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_metadata in PageLoadMetrics.UpdateTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_features)::BaseType>
      new_features_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& new_features_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::UseCounterFeatureDataView>>(
    in_new_features,
    new_features_fragment,
    &new_features_validate_params);

  params->new_features.Set(
      new_features_fragment.is_null() ? nullptr : new_features_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_features.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_features in PageLoadMetrics.UpdateTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::page_load_metrics::mojom::ResourceDataUpdateDataView>>(
    in_resources,
    resources_fragment,
    &resources_validate_params);

  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resources in PageLoadMetrics.UpdateTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->render_data)::BaseType> render_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_load_metrics::mojom::FrameRenderDataUpdateDataView>(
    in_render_data,
    render_data_fragment);

  params->render_data.Set(
      render_data_fragment.is_null() ? nullptr : render_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->render_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null render_data in PageLoadMetrics.UpdateTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->cpu_load_timing)::BaseType> cpu_load_timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_load_metrics::mojom::CpuTimingDataView>(
    in_cpu_load_timing,
    cpu_load_timing_fragment);

  params->cpu_load_timing.Set(
      cpu_load_timing_fragment.is_null() ? nullptr : cpu_load_timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cpu_load_timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cpu_load_timing in PageLoadMetrics.UpdateTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->input_timing_delta)::BaseType> input_timing_delta_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_load_metrics::mojom::InputTimingDataView>(
    in_input_timing_delta,
    input_timing_delta_fragment);

  params->input_timing_delta.Set(
      input_timing_delta_fragment.is_null() ? nullptr : input_timing_delta_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_timing_delta.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_timing_delta in PageLoadMetrics.UpdateTiming request");
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_load_metrics)::BaseType> subresource_load_metrics_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_load_metrics::mojom::SubresourceLoadMetricsDataView>(
    in_subresource_load_metrics,
    subresource_load_metrics_fragment);

  params->subresource_load_metrics.Set(
      subresource_load_metrics_fragment.is_null() ? nullptr : subresource_load_metrics_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->soft_navigation_metrics)::BaseType> soft_navigation_metrics_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_load_metrics::mojom::SoftNavigationMetricsDataView>(
    in_soft_navigation_metrics,
    soft_navigation_metrics_fragment);

  params->soft_navigation_metrics.Set(
      soft_navigation_metrics_fragment.is_null() ? nullptr : soft_navigation_metrics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->soft_navigation_metrics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null soft_navigation_metrics in PageLoadMetrics.UpdateTiming request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageLoadMetrics::Name_);
  message.set_method_name("UpdateTiming");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageLoadMetricsProxy::SetUpSharedMemoryForDroppedFrames(
    ::base::ReadOnlySharedMemoryRegion in_dropped_frames_memory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send page_load_metrics::mojom::PageLoadMetrics::SetUpSharedMemoryForDroppedFrames", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dropped_frames_memory"), in_dropped_frames_memory,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageLoadMetrics::kSetUpSharedMemoryForDroppedFrames), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::page_load_metrics::mojom::internal::PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dropped_frames_memory)::BaseType> dropped_frames_memory_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_dropped_frames_memory,
    dropped_frames_memory_fragment);

  params->dropped_frames_memory.Set(
      dropped_frames_memory_fragment.is_null() ? nullptr : dropped_frames_memory_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dropped_frames_memory.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dropped_frames_memory in PageLoadMetrics.SetUpSharedMemoryForDroppedFrames request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageLoadMetrics::Name_);
  message.set_method_name("SetUpSharedMemoryForDroppedFrames");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageLoadMetricsProxy::AddCustomUserTiming(
    CustomUserTimingMarkPtr in_custom_user_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send page_load_metrics::mojom::PageLoadMetrics::AddCustomUserTiming", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("custom_user_timing"), in_custom_user_timing,
                        "<value of type CustomUserTimingMarkPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageLoadMetrics::kAddCustomUserTiming), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::page_load_metrics::mojom::internal::PageLoadMetrics_AddCustomUserTiming_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->custom_user_timing)::BaseType> custom_user_timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_load_metrics::mojom::CustomUserTimingMarkDataView>(
    in_custom_user_timing,
    custom_user_timing_fragment);

  params->custom_user_timing.Set(
      custom_user_timing_fragment.is_null() ? nullptr : custom_user_timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->custom_user_timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null custom_user_timing in PageLoadMetrics.AddCustomUserTiming request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageLoadMetrics::Name_);
  message.set_method_name("AddCustomUserTiming");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageLoadMetricsStubDispatch::Accept(
    PageLoadMetrics* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageLoadMetrics>(message->header()->name)) {
    case messages::PageLoadMetrics::kUpdateTiming: {
      DCHECK(message->is_serialized());
      internal::PageLoadMetrics_UpdateTiming_Params_Data* params =
          reinterpret_cast<internal::PageLoadMetrics_UpdateTiming_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageLoadMetrics.0
      bool success = true;
      PageLoadTimingPtr p_page_load_timing{};
      FrameMetadataPtr p_frame_metadata{};
      std::vector<::blink::UseCounterFeature> p_new_features{};
      std::vector<ResourceDataUpdatePtr> p_resources{};
      FrameRenderDataUpdatePtr p_render_data{};
      CpuTimingPtr p_cpu_load_timing{};
      InputTimingPtr p_input_timing_delta{};
      std::optional<::blink::SubresourceLoadMetrics> p_subresource_load_metrics{};
      SoftNavigationMetricsPtr p_soft_navigation_metrics{};
      PageLoadMetrics_UpdateTiming_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageLoadTiming(&p_page_load_timing))
        success = false;
      if (success && !input_data_view.ReadFrameMetadata(&p_frame_metadata))
        success = false;
      if (success && !input_data_view.ReadNewFeatures(&p_new_features))
        success = false;
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (success && !input_data_view.ReadRenderData(&p_render_data))
        success = false;
      if (success && !input_data_view.ReadCpuLoadTiming(&p_cpu_load_timing))
        success = false;
      if (success && !input_data_view.ReadInputTimingDelta(&p_input_timing_delta))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoadMetrics(&p_subresource_load_metrics))
        success = false;
      if (success && !input_data_view.ReadSoftNavigationMetrics(&p_soft_navigation_metrics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageLoadMetrics::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTiming(        
        std::move(p_page_load_timing), 
        std::move(p_frame_metadata), 
        std::move(p_new_features), 
        std::move(p_resources), 
        std::move(p_render_data), 
        std::move(p_cpu_load_timing), 
        std::move(p_input_timing_delta), 
        std::move(p_subresource_load_metrics), 
        std::move(p_soft_navigation_metrics));
      return true;
    }
    case messages::PageLoadMetrics::kSetUpSharedMemoryForDroppedFrames: {
      DCHECK(message->is_serialized());
      internal::PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data* params =
          reinterpret_cast<internal::PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageLoadMetrics.1
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_dropped_frames_memory{};
      PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDroppedFramesMemory(&p_dropped_frames_memory))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageLoadMetrics::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUpSharedMemoryForDroppedFrames(        
        std::move(p_dropped_frames_memory));
      return true;
    }
    case messages::PageLoadMetrics::kAddCustomUserTiming: {
      DCHECK(message->is_serialized());
      internal::PageLoadMetrics_AddCustomUserTiming_Params_Data* params =
          reinterpret_cast<internal::PageLoadMetrics_AddCustomUserTiming_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageLoadMetrics.2
      bool success = true;
      CustomUserTimingMarkPtr p_custom_user_timing{};
      PageLoadMetrics_AddCustomUserTiming_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCustomUserTiming(&p_custom_user_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageLoadMetrics::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddCustomUserTiming(        
        std::move(p_custom_user_timing));
      return true;
    }
  }
  return false;
}

// static
bool PageLoadMetricsStubDispatch::AcceptWithResponder(
    PageLoadMetrics* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageLoadMetrics>(message->header()->name)) {
    case messages::PageLoadMetrics::kUpdateTiming: {
      break;
    }
    case messages::PageLoadMetrics::kSetUpSharedMemoryForDroppedFrames: {
      break;
    }
    case messages::PageLoadMetrics::kAddCustomUserTiming: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageLoadMetricsValidationInfo[] = {
    { &internal::PageLoadMetrics_UpdateTiming_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageLoadMetrics_AddCustomUserTiming_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageLoadMetricsRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::page_load_metrics::mojom::PageLoadMetrics::Name_,
    kPageLoadMetricsValidationInfo);
}



}  // page_load_metrics::mojom


namespace mojo {


// static
bool StructTraits<::page_load_metrics::mojom::DocumentTiming::DataView, ::page_load_metrics::mojom::DocumentTimingPtr>::Read(
    ::page_load_metrics::mojom::DocumentTiming::DataView input,
    ::page_load_metrics::mojom::DocumentTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::DocumentTimingPtr result(::page_load_metrics::mojom::DocumentTiming::New());
  
      if (success && !input.ReadDomContentLoadedEventStart(&result->dom_content_loaded_event_start))
        success = false;
      if (success && !input.ReadLoadEventStart(&result->load_event_start))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::LcpResourceLoadTimings::DataView, ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr>::Read(
    ::page_load_metrics::mojom::LcpResourceLoadTimings::DataView input,
    ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::LcpResourceLoadTimingsPtr result(::page_load_metrics::mojom::LcpResourceLoadTimings::New());
  
      if (success && !input.ReadDiscoveryTime(&result->discovery_time))
        success = false;
      if (success && !input.ReadLoadStart(&result->load_start))
        success = false;
      if (success && !input.ReadLoadEnd(&result->load_end))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::LargestContentfulPaintTiming::DataView, ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr>::Read(
    ::page_load_metrics::mojom::LargestContentfulPaintTiming::DataView input,
    ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::LargestContentfulPaintTimingPtr result(::page_load_metrics::mojom::LargestContentfulPaintTiming::New());
  
      if (success && !input.ReadLargestImagePaint(&result->largest_image_paint))
        success = false;
      if (success)
        result->largest_image_paint_size = input.largest_image_paint_size();
      if (success && !input.ReadLargestTextPaint(&result->largest_text_paint))
        success = false;
      if (success)
        result->largest_text_paint_size = input.largest_text_paint_size();
      if (success && !input.ReadResourceLoadTimings(&result->resource_load_timings))
        success = false;
      if (success)
        result->type = input.type();
      if (success)
        result->image_bpp = input.image_bpp();
      if (success)
        result->image_request_priority_valid = input.image_request_priority_valid();
      if (success && !input.ReadImageRequestPriorityValue(&result->image_request_priority_value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::PaintTiming::DataView, ::page_load_metrics::mojom::PaintTimingPtr>::Read(
    ::page_load_metrics::mojom::PaintTiming::DataView input,
    ::page_load_metrics::mojom::PaintTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::PaintTimingPtr result(::page_load_metrics::mojom::PaintTiming::New());
  
      if (success && !input.ReadFirstPaint(&result->first_paint))
        success = false;
      if (success && !input.ReadFirstImagePaint(&result->first_image_paint))
        success = false;
      if (success && !input.ReadFirstContentfulPaint(&result->first_contentful_paint))
        success = false;
      if (success && !input.ReadFirstMeaningfulPaint(&result->first_meaningful_paint))
        success = false;
      if (success && !input.ReadLargestContentfulPaint(&result->largest_contentful_paint))
        success = false;
      if (success && !input.ReadExperimentalLargestContentfulPaint(&result->experimental_largest_contentful_paint))
        success = false;
      if (success && !input.ReadFirstEligibleToPaint(&result->first_eligible_to_paint))
        success = false;
      if (success && !input.ReadFirstInputOrScrollNotifiedTimestamp(&result->first_input_or_scroll_notified_timestamp))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::MonotonicPaintTiming::DataView, ::page_load_metrics::mojom::MonotonicPaintTimingPtr>::Read(
    ::page_load_metrics::mojom::MonotonicPaintTiming::DataView input,
    ::page_load_metrics::mojom::MonotonicPaintTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::MonotonicPaintTimingPtr result(::page_load_metrics::mojom::MonotonicPaintTiming::New());
  
      if (success && !input.ReadFirstPaint(&result->first_paint))
        success = false;
      if (success && !input.ReadFirstContentfulPaint(&result->first_contentful_paint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::ParseTiming::DataView, ::page_load_metrics::mojom::ParseTimingPtr>::Read(
    ::page_load_metrics::mojom::ParseTiming::DataView input,
    ::page_load_metrics::mojom::ParseTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::ParseTimingPtr result(::page_load_metrics::mojom::ParseTiming::New());
  
      if (success && !input.ReadParseStart(&result->parse_start))
        success = false;
      if (success && !input.ReadParseStop(&result->parse_stop))
        success = false;
      if (success && !input.ReadParseBlockedOnScriptLoadDuration(&result->parse_blocked_on_script_load_duration))
        success = false;
      if (success && !input.ReadParseBlockedOnScriptLoadFromDocumentWriteDuration(&result->parse_blocked_on_script_load_from_document_write_duration))
        success = false;
      if (success && !input.ReadParseBlockedOnScriptExecutionDuration(&result->parse_blocked_on_script_execution_duration))
        success = false;
      if (success && !input.ReadParseBlockedOnScriptExecutionFromDocumentWriteDuration(&result->parse_blocked_on_script_execution_from_document_write_duration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::InteractiveTiming::DataView, ::page_load_metrics::mojom::InteractiveTimingPtr>::Read(
    ::page_load_metrics::mojom::InteractiveTiming::DataView input,
    ::page_load_metrics::mojom::InteractiveTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::InteractiveTimingPtr result(::page_load_metrics::mojom::InteractiveTiming::New());
  
      if (success && !input.ReadFirstInputDelay(&result->first_input_delay))
        success = false;
      if (success && !input.ReadFirstInputTimestamp(&result->first_input_timestamp))
        success = false;
      if (success && !input.ReadFirstScrollDelay(&result->first_scroll_delay))
        success = false;
      if (success && !input.ReadFirstScrollTimestamp(&result->first_scroll_timestamp))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::CustomUserTimingMark::DataView, ::page_load_metrics::mojom::CustomUserTimingMarkPtr>::Read(
    ::page_load_metrics::mojom::CustomUserTimingMark::DataView input,
    ::page_load_metrics::mojom::CustomUserTimingMarkPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::CustomUserTimingMarkPtr result(::page_load_metrics::mojom::CustomUserTimingMark::New());
  
      if (success && !input.ReadMarkName(&result->mark_name))
        success = false;
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::DomainLookupTiming::DataView, ::page_load_metrics::mojom::DomainLookupTimingPtr>::Read(
    ::page_load_metrics::mojom::DomainLookupTiming::DataView input,
    ::page_load_metrics::mojom::DomainLookupTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::DomainLookupTimingPtr result(::page_load_metrics::mojom::DomainLookupTiming::New());
  
      if (success && !input.ReadDomainLookupStart(&result->domain_lookup_start))
        success = false;
      if (success && !input.ReadDomainLookupEnd(&result->domain_lookup_end))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::PageLoadTiming::DataView, ::page_load_metrics::mojom::PageLoadTimingPtr>::Read(
    ::page_load_metrics::mojom::PageLoadTiming::DataView input,
    ::page_load_metrics::mojom::PageLoadTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::PageLoadTimingPtr result(::page_load_metrics::mojom::PageLoadTiming::New());
  
      if (success && !input.ReadNavigationStart(&result->navigation_start))
        success = false;
      if (success && !input.ReadConnectStart(&result->connect_start))
        success = false;
      if (success && !input.ReadConnectEnd(&result->connect_end))
        success = false;
      if (success && !input.ReadResponseStart(&result->response_start))
        success = false;
      if (success && !input.ReadDocumentTiming(&result->document_timing))
        success = false;
      if (success && !input.ReadInteractiveTiming(&result->interactive_timing))
        success = false;
      if (success && !input.ReadPaintTiming(&result->paint_timing))
        success = false;
      if (success && !input.ReadParseTiming(&result->parse_timing))
        success = false;
      if (success && !input.ReadDomainLookupTiming(&result->domain_lookup_timing))
        success = false;
      if (success && !input.ReadBackForwardCacheTimings(&result->back_forward_cache_timings))
        success = false;
      if (success && !input.ReadActivationStart(&result->activation_start))
        success = false;
      if (success && !input.ReadInputToNavigationStart(&result->input_to_navigation_start))
        success = false;
      if (success && !input.ReadUserTimingMarkFullyLoaded(&result->user_timing_mark_fully_loaded))
        success = false;
      if (success && !input.ReadUserTimingMarkFullyVisible(&result->user_timing_mark_fully_visible))
        success = false;
      if (success && !input.ReadUserTimingMarkInteractive(&result->user_timing_mark_interactive))
        success = false;
      if (success && !input.ReadMonotonicPaintTiming(&result->monotonic_paint_timing))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::FrameMetadata::DataView, ::page_load_metrics::mojom::FrameMetadataPtr>::Read(
    ::page_load_metrics::mojom::FrameMetadata::DataView input,
    ::page_load_metrics::mojom::FrameMetadataPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::FrameMetadataPtr result(::page_load_metrics::mojom::FrameMetadata::New());
  
      if (success)
        result->behavior_flags = input.behavior_flags();
      if (success && !input.ReadMainFrameIntersectionRect(&result->main_frame_intersection_rect))
        success = false;
      if (success && !input.ReadMainFrameViewportRect(&result->main_frame_viewport_rect))
        success = false;
      if (success && !input.ReadMainFrameAdRects(&result->main_frame_ad_rects))
        success = false;
      if (success && !input.ReadFrameworkDetectionResult(&result->framework_detection_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::SubresourceLoadMetrics::DataView, ::page_load_metrics::mojom::SubresourceLoadMetricsPtr>::Read(
    ::page_load_metrics::mojom::SubresourceLoadMetrics::DataView input,
    ::page_load_metrics::mojom::SubresourceLoadMetricsPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::SubresourceLoadMetricsPtr result(::page_load_metrics::mojom::SubresourceLoadMetrics::New());
  
      if (success)
        result->number_of_subresources_loaded = input.number_of_subresources_loaded();
      if (success)
        result->number_of_subresource_loads_handled_by_service_worker = input.number_of_subresource_loads_handled_by_service_worker();
      if (success && !input.ReadServiceWorkerSubresourceLoadMetrics(&result->service_worker_subresource_load_metrics))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::DataView, ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr>::Read(
    ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::DataView input,
    ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsPtr result(::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetrics::New());
  
      if (success)
        result->image_handled = input.image_handled();
      if (success)
        result->image_fallback = input.image_fallback();
      if (success)
        result->css_handled = input.css_handled();
      if (success)
        result->css_fallback = input.css_fallback();
      if (success)
        result->script_handled = input.script_handled();
      if (success)
        result->script_fallback = input.script_fallback();
      if (success)
        result->font_handled = input.font_handled();
      if (success)
        result->font_fallback = input.font_fallback();
      if (success)
        result->raw_handled = input.raw_handled();
      if (success)
        result->raw_fallback = input.raw_fallback();
      if (success)
        result->svg_handled = input.svg_handled();
      if (success)
        result->svg_fallback = input.svg_fallback();
      if (success)
        result->xsl_handled = input.xsl_handled();
      if (success)
        result->xsl_fallback = input.xsl_fallback();
      if (success)
        result->link_prefetch_handled = input.link_prefetch_handled();
      if (success)
        result->link_prefetch_fallback = input.link_prefetch_fallback();
      if (success)
        result->text_track_handled = input.text_track_handled();
      if (success)
        result->text_track_fallback = input.text_track_fallback();
      if (success)
        result->audio_handled = input.audio_handled();
      if (success)
        result->audio_fallback = input.audio_fallback();
      if (success)
        result->video_handled = input.video_handled();
      if (success)
        result->video_fallback = input.video_fallback();
      if (success)
        result->manifest_handled = input.manifest_handled();
      if (success)
        result->manifest_fallback = input.manifest_fallback();
      if (success)
        result->speculation_rules_handled = input.speculation_rules_handled();
      if (success)
        result->speculation_rules_fallback = input.speculation_rules_fallback();
      if (success)
        result->mock_handled = input.mock_handled();
      if (success)
        result->mock_fallback = input.mock_fallback();
      if (success)
        result->dictionary_handled = input.dictionary_handled();
      if (success)
        result->dictionary_fallback = input.dictionary_fallback();
      if (success)
        result->matched_cache_router_source_count = input.matched_cache_router_source_count();
      if (success)
        result->matched_fetch_event_router_source_count = input.matched_fetch_event_router_source_count();
      if (success)
        result->matched_network_router_source_count = input.matched_network_router_source_count();
      if (success)
        result->matched_race_network_and_fetch_router_source_count = input.matched_race_network_and_fetch_router_source_count();
      if (success)
        result->matched_race_network_and_cache_router_source_count = input.matched_race_network_and_cache_router_source_count();
      if (success && !input.ReadTotalRouterEvaluationTimeForSubresources(&result->total_router_evaluation_time_for_subresources))
        success = false;
      if (success && !input.ReadTotalCacheLookupTimeForSubresources(&result->total_cache_lookup_time_for_subresources))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::ResourceDataUpdate::DataView, ::page_load_metrics::mojom::ResourceDataUpdatePtr>::Read(
    ::page_load_metrics::mojom::ResourceDataUpdate::DataView input,
    ::page_load_metrics::mojom::ResourceDataUpdatePtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::ResourceDataUpdatePtr result(::page_load_metrics::mojom::ResourceDataUpdate::New());
  
      if (success)
        result->request_id = input.request_id();
      if (success && !input.ReadDeltaBytes(&result->delta_bytes))
        success = false;
      if (success && !input.ReadReceivedDataLength(&result->received_data_length))
        success = false;
      if (success && !input.ReadEncodedBodyLength(&result->encoded_body_length))
        success = false;
      if (success && !input.ReadDecodedBodyLength(&result->decoded_body_length))
        success = false;
      if (success)
        result->is_complete = input.is_complete();
      if (success)
        result->reported_as_ad_resource = input.reported_as_ad_resource();
      if (success)
        result->is_main_frame_resource = input.is_main_frame_resource();
      if (success && !input.ReadCacheType(&result->cache_type))
        success = false;
      if (success)
        result->is_primary_frame_resource = input.is_primary_frame_resource();
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success)
        result->is_secure_scheme = input.is_secure_scheme();
      if (success)
        result->proxy_used = input.proxy_used();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::LayoutShift::DataView, ::page_load_metrics::mojom::LayoutShiftPtr>::Read(
    ::page_load_metrics::mojom::LayoutShift::DataView input,
    ::page_load_metrics::mojom::LayoutShiftPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::LayoutShiftPtr result(::page_load_metrics::mojom::LayoutShift::New());
  
      if (success && !input.ReadLayoutShiftTime(&result->layout_shift_time))
        success = false;
      if (success)
        result->layout_shift_score = input.layout_shift_score();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::FrameRenderDataUpdate::DataView, ::page_load_metrics::mojom::FrameRenderDataUpdatePtr>::Read(
    ::page_load_metrics::mojom::FrameRenderDataUpdate::DataView input,
    ::page_load_metrics::mojom::FrameRenderDataUpdatePtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::FrameRenderDataUpdatePtr result(::page_load_metrics::mojom::FrameRenderDataUpdate::New());
  
      if (success)
        result->layout_shift_delta = input.layout_shift_delta();
      if (success)
        result->layout_shift_delta_before_input_or_scroll = input.layout_shift_delta_before_input_or_scroll();
      if (success && !input.ReadNewLayoutShifts(&result->new_layout_shifts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::CpuTiming::DataView, ::page_load_metrics::mojom::CpuTimingPtr>::Read(
    ::page_load_metrics::mojom::CpuTiming::DataView input,
    ::page_load_metrics::mojom::CpuTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::CpuTimingPtr result(::page_load_metrics::mojom::CpuTiming::New());
  
      if (success && !input.ReadTaskTime(&result->task_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::InputTiming::DataView, ::page_load_metrics::mojom::InputTimingPtr>::Read(
    ::page_load_metrics::mojom::InputTiming::DataView input,
    ::page_load_metrics::mojom::InputTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::InputTimingPtr result(::page_load_metrics::mojom::InputTiming::New());
  
      if (success && !input.ReadUserInteractionLatencies(&result->user_interaction_latencies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::UserInteractionLatency::DataView, ::page_load_metrics::mojom::UserInteractionLatencyPtr>::Read(
    ::page_load_metrics::mojom::UserInteractionLatency::DataView input,
    ::page_load_metrics::mojom::UserInteractionLatencyPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::UserInteractionLatencyPtr result(::page_load_metrics::mojom::UserInteractionLatency::New());
  
      if (success && !input.ReadInteractionLatency(&result->interaction_latency))
        success = false;
      if (success)
        result->interaction_offset = input.interaction_offset();
      if (success && !input.ReadInteractionTime(&result->interaction_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::BackForwardCacheTiming::DataView, ::page_load_metrics::mojom::BackForwardCacheTimingPtr>::Read(
    ::page_load_metrics::mojom::BackForwardCacheTiming::DataView input,
    ::page_load_metrics::mojom::BackForwardCacheTimingPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::BackForwardCacheTimingPtr result(::page_load_metrics::mojom::BackForwardCacheTiming::New());
  
      if (success && !input.ReadFirstPaintAfterBackForwardCacheRestore(&result->first_paint_after_back_forward_cache_restore))
        success = false;
      if (success && !input.ReadRequestAnimationFramesAfterBackForwardCacheRestore(&result->request_animation_frames_after_back_forward_cache_restore))
        success = false;
      if (success && !input.ReadFirstInputDelayAfterBackForwardCacheRestore(&result->first_input_delay_after_back_forward_cache_restore))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_load_metrics::mojom::SoftNavigationMetrics::DataView, ::page_load_metrics::mojom::SoftNavigationMetricsPtr>::Read(
    ::page_load_metrics::mojom::SoftNavigationMetrics::DataView input,
    ::page_load_metrics::mojom::SoftNavigationMetricsPtr* output) {
  bool success = true;
  ::page_load_metrics::mojom::SoftNavigationMetricsPtr result(::page_load_metrics::mojom::SoftNavigationMetrics::New());
  
      if (success)
        result->count = input.count();
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
      if (success)
        result->navigation_id = input.navigation_id();
      if (success && !input.ReadSameDocumentMetricsToken(&result->same_document_metrics_token))
        success = false;
      if (success && !input.ReadLargestContentfulPaint(&result->largest_contentful_paint))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace page_load_metrics::mojom {


void PageLoadMetricsInterceptorForTesting::UpdateTiming(PageLoadTimingPtr page_load_timing, FrameMetadataPtr frame_metadata, const std::vector<::blink::UseCounterFeature>& new_features, std::vector<ResourceDataUpdatePtr> resources, FrameRenderDataUpdatePtr render_data, CpuTimingPtr cpu_load_timing, InputTimingPtr input_timing_delta, const std::optional<::blink::SubresourceLoadMetrics>& subresource_load_metrics, SoftNavigationMetricsPtr soft_navigation_metrics) {
  GetForwardingInterface()->UpdateTiming(
    std::move(page_load_timing)
    , 
    std::move(frame_metadata)
    , 
    std::move(new_features)
    , 
    std::move(resources)
    , 
    std::move(render_data)
    , 
    std::move(cpu_load_timing)
    , 
    std::move(input_timing_delta)
    , 
    std::move(subresource_load_metrics)
    , 
    std::move(soft_navigation_metrics)
    );
}
void PageLoadMetricsInterceptorForTesting::SetUpSharedMemoryForDroppedFrames(::base::ReadOnlySharedMemoryRegion dropped_frames_memory) {
  GetForwardingInterface()->SetUpSharedMemoryForDroppedFrames(
    std::move(dropped_frames_memory)
    );
}
void PageLoadMetricsInterceptorForTesting::AddCustomUserTiming(CustomUserTimingMarkPtr custom_user_timing) {
  GetForwardingInterface()->AddCustomUserTiming(
    std::move(custom_user_timing)
    );
}
PageLoadMetricsAsyncWaiter::PageLoadMetricsAsyncWaiter(
    PageLoadMetrics* proxy) : proxy_(proxy) {}

PageLoadMetricsAsyncWaiter::~PageLoadMetricsAsyncWaiter() = default;







}  // page_load_metrics::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif