// components/page_load_metrics/common/page_load_metrics.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "services/network/public/mojom/request_priority.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/loader/javascript_framework_detection.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/use_counter/use_counter_feature.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace page_load_metrics::mojom {
namespace internal {
class DocumentTiming_Data;
class LcpResourceLoadTimings_Data;
class LargestContentfulPaintTiming_Data;
class PaintTiming_Data;
class MonotonicPaintTiming_Data;
class ParseTiming_Data;
class InteractiveTiming_Data;
class CustomUserTimingMark_Data;
class DomainLookupTiming_Data;
class PageLoadTiming_Data;
class FrameMetadata_Data;
class SubresourceLoadMetrics_Data;
class ServiceWorkerSubresourceLoadMetrics_Data;
class ResourceDataUpdate_Data;
class LayoutShift_Data;
class FrameRenderDataUpdate_Data;
class CpuTiming_Data;
class InputTiming_Data;
class UserInteractionLatency_Data;
class BackForwardCacheTiming_Data;
class SoftNavigationMetrics_Data;

struct CacheType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  DocumentTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> dom_content_loaded_event_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> load_event_start;

 private:
  friend class mojo::internal::MessageFragment<DocumentTiming_Data>;

  DocumentTiming_Data();
  ~DocumentTiming_Data() = delete;
};
static_assert(sizeof(DocumentTiming_Data) == 24,
              "Bad sizeof(DocumentTiming_Data)");
// Used by DocumentTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DocumentTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DocumentTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DocumentTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DocumentTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DocumentTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  LcpResourceLoadTimings_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> discovery_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> load_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> load_end;

 private:
  friend class mojo::internal::MessageFragment<LcpResourceLoadTimings_Data>;

  LcpResourceLoadTimings_Data();
  ~LcpResourceLoadTimings_Data() = delete;
};
static_assert(sizeof(LcpResourceLoadTimings_Data) == 32,
              "Bad sizeof(LcpResourceLoadTimings_Data)");
// Used by LcpResourceLoadTimings::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LcpResourceLoadTimings_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LcpResourceLoadTimings_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LcpResourceLoadTimings_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<LcpResourceLoadTimings_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LcpResourceLoadTimings_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  LargestContentfulPaintTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> largest_image_paint;
  uint64_t largest_image_paint_size;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> largest_text_paint;
  uint64_t largest_text_paint_size;
  mojo::internal::Pointer<internal::LcpResourceLoadTimings_Data> resource_load_timings;
  uint64_t type;
  double image_bpp;
  uint8_t image_request_priority_valid : 1;
  uint8_t pad7_[3];
  int32_t image_request_priority_value;

 private:
  friend class mojo::internal::MessageFragment<LargestContentfulPaintTiming_Data>;

  LargestContentfulPaintTiming_Data();
  ~LargestContentfulPaintTiming_Data() = delete;
};
static_assert(sizeof(LargestContentfulPaintTiming_Data) == 72,
              "Bad sizeof(LargestContentfulPaintTiming_Data)");
// Used by LargestContentfulPaintTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LargestContentfulPaintTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LargestContentfulPaintTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LargestContentfulPaintTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<LargestContentfulPaintTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LargestContentfulPaintTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PaintTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_paint;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_image_paint;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_contentful_paint;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_meaningful_paint;
  mojo::internal::Pointer<internal::LargestContentfulPaintTiming_Data> largest_contentful_paint;
  mojo::internal::Pointer<internal::LargestContentfulPaintTiming_Data> experimental_largest_contentful_paint;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_eligible_to_paint;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_input_or_scroll_notified_timestamp;

 private:
  friend class mojo::internal::MessageFragment<PaintTiming_Data>;

  PaintTiming_Data();
  ~PaintTiming_Data() = delete;
};
static_assert(sizeof(PaintTiming_Data) == 72,
              "Bad sizeof(PaintTiming_Data)");
// Used by PaintTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PaintTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PaintTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PaintTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PaintTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PaintTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  MonotonicPaintTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> first_paint;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> first_contentful_paint;

 private:
  friend class mojo::internal::MessageFragment<MonotonicPaintTiming_Data>;

  MonotonicPaintTiming_Data();
  ~MonotonicPaintTiming_Data() = delete;
};
static_assert(sizeof(MonotonicPaintTiming_Data) == 24,
              "Bad sizeof(MonotonicPaintTiming_Data)");
// Used by MonotonicPaintTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MonotonicPaintTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MonotonicPaintTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MonotonicPaintTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MonotonicPaintTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MonotonicPaintTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ParseTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> parse_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> parse_stop;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> parse_blocked_on_script_load_duration;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> parse_blocked_on_script_load_from_document_write_duration;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> parse_blocked_on_script_execution_duration;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> parse_blocked_on_script_execution_from_document_write_duration;

 private:
  friend class mojo::internal::MessageFragment<ParseTiming_Data>;

  ParseTiming_Data();
  ~ParseTiming_Data() = delete;
};
static_assert(sizeof(ParseTiming_Data) == 56,
              "Bad sizeof(ParseTiming_Data)");
// Used by ParseTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ParseTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ParseTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ParseTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ParseTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ParseTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  InteractiveTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_input_delay;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_input_timestamp;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_scroll_delay;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_scroll_timestamp;

 private:
  friend class mojo::internal::MessageFragment<InteractiveTiming_Data>;

  InteractiveTiming_Data();
  ~InteractiveTiming_Data() = delete;
};
static_assert(sizeof(InteractiveTiming_Data) == 40,
              "Bad sizeof(InteractiveTiming_Data)");
// Used by InteractiveTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct InteractiveTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  InteractiveTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~InteractiveTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<InteractiveTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    InteractiveTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CustomUserTimingMark_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> mark_name;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> start_time;

 private:
  friend class mojo::internal::MessageFragment<CustomUserTimingMark_Data>;

  CustomUserTimingMark_Data();
  ~CustomUserTimingMark_Data() = delete;
};
static_assert(sizeof(CustomUserTimingMark_Data) == 24,
              "Bad sizeof(CustomUserTimingMark_Data)");
// Used by CustomUserTimingMark::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CustomUserTimingMark_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CustomUserTimingMark_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CustomUserTimingMark_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CustomUserTimingMark_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CustomUserTimingMark_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DomainLookupTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> domain_lookup_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> domain_lookup_end;

 private:
  friend class mojo::internal::MessageFragment<DomainLookupTiming_Data>;

  DomainLookupTiming_Data();
  ~DomainLookupTiming_Data() = delete;
};
static_assert(sizeof(DomainLookupTiming_Data) == 24,
              "Bad sizeof(DomainLookupTiming_Data)");
// Used by DomainLookupTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DomainLookupTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DomainLookupTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DomainLookupTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DomainLookupTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DomainLookupTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PageLoadTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> navigation_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> connect_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> connect_end;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> response_start;
  mojo::internal::Pointer<internal::DocumentTiming_Data> document_timing;
  mojo::internal::Pointer<internal::InteractiveTiming_Data> interactive_timing;
  mojo::internal::Pointer<internal::PaintTiming_Data> paint_timing;
  mojo::internal::Pointer<internal::ParseTiming_Data> parse_timing;
  mojo::internal::Pointer<internal::DomainLookupTiming_Data> domain_lookup_timing;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::BackForwardCacheTiming_Data>>> back_forward_cache_timings;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> activation_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> input_to_navigation_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> user_timing_mark_fully_loaded;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> user_timing_mark_fully_visible;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> user_timing_mark_interactive;
  mojo::internal::Pointer<internal::MonotonicPaintTiming_Data> monotonic_paint_timing;

 private:
  friend class mojo::internal::MessageFragment<PageLoadTiming_Data>;

  PageLoadTiming_Data();
  ~PageLoadTiming_Data() = delete;
};
static_assert(sizeof(PageLoadTiming_Data) == 136,
              "Bad sizeof(PageLoadTiming_Data)");
// Used by PageLoadTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PageLoadTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PageLoadTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PageLoadTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PageLoadTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PageLoadTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  FrameMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t behavior_flags;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> main_frame_intersection_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> main_frame_viewport_rect;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data>>> main_frame_ad_rects;
  mojo::internal::Pointer<::blink::mojom::internal::JavaScriptFrameworkDetectionResult_Data> framework_detection_result;

 private:
  friend class mojo::internal::MessageFragment<FrameMetadata_Data>;

  FrameMetadata_Data();
  ~FrameMetadata_Data() = delete;
};
static_assert(sizeof(FrameMetadata_Data) == 48,
              "Bad sizeof(FrameMetadata_Data)");
// Used by FrameMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct FrameMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  FrameMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~FrameMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<FrameMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    FrameMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SubresourceLoadMetrics_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t number_of_subresources_loaded;
  uint32_t number_of_subresource_loads_handled_by_service_worker;
  mojo::internal::Pointer<internal::ServiceWorkerSubresourceLoadMetrics_Data> service_worker_subresource_load_metrics;

 private:
  friend class mojo::internal::MessageFragment<SubresourceLoadMetrics_Data>;

  SubresourceLoadMetrics_Data();
  ~SubresourceLoadMetrics_Data() = delete;
};
static_assert(sizeof(SubresourceLoadMetrics_Data) == 24,
              "Bad sizeof(SubresourceLoadMetrics_Data)");
// Used by SubresourceLoadMetrics::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SubresourceLoadMetrics_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SubresourceLoadMetrics_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SubresourceLoadMetrics_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SubresourceLoadMetrics_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SubresourceLoadMetrics_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ServiceWorkerSubresourceLoadMetrics_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t image_handled : 1;
  uint8_t image_fallback : 1;
  uint8_t css_handled : 1;
  uint8_t css_fallback : 1;
  uint8_t script_handled : 1;
  uint8_t script_fallback : 1;
  uint8_t font_handled : 1;
  uint8_t font_fallback : 1;
  uint8_t raw_handled : 1;
  uint8_t raw_fallback : 1;
  uint8_t svg_handled : 1;
  uint8_t svg_fallback : 1;
  uint8_t xsl_handled : 1;
  uint8_t xsl_fallback : 1;
  uint8_t link_prefetch_handled : 1;
  uint8_t link_prefetch_fallback : 1;
  uint8_t text_track_handled : 1;
  uint8_t text_track_fallback : 1;
  uint8_t audio_handled : 1;
  uint8_t audio_fallback : 1;
  uint8_t video_handled : 1;
  uint8_t video_fallback : 1;
  uint8_t manifest_handled : 1;
  uint8_t manifest_fallback : 1;
  uint8_t speculation_rules_handled : 1;
  uint8_t speculation_rules_fallback : 1;
  uint8_t mock_handled : 1;
  uint8_t mock_fallback : 1;
  uint8_t dictionary_handled : 1;
  uint8_t dictionary_fallback : 1;
  uint32_t matched_cache_router_source_count;
  uint32_t matched_fetch_event_router_source_count;
  uint32_t matched_network_router_source_count;
  uint32_t matched_race_network_and_fetch_router_source_count;
  uint32_t matched_race_network_and_cache_router_source_count;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> total_router_evaluation_time_for_subresources;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> total_cache_lookup_time_for_subresources;

 private:
  friend class mojo::internal::MessageFragment<ServiceWorkerSubresourceLoadMetrics_Data>;

  ServiceWorkerSubresourceLoadMetrics_Data();
  ~ServiceWorkerSubresourceLoadMetrics_Data() = delete;
};
static_assert(sizeof(ServiceWorkerSubresourceLoadMetrics_Data) == 48,
              "Bad sizeof(ServiceWorkerSubresourceLoadMetrics_Data)");
// Used by ServiceWorkerSubresourceLoadMetrics::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ServiceWorkerSubresourceLoadMetrics_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ServiceWorkerSubresourceLoadMetrics_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ServiceWorkerSubresourceLoadMetrics_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ServiceWorkerSubresourceLoadMetrics_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ServiceWorkerSubresourceLoadMetrics_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ResourceDataUpdate_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t request_id;
  uint8_t is_complete : 1;
  uint8_t reported_as_ad_resource : 1;
  uint8_t is_main_frame_resource : 1;
  uint8_t is_primary_frame_resource : 1;
  uint8_t is_secure_scheme : 1;
  uint8_t proxy_used : 1;
  uint8_t pad6_[3];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteCount_Data> delta_bytes;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteCount_Data> received_data_length;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteCount_Data> encoded_body_length;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteCount_Data> decoded_body_length;
  int32_t cache_type;
  uint8_t pad11_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> mime_type;

 private:
  friend class mojo::internal::MessageFragment<ResourceDataUpdate_Data>;

  ResourceDataUpdate_Data();
  ~ResourceDataUpdate_Data() = delete;
};
static_assert(sizeof(ResourceDataUpdate_Data) == 64,
              "Bad sizeof(ResourceDataUpdate_Data)");
// Used by ResourceDataUpdate::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ResourceDataUpdate_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ResourceDataUpdate_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ResourceDataUpdate_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ResourceDataUpdate_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ResourceDataUpdate_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  LayoutShift_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> layout_shift_time;
  double layout_shift_score;

 private:
  friend class mojo::internal::MessageFragment<LayoutShift_Data>;

  LayoutShift_Data();
  ~LayoutShift_Data() = delete;
};
static_assert(sizeof(LayoutShift_Data) == 24,
              "Bad sizeof(LayoutShift_Data)");
// Used by LayoutShift::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LayoutShift_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LayoutShift_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LayoutShift_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<LayoutShift_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LayoutShift_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  FrameRenderDataUpdate_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float layout_shift_delta;
  float layout_shift_delta_before_input_or_scroll;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::LayoutShift_Data>>> new_layout_shifts;

 private:
  friend class mojo::internal::MessageFragment<FrameRenderDataUpdate_Data>;

  FrameRenderDataUpdate_Data();
  ~FrameRenderDataUpdate_Data() = delete;
};
static_assert(sizeof(FrameRenderDataUpdate_Data) == 24,
              "Bad sizeof(FrameRenderDataUpdate_Data)");
// Used by FrameRenderDataUpdate::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct FrameRenderDataUpdate_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  FrameRenderDataUpdate_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~FrameRenderDataUpdate_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<FrameRenderDataUpdate_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    FrameRenderDataUpdate_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CpuTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> task_time;

 private:
  friend class mojo::internal::MessageFragment<CpuTiming_Data>;

  CpuTiming_Data();
  ~CpuTiming_Data() = delete;
};
static_assert(sizeof(CpuTiming_Data) == 16,
              "Bad sizeof(CpuTiming_Data)");
// Used by CpuTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CpuTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CpuTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CpuTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CpuTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CpuTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  InputTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::UserInteractionLatency_Data>>> user_interaction_latencies;

 private:
  friend class mojo::internal::MessageFragment<InputTiming_Data>;

  InputTiming_Data();
  ~InputTiming_Data() = delete;
};
static_assert(sizeof(InputTiming_Data) == 16,
              "Bad sizeof(InputTiming_Data)");
// Used by InputTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct InputTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  InputTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~InputTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<InputTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    InputTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  UserInteractionLatency_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> interaction_latency;
  uint64_t interaction_offset;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> interaction_time;

 private:
  friend class mojo::internal::MessageFragment<UserInteractionLatency_Data>;

  UserInteractionLatency_Data();
  ~UserInteractionLatency_Data() = delete;
};
static_assert(sizeof(UserInteractionLatency_Data) == 32,
              "Bad sizeof(UserInteractionLatency_Data)");
// Used by UserInteractionLatency::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UserInteractionLatency_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UserInteractionLatency_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UserInteractionLatency_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UserInteractionLatency_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UserInteractionLatency_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BackForwardCacheTiming_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_paint_after_back_forward_cache_restore;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data>>> request_animation_frames_after_back_forward_cache_restore;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> first_input_delay_after_back_forward_cache_restore;

 private:
  friend class mojo::internal::MessageFragment<BackForwardCacheTiming_Data>;

  BackForwardCacheTiming_Data();
  ~BackForwardCacheTiming_Data() = delete;
};
static_assert(sizeof(BackForwardCacheTiming_Data) == 32,
              "Bad sizeof(BackForwardCacheTiming_Data)");
// Used by BackForwardCacheTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BackForwardCacheTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BackForwardCacheTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BackForwardCacheTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BackForwardCacheTiming_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BackForwardCacheTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SoftNavigationMetrics_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t count;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> start_time;
  uint32_t navigation_id;
  uint8_t pad2_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> same_document_metrics_token;
  mojo::internal::Pointer<internal::LargestContentfulPaintTiming_Data> largest_contentful_paint;

 private:
  friend class mojo::internal::MessageFragment<SoftNavigationMetrics_Data>;

  SoftNavigationMetrics_Data();
  ~SoftNavigationMetrics_Data() = delete;
};
static_assert(sizeof(SoftNavigationMetrics_Data) == 48,
              "Bad sizeof(SoftNavigationMetrics_Data)");
// Used by SoftNavigationMetrics::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SoftNavigationMetrics_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SoftNavigationMetrics_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SoftNavigationMetrics_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SoftNavigationMetrics_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SoftNavigationMetrics_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // page_load_metrics::mojom

#endif  // COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_SHARED_INTERNAL_H_