// components/page_load_metrics/common/page_load_metrics.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_SEND_VALIDATION_H_

#include "components/page_load_metrics/common/page_load_metrics.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/javascript_framework_detection.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/use_counter_feature.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"

#include "components/page_load_metrics/common/page_load_metrics.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::page_load_metrics::mojom::CacheType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::DocumentTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::DocumentTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::DocumentTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::dom_content_loaded_event_start(input)) in_dom_content_loaded_event_start = Traits::dom_content_loaded_event_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dom_content_loaded_event_start)::BaseType> dom_content_loaded_event_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_dom_content_loaded_event_start,
        dom_content_loaded_event_start_fragment);

      fragment->dom_content_loaded_event_start.Set(
          dom_content_loaded_event_start_fragment.is_null() ? nullptr : dom_content_loaded_event_start_fragment.data());

      decltype(Traits::load_event_start(input)) in_load_event_start = Traits::load_event_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->load_event_start)::BaseType> load_event_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_load_event_start,
        load_event_start_fragment);

      fragment->load_event_start.Set(
          load_event_start_fragment.is_null() ? nullptr : load_event_start_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::LcpResourceLoadTimingsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::LcpResourceLoadTimingsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::LcpResourceLoadTimings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::discovery_time(input)) in_discovery_time = Traits::discovery_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->discovery_time)::BaseType> discovery_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_discovery_time,
        discovery_time_fragment);

      fragment->discovery_time.Set(
          discovery_time_fragment.is_null() ? nullptr : discovery_time_fragment.data());

      decltype(Traits::load_start(input)) in_load_start = Traits::load_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->load_start)::BaseType> load_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_load_start,
        load_start_fragment);

      fragment->load_start.Set(
          load_start_fragment.is_null() ? nullptr : load_start_fragment.data());

      decltype(Traits::load_end(input)) in_load_end = Traits::load_end(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->load_end)::BaseType> load_end_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_load_end,
        load_end_fragment);

      fragment->load_end.Set(
          load_end_fragment.is_null() ? nullptr : load_end_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::LargestContentfulPaintTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::largest_image_paint(input)) in_largest_image_paint = Traits::largest_image_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->largest_image_paint)::BaseType> largest_image_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_largest_image_paint,
        largest_image_paint_fragment);

      fragment->largest_image_paint.Set(
          largest_image_paint_fragment.is_null() ? nullptr : largest_image_paint_fragment.data());

      fragment->largest_image_paint_size = Traits::largest_image_paint_size(input);

      decltype(Traits::largest_text_paint(input)) in_largest_text_paint = Traits::largest_text_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->largest_text_paint)::BaseType> largest_text_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_largest_text_paint,
        largest_text_paint_fragment);

      fragment->largest_text_paint.Set(
          largest_text_paint_fragment.is_null() ? nullptr : largest_text_paint_fragment.data());

      fragment->largest_text_paint_size = Traits::largest_text_paint_size(input);

      decltype(Traits::resource_load_timings(input)) in_resource_load_timings = Traits::resource_load_timings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resource_load_timings)::BaseType> resource_load_timings_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::LcpResourceLoadTimingsDataView, send_validation>(
        in_resource_load_timings,
        resource_load_timings_fragment);

      fragment->resource_load_timings.Set(
          resource_load_timings_fragment.is_null() ? nullptr : resource_load_timings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resource_load_timings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resource_load_timings in LargestContentfulPaintTiming struct");

      fragment->type = Traits::type(input);

      fragment->image_bpp = Traits::image_bpp(input);

      fragment->image_request_priority_valid = Traits::image_request_priority_valid(input);

      
      mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::image_request_priority_value(input),
        &fragment->image_request_priority_value);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::PaintTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::PaintTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::PaintTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::first_paint(input)) in_first_paint = Traits::first_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_paint)::BaseType> first_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_paint,
        first_paint_fragment);

      fragment->first_paint.Set(
          first_paint_fragment.is_null() ? nullptr : first_paint_fragment.data());

      decltype(Traits::first_image_paint(input)) in_first_image_paint = Traits::first_image_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_image_paint)::BaseType> first_image_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_image_paint,
        first_image_paint_fragment);

      fragment->first_image_paint.Set(
          first_image_paint_fragment.is_null() ? nullptr : first_image_paint_fragment.data());

      decltype(Traits::first_contentful_paint(input)) in_first_contentful_paint = Traits::first_contentful_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_contentful_paint)::BaseType> first_contentful_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_contentful_paint,
        first_contentful_paint_fragment);

      fragment->first_contentful_paint.Set(
          first_contentful_paint_fragment.is_null() ? nullptr : first_contentful_paint_fragment.data());

      decltype(Traits::first_meaningful_paint(input)) in_first_meaningful_paint = Traits::first_meaningful_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_meaningful_paint)::BaseType> first_meaningful_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_meaningful_paint,
        first_meaningful_paint_fragment);

      fragment->first_meaningful_paint.Set(
          first_meaningful_paint_fragment.is_null() ? nullptr : first_meaningful_paint_fragment.data());

      decltype(Traits::largest_contentful_paint(input)) in_largest_contentful_paint = Traits::largest_contentful_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->largest_contentful_paint)::BaseType> largest_contentful_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView, send_validation>(
        in_largest_contentful_paint,
        largest_contentful_paint_fragment);

      fragment->largest_contentful_paint.Set(
          largest_contentful_paint_fragment.is_null() ? nullptr : largest_contentful_paint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->largest_contentful_paint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null largest_contentful_paint in PaintTiming struct");

      decltype(Traits::experimental_largest_contentful_paint(input)) in_experimental_largest_contentful_paint = Traits::experimental_largest_contentful_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->experimental_largest_contentful_paint)::BaseType> experimental_largest_contentful_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView, send_validation>(
        in_experimental_largest_contentful_paint,
        experimental_largest_contentful_paint_fragment);

      fragment->experimental_largest_contentful_paint.Set(
          experimental_largest_contentful_paint_fragment.is_null() ? nullptr : experimental_largest_contentful_paint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->experimental_largest_contentful_paint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null experimental_largest_contentful_paint in PaintTiming struct");

      decltype(Traits::first_eligible_to_paint(input)) in_first_eligible_to_paint = Traits::first_eligible_to_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_eligible_to_paint)::BaseType> first_eligible_to_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_eligible_to_paint,
        first_eligible_to_paint_fragment);

      fragment->first_eligible_to_paint.Set(
          first_eligible_to_paint_fragment.is_null() ? nullptr : first_eligible_to_paint_fragment.data());

      decltype(Traits::first_input_or_scroll_notified_timestamp(input)) in_first_input_or_scroll_notified_timestamp = Traits::first_input_or_scroll_notified_timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_input_or_scroll_notified_timestamp)::BaseType> first_input_or_scroll_notified_timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_input_or_scroll_notified_timestamp,
        first_input_or_scroll_notified_timestamp_fragment);

      fragment->first_input_or_scroll_notified_timestamp.Set(
          first_input_or_scroll_notified_timestamp_fragment.is_null() ? nullptr : first_input_or_scroll_notified_timestamp_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::MonotonicPaintTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::MonotonicPaintTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::MonotonicPaintTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::first_paint(input)) in_first_paint = Traits::first_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_paint)::BaseType> first_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_first_paint,
        first_paint_fragment);

      fragment->first_paint.Set(
          first_paint_fragment.is_null() ? nullptr : first_paint_fragment.data());

      decltype(Traits::first_contentful_paint(input)) in_first_contentful_paint = Traits::first_contentful_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_contentful_paint)::BaseType> first_contentful_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_first_contentful_paint,
        first_contentful_paint_fragment);

      fragment->first_contentful_paint.Set(
          first_contentful_paint_fragment.is_null() ? nullptr : first_contentful_paint_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::ParseTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::ParseTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::ParseTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::parse_start(input)) in_parse_start = Traits::parse_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parse_start)::BaseType> parse_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_parse_start,
        parse_start_fragment);

      fragment->parse_start.Set(
          parse_start_fragment.is_null() ? nullptr : parse_start_fragment.data());

      decltype(Traits::parse_stop(input)) in_parse_stop = Traits::parse_stop(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parse_stop)::BaseType> parse_stop_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_parse_stop,
        parse_stop_fragment);

      fragment->parse_stop.Set(
          parse_stop_fragment.is_null() ? nullptr : parse_stop_fragment.data());

      decltype(Traits::parse_blocked_on_script_load_duration(input)) in_parse_blocked_on_script_load_duration = Traits::parse_blocked_on_script_load_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parse_blocked_on_script_load_duration)::BaseType> parse_blocked_on_script_load_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_parse_blocked_on_script_load_duration,
        parse_blocked_on_script_load_duration_fragment);

      fragment->parse_blocked_on_script_load_duration.Set(
          parse_blocked_on_script_load_duration_fragment.is_null() ? nullptr : parse_blocked_on_script_load_duration_fragment.data());

      decltype(Traits::parse_blocked_on_script_load_from_document_write_duration(input)) in_parse_blocked_on_script_load_from_document_write_duration = Traits::parse_blocked_on_script_load_from_document_write_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parse_blocked_on_script_load_from_document_write_duration)::BaseType> parse_blocked_on_script_load_from_document_write_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_parse_blocked_on_script_load_from_document_write_duration,
        parse_blocked_on_script_load_from_document_write_duration_fragment);

      fragment->parse_blocked_on_script_load_from_document_write_duration.Set(
          parse_blocked_on_script_load_from_document_write_duration_fragment.is_null() ? nullptr : parse_blocked_on_script_load_from_document_write_duration_fragment.data());

      decltype(Traits::parse_blocked_on_script_execution_duration(input)) in_parse_blocked_on_script_execution_duration = Traits::parse_blocked_on_script_execution_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parse_blocked_on_script_execution_duration)::BaseType> parse_blocked_on_script_execution_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_parse_blocked_on_script_execution_duration,
        parse_blocked_on_script_execution_duration_fragment);

      fragment->parse_blocked_on_script_execution_duration.Set(
          parse_blocked_on_script_execution_duration_fragment.is_null() ? nullptr : parse_blocked_on_script_execution_duration_fragment.data());

      decltype(Traits::parse_blocked_on_script_execution_from_document_write_duration(input)) in_parse_blocked_on_script_execution_from_document_write_duration = Traits::parse_blocked_on_script_execution_from_document_write_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parse_blocked_on_script_execution_from_document_write_duration)::BaseType> parse_blocked_on_script_execution_from_document_write_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_parse_blocked_on_script_execution_from_document_write_duration,
        parse_blocked_on_script_execution_from_document_write_duration_fragment);

      fragment->parse_blocked_on_script_execution_from_document_write_duration.Set(
          parse_blocked_on_script_execution_from_document_write_duration_fragment.is_null() ? nullptr : parse_blocked_on_script_execution_from_document_write_duration_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::InteractiveTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::InteractiveTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::InteractiveTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::first_input_delay(input)) in_first_input_delay = Traits::first_input_delay(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_input_delay)::BaseType> first_input_delay_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_input_delay,
        first_input_delay_fragment);

      fragment->first_input_delay.Set(
          first_input_delay_fragment.is_null() ? nullptr : first_input_delay_fragment.data());

      decltype(Traits::first_input_timestamp(input)) in_first_input_timestamp = Traits::first_input_timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_input_timestamp)::BaseType> first_input_timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_input_timestamp,
        first_input_timestamp_fragment);

      fragment->first_input_timestamp.Set(
          first_input_timestamp_fragment.is_null() ? nullptr : first_input_timestamp_fragment.data());

      decltype(Traits::first_scroll_delay(input)) in_first_scroll_delay = Traits::first_scroll_delay(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_scroll_delay)::BaseType> first_scroll_delay_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_scroll_delay,
        first_scroll_delay_fragment);

      fragment->first_scroll_delay.Set(
          first_scroll_delay_fragment.is_null() ? nullptr : first_scroll_delay_fragment.data());

      decltype(Traits::first_scroll_timestamp(input)) in_first_scroll_timestamp = Traits::first_scroll_timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_scroll_timestamp)::BaseType> first_scroll_timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_scroll_timestamp,
        first_scroll_timestamp_fragment);

      fragment->first_scroll_timestamp.Set(
          first_scroll_timestamp_fragment.is_null() ? nullptr : first_scroll_timestamp_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::CustomUserTimingMarkDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::CustomUserTimingMarkDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::CustomUserTimingMark_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mark_name(input)) in_mark_name = Traits::mark_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mark_name)::BaseType> mark_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mark_name,
        mark_name_fragment);

      fragment->mark_name.Set(
          mark_name_fragment.is_null() ? nullptr : mark_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mark_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mark_name in CustomUserTimingMark struct");

      decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start_time)::BaseType> start_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_start_time,
        start_time_fragment);

      fragment->start_time.Set(
          start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_time in CustomUserTimingMark struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::DomainLookupTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::DomainLookupTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::DomainLookupTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::domain_lookup_start(input)) in_domain_lookup_start = Traits::domain_lookup_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain_lookup_start)::BaseType> domain_lookup_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_domain_lookup_start,
        domain_lookup_start_fragment);

      fragment->domain_lookup_start.Set(
          domain_lookup_start_fragment.is_null() ? nullptr : domain_lookup_start_fragment.data());

      decltype(Traits::domain_lookup_end(input)) in_domain_lookup_end = Traits::domain_lookup_end(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain_lookup_end)::BaseType> domain_lookup_end_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_domain_lookup_end,
        domain_lookup_end_fragment);

      fragment->domain_lookup_end.Set(
          domain_lookup_end_fragment.is_null() ? nullptr : domain_lookup_end_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::PageLoadTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::PageLoadTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::PageLoadTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::navigation_start(input)) in_navigation_start = Traits::navigation_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->navigation_start)::BaseType> navigation_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_navigation_start,
        navigation_start_fragment);

      fragment->navigation_start.Set(
          navigation_start_fragment.is_null() ? nullptr : navigation_start_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->navigation_start.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_start in PageLoadTiming struct");

      decltype(Traits::connect_start(input)) in_connect_start = Traits::connect_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->connect_start)::BaseType> connect_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_connect_start,
        connect_start_fragment);

      fragment->connect_start.Set(
          connect_start_fragment.is_null() ? nullptr : connect_start_fragment.data());

      decltype(Traits::connect_end(input)) in_connect_end = Traits::connect_end(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->connect_end)::BaseType> connect_end_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_connect_end,
        connect_end_fragment);

      fragment->connect_end.Set(
          connect_end_fragment.is_null() ? nullptr : connect_end_fragment.data());

      decltype(Traits::response_start(input)) in_response_start = Traits::response_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_start)::BaseType> response_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_response_start,
        response_start_fragment);

      fragment->response_start.Set(
          response_start_fragment.is_null() ? nullptr : response_start_fragment.data());

      decltype(Traits::document_timing(input)) in_document_timing = Traits::document_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->document_timing)::BaseType> document_timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::DocumentTimingDataView, send_validation>(
        in_document_timing,
        document_timing_fragment);

      fragment->document_timing.Set(
          document_timing_fragment.is_null() ? nullptr : document_timing_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->document_timing.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_timing in PageLoadTiming struct");

      decltype(Traits::interactive_timing(input)) in_interactive_timing = Traits::interactive_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interactive_timing)::BaseType> interactive_timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::InteractiveTimingDataView, send_validation>(
        in_interactive_timing,
        interactive_timing_fragment);

      fragment->interactive_timing.Set(
          interactive_timing_fragment.is_null() ? nullptr : interactive_timing_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->interactive_timing.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interactive_timing in PageLoadTiming struct");

      decltype(Traits::paint_timing(input)) in_paint_timing = Traits::paint_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->paint_timing)::BaseType> paint_timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::PaintTimingDataView, send_validation>(
        in_paint_timing,
        paint_timing_fragment);

      fragment->paint_timing.Set(
          paint_timing_fragment.is_null() ? nullptr : paint_timing_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->paint_timing.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null paint_timing in PageLoadTiming struct");

      decltype(Traits::parse_timing(input)) in_parse_timing = Traits::parse_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parse_timing)::BaseType> parse_timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::ParseTimingDataView, send_validation>(
        in_parse_timing,
        parse_timing_fragment);

      fragment->parse_timing.Set(
          parse_timing_fragment.is_null() ? nullptr : parse_timing_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->parse_timing.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parse_timing in PageLoadTiming struct");

      decltype(Traits::domain_lookup_timing(input)) in_domain_lookup_timing = Traits::domain_lookup_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain_lookup_timing)::BaseType> domain_lookup_timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::DomainLookupTimingDataView, send_validation>(
        in_domain_lookup_timing,
        domain_lookup_timing_fragment);

      fragment->domain_lookup_timing.Set(
          domain_lookup_timing_fragment.is_null() ? nullptr : domain_lookup_timing_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->domain_lookup_timing.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain_lookup_timing in PageLoadTiming struct");

      decltype(Traits::back_forward_cache_timings(input)) in_back_forward_cache_timings = Traits::back_forward_cache_timings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->back_forward_cache_timings)::BaseType>
          back_forward_cache_timings_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& back_forward_cache_timings_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::page_load_metrics::mojom::BackForwardCacheTimingDataView>, send_validation>(
        in_back_forward_cache_timings,
        back_forward_cache_timings_fragment,
        &back_forward_cache_timings_validate_params);

      fragment->back_forward_cache_timings.Set(
          back_forward_cache_timings_fragment.is_null() ? nullptr : back_forward_cache_timings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->back_forward_cache_timings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null back_forward_cache_timings in PageLoadTiming struct");

      decltype(Traits::activation_start(input)) in_activation_start = Traits::activation_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->activation_start)::BaseType> activation_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_activation_start,
        activation_start_fragment);

      fragment->activation_start.Set(
          activation_start_fragment.is_null() ? nullptr : activation_start_fragment.data());

      decltype(Traits::input_to_navigation_start(input)) in_input_to_navigation_start = Traits::input_to_navigation_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input_to_navigation_start)::BaseType> input_to_navigation_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_input_to_navigation_start,
        input_to_navigation_start_fragment);

      fragment->input_to_navigation_start.Set(
          input_to_navigation_start_fragment.is_null() ? nullptr : input_to_navigation_start_fragment.data());

      decltype(Traits::user_timing_mark_fully_loaded(input)) in_user_timing_mark_fully_loaded = Traits::user_timing_mark_fully_loaded(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_timing_mark_fully_loaded)::BaseType> user_timing_mark_fully_loaded_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_user_timing_mark_fully_loaded,
        user_timing_mark_fully_loaded_fragment);

      fragment->user_timing_mark_fully_loaded.Set(
          user_timing_mark_fully_loaded_fragment.is_null() ? nullptr : user_timing_mark_fully_loaded_fragment.data());

      decltype(Traits::user_timing_mark_fully_visible(input)) in_user_timing_mark_fully_visible = Traits::user_timing_mark_fully_visible(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_timing_mark_fully_visible)::BaseType> user_timing_mark_fully_visible_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_user_timing_mark_fully_visible,
        user_timing_mark_fully_visible_fragment);

      fragment->user_timing_mark_fully_visible.Set(
          user_timing_mark_fully_visible_fragment.is_null() ? nullptr : user_timing_mark_fully_visible_fragment.data());

      decltype(Traits::user_timing_mark_interactive(input)) in_user_timing_mark_interactive = Traits::user_timing_mark_interactive(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_timing_mark_interactive)::BaseType> user_timing_mark_interactive_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_user_timing_mark_interactive,
        user_timing_mark_interactive_fragment);

      fragment->user_timing_mark_interactive.Set(
          user_timing_mark_interactive_fragment.is_null() ? nullptr : user_timing_mark_interactive_fragment.data());

      decltype(Traits::monotonic_paint_timing(input)) in_monotonic_paint_timing = Traits::monotonic_paint_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->monotonic_paint_timing)::BaseType> monotonic_paint_timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::MonotonicPaintTimingDataView, send_validation>(
        in_monotonic_paint_timing,
        monotonic_paint_timing_fragment);

      fragment->monotonic_paint_timing.Set(
          monotonic_paint_timing_fragment.is_null() ? nullptr : monotonic_paint_timing_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::FrameMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::FrameMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::FrameMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->behavior_flags = Traits::behavior_flags(input);

      decltype(Traits::main_frame_intersection_rect(input)) in_main_frame_intersection_rect = Traits::main_frame_intersection_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->main_frame_intersection_rect)::BaseType> main_frame_intersection_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_main_frame_intersection_rect,
        main_frame_intersection_rect_fragment);

      fragment->main_frame_intersection_rect.Set(
          main_frame_intersection_rect_fragment.is_null() ? nullptr : main_frame_intersection_rect_fragment.data());

      decltype(Traits::main_frame_viewport_rect(input)) in_main_frame_viewport_rect = Traits::main_frame_viewport_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->main_frame_viewport_rect)::BaseType> main_frame_viewport_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_main_frame_viewport_rect,
        main_frame_viewport_rect_fragment);

      fragment->main_frame_viewport_rect.Set(
          main_frame_viewport_rect_fragment.is_null() ? nullptr : main_frame_viewport_rect_fragment.data());

      decltype(Traits::main_frame_ad_rects(input)) in_main_frame_ad_rects = Traits::main_frame_ad_rects(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->main_frame_ad_rects)::BaseType>
          main_frame_ad_rects_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& main_frame_ad_rects_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<int32_t, ::gfx::mojom::RectDataView>, send_validation>(
        in_main_frame_ad_rects,
        main_frame_ad_rects_fragment,
        &main_frame_ad_rects_validate_params);

      fragment->main_frame_ad_rects.Set(
          main_frame_ad_rects_fragment.is_null() ? nullptr : main_frame_ad_rects_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->main_frame_ad_rects.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_frame_ad_rects in FrameMetadata struct");

      decltype(Traits::framework_detection_result(input)) in_framework_detection_result = Traits::framework_detection_result(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->framework_detection_result)::BaseType> framework_detection_result_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::JavaScriptFrameworkDetectionResultDataView, send_validation>(
        in_framework_detection_result,
        framework_detection_result_fragment);

      fragment->framework_detection_result.Set(
          framework_detection_result_fragment.is_null() ? nullptr : framework_detection_result_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->framework_detection_result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null framework_detection_result in FrameMetadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::SubresourceLoadMetricsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::SubresourceLoadMetricsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::SubresourceLoadMetrics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->number_of_subresources_loaded = Traits::number_of_subresources_loaded(input);

      fragment->number_of_subresource_loads_handled_by_service_worker = Traits::number_of_subresource_loads_handled_by_service_worker(input);

      decltype(Traits::service_worker_subresource_load_metrics(input)) in_service_worker_subresource_load_metrics = Traits::service_worker_subresource_load_metrics(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->service_worker_subresource_load_metrics)::BaseType> service_worker_subresource_load_metrics_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsDataView, send_validation>(
        in_service_worker_subresource_load_metrics,
        service_worker_subresource_load_metrics_fragment);

      fragment->service_worker_subresource_load_metrics.Set(
          service_worker_subresource_load_metrics_fragment.is_null() ? nullptr : service_worker_subresource_load_metrics_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::ServiceWorkerSubresourceLoadMetrics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->image_handled = Traits::image_handled(input);

      fragment->image_fallback = Traits::image_fallback(input);

      fragment->css_handled = Traits::css_handled(input);

      fragment->css_fallback = Traits::css_fallback(input);

      fragment->script_handled = Traits::script_handled(input);

      fragment->script_fallback = Traits::script_fallback(input);

      fragment->font_handled = Traits::font_handled(input);

      fragment->font_fallback = Traits::font_fallback(input);

      fragment->raw_handled = Traits::raw_handled(input);

      fragment->raw_fallback = Traits::raw_fallback(input);

      fragment->svg_handled = Traits::svg_handled(input);

      fragment->svg_fallback = Traits::svg_fallback(input);

      fragment->xsl_handled = Traits::xsl_handled(input);

      fragment->xsl_fallback = Traits::xsl_fallback(input);

      fragment->link_prefetch_handled = Traits::link_prefetch_handled(input);

      fragment->link_prefetch_fallback = Traits::link_prefetch_fallback(input);

      fragment->text_track_handled = Traits::text_track_handled(input);

      fragment->text_track_fallback = Traits::text_track_fallback(input);

      fragment->audio_handled = Traits::audio_handled(input);

      fragment->audio_fallback = Traits::audio_fallback(input);

      fragment->video_handled = Traits::video_handled(input);

      fragment->video_fallback = Traits::video_fallback(input);

      fragment->manifest_handled = Traits::manifest_handled(input);

      fragment->manifest_fallback = Traits::manifest_fallback(input);

      fragment->speculation_rules_handled = Traits::speculation_rules_handled(input);

      fragment->speculation_rules_fallback = Traits::speculation_rules_fallback(input);

      fragment->mock_handled = Traits::mock_handled(input);

      fragment->mock_fallback = Traits::mock_fallback(input);

      fragment->dictionary_handled = Traits::dictionary_handled(input);

      fragment->dictionary_fallback = Traits::dictionary_fallback(input);

      fragment->matched_cache_router_source_count = Traits::matched_cache_router_source_count(input);

      fragment->matched_fetch_event_router_source_count = Traits::matched_fetch_event_router_source_count(input);

      fragment->matched_network_router_source_count = Traits::matched_network_router_source_count(input);

      fragment->matched_race_network_and_fetch_router_source_count = Traits::matched_race_network_and_fetch_router_source_count(input);

      fragment->matched_race_network_and_cache_router_source_count = Traits::matched_race_network_and_cache_router_source_count(input);

      decltype(Traits::total_router_evaluation_time_for_subresources(input)) in_total_router_evaluation_time_for_subresources = Traits::total_router_evaluation_time_for_subresources(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total_router_evaluation_time_for_subresources)::BaseType> total_router_evaluation_time_for_subresources_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_total_router_evaluation_time_for_subresources,
        total_router_evaluation_time_for_subresources_fragment);

      fragment->total_router_evaluation_time_for_subresources.Set(
          total_router_evaluation_time_for_subresources_fragment.is_null() ? nullptr : total_router_evaluation_time_for_subresources_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->total_router_evaluation_time_for_subresources.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null total_router_evaluation_time_for_subresources in ServiceWorkerSubresourceLoadMetrics struct");

      decltype(Traits::total_cache_lookup_time_for_subresources(input)) in_total_cache_lookup_time_for_subresources = Traits::total_cache_lookup_time_for_subresources(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total_cache_lookup_time_for_subresources)::BaseType> total_cache_lookup_time_for_subresources_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_total_cache_lookup_time_for_subresources,
        total_cache_lookup_time_for_subresources_fragment);

      fragment->total_cache_lookup_time_for_subresources.Set(
          total_cache_lookup_time_for_subresources_fragment.is_null() ? nullptr : total_cache_lookup_time_for_subresources_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->total_cache_lookup_time_for_subresources.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null total_cache_lookup_time_for_subresources in ServiceWorkerSubresourceLoadMetrics struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::ResourceDataUpdateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::ResourceDataUpdateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::ResourceDataUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->request_id = Traits::request_id(input);

      decltype(Traits::delta_bytes(input)) in_delta_bytes = Traits::delta_bytes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->delta_bytes)::BaseType> delta_bytes_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView, send_validation>(
        in_delta_bytes,
        delta_bytes_fragment);

      fragment->delta_bytes.Set(
          delta_bytes_fragment.is_null() ? nullptr : delta_bytes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->delta_bytes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null delta_bytes in ResourceDataUpdate struct");

      decltype(Traits::received_data_length(input)) in_received_data_length = Traits::received_data_length(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->received_data_length)::BaseType> received_data_length_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView, send_validation>(
        in_received_data_length,
        received_data_length_fragment);

      fragment->received_data_length.Set(
          received_data_length_fragment.is_null() ? nullptr : received_data_length_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->received_data_length.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null received_data_length in ResourceDataUpdate struct");

      decltype(Traits::encoded_body_length(input)) in_encoded_body_length = Traits::encoded_body_length(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->encoded_body_length)::BaseType> encoded_body_length_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView, send_validation>(
        in_encoded_body_length,
        encoded_body_length_fragment);

      fragment->encoded_body_length.Set(
          encoded_body_length_fragment.is_null() ? nullptr : encoded_body_length_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->encoded_body_length.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null encoded_body_length in ResourceDataUpdate struct");

      decltype(Traits::decoded_body_length(input)) in_decoded_body_length = Traits::decoded_body_length(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->decoded_body_length)::BaseType> decoded_body_length_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView, send_validation>(
        in_decoded_body_length,
        decoded_body_length_fragment);

      fragment->decoded_body_length.Set(
          decoded_body_length_fragment.is_null() ? nullptr : decoded_body_length_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->decoded_body_length.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null decoded_body_length in ResourceDataUpdate struct");

      fragment->is_complete = Traits::is_complete(input);

      fragment->reported_as_ad_resource = Traits::reported_as_ad_resource(input);

      fragment->is_main_frame_resource = Traits::is_main_frame_resource(input);

      
      mojo::internal::Serialize<::page_load_metrics::mojom::CacheType>(
        Traits::cache_type(input),
        &fragment->cache_type);

      fragment->is_primary_frame_resource = Traits::is_primary_frame_resource(input);

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in ResourceDataUpdate struct");

      fragment->is_secure_scheme = Traits::is_secure_scheme(input);

      fragment->proxy_used = Traits::proxy_used(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::LayoutShiftDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::LayoutShiftDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::LayoutShift_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::layout_shift_time(input)) in_layout_shift_time = Traits::layout_shift_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->layout_shift_time)::BaseType> layout_shift_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_layout_shift_time,
        layout_shift_time_fragment);

      fragment->layout_shift_time.Set(
          layout_shift_time_fragment.is_null() ? nullptr : layout_shift_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->layout_shift_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null layout_shift_time in LayoutShift struct");

      fragment->layout_shift_score = Traits::layout_shift_score(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::FrameRenderDataUpdateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::FrameRenderDataUpdateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::FrameRenderDataUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->layout_shift_delta = Traits::layout_shift_delta(input);

      fragment->layout_shift_delta_before_input_or_scroll = Traits::layout_shift_delta_before_input_or_scroll(input);

      decltype(Traits::new_layout_shifts(input)) in_new_layout_shifts = Traits::new_layout_shifts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->new_layout_shifts)::BaseType>
          new_layout_shifts_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& new_layout_shifts_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::page_load_metrics::mojom::LayoutShiftDataView>, send_validation>(
        in_new_layout_shifts,
        new_layout_shifts_fragment,
        &new_layout_shifts_validate_params);

      fragment->new_layout_shifts.Set(
          new_layout_shifts_fragment.is_null() ? nullptr : new_layout_shifts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->new_layout_shifts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_layout_shifts in FrameRenderDataUpdate struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::CpuTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::CpuTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::CpuTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::task_time(input)) in_task_time = Traits::task_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->task_time)::BaseType> task_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_task_time,
        task_time_fragment);

      fragment->task_time.Set(
          task_time_fragment.is_null() ? nullptr : task_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->task_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null task_time in CpuTiming struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::InputTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::InputTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::InputTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::user_interaction_latencies(input)) in_user_interaction_latencies = Traits::user_interaction_latencies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_interaction_latencies)::BaseType>
          user_interaction_latencies_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& user_interaction_latencies_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::page_load_metrics::mojom::UserInteractionLatencyDataView>, send_validation>(
        in_user_interaction_latencies,
        user_interaction_latencies_fragment,
        &user_interaction_latencies_validate_params);

      fragment->user_interaction_latencies.Set(
          user_interaction_latencies_fragment.is_null() ? nullptr : user_interaction_latencies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->user_interaction_latencies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_interaction_latencies in InputTiming struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::UserInteractionLatencyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::UserInteractionLatencyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::UserInteractionLatency_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::interaction_latency(input)) in_interaction_latency = Traits::interaction_latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interaction_latency)::BaseType> interaction_latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_interaction_latency,
        interaction_latency_fragment);

      fragment->interaction_latency.Set(
          interaction_latency_fragment.is_null() ? nullptr : interaction_latency_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->interaction_latency.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interaction_latency in UserInteractionLatency struct");

      fragment->interaction_offset = Traits::interaction_offset(input);

      decltype(Traits::interaction_time(input)) in_interaction_time = Traits::interaction_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interaction_time)::BaseType> interaction_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_interaction_time,
        interaction_time_fragment);

      fragment->interaction_time.Set(
          interaction_time_fragment.is_null() ? nullptr : interaction_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->interaction_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interaction_time in UserInteractionLatency struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::BackForwardCacheTimingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::BackForwardCacheTimingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::BackForwardCacheTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::first_paint_after_back_forward_cache_restore(input)) in_first_paint_after_back_forward_cache_restore = Traits::first_paint_after_back_forward_cache_restore(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_paint_after_back_forward_cache_restore)::BaseType> first_paint_after_back_forward_cache_restore_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_paint_after_back_forward_cache_restore,
        first_paint_after_back_forward_cache_restore_fragment);

      fragment->first_paint_after_back_forward_cache_restore.Set(
          first_paint_after_back_forward_cache_restore_fragment.is_null() ? nullptr : first_paint_after_back_forward_cache_restore_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->first_paint_after_back_forward_cache_restore.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null first_paint_after_back_forward_cache_restore in BackForwardCacheTiming struct");

      decltype(Traits::request_animation_frames_after_back_forward_cache_restore(input)) in_request_animation_frames_after_back_forward_cache_restore = Traits::request_animation_frames_after_back_forward_cache_restore(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_animation_frames_after_back_forward_cache_restore)::BaseType>
          request_animation_frames_after_back_forward_cache_restore_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& request_animation_frames_after_back_forward_cache_restore_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::TimeDeltaDataView>, send_validation>(
        in_request_animation_frames_after_back_forward_cache_restore,
        request_animation_frames_after_back_forward_cache_restore_fragment,
        &request_animation_frames_after_back_forward_cache_restore_validate_params);

      fragment->request_animation_frames_after_back_forward_cache_restore.Set(
          request_animation_frames_after_back_forward_cache_restore_fragment.is_null() ? nullptr : request_animation_frames_after_back_forward_cache_restore_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->request_animation_frames_after_back_forward_cache_restore.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_animation_frames_after_back_forward_cache_restore in BackForwardCacheTiming struct");

      decltype(Traits::first_input_delay_after_back_forward_cache_restore(input)) in_first_input_delay_after_back_forward_cache_restore = Traits::first_input_delay_after_back_forward_cache_restore(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_input_delay_after_back_forward_cache_restore)::BaseType> first_input_delay_after_back_forward_cache_restore_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_first_input_delay_after_back_forward_cache_restore,
        first_input_delay_after_back_forward_cache_restore_fragment);

      fragment->first_input_delay_after_back_forward_cache_restore.Set(
          first_input_delay_after_back_forward_cache_restore_fragment.is_null() ? nullptr : first_input_delay_after_back_forward_cache_restore_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::page_load_metrics::mojom::SoftNavigationMetricsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_load_metrics::mojom::SoftNavigationMetricsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_load_metrics::mojom::internal::SoftNavigationMetrics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->count = Traits::count(input);

      decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start_time)::BaseType> start_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_start_time,
        start_time_fragment);

      fragment->start_time.Set(
          start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_time in SoftNavigationMetrics struct");

      fragment->navigation_id = Traits::navigation_id(input);

      decltype(Traits::same_document_metrics_token(input)) in_same_document_metrics_token = Traits::same_document_metrics_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->same_document_metrics_token)::BaseType> same_document_metrics_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_same_document_metrics_token,
        same_document_metrics_token_fragment);

      fragment->same_document_metrics_token.Set(
          same_document_metrics_token_fragment.is_null() ? nullptr : same_document_metrics_token_fragment.data());

      decltype(Traits::largest_contentful_paint(input)) in_largest_contentful_paint = Traits::largest_contentful_paint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->largest_contentful_paint)::BaseType> largest_contentful_paint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView, send_validation>(
        in_largest_contentful_paint,
        largest_contentful_paint_fragment);

      fragment->largest_contentful_paint.Set(
          largest_contentful_paint_fragment.is_null() ? nullptr : largest_contentful_paint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->largest_contentful_paint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null largest_contentful_paint in SoftNavigationMetrics struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_SEND_VALIDATION_H_