// components/page_load_metrics/common/page_load_metrics.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace page_load_metrics::mojom {
namespace internal {
class  PageLoadMetrics_UpdateTiming_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PageLoadTiming_Data> page_load_timing;
  mojo::internal::Pointer<internal::FrameMetadata_Data> frame_metadata;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::blink::mojom::internal::UseCounterFeature_Data>>> new_features;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ResourceDataUpdate_Data>>> resources;
  mojo::internal::Pointer<internal::FrameRenderDataUpdate_Data> render_data;
  mojo::internal::Pointer<internal::CpuTiming_Data> cpu_load_timing;
  mojo::internal::Pointer<internal::InputTiming_Data> input_timing_delta;
  mojo::internal::Pointer<internal::SubresourceLoadMetrics_Data> subresource_load_metrics;
  mojo::internal::Pointer<internal::SoftNavigationMetrics_Data> soft_navigation_metrics;

 private:
  friend class mojo::internal::MessageFragment<PageLoadMetrics_UpdateTiming_Params_Data>;

  PageLoadMetrics_UpdateTiming_Params_Data();
  ~PageLoadMetrics_UpdateTiming_Params_Data() = delete;
};
static_assert(sizeof(PageLoadMetrics_UpdateTiming_Params_Data) == 80,
              "Bad sizeof(PageLoadMetrics_UpdateTiming_Params_Data)");
class  PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> dropped_frames_memory;

 private:
  friend class mojo::internal::MessageFragment<PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data>;

  PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data();
  ~PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data() = delete;
};
static_assert(sizeof(PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data) == 16,
              "Bad sizeof(PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data)");
class  PageLoadMetrics_AddCustomUserTiming_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CustomUserTimingMark_Data> custom_user_timing;

 private:
  friend class mojo::internal::MessageFragment<PageLoadMetrics_AddCustomUserTiming_Params_Data>;

  PageLoadMetrics_AddCustomUserTiming_Params_Data();
  ~PageLoadMetrics_AddCustomUserTiming_Params_Data() = delete;
};
static_assert(sizeof(PageLoadMetrics_AddCustomUserTiming_Params_Data) == 16,
              "Bad sizeof(PageLoadMetrics_AddCustomUserTiming_Params_Data)");

}  // namespace internal


class PageLoadMetrics_UpdateTiming_ParamsDataView {
 public:
  PageLoadMetrics_UpdateTiming_ParamsDataView() = default;

  PageLoadMetrics_UpdateTiming_ParamsDataView(
      internal::PageLoadMetrics_UpdateTiming_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPageLoadTimingDataView(
      PageLoadTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageLoadTiming(UserType* output) {
    
    auto* pointer = data_->page_load_timing.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::PageLoadTimingDataView>(
        pointer, output, message_);
  }
  inline void GetFrameMetadataDataView(
      FrameMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameMetadata(UserType* output) {
    
    auto* pointer = data_->frame_metadata.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::FrameMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetNewFeaturesDataView(
      mojo::ArrayDataView<::blink::mojom::UseCounterFeatureDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewFeatures(UserType* output) {
    
    auto* pointer = data_->new_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::UseCounterFeatureDataView>>(
        pointer, output, message_);
  }
  inline void GetResourcesDataView(
      mojo::ArrayDataView<ResourceDataUpdateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResources(UserType* output) {
    
    auto* pointer = data_->resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::page_load_metrics::mojom::ResourceDataUpdateDataView>>(
        pointer, output, message_);
  }
  inline void GetRenderDataDataView(
      FrameRenderDataUpdateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRenderData(UserType* output) {
    
    auto* pointer = data_->render_data.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::FrameRenderDataUpdateDataView>(
        pointer, output, message_);
  }
  inline void GetCpuLoadTimingDataView(
      CpuTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCpuLoadTiming(UserType* output) {
    
    auto* pointer = data_->cpu_load_timing.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::CpuTimingDataView>(
        pointer, output, message_);
  }
  inline void GetInputTimingDeltaDataView(
      InputTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputTimingDelta(UserType* output) {
    
    auto* pointer = data_->input_timing_delta.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::InputTimingDataView>(
        pointer, output, message_);
  }
  inline void GetSubresourceLoadMetricsDataView(
      SubresourceLoadMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubresourceLoadMetrics(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::page_load_metrics::mojom::SubresourceLoadMetricsDataView, UserType>(),
    "Attempting to read the optional `subresource_load_metrics` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubresourceLoadMetrics` instead "
    "of `ReadSubresourceLoadMetrics if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subresource_load_metrics.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::SubresourceLoadMetricsDataView>(
        pointer, output, message_);
  }
  inline void GetSoftNavigationMetricsDataView(
      SoftNavigationMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSoftNavigationMetrics(UserType* output) {
    
    auto* pointer = data_->soft_navigation_metrics.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::SoftNavigationMetricsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageLoadMetrics_UpdateTiming_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_ParamsDataView {
 public:
  PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_ParamsDataView() = default;

  PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_ParamsDataView(
      internal::PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDroppedFramesMemoryDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDroppedFramesMemory(UserType* output) {
    
    auto* pointer = data_->dropped_frames_memory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageLoadMetrics_AddCustomUserTiming_ParamsDataView {
 public:
  PageLoadMetrics_AddCustomUserTiming_ParamsDataView() = default;

  PageLoadMetrics_AddCustomUserTiming_ParamsDataView(
      internal::PageLoadMetrics_AddCustomUserTiming_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCustomUserTimingDataView(
      CustomUserTimingMarkDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomUserTiming(UserType* output) {
    
    auto* pointer = data_->custom_user_timing.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::CustomUserTimingMarkDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageLoadMetrics_AddCustomUserTiming_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetPageLoadTimingDataView(
    PageLoadTimingDataView* output) {
  auto pointer = data_->page_load_timing.Get();
  *output = PageLoadTimingDataView(pointer, message_);
}
inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetFrameMetadataDataView(
    FrameMetadataDataView* output) {
  auto pointer = data_->frame_metadata.Get();
  *output = FrameMetadataDataView(pointer, message_);
}
inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetNewFeaturesDataView(
    mojo::ArrayDataView<::blink::mojom::UseCounterFeatureDataView>* output) {
  auto pointer = data_->new_features.Get();
  *output = mojo::ArrayDataView<::blink::mojom::UseCounterFeatureDataView>(pointer, message_);
}
inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetResourcesDataView(
    mojo::ArrayDataView<ResourceDataUpdateDataView>* output) {
  auto pointer = data_->resources.Get();
  *output = mojo::ArrayDataView<ResourceDataUpdateDataView>(pointer, message_);
}
inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetRenderDataDataView(
    FrameRenderDataUpdateDataView* output) {
  auto pointer = data_->render_data.Get();
  *output = FrameRenderDataUpdateDataView(pointer, message_);
}
inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetCpuLoadTimingDataView(
    CpuTimingDataView* output) {
  auto pointer = data_->cpu_load_timing.Get();
  *output = CpuTimingDataView(pointer, message_);
}
inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetInputTimingDeltaDataView(
    InputTimingDataView* output) {
  auto pointer = data_->input_timing_delta.Get();
  *output = InputTimingDataView(pointer, message_);
}
inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetSubresourceLoadMetricsDataView(
    SubresourceLoadMetricsDataView* output) {
  auto pointer = data_->subresource_load_metrics.Get();
  *output = SubresourceLoadMetricsDataView(pointer, message_);
}
inline void PageLoadMetrics_UpdateTiming_ParamsDataView::GetSoftNavigationMetricsDataView(
    SoftNavigationMetricsDataView* output) {
  auto pointer = data_->soft_navigation_metrics.Get();
  *output = SoftNavigationMetricsDataView(pointer, message_);
}


inline void PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_ParamsDataView::GetDroppedFramesMemoryDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->dropped_frames_memory.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}


inline void PageLoadMetrics_AddCustomUserTiming_ParamsDataView::GetCustomUserTimingDataView(
    CustomUserTimingMarkDataView* output) {
  auto pointer = data_->custom_user_timing.Get();
  *output = CustomUserTimingMarkDataView(pointer, message_);
}



}  // page_load_metrics::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_PARAMS_DATA_H_