// components/page_image_service/mojom/page_image_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_SHARED_H_
#define COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/page_image_service/mojom/page_image_service.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/page_image_service/mojom/page_image_service.mojom-data-view.h"




namespace std {

template <>
struct hash<::page_image_service::mojom::ClientId>
    : public mojo::internal::EnumHashImpl<::page_image_service::mojom::ClientId> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::page_image_service::mojom::ClientId, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::page_image_service::mojom::ClientId, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::page_image_service::mojom::ClientId>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::page_image_service::mojom::OptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_image_service::mojom::OptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_image_service::mojom::internal::Options_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->suggest_images = Traits::suggest_images(input);

    fragment->optimization_guide_images = Traits::optimization_guide_images(input);
  }

  static bool Deserialize(::page_image_service::mojom::internal::Options_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::page_image_service::mojom::OptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::page_image_service::mojom::ImageResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::page_image_service::mojom::ImageResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::page_image_service::mojom::internal::ImageResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_url(input)) in_image_url = Traits::image_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_url)::BaseType> image_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_image_url,
      image_url_fragment);

    fragment->image_url.Set(
        image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_url in ImageResult struct");
  }

  static bool Deserialize(::page_image_service::mojom::internal::ImageResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::page_image_service::mojom::ImageResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace page_image_service::mojom {



inline void ImageResultDataView::GetImageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // page_image_service::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::page_image_service::mojom::ClientId> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::page_image_service::mojom::ClientId value);
};

} // namespace perfetto

#endif  // COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_SHARED_H_