// components/page_image_service/mojom/page_image_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/page_image_service/mojom/page_image_service.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace page_image_service::mojom {
class OptionsDataView;

class ImageResultDataView;



}  // page_image_service::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::page_image_service::mojom::OptionsDataView> {
  using Data = ::page_image_service::mojom::internal::Options_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_image_service::mojom::ImageResultDataView> {
  using Data = ::page_image_service::mojom::internal::ImageResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace page_image_service::mojom {


enum class ClientId : int32_t {
  
  Journeys = 0,
  
  JourneysSidePanel = 1,
  
  NtpRealbox = 2,
  
  NtpQuests = 3,
  
  Bookmarks = 4,
  
  NtpTabResumption = 5,
  
  HistoryEmbeddings = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, ClientId value);
inline bool IsKnownEnumValue(ClientId value) {
  return internal::ClientId_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageImageServiceHandlerInterfaceBase {};

using PageImageServiceHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageImageServiceHandlerInterfaceBase>;
using PageImageServiceHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageImageServiceHandlerInterfaceBase>;
using PageImageServiceHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageImageServiceHandlerInterfaceBase>;
using PageImageServiceHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageImageServiceHandlerInterfaceBase>;


class OptionsDataView {
 public:
  OptionsDataView() = default;

  OptionsDataView(
      internal::Options_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool suggest_images() const {
    return data_->suggest_images;
  }
  bool optimization_guide_images() const {
    return data_->optimization_guide_images;
  }
 private:
  internal::Options_Data* data_ = nullptr;
};


class ImageResultDataView {
 public:
  ImageResultDataView() = default;

  ImageResultDataView(
      internal::ImageResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageUrl(UserType* output) {
    
    auto* pointer = data_->image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ImageResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // page_image_service::mojom

#endif  // COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_DATA_VIEW_H_