// components/os_crypt/async/common/encryptor.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/os_crypt/async/common/encryptor.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('osCryptAsync.mojom');
  var algorithm$ =
      mojo.internal.exposeNamespace('osCryptAsync.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/os_crypt/async/common/algorithm.mojom', 'algorithm.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }



  function Key(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Key.prototype.initDefaults_ = function() {
    this.algorithm = 0;
    this.key = null;
  };
  Key.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Key.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Key.algorithm
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, algorithm$.Algorithm);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Key.key
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, shared_memory$.UnsafeSharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Key.encodedSize = codec.kStructHeaderSize + 16;

  Key.decode = function(decoder) {
    var packed;
    var val = new Key();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.algorithm =
        decoder.decodeStruct(new codec.Enum(algorithm$.Algorithm));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.key =
        decoder.decodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion);
    return val;
  };

  Key.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Key.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.algorithm);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(shared_memory$.UnsafeSharedMemoryRegion, val.key);
  };
  function Encryptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Encryptor.prototype.initDefaults_ = function() {
    this.providerForEncryption = null;
    this.keyEntries = null;
  };
  Encryptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Encryptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Encryptor.providerForEncryption
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Encryptor.keyEntries
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.String, new codec.NullablePointerTo(Key), true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Encryptor.encodedSize = codec.kStructHeaderSize + 16;

  Encryptor.decode = function(decoder) {
    var packed;
    var val = new Encryptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.providerForEncryption =
        decoder.decodeStruct(codec.String);
    val.keyEntries =
        decoder.decodeMapPointer(codec.String, new codec.NullablePointerTo(Key));
    return val;
  };

  Encryptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Encryptor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.providerForEncryption);
    encoder.encodeMapPointer(codec.String, new codec.NullablePointerTo(Key), val.keyEntries);
  };
  exports.Key = Key;
  exports.Encryptor = Encryptor;
})();