// components/os_crypt/async/common/encryptor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_SHARED_H_
#define COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/os_crypt/async/common/encryptor.mojom-shared-internal.h"
#include "components/os_crypt/async/common/algorithm.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/os_crypt/async/common/encryptor.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::os_crypt_async::mojom::KeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::os_crypt_async::mojom::KeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::os_crypt_async::mojom::internal::Key_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::os_crypt_async::mojom::Algorithm>(
      Traits::algorithm(input),
      &fragment->algorithm);

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in Key struct");
  }

  static bool Deserialize(::os_crypt_async::mojom::internal::Key_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::os_crypt_async::mojom::KeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::os_crypt_async::mojom::EncryptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::os_crypt_async::mojom::EncryptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::os_crypt_async::mojom::internal::Encryptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::provider_for_encryption(input)) in_provider_for_encryption = Traits::provider_for_encryption(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->provider_for_encryption)::BaseType> provider_for_encryption_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_provider_for_encryption,
      provider_for_encryption_fragment);

    fragment->provider_for_encryption.Set(
        provider_for_encryption_fragment.is_null() ? nullptr : provider_for_encryption_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->provider_for_encryption.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null provider_for_encryption in Encryptor struct");

    decltype(Traits::key_entries(input)) in_key_entries = Traits::key_entries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_entries)::BaseType>
        key_entries_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& key_entries_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, true, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::os_crypt_async::mojom::KeyDataView>>(
      in_key_entries,
      key_entries_fragment,
      &key_entries_validate_params);

    fragment->key_entries.Set(
        key_entries_fragment.is_null() ? nullptr : key_entries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_entries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_entries in Encryptor struct");
  }

  static bool Deserialize(::os_crypt_async::mojom::internal::Encryptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::os_crypt_async::mojom::EncryptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace os_crypt_async::mojom {

inline void KeyDataView::GetKeyDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) {
  auto pointer = data_->key.Get();
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(pointer, message_);
}


inline void EncryptorDataView::GetProviderForEncryptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->provider_for_encryption.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void EncryptorDataView::GetKeyEntriesDataView(
    mojo::MapDataView<mojo::StringDataView, KeyDataView>* output) {
  auto pointer = data_->key_entries.Get();
  *output = mojo::MapDataView<mojo::StringDataView, KeyDataView>(pointer, message_);
}



}  // os_crypt_async::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_SHARED_H_