// components/os_crypt/async/common/encryptor.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_SEND_VALIDATION_H_

#include "components/os_crypt/async/common/encryptor.mojom-shared-internal.h"
#include "components/os_crypt/async/common/algorithm.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"

#include "components/os_crypt/async/common/encryptor.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::os_crypt_async::mojom::KeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::os_crypt_async::mojom::KeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::os_crypt_async::mojom::internal::Key_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::os_crypt_async::mojom::Algorithm>(
        Traits::algorithm(input),
        &fragment->algorithm);

      decltype(Traits::key(input)) in_key = Traits::key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key)::BaseType> key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView, send_validation>(
        in_key,
        key_fragment);

      fragment->key.Set(
          key_fragment.is_null() ? nullptr : key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in Key struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::os_crypt_async::mojom::EncryptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::os_crypt_async::mojom::EncryptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::os_crypt_async::mojom::internal::Encryptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::provider_for_encryption(input)) in_provider_for_encryption = Traits::provider_for_encryption(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->provider_for_encryption)::BaseType> provider_for_encryption_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_provider_for_encryption,
        provider_for_encryption_fragment);

      fragment->provider_for_encryption.Set(
          provider_for_encryption_fragment.is_null() ? nullptr : provider_for_encryption_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->provider_for_encryption.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null provider_for_encryption in Encryptor struct");

      decltype(Traits::key_entries(input)) in_key_entries = Traits::key_entries(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_entries)::BaseType>
          key_entries_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& key_entries_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, true, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::os_crypt_async::mojom::KeyDataView>, send_validation>(
        in_key_entries,
        key_entries_fragment,
        &key_entries_validate_params);

      fragment->key_entries.Set(
          key_entries_fragment.is_null() ? nullptr : key_entries_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_entries.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_entries in Encryptor struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_SEND_VALIDATION_H_