// components/os_crypt/async/common/encryptor.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_BLINK_H_
#define COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/os_crypt/async/common/encryptor.mojom-features.h"  // IWYU pragma: export
#include "components/os_crypt/async/common/encryptor.mojom-shared.h"  // IWYU pragma: export
#include "components/os_crypt/async/common/encryptor.mojom-blink-forward.h"  // IWYU pragma: export
#include "components/os_crypt/async/common/algorithm.mojom-blink-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace os_crypt_async::mojom::blink {









class  Key {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Key, T>::value>;
  using DataView = KeyDataView;
  using Data_ = internal::Key_Data;

  template <typename... Args>
  static KeyPtr New(Args&&... args) {
    return KeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KeyPtr From(const U& u) {
    return mojo::TypeConverter<KeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Key>::Convert(*this);
  }


  Key();

  Key(
      ::os_crypt_async::mojom::blink::Algorithm algorithm,
      ::base::UnsafeSharedMemoryRegion key);

Key(const Key&) = delete;
Key& operator=(const Key&) = delete;

  ~Key();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KeyPtr>
  KeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Key::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Key::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Key::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Key::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Key_UnserializedMessageContext<
            UserType, Key::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Key::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Key::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Key_UnserializedMessageContext<
            UserType, Key::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Key::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::os_crypt_async::mojom::blink::Algorithm algorithm;
  
  ::base::UnsafeSharedMemoryRegion key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Key::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Key::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Key::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Key::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Encryptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Encryptor, T>::value>;
  using DataView = EncryptorDataView;
  using Data_ = internal::Encryptor_Data;

  template <typename... Args>
  static EncryptorPtr New(Args&&... args) {
    return EncryptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EncryptorPtr From(const U& u) {
    return mojo::TypeConverter<EncryptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Encryptor>::Convert(*this);
  }


  Encryptor();

  Encryptor(
      const ::blink::String& provider_for_encryption,
      ::blink::HashMap<::blink::String, KeyPtr> key_entries);

Encryptor(const Encryptor&) = delete;
Encryptor& operator=(const Encryptor&) = delete;

  ~Encryptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EncryptorPtr>
  EncryptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Encryptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Encryptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Encryptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Encryptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Encryptor_UnserializedMessageContext<
            UserType, Encryptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Encryptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Encryptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Encryptor_UnserializedMessageContext<
            UserType, Encryptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Encryptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String provider_for_encryption;
  
  ::blink::HashMap<::blink::String, KeyPtr> key_entries;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Encryptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Encryptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Encryptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Encryptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
KeyPtr Key::Clone() const {
  return New(
      mojo::Clone(algorithm),
      mojo::Clone(key)
  );
}

template <typename T, Key::EnableIfSame<T>*>
bool Key::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->algorithm, other_struct.algorithm))
    return false;
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  return true;
}

template <typename T, Key::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.algorithm < rhs.algorithm)
    return true;
  if (rhs.algorithm < lhs.algorithm)
    return false;
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  return false;
}
template <typename StructPtrType>
EncryptorPtr Encryptor::Clone() const {
  return New(
      mojo::Clone(provider_for_encryption),
      mojo::Clone(key_entries)
  );
}

template <typename T, Encryptor::EnableIfSame<T>*>
bool Encryptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provider_for_encryption, other_struct.provider_for_encryption))
    return false;
  if (!mojo::Equals(this->key_entries, other_struct.key_entries))
    return false;
  return true;
}

template <typename T, Encryptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.provider_for_encryption < rhs.provider_for_encryption)
    return true;
  if (rhs.provider_for_encryption < lhs.provider_for_encryption)
    return false;
  if (lhs.key_entries < rhs.key_entries)
    return true;
  if (rhs.key_entries < lhs.key_entries)
    return false;
  return false;
}


}  // os_crypt_async::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::os_crypt_async::mojom::blink::Key::DataView,
                                         ::os_crypt_async::mojom::blink::KeyPtr> {
  static bool IsNull(const ::os_crypt_async::mojom::blink::KeyPtr& input) { return !input; }
  static void SetToNull(::os_crypt_async::mojom::blink::KeyPtr* output) { output->reset(); }

  static decltype(::os_crypt_async::mojom::blink::Key::algorithm) algorithm(
      const ::os_crypt_async::mojom::blink::KeyPtr& input) {
    return input->algorithm;
  }

  static  decltype(::os_crypt_async::mojom::blink::Key::key)& key(
       ::os_crypt_async::mojom::blink::KeyPtr& input) {
    return input->key;
  }

  static bool Read(::os_crypt_async::mojom::blink::Key::DataView input, ::os_crypt_async::mojom::blink::KeyPtr* output);
};


template <>
struct  StructTraits<::os_crypt_async::mojom::blink::Encryptor::DataView,
                                         ::os_crypt_async::mojom::blink::EncryptorPtr> {
  static bool IsNull(const ::os_crypt_async::mojom::blink::EncryptorPtr& input) { return !input; }
  static void SetToNull(::os_crypt_async::mojom::blink::EncryptorPtr* output) { output->reset(); }

  static const decltype(::os_crypt_async::mojom::blink::Encryptor::provider_for_encryption)& provider_for_encryption(
      const ::os_crypt_async::mojom::blink::EncryptorPtr& input) {
    return input->provider_for_encryption;
  }

  static  decltype(::os_crypt_async::mojom::blink::Encryptor::key_entries)& key_entries(
       ::os_crypt_async::mojom::blink::EncryptorPtr& input) {
    return input->key_entries;
  }

  static bool Read(::os_crypt_async::mojom::blink::Encryptor::DataView input, ::os_crypt_async::mojom::blink::EncryptorPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_OS_CRYPT_ASYNC_COMMON_ENCRYPTOR_MOJOM_BLINK_H_