// components/optimization_guide/public/mojom/model_broker.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_SHARED_H_
#define COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/optimization_guide/public/mojom/model_broker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/optimization_guide/public/mojom/model_broker.mojom-data-view.h"




namespace std {

template <>
struct hash<::optimization_guide::mojom::OnDeviceFeature>
    : public mojo::internal::EnumHashImpl<::optimization_guide::mojom::OnDeviceFeature> {};

template <>
struct hash<::optimization_guide::mojom::ModelUnavailableReason>
    : public mojo::internal::EnumHashImpl<::optimization_guide::mojom::ModelUnavailableReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::optimization_guide::mojom::OnDeviceFeature, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::optimization_guide::mojom::OnDeviceFeature, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::optimization_guide::mojom::OnDeviceFeature>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::optimization_guide::mojom::ModelUnavailableReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::optimization_guide::mojom::ModelUnavailableReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::optimization_guide::mojom::ModelUnavailableReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::optimization_guide::mojom::ModelSolutionConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::optimization_guide::mojom::ModelSolutionConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::optimization_guide::mojom::internal::ModelSolutionConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::feature_config(input)) in_feature_config = Traits::feature_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->feature_config)::BaseType> feature_config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
      in_feature_config,
      feature_config_fragment);

    fragment->feature_config.Set(
        feature_config_fragment.is_null() ? nullptr : feature_config_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->feature_config.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feature_config in ModelSolutionConfig struct");

    decltype(Traits::text_safety_config(input)) in_text_safety_config = Traits::text_safety_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_safety_config)::BaseType> text_safety_config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
      in_text_safety_config,
      text_safety_config_fragment);

    fragment->text_safety_config.Set(
        text_safety_config_fragment.is_null() ? nullptr : text_safety_config_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_safety_config.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_safety_config in ModelSolutionConfig struct");

    decltype(Traits::model_versions(input)) in_model_versions = Traits::model_versions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_versions)::BaseType> model_versions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
      in_model_versions,
      model_versions_fragment);

    fragment->model_versions.Set(
        model_versions_fragment.is_null() ? nullptr : model_versions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_versions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_versions in ModelSolutionConfig struct");

    fragment->max_tokens = Traits::max_tokens(input);
  }

  static bool Deserialize(::optimization_guide::mojom::internal::ModelSolutionConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::optimization_guide::mojom::ModelSolutionConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::optimization_guide::mojom::ModelSubscriptionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::optimization_guide::mojom::ModelSubscriptionOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::optimization_guide::mojom::internal::ModelSubscriptionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::optimization_guide::mojom::OnDeviceFeature>(
      Traits::feature(input),
      &fragment->feature);

    fragment->mark_used = Traits::mark_used(input);
  }

  static bool Deserialize(::optimization_guide::mojom::internal::ModelSubscriptionOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::optimization_guide::mojom::ModelSubscriptionOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace optimization_guide::mojom {

inline void ModelSolutionConfigDataView::GetFeatureConfigDataView(
    ::mojo_base::mojom::ProtoWrapperDataView* output) {
  auto pointer = data_->feature_config.Get();
  *output = ::mojo_base::mojom::ProtoWrapperDataView(pointer, message_);
}
inline void ModelSolutionConfigDataView::GetTextSafetyConfigDataView(
    ::mojo_base::mojom::ProtoWrapperDataView* output) {
  auto pointer = data_->text_safety_config.Get();
  *output = ::mojo_base::mojom::ProtoWrapperDataView(pointer, message_);
}
inline void ModelSolutionConfigDataView::GetModelVersionsDataView(
    ::mojo_base::mojom::ProtoWrapperDataView* output) {
  auto pointer = data_->model_versions.Get();
  *output = ::mojo_base::mojom::ProtoWrapperDataView(pointer, message_);
}





}  // optimization_guide::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::optimization_guide::mojom::OnDeviceFeature> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::optimization_guide::mojom::OnDeviceFeature value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::optimization_guide::mojom::ModelUnavailableReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::optimization_guide::mojom::ModelUnavailableReason value);
};

} // namespace perfetto

#endif  // COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_SHARED_H_