// components/optimization_guide/public/mojom/model_broker.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/optimization_guide/public/mojom/model_broker.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/optimization_guide/public/mojom/model_broker.mojom-params-data.h"
namespace optimization_guide {
namespace mojom {

NOINLINE static const char* OnDeviceFeatureToStringHelper(OnDeviceFeature value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OnDeviceFeature::kCompose:
      return "kCompose";
    case OnDeviceFeature::kTest:
      return "kTest";
    case OnDeviceFeature::kPromptApi:
      return "kPromptApi";
    case OnDeviceFeature::kHistorySearch:
      return "kHistorySearch";
    case OnDeviceFeature::kSummarize:
      return "kSummarize";
    case OnDeviceFeature::kHistoryQueryIntent:
      return "kHistoryQueryIntent";
    case OnDeviceFeature::kScamDetection:
      return "kScamDetection";
    case OnDeviceFeature::kPermissionsAi:
      return "kPermissionsAi";
    case OnDeviceFeature::kWritingAssistanceApi:
      return "kWritingAssistanceApi";
    case OnDeviceFeature::kOnDeviceSpeechRecognition:
      return "kOnDeviceSpeechRecognition";
    case OnDeviceFeature::kProofreaderApi:
      return "kProofreaderApi";
    default:
      return nullptr;
  }
}

std::string OnDeviceFeatureToString(OnDeviceFeature value) {
  const char *str = OnDeviceFeatureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OnDeviceFeature value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OnDeviceFeature value) {
  return os << OnDeviceFeatureToString(value);
}

NOINLINE static const char* ModelUnavailableReasonToStringHelper(ModelUnavailableReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ModelUnavailableReason::kUnknown:
      return "kUnknown";
    case ModelUnavailableReason::kNotSupported:
      return "kNotSupported";
    case ModelUnavailableReason::kPendingAssets:
      return "kPendingAssets";
    case ModelUnavailableReason::kPendingUsage:
      return "kPendingUsage";
    default:
      return nullptr;
  }
}

std::string ModelUnavailableReasonToString(ModelUnavailableReason value) {
  const char *str = ModelUnavailableReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ModelUnavailableReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ModelUnavailableReason value) {
  return os << ModelUnavailableReasonToString(value);
}

namespace internal {


// static
bool ModelSolutionConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelSolutionConfig_Data* object =
      static_cast<const ModelSolutionConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feature_config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->feature_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_safety_config, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text_safety_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_versions, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->model_versions, validation_context))
    return false;

  return true;
}

ModelSolutionConfig_Data::ModelSolutionConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelSubscriptionOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelSubscriptionOptions_Data* object =
      static_cast<const ModelSubscriptionOptions_Data*>(data);


  if (!::optimization_guide::mojom::internal::OnDeviceFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  return true;
}

ModelSubscriptionOptions_Data::ModelSubscriptionOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelSolution_CreateSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelSolution_CreateSession_Params_Data* object =
      static_cast<const ModelSolution_CreateSession_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

ModelSolution_CreateSession_Params_Data::ModelSolution_CreateSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelSolution_CreateTextSafetySession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelSolution_CreateTextSafetySession_Params_Data* object =
      static_cast<const ModelSolution_CreateTextSafetySession_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ModelSolution_CreateTextSafetySession_Params_Data::ModelSolution_CreateTextSafetySession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelSolution_ReportHealthyCompletion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelSolution_ReportHealthyCompletion_Params_Data* object =
      static_cast<const ModelSolution_ReportHealthyCompletion_Params_Data*>(data);

  return true;
}

ModelSolution_ReportHealthyCompletion_Params_Data::ModelSolution_ReportHealthyCompletion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelSubscriber_Unavailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelSubscriber_Unavailable_Params_Data* object =
      static_cast<const ModelSubscriber_Unavailable_Params_Data*>(data);


  if (!::optimization_guide::mojom::internal::ModelUnavailableReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

ModelSubscriber_Unavailable_Params_Data::ModelSubscriber_Unavailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelSubscriber_Available_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelSubscriber_Available_Params_Data* object =
      static_cast<const ModelSubscriber_Available_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->solution, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->solution,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ModelSubscriber_Available_Params_Data::ModelSubscriber_Available_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModelBroker_Subscribe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelBroker_Subscribe_Params_Data* object =
      static_cast<const ModelBroker_Subscribe_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subcriber, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subcriber,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ModelBroker_Subscribe_Params_Data::ModelBroker_Subscribe_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace optimization_guide

namespace perfetto {

// static
void TraceFormatTraits<::optimization_guide::mojom::OnDeviceFeature>::WriteIntoTrace(
   perfetto::TracedValue context, ::optimization_guide::mojom::OnDeviceFeature value) {
  return std::move(context).WriteString(::optimization_guide::mojom::OnDeviceFeatureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::optimization_guide::mojom::ModelUnavailableReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::optimization_guide::mojom::ModelUnavailableReason value) {
  return std::move(context).WriteString(::optimization_guide::mojom::ModelUnavailableReasonToString(value));
}

} // namespace perfetto