// components/optimization_guide/public/mojom/model_broker.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/optimization_guide/public/mojom/model_broker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-shared.h"


namespace optimization_guide::mojom {
class ModelSolutionConfigDataView;

class ModelSubscriptionOptionsDataView;



}  // optimization_guide::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::optimization_guide::mojom::ModelSolutionConfigDataView> {
  using Data = ::optimization_guide::mojom::internal::ModelSolutionConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::optimization_guide::mojom::ModelSubscriptionOptionsDataView> {
  using Data = ::optimization_guide::mojom::internal::ModelSubscriptionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace optimization_guide::mojom {


enum class OnDeviceFeature : int32_t {
  
  kCompose = 0,
  
  kTest = 1,
  
  kPromptApi = 2,
  
  kHistorySearch = 3,
  
  kSummarize = 4,
  
  kHistoryQueryIntent = 5,
  
  kScamDetection = 6,
  
  kPermissionsAi = 7,
  
  kWritingAssistanceApi = 8,
  
  kOnDeviceSpeechRecognition = 9,
  
  kProofreaderApi = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

 std::ostream& operator<<(std::ostream& os, OnDeviceFeature value);
inline bool IsKnownEnumValue(OnDeviceFeature value) {
  return internal::OnDeviceFeature_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ModelUnavailableReason : int32_t {
  
  kUnknown = 0,
  
  kNotSupported = 2,
  
  kPendingAssets = 3,
  
  kPendingUsage = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ModelUnavailableReason value);
inline bool IsKnownEnumValue(ModelUnavailableReason value) {
  return internal::ModelUnavailableReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ModelSolutionInterfaceBase {};

using ModelSolutionPtrDataView =
    mojo::InterfacePtrDataView<ModelSolutionInterfaceBase>;
using ModelSolutionRequestDataView =
    mojo::InterfaceRequestDataView<ModelSolutionInterfaceBase>;
using ModelSolutionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ModelSolutionInterfaceBase>;
using ModelSolutionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ModelSolutionInterfaceBase>;
class ModelSubscriberInterfaceBase {};

using ModelSubscriberPtrDataView =
    mojo::InterfacePtrDataView<ModelSubscriberInterfaceBase>;
using ModelSubscriberRequestDataView =
    mojo::InterfaceRequestDataView<ModelSubscriberInterfaceBase>;
using ModelSubscriberAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ModelSubscriberInterfaceBase>;
using ModelSubscriberAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ModelSubscriberInterfaceBase>;
class ModelBrokerInterfaceBase {};

using ModelBrokerPtrDataView =
    mojo::InterfacePtrDataView<ModelBrokerInterfaceBase>;
using ModelBrokerRequestDataView =
    mojo::InterfaceRequestDataView<ModelBrokerInterfaceBase>;
using ModelBrokerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ModelBrokerInterfaceBase>;
using ModelBrokerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ModelBrokerInterfaceBase>;


class ModelSolutionConfigDataView {
 public:
  ModelSolutionConfigDataView() = default;

  ModelSolutionConfigDataView(
      internal::ModelSolutionConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFeatureConfigDataView(
      ::mojo_base::mojom::ProtoWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatureConfig(UserType* output) {
    
    auto* pointer = data_->feature_config.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProtoWrapperDataView>(
        pointer, output, message_);
  }
  inline void GetTextSafetyConfigDataView(
      ::mojo_base::mojom::ProtoWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextSafetyConfig(UserType* output) {
    
    auto* pointer = data_->text_safety_config.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProtoWrapperDataView>(
        pointer, output, message_);
  }
  inline void GetModelVersionsDataView(
      ::mojo_base::mojom::ProtoWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelVersions(UserType* output) {
    
    auto* pointer = data_->model_versions.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProtoWrapperDataView>(
        pointer, output, message_);
  }
  int32_t max_tokens() const {
    return data_->max_tokens;
  }
 private:
  internal::ModelSolutionConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ModelSubscriptionOptionsDataView {
 public:
  ModelSubscriptionOptionsDataView() = default;

  ModelSubscriptionOptionsDataView(
      internal::ModelSubscriptionOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFeature(UserType* output) const {
    auto data_value = data_->feature;
    return mojo::internal::Deserialize<::optimization_guide::mojom::OnDeviceFeature>(
        data_value, output);
  }
  OnDeviceFeature feature() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::optimization_guide::mojom::OnDeviceFeature>(data_->feature));
  }
  bool mark_used() const {
    return data_->mark_used;
  }
 private:
  internal::ModelSubscriptionOptions_Data* data_ = nullptr;
};


}  // optimization_guide::mojom

#endif  // COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_DATA_VIEW_H_