// components/optimization_guide/content/mojom/page_text_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OPTIMIZATION_GUIDE_CONTENT_MOJOM_PAGE_TEXT_SERVICE_MOJOM_H_
#define COMPONENTS_OPTIMIZATION_GUIDE_CONTENT_MOJOM_PAGE_TEXT_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/optimization_guide/content/mojom/page_text_service.mojom-features.h"  // IWYU pragma: export
#include "components/optimization_guide/content/mojom/page_text_service.mojom-shared.h"  // IWYU pragma: export
#include "components/optimization_guide/content/mojom/page_text_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace optimization_guide::mojom {

class PageTextConsumerProxy;

template <typename ImplRefTraits>
class PageTextConsumerStub;

class PageTextConsumerRequestValidator;


class PageTextConsumer
    : public PageTextConsumerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "optimization_guide.mojom.PageTextConsumer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageTextConsumerInterfaceBase;
  using Proxy_ = PageTextConsumerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageTextConsumerStub<ImplRefTraits>;

  using RequestValidator_ = PageTextConsumerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnTextDumpChunkMinVersion = 0,
    kOnChunksEndMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnTextDumpChunk_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnChunksEnd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageTextConsumer() = default;

  virtual void OnTextDumpChunk(const ::std::u16string& chunk) = 0;

  virtual void OnChunksEnd() = 0;
};

class PageTextServiceProxy;

template <typename ImplRefTraits>
class PageTextServiceStub;

class PageTextServiceRequestValidator;


class PageTextService
    : public PageTextServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "optimization_guide.mojom.PageTextService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageTextServiceInterfaceBase;
  using Proxy_ = PageTextServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageTextServiceStub<ImplRefTraits>;

  using RequestValidator_ = PageTextServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestPageTextDumpMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestPageTextDump_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageTextService() = default;

  virtual void RequestPageTextDump(PageTextDumpRequestPtr request, ::mojo::PendingRemote<PageTextConsumer> consumer) = 0;
};



class  PageTextConsumerProxy
    : public PageTextConsumer {
 public:
  using InterfaceType = PageTextConsumer;

  explicit PageTextConsumerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnTextDumpChunk(const ::std::u16string& chunk) final;
  
  void OnChunksEnd() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageTextServiceProxy
    : public PageTextService {
 public:
  using InterfaceType = PageTextService;

  explicit PageTextServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestPageTextDump(PageTextDumpRequestPtr request, ::mojo::PendingRemote<PageTextConsumer> consumer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageTextConsumerStubDispatch {
 public:
  static bool Accept(PageTextConsumer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageTextConsumer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageTextConsumer>>
class PageTextConsumerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageTextConsumerStub() = default;
  ~PageTextConsumerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageTextConsumerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageTextConsumerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageTextServiceStubDispatch {
 public:
  static bool Accept(PageTextService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageTextService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageTextService>>
class PageTextServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageTextServiceStub() = default;
  ~PageTextServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageTextServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageTextServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageTextConsumerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageTextServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  PageTextDumpRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageTextDumpRequest, T>::value>;
  using DataView = PageTextDumpRequestDataView;
  using Data_ = internal::PageTextDumpRequest_Data;

  template <typename... Args>
  static PageTextDumpRequestPtr New(Args&&... args) {
    return PageTextDumpRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageTextDumpRequestPtr From(const U& u) {
    return mojo::TypeConverter<PageTextDumpRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageTextDumpRequest>::Convert(*this);
  }


  PageTextDumpRequest();

  PageTextDumpRequest(
      uint32_t max_size,
      TextDumpEvent event);


  ~PageTextDumpRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageTextDumpRequestPtr>
  PageTextDumpRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageTextDumpRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageTextDumpRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageTextDumpRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageTextDumpRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageTextDumpRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageTextDumpRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageTextDumpRequest_UnserializedMessageContext<
            UserType, PageTextDumpRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageTextDumpRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageTextDumpRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageTextDumpRequest_UnserializedMessageContext<
            UserType, PageTextDumpRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageTextDumpRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t max_size;
  
  TextDumpEvent event;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageTextDumpRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageTextDumpRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageTextDumpRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageTextDumpRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
PageTextDumpRequestPtr PageTextDumpRequest::Clone() const {
  return New(
      mojo::Clone(max_size),
      mojo::Clone(event)
  );
}

template <typename T, PageTextDumpRequest::EnableIfSame<T>*>
bool PageTextDumpRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->max_size, other_struct.max_size))
    return false;
  if (!mojo::Equals(this->event, other_struct.event))
    return false;
  return true;
}

template <typename T, PageTextDumpRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.max_size < rhs.max_size)
    return true;
  if (rhs.max_size < lhs.max_size)
    return false;
  if (lhs.event < rhs.event)
    return true;
  if (rhs.event < lhs.event)
    return false;
  return false;
}


}  // optimization_guide::mojom

namespace mojo {


template <>
struct  StructTraits<::optimization_guide::mojom::PageTextDumpRequest::DataView,
                                         ::optimization_guide::mojom::PageTextDumpRequestPtr> {
  static bool IsNull(const ::optimization_guide::mojom::PageTextDumpRequestPtr& input) { return !input; }
  static void SetToNull(::optimization_guide::mojom::PageTextDumpRequestPtr* output) { output->reset(); }

  static decltype(::optimization_guide::mojom::PageTextDumpRequest::max_size) max_size(
      const ::optimization_guide::mojom::PageTextDumpRequestPtr& input) {
    return input->max_size;
  }

  static decltype(::optimization_guide::mojom::PageTextDumpRequest::event) event(
      const ::optimization_guide::mojom::PageTextDumpRequestPtr& input) {
    return input->event;
  }

  static bool Read(::optimization_guide::mojom::PageTextDumpRequest::DataView input, ::optimization_guide::mojom::PageTextDumpRequestPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_OPTIMIZATION_GUIDE_CONTENT_MOJOM_PAGE_TEXT_SERVICE_MOJOM_H_