// components/optimization_guide/content/mojom/page_text_service.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  String16Spec as mojoBase_mojom_String16Spec,
  String16 as mojoBase_mojom_String16
} from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';





export const TextDumpEventSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TextDumpEvent {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kFirstLayout = 0,
  kFinishedLoad = 1,
}



export type PageTextConsumerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageTextConsumerPendingReceiver>;

export class PageTextConsumerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageTextConsumer> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageTextConsumerPendingReceiver>;
  constructor(handle: MojoHandle|PageTextConsumerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'optimization_guide.mojom.PageTextConsumer',
        scope);
  }
}

export interface PageTextConsumerInterface {
  onTextDumpChunk(chunk: mojoBase_mojom_String16): void;
  onChunksEnd(): void;
}

export class PageTextConsumerRemote implements PageTextConsumerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageTextConsumerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageTextConsumerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageTextConsumerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageTextConsumerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onTextDumpChunk(
      chunk: mojoBase_mojom_String16): void {
    this.proxy.sendMessage(
        0,
        PageTextConsumer_OnTextDumpChunk_ParamsSpec.$,
        null,
        [
          chunk
        ],
        false);
  }

  onChunksEnd(): void {
    this.proxy.sendMessage(
        1,
        PageTextConsumer_OnChunksEnd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageTextConsumer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageTextConsumerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageTextConsumerRemote, PageTextConsumerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageTextConsumerRemote, PageTextConsumerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageTextConsumerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageTextConsumerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageTextConsumer_OnTextDumpChunk_ParamsSpec.$,
        null,
        impl.onTextDumpChunk.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageTextConsumer_OnChunksEnd_ParamsSpec.$,
        null,
        impl.onChunksEnd.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageTextConsumer {
  static get $interfaceName(): string {
    return "optimization_guide.mojom.PageTextConsumer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageTextConsumerRemote {
    let remote = new PageTextConsumerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageTextConsumer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageTextConsumerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageTextConsumerRemote, PageTextConsumerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageTextConsumerRemote, PageTextConsumerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onTextDumpChunk: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onChunksEnd: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageTextConsumerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onTextDumpChunk =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageTextConsumer_OnTextDumpChunk_ParamsSpec.$,
        null,
        this.onTextDumpChunk.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onChunksEnd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageTextConsumer_OnChunksEnd_ParamsSpec.$,
        null,
        this.onChunksEnd.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageTextServicePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageTextServicePendingReceiver>;

export class PageTextServicePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageTextService> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageTextServicePendingReceiver>;
  constructor(handle: MojoHandle|PageTextServicePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'optimization_guide.mojom.PageTextService',
        scope);
  }
}

export interface PageTextServiceInterface {
  requestPageTextDump(request: PageTextDumpRequest, consumer: PageTextConsumerRemote): void;
}

export class PageTextServiceRemote implements PageTextServiceInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageTextServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageTextServicePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageTextServicePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageTextServicePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  requestPageTextDump(
      request: PageTextDumpRequest,
      consumer: PageTextConsumerRemote): void {
    this.proxy.sendMessage(
        0,
        PageTextService_RequestPageTextDump_ParamsSpec.$,
        null,
        [
          request,
          consumer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageTextService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageTextServiceReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageTextServiceRemote, PageTextServicePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageTextServiceRemote, PageTextServicePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageTextServiceInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageTextServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageTextService_RequestPageTextDump_ParamsSpec.$,
        null,
        impl.requestPageTextDump.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageTextService {
  static get $interfaceName(): string {
    return "optimization_guide.mojom.PageTextService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageTextServiceRemote {
    let remote = new PageTextServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageTextService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageTextServiceCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageTextServiceRemote, PageTextServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageTextServiceRemote, PageTextServicePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  requestPageTextDump: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageTextServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.requestPageTextDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageTextService_RequestPageTextDump_ParamsSpec.$,
        null,
        this.requestPageTextDump.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageTextDumpRequestSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageTextConsumer_OnTextDumpChunk_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageTextConsumer_OnChunksEnd_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageTextService_RequestPageTextDump_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageTextDumpRequestMojoType {
  maxSize: number;
  event: TextDumpEvent;
}


export type PageTextDumpRequest = PageTextDumpRequestMojoType;
mojo.internal.Struct<PageTextDumpRequestMojoType>(
    PageTextDumpRequestSpec.$,
    'PageTextDumpRequest',
    [
      mojo.internal.StructField<PageTextDumpRequestMojoType, number>(
        'maxSize', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageTextDumpRequestMojoType, TextDumpEvent>(
        'event', 4,
        0,
        TextDumpEventSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageTextConsumer_OnTextDumpChunk_ParamsMojoType {
  chunk: mojoBase_mojom_String16;
}


export type PageTextConsumer_OnTextDumpChunk_Params = PageTextConsumer_OnTextDumpChunk_ParamsMojoType;
mojo.internal.Struct<PageTextConsumer_OnTextDumpChunk_ParamsMojoType>(
    PageTextConsumer_OnTextDumpChunk_ParamsSpec.$,
    'PageTextConsumer_OnTextDumpChunk_Params',
    [
      mojo.internal.StructField<PageTextConsumer_OnTextDumpChunk_ParamsMojoType, mojoBase_mojom_String16>(
        'chunk', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageTextConsumer_OnChunksEnd_ParamsMojoType {
}


export type PageTextConsumer_OnChunksEnd_Params = PageTextConsumer_OnChunksEnd_ParamsMojoType;
mojo.internal.Struct<PageTextConsumer_OnChunksEnd_ParamsMojoType>(
    PageTextConsumer_OnChunksEnd_ParamsSpec.$,
    'PageTextConsumer_OnChunksEnd_Params',
    [
    ],
    [[0, 8],]);





export interface PageTextService_RequestPageTextDump_ParamsMojoType {
  request: PageTextDumpRequest;
  consumer: PageTextConsumerRemote;
}


export type PageTextService_RequestPageTextDump_Params = PageTextService_RequestPageTextDump_ParamsMojoType;
mojo.internal.Struct<PageTextService_RequestPageTextDump_ParamsMojoType>(
    PageTextService_RequestPageTextDump_ParamsSpec.$,
    'PageTextService_RequestPageTextDump_Params',
    [
      mojo.internal.StructField<PageTextService_RequestPageTextDump_ParamsMojoType, PageTextDumpRequest>(
        'request', 0,
        0,
        PageTextDumpRequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageTextService_RequestPageTextDump_ParamsMojoType, PageTextConsumerRemote>(
        'consumer', 8,
        0,
        mojo.internal.InterfaceProxy(PageTextConsumerRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



