// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.cc.template is used to generate vector_icons.cc. Edit the former
// rather than the latter.

#include "components/omnibox/browser/vector_icons.h"

#include "components/vector_icons/cc_macros.h"
#include "ui/gfx/vector_icon_types.h"

#define DECLARE_VECTOR_COMMAND(x) using gfx::x;
DECLARE_VECTOR_COMMANDS

namespace omnibox {

VECTOR_ICON_REP_TEMPLATE(kAnswerCalculatorPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3, 5,
R_H_LINE_TO, 10,
R_V_LINE_TO, 2,
H_LINE_TO, 3,
V_LINE_TO, 5,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 10,
R_V_LINE_TO, 2,
H_LINE_TO, 3,
V_LINE_TO, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerCalculatorRepList, kAnswerCalculatorIcon, {kAnswerCalculatorPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerCurrencyPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 3.64,
R_V_LINE_TO, 2.18,
R_LINE_TO, 3, -2.91,
LINE_TO, 8, 0,
R_V_LINE_TO, 2.18,
CUBIC_TO, 4.68, 2.18, 2, 4.79, 2, 8,
R_CUBIC_TO, 0, 1.14, 0.35, 2.2, 0.93, 3.1,
R_LINE_TO, 1.1, -1.06,
ARC_TO, 4.17, 4.17, 0, 0, 1, 3.5, 8,
R_CUBIC_TO, 0, -2.41, 2.02, -4.36, 4.5, -4.36,
CLOSE,
R_MOVE_TO, 5.07, 1.27,
R_LINE_TO, -1.09, 1.06,
R_CUBIC_TO, 0.33, 0.61, 0.53, 1.3, 0.53, 2.04,
R_CUBIC_TO, 0, 2.41, -2.02, 4.36, -4.5, 4.36,
R_V_LINE_TO, -2.18,
LINE_TO, 5, 13.09,
LINE_TO, 8, 16,
R_V_LINE_TO, -2.18,
R_CUBIC_TO, 3.32, 0, 6, -2.6, 6, -5.82,
R_ARC_TO, 5.64, 5.64, 0, 0, 0, -0.93, -3.1,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerCurrencyRepList, kAnswerCurrencyIcon, {kAnswerCurrencyPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerCurrencyChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.77, 10.39,
R_ARC_TO, 5.41, 5.41, 0, 0, 1, -0.48, -1.13,
R_ARC_TO, 4.37, 4.37, 0, 0, 1, -0.18, -1.27,
R_CUBIC_TO, 0, -1.36, 0.48, -2.52, 1.44, -3.49,
R_CUBIC_TO, 0.96, -0.96, 2.13, -1.43, 3.51, -1.39,
R_H_LINE_TO, 0,
R_LINE_TO, -0.89, -0.89,
R_LINE_TO, 0.89, -0.89,
LINE_TO, 10.54, 3.8,
LINE_TO, 8.07, 6.27,
R_LINE_TO, -0.89, -0.89,
R_LINE_TO, 0.89, -0.89,
R_H_LINE_TO, 0.01,
R_CUBIC_TO, -1.01, -0.02, -1.85, 0.31, -2.55, 1,
R_CUBIC_TO, -0.69, 0.7, -1.03, 1.52, -1.03, 2.5,
R_CUBIC_TO, 0, 0.25, 0.02, 0.49, 0.07, 0.72,
R_CUBIC_TO, 0.05, 0.23, 0.12, 0.45, 0.22, 0.67,
CLOSE,
R_MOVE_TO, 4.16, 4.29,
R_LINE_TO, -2.47, -2.47,
R_LINE_TO, 2.47, -2.48,
R_LINE_TO, 0.89, 0.89,
R_LINE_TO, -0.89, 0.89,
H_LINE_TO, 7.93,
R_CUBIC_TO, 1.01, 0.02, 1.86, -0.31, 2.55, -1.01,
R_ARC_TO, 3.41, 3.41, 0, 0, 0, 1.03, -2.5,
R_ARC_TO, 3.6, 3.6, 0, 0, 0, -0.07, -0.72,
R_ARC_TO, 3.51, 3.51, 0, 0, 0, -0.22, -0.67,
R_LINE_TO, 1.01, -1,
R_CUBIC_TO, 0.2, 0.36, 0.36, 0.73, 0.48, 1.13,
R_CUBIC_TO, 0.12, 0.4, 0.18, 0.82, 0.18, 1.26,
R_CUBIC_TO, 0, 1.35, -0.48, 2.51, -1.44, 3.48,
R_CUBIC_TO, -0.96, 0.97, -2.13, 1.44, -3.51, 1.41,
R_H_LINE_TO, 0,
R_LINE_TO, 0.89, 0.89,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerCurrencyChromeRefreshRepList, kAnswerCurrencyChromeRefreshIcon, {kAnswerCurrencyChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerDefaultPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8.14, 9.33,
V_LINE_TO, 6.73,
R_H_LINE_TO, 6.68,
R_CUBIC_TO, 0.1, 0.44, 0.18, 0.85, 0.18, 1.44,
CUBIC_TO, 15, 12.16, 12.27, 15, 8.15, 15,
CUBIC_TO, 4.2, 15, 1, 11.86, 1, 8,
R_CUBIC_TO, 0, -3.86, 3.2, -7, 7.14, -7,
R_CUBIC_TO, 1.93, 0, 3.54, 0.69, 4.78, 1.83,
R_LINE_TO, -2.03, 1.93,
R_CUBIC_TO, -0.51, -0.48, -1.41, -1.04, -2.75, -1.04,
ARC_TO, 4.3, 4.3, 0, 0, 0, 3.85, 8,
R_ARC_TO, 4.3, 4.3, 0, 0, 0, 4.29, 4.28,
R_CUBIC_TO, 2.74, 0, 3.74, -1.85, 3.93, -2.95,
H_LINE_TO, 8.14,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerDefaultRepList, kAnswerDefaultIcon, {kAnswerDefaultPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerDictionaryPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 13, 1,
H_LINE_TO, 3,
R_CUBIC_TO, -0.6, 0, -1, 0.4, -1, 1,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 0.6, 0.4, 1, 1, 1,
R_H_LINE_TO, 10,
R_CUBIC_TO, 0.6, 0, 1, -0.4, 1, -1,
V_LINE_TO, 2,
R_CUBIC_TO, 0, -0.6, -0.4, -1, -1, -1,
CLOSE,
R_MOVE_TO, -1, 12,
H_LINE_TO, 4,
V_LINE_TO, 3,
R_H_LINE_TO, 1,
R_V_LINE_TO, 6,
R_LINE_TO, 2, -1.1,
LINE_TO, 9, 9,
V_LINE_TO, 3,
R_H_LINE_TO, 3,
R_V_LINE_TO, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerDictionaryRepList, kAnswerDictionaryIcon, {kAnswerDictionaryPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerDictionaryChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 4.44, 14.54,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.35, 1.35, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 2.85,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 7.11,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 10.31,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 0.01, -1.38,
R_H_LINE_TO, 7.1,
V_LINE_TO, 2.85,
R_H_LINE_TO, -1.14,
R_V_LINE_TO, 5.2,
R_LINE_TO, -1.6, -0.8,
R_LINE_TO, -1.6, 0.8,
R_V_LINE_TO, -5.2,
H_LINE_TO, 4.45,
CLOSE,
R_MOVE_TO, 0, 0,
V_LINE_TO, 2.85,
CLOSE,
R_MOVE_TO, 2.76, -5.11,
R_LINE_TO, 1.6, -0.8,
R_LINE_TO, 1.6, 0.8,
R_LINE_TO, -1.6, -0.8,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerDictionaryChromeRefreshRepList, kAnswerDictionaryChromeRefreshIcon, {kAnswerDictionaryChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerFinancePath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 9, 12,
V_LINE_TO, 7,
R_H_LINE_TO, 2,
R_V_LINE_TO, 5,
R_H_LINE_TO, 2,
R_LINE_TO, -3, 3,
R_LINE_TO, -3, -3,
R_H_LINE_TO, 2,
CLOSE,
MOVE_TO, 7, 4,
R_V_LINE_TO, 5,
H_LINE_TO, 5,
V_LINE_TO, 4,
H_LINE_TO, 3,
R_LINE_TO, 3, -3,
R_LINE_TO, 3, 3,
H_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerFinanceRepList, kAnswerFinanceIcon, {kAnswerFinancePath})
VECTOR_ICON_REP_TEMPLATE(kAnswerFinanceChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 5.31, 8.78,
V_LINE_TO, 4,
LINE_TO, 3.65, 5.66,
R_LINE_TO, -0.98, -0.98,
LINE_TO, 6, 1.36,
R_LINE_TO, 3.33, 3.33,
R_LINE_TO, -0.98, 0.98,
R_LINE_TO, -1.66, -1.66,
R_V_LINE_TO, 4.77,
CLOSE,
MOVE_TO, 10, 14.65,
R_LINE_TO, -3.33, -3.33,
R_LINE_TO, 0.98, -0.98,
R_LINE_TO, 1.66, 1.66,
V_LINE_TO, 7.22,
R_H_LINE_TO, 1.38,
R_V_LINE_TO, 4.77,
R_LINE_TO, 1.66, -1.66,
R_LINE_TO, 0.98, 0.98,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerFinanceChromeRefreshRepList, kAnswerFinanceChromeRefreshIcon, {kAnswerFinanceChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerSunrisePath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 4,
CUBIC_TO, 5.79, 4, 4, 5.79, 4, 8,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
CLOSE,
R_MOVE_TO, 1, -4,
R_V_LINE_TO, 2,
H_LINE_TO, 7,
V_LINE_TO, 0,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 14,
R_V_LINE_TO, 2,
H_LINE_TO, 7,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
CLOSE,
MOVE_TO, 0, 7,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
H_LINE_TO, 0,
V_LINE_TO, 7,
CLOSE,
R_MOVE_TO, 14, 0,
R_H_LINE_TO, 2,
R_V_LINE_TO, 2,
R_H_LINE_TO, -2,
V_LINE_TO, 7,
CLOSE,
MOVE_TO, 3.05, 1.64,
LINE_TO, 4.46, 3.05,
LINE_TO, 3.05, 4.46,
LINE_TO, 1.64, 3.05,
LINE_TO, 3.05, 1.64,
CLOSE,
R_MOVE_TO, 9.9, 9.9,
R_LINE_TO, 1.41, 1.41,
R_LINE_TO, -1.41, 1.41,
R_LINE_TO, -1.41, -1.41,
R_LINE_TO, 1.41, -1.41,
CLOSE,
MOVE_TO, 1.64, 12.95,
R_LINE_TO, 1.41, -1.41,
R_LINE_TO, 1.41, 1.41,
R_LINE_TO, -1.41, 1.41,
R_LINE_TO, -1.41, -1.41,
CLOSE,
R_MOVE_TO, 9.9, -9.9,
R_LINE_TO, 1.41, -1.41,
R_LINE_TO, 1.41, 1.41,
R_LINE_TO, -1.41, 1.41,
R_LINE_TO, -1.41, -1.41,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerSunriseRepList, kAnswerSunriseIcon, {kAnswerSunrisePath})
VECTOR_ICON_REP_TEMPLATE(kAnswerSunriseChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 7.31, 2.86,
V_LINE_TO, 0.68,
H_LINE_TO, 8.69,
R_V_LINE_TO, 2.18,
CLOSE,
R_MOVE_TO, 0, 12.46,
R_V_LINE_TO, -2.18,
H_LINE_TO, 8.69,
R_V_LINE_TO, 2.18,
CLOSE,
R_MOVE_TO, 5.83, -6.63,
V_LINE_TO, 7.31,
R_H_LINE_TO, 2.18,
V_LINE_TO, 8.69,
CLOSE,
R_MOVE_TO, -12.46, 0,
V_LINE_TO, 7.31,
R_H_LINE_TO, 2.18,
V_LINE_TO, 8.69,
CLOSE,
MOVE_TO, 12.12, 4.86,
R_LINE_TO, -0.98, -0.98,
LINE_TO, 12.67, 2.3,
R_LINE_TO, 1.03, 1.03,
CLOSE,
MOVE_TO, 3.35, 13.68,
LINE_TO, 2.32, 12.65,
R_LINE_TO, 1.56, -1.51,
R_LINE_TO, 0.98, 0.98,
CLOSE,
R_MOVE_TO, 9.32, 0,
R_LINE_TO, -1.53, -1.56,
R_LINE_TO, 0.98, -0.98,
R_LINE_TO, 1.58, 1.52,
CLOSE,
MOVE_TO, 3.88, 4.86,
LINE_TO, 2.32, 3.33,
R_LINE_TO, 1.03, -1.03,
R_LINE_TO, 1.52, 1.58,
CLOSE,
MOVE_TO, 8, 12,
R_CUBIC_TO, -1.11, 0, -2.06, -0.39, -2.83, -1.17,
CUBIC_TO, 4.39, 10.06, 4, 9.11, 4, 8,
R_CUBIC_TO, 0, -1.11, 0.39, -2.06, 1.17, -2.83,
CUBIC_TO, 5.95, 4.39, 6.89, 4, 8, 4,
R_CUBIC_TO, 1.11, 0, 2.06, 0.39, 2.83, 1.17,
CUBIC_TO, 11.61, 5.95, 12, 6.89, 12, 8,
R_CUBIC_TO, 0, 1.11, -0.39, 2.06, -1.17, 2.83,
CUBIC_TO, 10.06, 11.61, 9.11, 12, 8, 12,
CLOSE,
R_MOVE_TO, 0, -1.37,
R_ARC_TO, 2.53, 2.53, 0, 0, 0, 1.86, -0.77,
R_ARC_TO, 2.56, 2.56, 0, 0, 0, 0.76, -1.87,
R_CUBIC_TO, 0, -0.73, -0.25, -1.35, -0.76, -1.85,
R_ARC_TO, 2.52, 2.52, 0, 0, 0, -1.85, -0.76,
R_CUBIC_TO, -0.73, 0, -1.35, 0.25, -1.86, 0.76,
R_CUBIC_TO, -0.51, 0.5, -0.76, 1.12, -0.76, 1.85,
R_CUBIC_TO, 0, 0.73, 0.25, 1.35, 0.76, 1.87,
R_ARC_TO, 2.5, 2.5, 0, 0, 0, 1.85, 0.77,
CLOSE,
R_MOVE_TO, 0.02, -2.65,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerSunriseChromeRefreshRepList, kAnswerSunriseChromeRefreshIcon, {kAnswerSunriseChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerTranslationPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8.6, 10.3,
LINE_TO, 6.9, 8.7,
R_CUBIC_TO, 1.2, -1.2, 2, -2.7, 2.4, -4.2,
R_H_LINE_TO, 1.9,
V_LINE_TO, 3.3,
H_LINE_TO, 6.7,
V_LINE_TO, 2,
H_LINE_TO, 5.5,
R_V_LINE_TO, 1.3,
H_LINE_TO, 1,
R_V_LINE_TO, 1.3,
R_H_LINE_TO, 7.1,
R_CUBIC_TO, -0.4, 1.2, -1.1, 2.3, -2, 3.3,
R_CUBIC_TO, -0.6, -0.6, -1.1, -1.3, -1.5, -2.1,
H_LINE_TO, 3.3,
R_CUBIC_TO, 0.5, 1, 1.1, 2, 1.9, 2.9,
LINE_TO, 2, 11.9,
R_LINE_TO, 0.9, 0.9,
R_LINE_TO, 3.2, -3.2,
R_LINE_TO, 2, 2,
R_LINE_TO, 0.5, -1.3,
CLOSE,
R_MOVE_TO, 3.5, -3.2,
R_H_LINE_TO, -1.2,
LINE_TO, 8, 14.7,
R_H_LINE_TO, 1.3,
R_LINE_TO, 0.7, -1.9,
R_H_LINE_TO, 3,
R_LINE_TO, 0.7, 1.9,
H_LINE_TO, 15,
R_LINE_TO, -2.9, -7.6,
CLOSE,
R_MOVE_TO, -1.6, 4.4,
R_LINE_TO, 1, -2.8,
R_LINE_TO, 1, 2.8,
R_H_LINE_TO, -2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerTranslationRepList, kAnswerTranslationIcon, {kAnswerTranslationPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerTranslationChromeRefreshPath, CANVAS_DIMENSIONS, 16,
R_MOVE_TO, 8.13, 14.52,
R_LINE_TO, 2.91, -7.75,
R_H_LINE_TO, 1.39,
R_LINE_TO, 2.91, 7.75,
R_H_LINE_TO, -1.34,
R_LINE_TO, -0.69, -1.99,
R_H_LINE_TO, -3.12,
R_LINE_TO, -0.7, 1.99,
CLOSE,
R_MOVE_TO, 2.45, -3.11,
R_H_LINE_TO, 2.31,
LINE_TO, 11.77, 8.2,
R_H_LINE_TO, -0.07,
CLOSE,
R_MOVE_TO, -7.86, 1.07,
R_LINE_TO, -0.85, -0.87,
R_LINE_TO, 3.27, -3.23,
R_ARC_TO, 15.27, 15.27, 0, 0, 1, -1.14, -1.34,
R_ARC_TO, 9.15, 9.15, 0, 0, 1, -0.91, -1.51,
R_H_LINE_TO, 1.39,
R_CUBIC_TO, 0.21, 0.36, 0.44, 0.7, 0.7, 1.02,
R_CUBIC_TO, 0.26, 0.32, 0.52, 0.63, 0.79, 0.93,
ARC_TO, 15.29, 15.29, 0, 0, 0, 7.16, 6,
R_CUBIC_TO, 0.36, -0.52, 0.66, -1.07, 0.89, -1.67,
H_LINE_TO, 0.66,
V_LINE_TO, 3.1,
R_H_LINE_TO, 4.69,
V_LINE_TO, 1.48,
R_H_LINE_TO, 1.22,
R_V_LINE_TO, 1.63,
R_H_LINE_TO, 4.69,
R_V_LINE_TO, 1.23,
R_H_LINE_TO, -1.93,
R_ARC_TO, 7.96, 7.96, 0, 0, 1, -1.04, 2.16,
R_CUBIC_TO, -0.45, 0.67, -0.95, 1.3, -1.5, 1.9,
R_LINE_TO, 1.55, 1.53,
R_LINE_TO, -0.47, 1.26,
R_LINE_TO, -1.91, -1.9,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerTranslationChromeRefreshRepList, kAnswerTranslationChromeRefreshIcon, {kAnswerTranslationChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kAnswerWhenIsPath, CANVAS_DIMENSIONS, 16,
CIRCLE, 10, 10, 2,
MOVE_TO, 13.7, 2,
H_LINE_TO, 13,
V_LINE_TO, 1,
R_H_LINE_TO, -2,
R_V_LINE_TO, 1,
H_LINE_TO, 5,
V_LINE_TO, 1,
H_LINE_TO, 3,
R_V_LINE_TO, 1,
R_H_LINE_TO, -0.7,
CUBIC_TO, 1.6, 2, 1, 2.6, 1, 3.3,
R_V_LINE_TO, 10.3,
R_CUBIC_TO, 0, 0.8, 0.6, 1.4, 1.3, 1.4,
R_H_LINE_TO, 11.3,
R_CUBIC_TO, 0.7, 0, 1.3, -0.6, 1.3, -1.3,
V_LINE_TO, 3.3,
R_CUBIC_TO, 0.1, -0.7, -0.5, -1.3, -1.2, -1.3,
CLOSE,
MOVE_TO, 13, 13,
H_LINE_TO, 3,
V_LINE_TO, 5,
R_H_LINE_TO, 10,
R_V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAnswerWhenIsRepList, kAnswerWhenIsIcon, {kAnswerWhenIsPath})
VECTOR_ICON_REP_TEMPLATE(kBookmarkPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 18,
R_ARC_TO, 8, 8, 0, 1, 1, 0, -16,
R_ARC_TO, 8, 8, 0, 0, 1, 0, 16,
CLOSE,
R_MOVE_TO, 0, -4.96,
LINE_TO, 13.09, 15,
R_LINE_TO, -0.82, -3.7,
LINE_TO, 15, 8.81,
R_LINE_TO, -3.59, -0.32,
LINE_TO, 10, 5,
LINE_TO, 8.6, 8.49,
LINE_TO, 5, 8.81,
R_LINE_TO, 2.73, 2.49,
R_LINE_TO, -0.82, 3.7,
LINE_TO, 10, 13.04,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBookmarkRepList, kBookmarkIcon, {kBookmarkPath})
VECTOR_ICON_REP_TEMPLATE(kBookmarkChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 5.94, 11.81,
LINE_TO, 8, 10.59,
R_LINE_TO, 2.07, 1.22,
R_LINE_TO, -0.55, -2.31,
R_LINE_TO, 1.79, -1.53,
R_LINE_TO, -2.36, -0.21,
LINE_TO, 8, 5.57,
LINE_TO, 7.05, 7.77,
R_LINE_TO, -2.36, 0.2,
R_LINE_TO, 1.8, 1.52,
CLOSE,
R_MOVE_TO, -2.09, 2.87,
R_LINE_TO, 1.11, -4.66,
R_LINE_TO, -3.68, -3.14,
R_LINE_TO, 4.83, -0.41,
LINE_TO, 8, 2.06,
R_LINE_TO, 1.89, 4.42,
R_LINE_TO, 4.83, 0.4,
R_LINE_TO, -3.68, 3.14,
R_LINE_TO, 1.11, 4.66,
LINE_TO, 8, 12.2,
CLOSE,
MOVE_TO, 8, 8.86,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kBookmarkChromeRefreshRepList, kBookmarkChromeRefreshIcon, {kBookmarkChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kCalculatorPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 8, 12,
LINE_TO, 24, 12,
LINE_TO, 24, 15,
LINE_TO, 8, 15,
LINE_TO, 8, 12,
LINE_TO, 8, 12,
CLOSE,
MOVE_TO, 8, 18,
LINE_TO, 24, 18,
LINE_TO, 24, 21,
LINE_TO, 8, 21,
LINE_TO, 8, 18,
LINE_TO, 8, 18,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kCalculator16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 4, 5,
LINE_TO, 12, 5,
LINE_TO, 12, 7,
LINE_TO, 4, 7,
LINE_TO, 4, 5,
LINE_TO, 4, 5,
CLOSE,
MOVE_TO, 4, 9,
LINE_TO, 12, 9,
LINE_TO, 12, 11,
LINE_TO, 4, 11,
LINE_TO, 4, 9,
LINE_TO, 4, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCalculatorRepList, kCalculatorIcon, {kCalculatorPath}, {kCalculator16Path})
VECTOR_ICON_REP_TEMPLATE(kCalculatorChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 3.11, 11.29,
V_LINE_TO, 9.11,
R_H_LINE_TO, 9.78,
R_V_LINE_TO, 2.18,
CLOSE,
R_MOVE_TO, 0, -4.4,
V_LINE_TO, 4.71,
R_H_LINE_TO, 9.78,
R_V_LINE_TO, 2.18,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kCalculatorChromeRefreshRepList, kCalculatorChromeRefreshIcon, {kCalculatorChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kClearPath, CANVAS_DIMENSIONS, 26,
MOVE_TO, 7.92, 20.5,
R_ARC_TO, 126.99, 126.99, 0, 0, 1, -5.77, -5.01,
R_ARC_TO, 3.27, 3.27, 0, 0, 1, -0.3, -4.7,
R_CUBIC_TO, 0.06, -0.07, 2.08, -1.82, 6.06, -5.24,
R_CUBIC_TO, 0.71, -0.61, 1.52, -0.54, 2.54, -0.54,
R_CUBIC_TO, 0.01, -0.01, 2.04, -0.01, 6.1, 0,
CUBIC_TO, 21.28, 5, 24.99, 8.38, 25, 12.97,
CUBIC_TO, 25, 17.6, 21.29, 21, 16.55, 21,
R_H_LINE_TO, -6.13,
R_CUBIC_TO, -0.98, 0, -2, 0, -2.5, -0.5,
CLOSE,
MOVE_TO, 21, 9.97,
LINE_TO, 20.03, 9,
LINE_TO, 17, 12.03,
LINE_TO, 13.97, 9,
R_LINE_TO, -0.97, 0.97,
LINE_TO, 16.03, 13,
LINE_TO, 13, 16.03,
R_LINE_TO, 0.97, 0.97,
LINE_TO, 17, 13.97,
LINE_TO, 20.03, 17,
R_LINE_TO, 0.97, -0.97,
LINE_TO, 17.97, 13,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kClearRepList, kClearIcon, {kClearPath})
VECTOR_ICON_REP_TEMPLATE(kDinoCr2023Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 4.75, 15.25,
R_V_LINE_TO, -2.6,
R_H_LINE_TO, -0.65,
V_LINE_TO, 12,
R_H_LINE_TO, -0.65,
R_V_LINE_TO, -0.65,
R_H_LINE_TO, -0.65,
R_V_LINE_TO, -0.66,
R_H_LINE_TO, -0.66,
R_V_LINE_TO, -0.65,
R_H_LINE_TO, -0.65,
V_LINE_TO, 6.13,
R_H_LINE_TO, 0.65,
R_V_LINE_TO, 1.3,
R_H_LINE_TO, 0.65,
R_V_LINE_TO, 0.65,
R_H_LINE_TO, 0.65,
R_V_LINE_TO, 0.64,
R_H_LINE_TO, 1.31,
R_V_LINE_TO, -0.64,
R_H_LINE_TO, 0.64,
R_LINE_TO, 0.01, -0.64,
H_LINE_TO, 6.45,
V_LINE_TO, 6.79,
R_H_LINE_TO, 1.06,
R_V_LINE_TO, -0.66,
R_H_LINE_TO, 0.64,
V_LINE_TO, 1.96,
R_H_LINE_TO, 0.65,
R_V_LINE_TO, -0.65,
R_H_LINE_TO, 5.09,
R_V_LINE_TO, 0.65,
R_H_LINE_TO, 0.65,
V_LINE_TO, 4.82,
R_H_LINE_TO, -3.26,
R_V_LINE_TO, 0.65,
R_H_LINE_TO, 1.95,
R_V_LINE_TO, 0.66,
H_LINE_TO, 10.62,
R_V_LINE_TO, 1.3,
R_H_LINE_TO, 1.3,
R_V_LINE_TO, 1.3,
R_H_LINE_TO, -0.65,
R_V_LINE_TO, -0.65,
R_H_LINE_TO, -0.65,
V_LINE_TO, 10.3,
R_H_LINE_TO, -0.65,
R_V_LINE_TO, 0.91,
R_H_LINE_TO, -0.65,
R_V_LINE_TO, 0.65,
R_H_LINE_TO, -0.66,
R_V_LINE_TO, 2.75,
R_H_LINE_TO, 0.66,
R_V_LINE_TO, 0.65,
H_LINE_TO, 8.02,
R_V_LINE_TO, -1.94,
R_H_LINE_TO, -0.65,
R_V_LINE_TO, -0.65,
R_H_LINE_TO, -0.66,
R_V_LINE_TO, 0.65,
R_H_LINE_TO, -0.66,
R_V_LINE_TO, 0.65,
R_H_LINE_TO, -0.66,
R_V_LINE_TO, 0.65,
R_H_LINE_TO, 0.66,
R_V_LINE_TO, 0.65,
CLOSE,
MOVE_TO, 9.3, 2.96,
R_H_LINE_TO, 0.65,
V_LINE_TO, 2.3,
R_H_LINE_TO, -0.64,
CLOSE,
MOVE_TO, 0.85, 13.37,
R_H_LINE_TO, 2.6,
R_V_LINE_TO, -0.32,
H_LINE_TO, 0.84,
CLOSE,
R_MOVE_TO, 9.12, 0,
R_H_LINE_TO, 5.19,
R_V_LINE_TO, -0.32,
H_LINE_TO, 9.97,
CLOSE,
MOVE_TO, 2.8, 14.68,
R_H_LINE_TO, 1.3,
R_V_LINE_TO, -0.32,
H_LINE_TO, 2.8,
CLOSE,
R_MOVE_TO, -1.96, 0.98,
R_H_LINE_TO, 1.29,
R_V_LINE_TO, -0.34,
H_LINE_TO, 0.84,
CLOSE,
R_MOVE_TO, 13.37, -0.34,
R_H_LINE_TO, 0.32,
V_LINE_TO, 15,
R_H_LINE_TO, -0.32,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDinoCr2023RepList, kDinoCr2023Icon, {kDinoCr2023Path})
VECTOR_ICON_REP_TEMPLATE(kDriveDocsPath, CANVAS_DIMENSIONS, 16,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
MOVE_TO, 14, 0,
H_LINE_TO, 2,
CUBIC_TO, 0.9, 0, 0, 0.9, 0, 2,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 12,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 2,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
MOVE_TO, 3, 3,
H_LINE_TO, 13,
V_LINE_TO, 5,
H_LINE_TO, 3,
CLOSE,
MOVE_TO, 3, 7,
H_LINE_TO, 13,
V_LINE_TO, 9,
H_LINE_TO, 3,
CLOSE,
MOVE_TO, 3, 11,
H_LINE_TO, 9,
V_LINE_TO, 13,
H_LINE_TO, 3,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveDocsRepList, kDriveDocsIcon, {kDriveDocsPath})
VECTOR_ICON_REP_TEMPLATE(kDriveFolderPath, PATH_COLOR_ARGB, 0xFF, 0x5F, 0x63, 0x68,
MOVE_TO, 20, 8,
H_LINE_TO, 8,
R_CUBIC_TO, -2.21, 0, -3.98, 1.79, -3.98, 4,
LINE_TO, 4, 36,
R_CUBIC_TO, 0, 2.21, 1.79, 4, 4, 4,
R_H_LINE_TO, 32,
R_CUBIC_TO, 2.21, 0, 4, -1.79, 4, -4,
V_LINE_TO, 16,
R_CUBIC_TO, 0, -2.21, -1.79, -4, -4, -4,
H_LINE_TO, 24,
R_LINE_TO, -4, -4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveFolderRepList, kDriveFolderIcon, {kDriveFolderPath})
VECTOR_ICON_REP_TEMPLATE(kDriveFormsPath, CANVAS_DIMENSIONS, 18,
PATH_COLOR_ARGB, 0xFF, 0x67, 0x3A, 0xB7,
MOVE_TO, 16, 0,
H_LINE_TO, 2,
CUBIC_TO, 0.9, 0, 0, 0.9, 0, 2,
R_V_LINE_TO, 14,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 14,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 2,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
MOVE_TO, 6, 14,
H_LINE_TO, 4,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -4,
H_LINE_TO, 4,
V_LINE_TO, 8,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -4,
H_LINE_TO, 4,
V_LINE_TO, 4,
R_H_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 8, 8,
H_LINE_TO, 7,
R_V_LINE_TO, -2,
R_H_LINE_TO, 7,
CLOSE,
R_MOVE_TO, 0, -4,
H_LINE_TO, 7,
V_LINE_TO, 8,
R_H_LINE_TO, 7,
CLOSE,
R_MOVE_TO, 0, -4,
H_LINE_TO, 7,
V_LINE_TO, 4,
R_H_LINE_TO, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveFormsRepList, kDriveFormsIcon, {kDriveFormsPath})
VECTOR_ICON_REP_TEMPLATE(kDriveImagePath, CANVAS_DIMENSIONS, 16,
PATH_COLOR_ARGB, 0xFF, 0xD9, 0x30, 0x25,
MOVE_TO, 16, 14,
V_LINE_TO, 2,
R_CUBIC_TO, 0, -1, -1, -2, -2, -2,
H_LINE_TO, 2,
CUBIC_TO, 1, 0, 0, 1, 0, 2,
V_LINE_TO, 14,
R_CUBIC_TO, 0, 1, 1, 2, 2, 2,
H_LINE_TO, 14,
R_CUBIC_TO, 1, 0, 2, -1, 2, -2,
CLOSE,
MOVE_TO, 5, 9,
R_LINE_TO, 2, 3,
R_LINE_TO, 3, -4,
R_LINE_TO, 4, 5,
H_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveImageRepList, kDriveImageIcon, {kDriveImagePath})
VECTOR_ICON_REP_TEMPLATE(kDriveLogoPath, CANVAS_DIMENSIONS, 192,
PATH_COLOR_ARGB, 0xFF, 0x42, 0x85, 0xF4,
MOVE_TO, 33, 124,
R_V_LINE_TO, 52,
R_H_LINE_TO, 126,
R_LINE_TO, 29, -52,
H_LINE_TO, 33,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0x0F, 0x9D, 0x58,
MOVE_TO, 66, 16,
LINE_TO, 4, 124,
R_LINE_TO, 29, 52,
R_LINE_TO, 71, -122,
R_LINE_TO, -38, -38,
NEW_PATH,
PATH_COLOR_ARGB, 0xFF, 0xFC, 0xB7, 0x00,
MOVE_TO, 126, 16,
H_LINE_TO, 66,
R_LINE_TO, 63, 108,
R_H_LINE_TO, 59,
LINE_TO, 126, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveLogoRepList, kDriveLogoIcon, {kDriveLogoPath})
VECTOR_ICON_REP_TEMPLATE(kDrivePdfPath, CANVAS_DIMENSIONS, 32,
PATH_COLOR_ARGB, 0xFF, 0xEA, 0x43, 0x35,
MOVE_TO, 7.1, 15.1,
H_LINE_TO, 9,
R_V_LINE_TO, -1.8,
H_LINE_TO, 7,
CLOSE,
MOVE_TO, 28.4, 0,
H_LINE_TO, 3.6,
CUBIC_TO, 1.6, 0, 0, 1.6, 0, 3.6,
R_V_LINE_TO, 24.8,
R_CUBIC_TO, 0, 2, 1.6, 3.6, 3.6, 3.6,
R_H_LINE_TO, 24.8,
R_CUBIC_TO, 2, 0, 3.6, -1.6, 3.6, -3.6,
V_LINE_TO, 3.6,
R_CUBIC_TO, 0, -2, -1.6, -3.6, -3.6, -3.6,
CLOSE,
MOVE_TO, 11.6, 15.1,
R_CUBIC_TO, 0, 1.5, -1.2, 2.7, -2.7, 2.7,
H_LINE_TO, 7,
R_V_LINE_TO, 3.5,
H_LINE_TO, 4.4,
V_LINE_TO, 10.7,
H_LINE_TO, 9,
R_CUBIC_TO, 1.5, 0, 2.7, 1.2, 2.7, 2.6,
CLOSE,
R_MOVE_TO, 17.7, -1.8,
H_LINE_TO, 25,
R_V_LINE_TO, 1.8,
R_H_LINE_TO, 2.7,
R_V_LINE_TO, 2.7,
R_H_LINE_TO, -2.7,
R_V_LINE_TO, 3.5,
R_H_LINE_TO, -2.7,
V_LINE_TO, 10.7,
R_H_LINE_TO, 7.1,
CLOSE,
R_MOVE_TO, -8.9, 5.4,
R_CUBIC_TO, 0, 1.4, -1.1, 2.6, -2.6, 2.6,
R_H_LINE_TO, -4.5,
V_LINE_TO, 10.7,
R_H_LINE_TO, 4.5,
R_CUBIC_TO, 1.5, 0, 2.6, 1.2, 2.6, 2.6,
CLOSE,
R_MOVE_TO, -4.4, 0,
R_H_LINE_TO, 1.8,
R_V_LINE_TO, -5.4,
H_LINE_TO, 16,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDrivePdfRepList, kDrivePdfIcon, {kDrivePdfPath})
VECTOR_ICON_REP_TEMPLATE(kDriveSheetsPath, CANVAS_DIMENSIONS, 16,
PATH_COLOR_ARGB, 0xFF, 0x0F, 0x9D, 0x58,
MOVE_TO, 14, 0,
H_LINE_TO, 2,
CUBIC_TO, 0.9, 0, 0, 0.9, 0, 2,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 12,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 2,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
MOVE_TO, 2, 5,
H_LINE_TO, 14,
R_V_LINE_TO, 2,
H_LINE_TO, 2,
MOVE_TO, 5, 2,
R_H_LINE_TO, 2,
V_LINE_TO, 5,
R_H_LINE_TO, -2,
MOVE_TO, 5, 7,
R_H_LINE_TO, 2,
V_LINE_TO, 14,
R_H_LINE_TO, -2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveSheetsRepList, kDriveSheetsIcon, {kDriveSheetsPath})
VECTOR_ICON_REP_TEMPLATE(kDriveSlidesPath, CANVAS_DIMENSIONS, 16,
PATH_COLOR_ARGB, 0xFF, 0xF4, 0xB4, 0x00,
MOVE_TO, 14, 0,
H_LINE_TO, 2,
CUBIC_TO, 0.9, 0, 0, 0.9, 0, 2,
R_V_LINE_TO, 12,
R_CUBIC_TO, 0, 1.1, 0.9, 2, 2, 2,
R_H_LINE_TO, 12,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
V_LINE_TO, 2,
R_CUBIC_TO, 0, -1.1, -0.9, -2, -2, -2,
CLOSE,
MOVE_TO, 2, 4,
H_LINE_TO, 14,
V_LINE_TO, 12,
H_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveSlidesRepList, kDriveSlidesIcon, {kDriveSlidesPath})
VECTOR_ICON_REP_TEMPLATE(kDriveVideoPath, CANVAS_DIMENSIONS, 16,
PATH_COLOR_ARGB, 0xFF, 0xEA, 0x43, 0x35,
MOVE_TO, 12.8, 2,
R_LINE_TO, 1.6, 2.6,
H_LINE_TO, 12,
LINE_TO, 10.4, 2,
H_LINE_TO, 8.8,
R_LINE_TO, 1.6, 2.6,
H_LINE_TO, 8,
LINE_TO, 6.4, 2,
H_LINE_TO, 4.8,
R_LINE_TO, 1.6, 2.6,
H_LINE_TO, 4,
LINE_TO, 2.4, 2,
R_H_LINE_TO, -0.8,
CUBIC_TO, 0.7, 2, 0, 2.7, 0, 3.5,
R_V_LINE_TO, 9,
R_CUBIC_TO, 0, 0.8, 0.7, 1.5, 1.6, 1.5,
R_H_LINE_TO, 12.8,
R_CUBIC_TO, 0.9, 0, 1.6, -0.7, 1.6, -1.5,
V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kDriveVideoRepList, kDriveVideoIcon, {kDriveVideoPath})
VECTOR_ICON_REP_TEMPLATE(kEnterprisePath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 16, 17,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, -4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 4, 6,
R_H_LINE_TO, -8,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, -2,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
V_LINE_TO, 9,
R_H_LINE_TO, 8,
R_V_LINE_TO, 10,
CLOSE,
MOVE_TO, 8, 7,
R_H_LINE_TO, 2,
V_LINE_TO, 5,
H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
V_LINE_TO, 9,
H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
H_LINE_TO, 8,
R_V_LINE_TO, 2,
CLOSE,
MOVE_TO, 4, 7,
R_H_LINE_TO, 2,
V_LINE_TO, 5,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
V_LINE_TO, 9,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 0, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, -2,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, 8, -12,
V_LINE_TO, 3,
H_LINE_TO, 2,
R_V_LINE_TO, 18,
R_H_LINE_TO, 20,
V_LINE_TO, 7,
H_LINE_TO, 12,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kEnterprise12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 8, 9,
R_H_LINE_TO, 1,
V_LINE_TO, 8,
H_LINE_TO, 8,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, -2,
R_H_LINE_TO, 1,
V_LINE_TO, 6,
H_LINE_TO, 8,
R_V_LINE_TO, 1,
CLOSE,
MOVE_TO, 4, 4,
R_H_LINE_TO, 1,
V_LINE_TO, 3,
H_LINE_TO, 4,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 5,
H_LINE_TO, 4,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 7,
H_LINE_TO, 4,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 9,
H_LINE_TO, 4,
R_V_LINE_TO, 1,
CLOSE,
MOVE_TO, 2, 4,
R_H_LINE_TO, 1,
V_LINE_TO, 3,
H_LINE_TO, 2,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 5,
H_LINE_TO, 2,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 7,
H_LINE_TO, 2,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 0, 2,
R_H_LINE_TO, 1,
V_LINE_TO, 9,
H_LINE_TO, 2,
R_V_LINE_TO, 1,
CLOSE,
R_MOVE_TO, 4, -6,
V_LINE_TO, 2,
H_LINE_TO, 1,
R_V_LINE_TO, 9,
R_H_LINE_TO, 10,
V_LINE_TO, 4,
H_LINE_TO, 6,
CLOSE,
R_MOVE_TO, 4, 6,
H_LINE_TO, 6,
V_LINE_TO, 9,
R_H_LINE_TO, 1,
V_LINE_TO, 8,
H_LINE_TO, 6,
V_LINE_TO, 7,
R_H_LINE_TO, 1,
V_LINE_TO, 6,
H_LINE_TO, 6,
V_LINE_TO, 5,
R_H_LINE_TO, 4,
R_V_LINE_TO, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kEnterpriseRepList, kEnterpriseIcon, {kEnterprisePath}, {kEnterprise12Path})
VECTOR_ICON_REP_TEMPLATE(kExtensionAppPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 24, 14,
LINE_TO, 24, 10,
CUBIC_TO, 24, 9, 23, 8, 22, 8,
LINE_TO, 18, 8,
LINE_TO, 18, 6,
CUBIC_TO, 17.57, 4.28, 16.5, 3, 15, 3,
CUBIC_TO, 13.5, 3, 11.86, 4.28, 12, 6,
LINE_TO, 12, 8,
LINE_TO, 7, 8,
CUBIC_TO, 6, 8, 5, 9, 5, 10,
LINE_TO, 5, 14,
LINE_TO, 7, 14,
CUBIC_TO, 8.42, 14.2, 9.8, 15.58, 10, 17,
CUBIC_TO, 9.8, 18.99, 8.42, 20.37, 7, 20,
LINE_TO, 5, 20,
LINE_TO, 5, 25,
CUBIC_TO, 5, 25.97, 6.03, 27, 7, 27,
LINE_TO, 12, 27,
LINE_TO, 12, 25,
CUBIC_TO, 11.63, 23.58, 13.01, 22.2, 15, 22,
CUBIC_TO, 16.42, 22.2, 17.8, 23.58, 18, 25,
LINE_TO, 18, 27,
LINE_TO, 22, 27,
CUBIC_TO, 23, 27, 24, 26, 24, 25,
LINE_TO, 24, 20,
LINE_TO, 26, 20,
CUBIC_TO, 27.72, 20.14, 29, 18.5, 29, 17,
CUBIC_TO, 29, 15.5, 27.72, 14.43, 26, 14,
LINE_TO, 24, 14,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kExtensionApp16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 12.71, 6.71,
LINE_TO, 12.71, 4.43,
CUBIC_TO, 12.71, 3.8, 12.2, 3.29, 11.57, 3.29,
LINE_TO, 9.29, 3.29,
LINE_TO, 9.29, 2.43,
CUBIC_TO, 9.29, 1.64, 8.65, 1, 7.86, 1,
CUBIC_TO, 7.07, 1, 6.43, 1.64, 6.43, 2.43,
LINE_TO, 6.43, 3.29,
LINE_TO, 4.14, 3.29,
CUBIC_TO, 3.51, 3.29, 3.01, 3.8, 3.01, 4.43,
LINE_TO, 3.01, 6.6,
LINE_TO, 3.86, 6.6,
CUBIC_TO, 4.71, 6.6, 5.4, 7.29, 5.4, 8.14,
CUBIC_TO, 5.4, 8.99, 4.71, 9.69, 3.86, 9.69,
LINE_TO, 3, 9.69,
LINE_TO, 3, 11.86,
CUBIC_TO, 3, 12.49, 3.51, 13, 4.14, 13,
LINE_TO, 6.31, 13,
LINE_TO, 6.31, 12.14,
CUBIC_TO, 6.31, 11.29, 7.01, 10.6, 7.86, 10.6,
CUBIC_TO, 8.71, 10.6, 9.4, 11.29, 9.4, 12.14,
LINE_TO, 9.4, 13,
LINE_TO, 11.57, 13,
CUBIC_TO, 12.2, 13, 12.71, 12.49, 12.71, 11.86,
LINE_TO, 12.71, 9.57,
LINE_TO, 13.57, 9.57,
CUBIC_TO, 14.36, 9.57, 15, 8.93, 15, 8.14,
CUBIC_TO, 15, 7.35, 14.36, 6.71, 13.57, 6.71,
LINE_TO, 12.71, 6.71,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kExtensionAppRepList, kExtensionAppIcon, {kExtensionAppPath}, {kExtensionApp16Path})
VECTOR_ICON_REP_TEMPLATE(kFindInPageChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 12.33, 16.5,
R_LINE_TO, 1.5, 1.5,
H_LINE_TO, 5.5,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 4, 16.5,
R_V_LINE_TO, -13,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
ARC_TO, 1.44, 1.44, 0, 0, 1, 5.5, 2,
H_LINE_TO, 12,
R_LINE_TO, 4, 4,
R_V_LINE_TO, 9.92,
R_CUBIC_TO, 0, 0.5, -0.04, 0.88, -0.11, 1.13,
R_CUBIC_TO, -0.08, 0.25, -0.19, 0.43, -0.34, 0.54,
R_LINE_TO, -4.02, -4.02,
R_CUBIC_TO, -0.21, 0.14, -0.44, 0.24, -0.71, 0.3,
R_ARC_TO, 3.53, 3.53, 0, 0, 1, -0.81, 0.09,
R_CUBIC_TO, -0.83, 0, -1.54, -0.29, -2.12, -0.87,
ARC_TO, 2.89, 2.89, 0, 0, 1, 7, 10.96,
R_CUBIC_TO, 0, -0.83, 0.29, -1.54, 0.88, -2.12,
ARC_TO, 2.9, 2.9, 0, 0, 1, 10, 7.96,
R_CUBIC_TO, 0.83, 0, 1.54, 0.29, 2.13, 0.88,
R_CUBIC_TO, 0.58, 0.59, 0.88, 1.29, 0.88, 2.13,
R_CUBIC_TO, 0, 0.28, -0.04, 0.56, -0.1, 0.82,
R_CUBIC_TO, -0.07, 0.27, -0.17, 0.51, -0.31, 0.72,
R_LINE_TO, 1.92, 1.92,
V_LINE_TO, 6.63,
LINE_TO, 11.38, 3.5,
H_LINE_TO, 5.5,
R_V_LINE_TO, 13,
CLOSE,
R_MOVE_TO, -2.33, -4.04,
R_CUBIC_TO, 0.41, 0, 0.77, -0.14, 1.06, -0.44,
R_CUBIC_TO, 0.29, -0.29, 0.44, -0.65, 0.44, -1.06,
R_CUBIC_TO, 0, -0.41, -0.15, -0.76, -0.44, -1.06,
R_ARC_TO, 1.47, 1.47, 0, 0, 0, -1.06, -0.44,
R_CUBIC_TO, -0.41, 0, -0.77, 0.15, -1.06, 0.44,
R_ARC_TO, 1.46, 1.46, 0, 0, 0, -0.44, 1.06,
R_CUBIC_TO, 0, 0.41, 0.15, 0.77, 0.44, 1.06,
R_CUBIC_TO, 0.3, 0.29, 0.65, 0.44, 1.06, 0.44,
CLOSE,
MOVE_TO, 10, 10.75,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kFindInPageChromeRefreshRepList, kFindInPageChromeRefreshIcon, {kFindInPageChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kHttpPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 16.5, 3,
CUBIC_TO, 9.05, 3, 3, 9.05, 3, 16.5,
CUBIC_TO, 3, 23.95, 9.05, 30, 16.5, 30,
CUBIC_TO, 23.95, 30, 30, 23.95, 30, 16.5,
CUBIC_TO, 30, 9.05, 23.95, 3, 16.5, 3,
MOVE_TO, 6, 16.5,
CUBIC_TO, 6, 10.71, 10.71, 6, 16.5, 6,
CUBIC_TO, 22.29, 6, 27, 10.71, 27, 16.5,
CUBIC_TO, 27, 22.29, 22.29, 27, 16.5, 27,
CUBIC_TO, 10.71, 27, 6, 22.29, 6, 16.5,
MOVE_TO, 15, 23,
LINE_TO, 18, 23,
LINE_TO, 18, 15,
LINE_TO, 15, 15,
LINE_TO, 15, 23,
MOVE_TO, 15, 13,
LINE_TO, 18, 13,
LINE_TO, 18, 10,
LINE_TO, 15, 10,
LINE_TO, 15, 13,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kHttp20Path, CANVAS_DIMENSIONS, 20,
MOVE_TO, 10, 2,
R_CUBIC_TO, -4.42, 0, -8, 3.58, -8, 8,
R_CUBIC_TO, 0, 4.42, 3.58, 8, 8, 8,
R_CUBIC_TO, 4.42, 0, 8, -3.58, 8, -8,
R_CUBIC_TO, 0, -4.42, -3.58, -8, -8, -8,
CLOSE,
R_MOVE_TO, -6, 8,
R_CUBIC_TO, 0, -3.31, 2.69, -6, 6, -6,
R_CUBIC_TO, 3.31, 0, 6, 2.69, 6, 6,
R_CUBIC_TO, 0, 3.31, -2.69, 6, -6, 6,
R_CUBIC_TO, -3.31, 0, -6, -2.69, -6, -6,
CLOSE,
R_MOVE_TO, 7, 4,
V_LINE_TO, 9,
H_LINE_TO, 9,
R_V_LINE_TO, 5,
R_H_LINE_TO, 2,
CLOSE,
MOVE_TO, 9, 8,
R_H_LINE_TO, 2,
V_LINE_TO, 6,
H_LINE_TO, 9,
R_V_LINE_TO, 2,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kHttp16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8, 1,
CUBIC_TO, 4.14, 1, 1, 4.14, 1, 8,
CUBIC_TO, 1, 11.86, 4.14, 15, 8, 15,
CUBIC_TO, 11.86, 15, 15, 11.86, 15, 8,
CUBIC_TO, 15, 4.14, 11.86, 1, 8, 1,
MOVE_TO, 2.5, 8,
CUBIC_TO, 2.5, 4.97, 4.97, 2.5, 8, 2.5,
CUBIC_TO, 11.03, 2.5, 13.5, 4.97, 13.5, 8,
CUBIC_TO, 13.5, 11.03, 11.03, 13.5, 8, 13.5,
CUBIC_TO, 4.97, 13.5, 2.5, 11.03, 2.5, 8,
MOVE_TO, 9, 12,
LINE_TO, 9, 7,
LINE_TO, 7, 7,
LINE_TO, 7, 12,
LINE_TO, 9, 12,
MOVE_TO, 7, 6,
LINE_TO, 9, 6,
LINE_TO, 9, 4,
LINE_TO, 7, 4,
LINE_TO, 7, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHttpRepList, kHttpIcon, {kHttpPath}, {kHttp20Path}, {kHttp16Path})
VECTOR_ICON_REP_TEMPLATE(kHttpChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 7.34, 11.26,
R_H_LINE_TO, 1.32,
V_LINE_TO, 7.2,
H_LINE_TO, 7.34,
CLOSE,
R_MOVE_TO, 0.66, -5.18,
R_ARC_TO, 0.66, 0.66, 0, 0, 0, 0.48, -0.19,
R_ARC_TO, 0.66, 0.66, 0, 0, 0, 0.2, -0.48,
R_ARC_TO, 0.67, 0.67, 0, 0, 0, -0.2, -0.48,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, -0.48, -0.2,
R_ARC_TO, 0.66, 0.66, 0, 0, 0, -0.48, 0.2,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, -0.2, 0.48,
R_CUBIC_TO, 0, 0.2, 0.07, 0.36, 0.2, 0.49,
R_ARC_TO, 0.64, 0.64, 0, 0, 0, 0.48, 0.2,
CLOSE,
R_MOVE_TO, 0.01, 8.46,
R_CUBIC_TO, -0.9, 0, -1.75, -0.17, -2.54, -0.51,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -2.08, -1.4,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -1.4, -2.08,
R_ARC_TO, 6.33, 6.33, 0, 0, 1, -0.51, -2.55,
R_CUBIC_TO, 0, -0.91, 0.17, -1.75, 0.51, -2.54,
ARC_TO, 6.53, 6.53, 0, 0, 1, 3.38, 3.38,
ARC_TO, 6.52, 6.52, 0, 0, 1, 5.46, 1.98,
R_ARC_TO, 6.33, 6.33, 0, 0, 1, 2.55, -0.51,
R_CUBIC_TO, 0.91, 0, 1.75, 0.17, 2.54, 0.51,
R_CUBIC_TO, 0.79, 0.34, 1.48, 0.8, 2.07, 1.4,
R_ARC_TO, 6.5, 6.5, 0, 0, 1, 1.4, 2.08,
R_ARC_TO, 6.29, 6.29, 0, 0, 1, 0.51, 2.54,
R_CUBIC_TO, 0, 0.9, -0.17, 1.75, -0.51, 2.54,
R_ARC_TO, 6.52, 6.52, 0, 0, 1, -1.4, 2.08,
R_ARC_TO, 6.5, 6.5, 0, 0, 1, -2.08, 1.4,
R_ARC_TO, 6.29, 6.29, 0, 0, 1, -2.54, 0.51,
CLOSE,
MOVE_TO, 8, 13.15,
R_CUBIC_TO, 1.43, 0, 2.65, -0.5, 3.65, -1.5,
R_CUBIC_TO, 1, -1, 1.5, -2.22, 1.5, -3.65,
R_CUBIC_TO, 0, -1.43, -0.5, -2.65, -1.5, -3.65,
CUBIC_TO_SHORTHAND, 9.43, 2.85, 8, 2.85,
R_CUBIC_TO, -1.43, 0, -2.65, 0.5, -3.65, 1.5,
CUBIC_TO_SHORTHAND, 2.85, 6.57, 2.85, 8,
R_CUBIC_TO, 0, 1.43, 0.5, 2.65, 1.5, 3.65,
R_CUBIC_TO, 1, 1, 2.22, 1.5, 3.65, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kHttpChromeRefreshRepList, kHttpChromeRefreshIcon, {kHttpChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kIncognitoCr2023Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 5.16, 12.83,
R_ARC_TO, 1.95, 1.95, 0, 0, 1, -1.44, -0.59,
R_ARC_TO, 1.96, 1.96, 0, 0, 1, -0.59, -1.44,
R_CUBIC_TO, 0, -0.57, 0.2, -1.05, 0.59, -1.44,
R_CUBIC_TO, 0.39, -0.39, 0.87, -0.59, 1.44, -0.59,
R_CUBIC_TO, 0.42, 0, 0.8, 0.12, 1.14, 0.36,
R_CUBIC_TO, 0.34, 0.24, 0.59, 0.55, 0.75, 0.93,
R_ARC_TO, 2.38, 2.38, 0, 0, 1, 0.91, -0.18,
R_ARC_TO, 2.43, 2.43, 0, 0, 1, 0.92, 0.18,
R_ARC_TO, 2.1, 2.1, 0, 0, 1, 0.74, -0.93,
R_CUBIC_TO, 0.34, -0.24, 0.72, -0.36, 1.14, -0.36,
R_CUBIC_TO, 0.57, 0, 1.04, 0.2, 1.44, 0.59,
R_CUBIC_TO, 0.4, 0.4, 0.59, 0.88, 0.59, 1.44,
R_CUBIC_TO, 0, 0.57, -0.2, 1.05, -0.59, 1.44,
R_CUBIC_TO, -0.39, 0.4, -0.87, 0.59, -1.44, 0.59,
R_CUBIC_TO, -0.43, 0, -0.82, -0.12, -1.16, -0.36,
R_ARC_TO, 1.89, 1.89, 0, 0, 1, -0.73, -0.95,
R_ARC_TO, 1.25, 1.25, 0, 0, 0, -1.41, -0.28,
R_CUBIC_TO, -0.16, 0.07, -0.29, 0.16, -0.41, 0.28,
R_CUBIC_TO, -0.14, 0.39, -0.38, 0.71, -0.73, 0.95,
R_ARC_TO, 2, 2, 0, 0, 1, -1.16, 0.36,
CLOSE,
R_MOVE_TO, 0, -1.27,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.54, -0.22,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.23, -0.54,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, -0.23, -0.54,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.54, -0.23,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.54, 0.23,
R_ARC_TO, 0.75, 0.75, 0, 0, 0, -0.23, 0.54,
R_CUBIC_TO, 0, 0.21, 0.08, 0.39, 0.23, 0.54,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.54, 0.22,
CLOSE,
R_MOVE_TO, 5.6, 0,
R_ARC_TO, 0.75, 0.75, 0, 0, 0, 0.54, -0.22,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.23, -0.54,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.23, -0.54,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, -0.54, -0.23,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.54, 0.23,
R_ARC_TO, 0.73, 0.73, 0, 0, 0, -0.23, 0.54,
R_CUBIC_TO, 0, 0.21, 0.08, 0.39, 0.23, 0.54,
R_ARC_TO, 0.74, 0.74, 0, 0, 0, 0.54, 0.22,
CLOSE,
MOVE_TO, 2.3, 8,
V_LINE_TO, 6.68,
R_H_LINE_TO, 2.04,
LINE_TO, 5.59, 2.78,
R_ARC_TO, 1.04, 1.04, 0, 0, 1, 0.45, -0.52,
R_CUBIC_TO, 0.2, -0.11, 0.42, -0.14, 0.68, -0.08,
R_LINE_TO, 1.25, 0.33,
R_LINE_TO, 1.25, -0.33,
R_ARC_TO, 0.91, 0.91, 0, 0, 1, 0.67, 0.08,
R_CUBIC_TO, 0.2, 0.11, 0.35, 0.28, 0.45, 0.52,
R_LINE_TO, 1.26, 3.9,
R_H_LINE_TO, 2.12,
V_LINE_TO, 8,
CLOSE,
R_MOVE_TO, 3.5, -1.32,
R_H_LINE_TO, 4.33,
R_LINE_TO, -0.99, -3.05,
R_LINE_TO, -1.18, 0.31,
R_LINE_TO, -1.18, -0.31,
CLOSE,
R_MOVE_TO, 2.18, -0.07,
/*
Skiafy incorrectly produces a 2-arg call to R_H_LINE_TO:
R_H_LINE_TO, 2.19, -4.39,
The following two lines are the correctecd commmands:
*/
R_H_LINE_TO, 2.19,
R_H_LINE_TO, -4.39,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kIncognitoCr2023RepList, kIncognitoCr2023Icon, {kIncognitoCr2023Path})
VECTOR_ICON_REP_TEMPLATE(kInstallDesktopPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 6.42, 2,
R_V_LINE_TO, 1.2,
H_LINE_TO, 2.19,
R_V_LINE_TO, 8.44,
R_H_LINE_TO, 11.61,
V_LINE_TO, 9.58,
H_LINE_TO, 14.99,
R_V_LINE_TO, 1.81,
R_ARC_TO, 1.45, 1.45, 0, 0, 1, -1.31, 1.44,
R_LINE_TO, -0.14, 0.01,
H_LINE_TO, 11.74,
R_LINE_TO, 0.65, 0.72,
V_LINE_TO, 15,
H_LINE_TO, 3.6,
R_V_LINE_TO, -1.44,
R_LINE_TO, 0.65, -0.72,
H_LINE_TO, 2.44,
R_ARC_TO, 1.44, 1.44, 0, 0, 1, -1.44, -1.31,
LINE_TO, 1, 11.39,
V_LINE_TO, 3.44,
R_CUBIC_TO, 0, -0.75, 0.57, -1.37, 1.31, -1.44,
LINE_TO, 2.44, 2,
R_H_LINE_TO, 3.97,
CLOSE,
MOVE_TO, 11.2, 2,
R_V_LINE_TO, 5.1,
R_LINE_TO, 1.75, -1.81,
LINE_TO, 14, 6.37,
LINE_TO, 10.5, 10,
LINE_TO, 7, 6.37,
R_LINE_TO, 1.05, -1.09,
LINE_TO, 9.8, 7.1,
V_LINE_TO, 2,
R_H_LINE_TO, 1.4,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kInstallDesktopRepList, kInstallDesktopIcon, {kInstallDesktopPath})
VECTOR_ICON_REP_TEMPLATE(kJourneysPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19, 21,
R_QUADRATIC_TO, -0.97, 0, -1.75, -0.56,
R_QUADRATIC_TO, -0.77, -0.56, -1.07, -1.44,
H_LINE_TO, 11,
R_QUADRATIC_TO, -1.65, 0, -2.82, -1.17,
QUADRATIC_TO, 7, 16.65, 7, 15,
R_QUADRATIC_TO, 0, -1.65, 1.18, -2.82,
QUADRATIC_TO, 9.35, 11, 11, 11,
R_H_LINE_TO, 2,
R_QUADRATIC_TO, 0.83, 0, 1.41, -0.59,
QUADRATIC_TO, 15, 9.82, 15, 9,
R_QUADRATIC_TO, 0, -0.82, -0.59, -1.41,
QUADRATIC_TO, 13.83, 7, 13, 7,
H_LINE_TO, 7.83,
R_QUADRATIC_TO, -0.32, 0.88, -1.09, 1.44,
QUADRATIC_TO, 5.98, 9, 5, 9,
R_QUADRATIC_TO, -1.25, 0, -2.12, -0.87,
QUADRATIC_TO_SHORTHAND, 2, 6,
R_QUADRATIC_TO, 0, -1.25, 0.88, -2.12,
QUADRATIC_TO_SHORTHAND, 5, 3,
R_QUADRATIC_TO, 0.98, 0, 1.74, 0.56,
QUADRATIC_TO, 7.5, 4.13, 7.83, 5,
H_LINE_TO, 13,
R_QUADRATIC_TO, 1.65, 0, 2.83, 1.18,
QUADRATIC_TO, 17, 7.35, 17, 9,
R_QUADRATIC_TO, 0, 1.65, -1.17, 2.83,
QUADRATIC_TO, 14.65, 13, 13, 13,
R_H_LINE_TO, -2,
R_QUADRATIC_TO, -0.82, 0, -1.41, 0.59,
QUADRATIC_TO, 9, 14.18, 9, 15,
R_QUADRATIC_TO, 0, 0.83, 0.59, 1.41,
QUADRATIC_TO, 10.18, 17, 11, 17,
R_H_LINE_TO, 5.18,
R_QUADRATIC_TO, 0.33, -0.87, 1.09, -1.44,
QUADRATIC_TO, 18.02, 15, 19, 15,
R_QUADRATIC_TO, 1.25, 0, 2.13, 0.88,
QUADRATIC_TO_SHORTHAND, 22, 18,
R_QUADRATIC_TO, 0, 1.25, -0.87, 2.13,
QUADRATIC_TO_SHORTHAND, 19, 21,
CLOSE,
MOVE_TO, 5, 7,
R_QUADRATIC_TO, 0.43, 0, 0.71, -0.29,
QUADRATIC_TO, 6, 6.43, 6, 6,
R_QUADRATIC_TO, 0, -0.43, -0.29, -0.71,
QUADRATIC_TO, 5.43, 5, 5, 5,
R_QUADRATIC_TO, -0.43, 0, -0.71, 0.29,
QUADRATIC_TO, 4, 5.58, 4, 6,
R_QUADRATIC_TO, 0, 0.42, 0.29, 0.71,
QUADRATIC_TO, 4.58, 7, 5, 7,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kJourneysRepList, kJourneysIcon, {kJourneysPath})
VECTOR_ICON_REP_TEMPLATE(kJourneysChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 12.4, 13.72,
R_CUBIC_TO, -0.49, 0, -0.92, -0.14, -1.28, -0.43,
R_CUBIC_TO, -0.36, -0.29, -0.6, -0.64, -0.73, -1.06,
H_LINE_TO, 6.6,
R_ARC_TO, 2.15, 2.15, 0, 0, 1, -1.58, -0.65,
R_ARC_TO, 2.17, 2.17, 0, 0, 1, -0.65, -1.59,
R_CUBIC_TO, 0, -0.62, 0.22, -1.14, 0.65, -1.58,
R_CUBIC_TO, 0.43, -0.43, 0.96, -0.65, 1.58, -0.65,
R_H_LINE_TO, 2,
R_CUBIC_TO, 0.38, 0, 0.7, -0.14, 0.96, -0.41,
R_CUBIC_TO, 0.27, -0.26, 0.4, -0.59, 0.4, -0.97,
R_ARC_TO, 1.3, 1.3, 0, 0, 0, -0.4, -0.96,
R_ARC_TO, 1.33, 1.33, 0, 0, 0, -0.96, -0.4,
R_H_LINE_TO, -2.98,
R_ARC_TO, 2.09, 2.09, 0, 0, 1, -0.73, 1.06,
R_CUBIC_TO, -0.36, 0.29, -0.79, 0.43, -1.28, 0.43,
R_ARC_TO, 2.04, 2.04, 0, 0, 1, -1.5, -0.62,
R_ARC_TO, 2.04, 2.04, 0, 0, 1, -0.62, -1.5,
R_CUBIC_TO, 0, -0.59, 0.21, -1.09, 0.62, -1.5,
R_CUBIC_TO, 0.41, -0.41, 0.92, -0.62, 1.51, -0.62,
R_CUBIC_TO, 0.49, 0, 0.92, 0.14, 1.29, 0.43,
R_CUBIC_TO, 0.36, 0.29, 0.61, 0.64, 0.73, 1.06,
R_H_LINE_TO, 2.98,
R_CUBIC_TO, 0.73, 0, 1.35, 0.25, 1.86, 0.77,
R_CUBIC_TO, 0.51, 0.52, 0.77, 1.13, 0.77, 1.86,
R_CUBIC_TO, 0, 0.74, -0.25, 1.36, -0.76, 1.87,
R_ARC_TO, 2.54, 2.54, 0, 0, 1, -1.86, 0.77,
R_H_LINE_TO, -2,
R_ARC_TO, 0.93, 0.93, 0, 0, 0, -0.68, 0.28,
R_ARC_TO, 0.93, 0.93, 0, 0, 0, -0.28, 0.68,
R_CUBIC_TO, 0, 0.27, 0.09, 0.5, 0.28, 0.68,
R_ARC_TO, 0.93, 0.93, 0, 0, 0, 0.68, 0.28,
R_H_LINE_TO, 3.78,
R_CUBIC_TO, 0.13, -0.42, 0.37, -0.77, 0.73, -1.06,
R_CUBIC_TO, 0.36, -0.29, 0.79, -0.43, 1.29, -0.43,
R_CUBIC_TO, 0.59, 0, 1.09, 0.21, 1.5, 0.62,
R_CUBIC_TO, 0.41, 0.41, 0.62, 0.92, 0.62, 1.51,
R_CUBIC_TO, 0, 0.59, -0.21, 1.09, -0.62, 1.5,
R_CUBIC_TO, -0.41, 0.41, -0.91, 0.62, -1.5, 0.62,
CLOSE,
MOVE_TO, 3.6, 5.2,
R_ARC_TO, 0.77, 0.77, 0, 0, 0, 0.57, -0.23,
R_ARC_TO, 0.77, 0.77, 0, 0, 0, 0.23, -0.57,
R_ARC_TO, 0.78, 0.78, 0, 0, 0, -0.23, -0.57,
R_ARC_TO, 0.78, 0.78, 0, 0, 0, -0.57, -0.23,
R_ARC_TO, 0.77, 0.77, 0, 0, 0, -0.57, 0.23,
R_ARC_TO, 0.77, 0.77, 0, 0, 0, -0.23, 0.57,
R_CUBIC_TO, 0, 0.23, 0.07, 0.42, 0.23, 0.57,
R_CUBIC_TO, 0.15, 0.16, 0.34, 0.23, 0.57, 0.23,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kJourneysChromeRefreshRepList, kJourneysChromeRefreshIcon, {kJourneysChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kOfflinePinPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 2,
CUBIC_TO, 6.5, 2, 2, 6.5, 2, 12,
R_CUBIC_TO, 0, 5.5, 4.5, 10, 10, 10,
R_CUBIC_TO, 5.5, 0, 10, -4.5, 10, -10,
R_CUBIC_TO, 0, -5.5, -4.5, -10, -10, -10,
CLOSE,
R_MOVE_TO, 5, 16,
H_LINE_TO, 7,
R_V_LINE_TO, -2,
R_H_LINE_TO, 10,
R_V_LINE_TO, 2,
CLOSE,
R_MOVE_TO, -6.7, -4,
LINE_TO, 7, 10.7,
R_LINE_TO, 1.4, -1.4,
R_LINE_TO, 1.9, 1.9,
R_LINE_TO, 5.3, -5.3,
LINE_TO, 17, 7.3,
LINE_TO, 10.3, 14,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kOfflinePinRepList, kOfflinePinIcon, {kOfflinePinPath})
VECTOR_ICON_REP_TEMPLATE(kPageChromeRefreshPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 8.01, 14.54,
R_ARC_TO, 6.38, 6.38, 0, 0, 1, -2.54, -0.51,
R_ARC_TO, 6.59, 6.59, 0, 0, 1, -2.08, -1.41,
R_ARC_TO, 6.66, 6.66, 0, 0, 1, -1.41, -2.09,
R_ARC_TO, 6.39, 6.39, 0, 0, 1, -0.51, -2.54,
R_CUBIC_TO, 0, -0.9, 0.17, -1.75, 0.51, -2.53,
R_ARC_TO, 6.59, 6.59, 0, 0, 1, 3.49, -3.48,
R_ARC_TO, 6.39, 6.39, 0, 0, 1, 2.54, -0.51,
R_CUBIC_TO, 0.9, 0, 1.75, 0.17, 2.54, 0.51,
R_ARC_TO, 6.63, 6.63, 0, 0, 1, 3.48, 3.49,
R_CUBIC_TO, 0.34, 0.79, 0.51, 1.64, 0.51, 2.54,
R_ARC_TO, 6.38, 6.38, 0, 0, 1, -0.51, 2.54,
R_ARC_TO, 6.59, 6.59, 0, 0, 1, -3.49, 3.49,
R_CUBIC_TO, -0.79, 0.34, -1.63, 0.51, -2.53, 0.51,
CLOSE,
R_MOVE_TO, -0.8, -1.45,
R_V_LINE_TO, -1.13,
R_ARC_TO, 0.76, 0.76, 0, 0, 1, -0.56, -0.23,
R_ARC_TO, 0.77, 0.77, 0, 0, 1, -0.23, -0.56,
R_V_LINE_TO, -0.79,
R_LINE_TO, -3.45, -3.45,
R_ARC_TO, 6.23, 6.23, 0, 0, 0, -0.09, 0.57,
R_ARC_TO, 5.58, 5.58, 0, 0, 0, -0.02, 0.49,
R_CUBIC_TO, 0, 1.27, 0.41, 2.39, 1.23, 3.36,
R_CUBIC_TO, 0.82, 0.97, 1.86, 1.55, 3.13, 1.73,
CLOSE,
R_MOVE_TO, 4.76, -1.8,
R_CUBIC_TO, 0.2, -0.23, 0.37, -0.47, 0.52, -0.73,
R_CUBIC_TO, 0.14, -0.25, 0.27, -0.52, 0.37, -0.8,
R_ARC_TO, 5.32, 5.32, 0, 0, 0, 0.3, -1.77,
R_CUBIC_TO, 0, -1.04, -0.28, -1.99, -0.85, -2.85,
R_ARC_TO, 5.05, 5.05, 0, 0, 0, -2.31, -1.9,
R_V_LINE_TO, 0.4,
R_CUBIC_TO, 0, 0.32, -0.12, 0.61, -0.35, 0.84,
R_CUBIC_TO, -0.23, 0.23, -0.52, 0.35, -0.84, 0.35,
H_LINE_TO, 7.21,
R_V_LINE_TO, 0.79,
R_ARC_TO, 0.77, 0.77, 0, 0, 1, -0.23, 0.57,
R_ARC_TO, 0.77, 0.77, 0, 0, 1, -0.57, 0.23,
R_H_LINE_TO, -0.78,
R_V_LINE_TO, 1.59,
H_LINE_TO, 9.59,
R_CUBIC_TO, 0.23, 0, 0.41, 0.08, 0.57, 0.23,
R_CUBIC_TO, 0.16, 0.15, 0.23, 0.34, 0.23, 0.57,
R_V_LINE_TO, 1.58,
R_H_LINE_TO, 0.67,
R_ARC_TO, 0.87, 0.87, 0, 0, 1, 0.65, 0.27,
R_CUBIC_TO, 0.18, 0.18, 0.26, 0.39, 0.26, 0.65,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPageChromeRefreshRepList, kPageChromeRefreshIcon, {kPageChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kPriceTrackingDisabledPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 16, 14,
R_V_LINE_TO, 3,
H_LINE_TO, 8,
R_V_LINE_TO, -7,
R_CUBIC_TO, 0, -2.21, 1.79, -4, 4, -4,
R_CUBIC_TO, 0.85, 0, 1.64, 0.26, 2.28, 0.72,
R_LINE_TO, 1.43, -1.43,
R_CUBIC_TO, -0.64, -0.51, -1.39, -0.88, -2.21, -1.09,
V_LINE_TO, 3.5,
CUBIC_TO, 13.5, 2.67, 12.83, 2, 12, 2,
R_CUBIC_TO, -0.83, 0, -1.5, 0.67, -1.5, 1.5,
R_V_LINE_TO, 0.7,
CUBIC_TO, 7.91, 4.86, 6, 7.21, 6, 10,
R_V_LINE_TO, 7,
H_LINE_TO, 4,
R_V_LINE_TO, 2,
R_H_LINE_TO, 16,
R_V_LINE_TO, -2,
R_H_LINE_TO, -2,
R_V_LINE_TO, -3,
H_LINE_TO, 16,
CLOSE,
MOVE_TO, 12, 22,
R_CUBIC_TO, 1.1, 0, 2, -0.9, 2, -2,
R_H_LINE_TO, -4,
CUBIC_TO, 10, 21.1, 10.9, 22, 12, 22,
CLOSE,
MOVE_TO, 24, 8,
R_H_LINE_TO, -3,
V_LINE_TO, 5,
R_H_LINE_TO, -2,
R_V_LINE_TO, 3,
R_H_LINE_TO, -3,
R_V_LINE_TO, 2,
R_H_LINE_TO, 3,
R_V_LINE_TO, 3,
R_H_LINE_TO, 2,
R_V_LINE_TO, -3,
R_H_LINE_TO, 3,
V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPriceTrackingDisabledRepList, kPriceTrackingDisabledIcon, {kPriceTrackingDisabledPath})
VECTOR_ICON_REP_TEMPLATE(kPriceTrackingDisabledRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 10, 9.75,
CLOSE,
MOVE_TO, 10, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 16.5,
R_H_LINE_TO, 3,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 10, 18,
CLOSE,
R_MOVE_TO, 5.25, -7,
V_LINE_TO, 8.69,
H_LINE_TO, 13,
V_LINE_TO, 7.31,
R_H_LINE_TO, 2.25,
V_LINE_TO, 5,
R_H_LINE_TO, 1.5,
R_V_LINE_TO, 2.31,
H_LINE_TO, 19,
R_V_LINE_TO, 1.38,
R_H_LINE_TO, -2.25,
V_LINE_TO, 11,
CLOSE,
MOVE_TO, 4, 15.5,
V_LINE_TO, 14,
R_H_LINE_TO, 1,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -1.21, 0.37, -2.27, 1.11, -3.19,
CUBIC_TO, 6.86, 4.9, 7.82, 4.33, 9, 4.11,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 10, 2,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.2, 0.19, 0.29, 0.43, 0.29, 0.71,
R_V_LINE_TO, 1.11,
R_CUBIC_TO, 0.32, 0.07, 0.63, 0.16, 0.93, 0.28,
R_CUBIC_TO, 0.3, 0.12, 0.59, 0.27, 0.87, 0.45,
R_ARC_TO, 4.17, 4.17, 0, 0, 0, -0.85, 1.25,
R_ARC_TO, 3.78, 3.78, 0, 0, 0, -0.91, -0.43,
ARC_TO, 3.35, 3.35, 0, 0, 0, 10, 5.5,
R_CUBIC_TO, -0.97, 0, -1.8, 0.34, -2.48, 1.02,
CUBIC_TO, 6.84, 7.2, 6.5, 8.03, 6.5, 9,
R_V_LINE_TO, 5,
R_H_LINE_TO, 7,
R_V_LINE_TO, -2.25,
R_CUBIC_TO, 0.23, 0.15, 0.48, 0.28, 0.72, 0.39,
R_CUBIC_TO, 0.24, 0.1, 0.5, 0.19, 0.78, 0.26,
V_LINE_TO, 14,
R_H_LINE_TO, 1,
R_V_LINE_TO, 1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPriceTrackingDisabledRefreshRepList, kPriceTrackingDisabledRefreshIcon, {kPriceTrackingDisabledRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kPriceTrackingEnabledRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 2, 9,
R_CUBIC_TO, 0, -1.23, 0.25, -2.35, 0.74, -3.38,
R_ARC_TO, 8.17, 8.17, 0, 0, 1, 2.06, -2.66,
LINE_TO, 5.86, 4,
R_ARC_TO, 6.48, 6.48, 0, 0, 0, -1.72, 2.2,
ARC_TO, 6.27, 6.27, 0, 0, 0, 3.5, 9,
CLOSE,
R_MOVE_TO, 14.5, 0,
R_CUBIC_TO, 0, -1.02, -0.21, -1.95, -0.64, -2.82,
R_ARC_TO, 6.42, 6.42, 0, 0, 0, -1.74, -2.2,
R_LINE_TO, 1.08, -1.06,
R_ARC_TO, 7.99, 7.99, 0, 0, 1, 2.04, 2.68,
CUBIC_TO, 17.75, 6.64, 18, 7.78, 18, 9,
CLOSE,
MOVE_TO, 4, 15.5,
V_LINE_TO, 14,
R_H_LINE_TO, 1,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -1.21, 0.37, -2.27, 1.11, -3.19,
CUBIC_TO, 6.86, 4.9, 7.82, 4.33, 9, 4.11,
V_LINE_TO, 3,
R_CUBIC_TO, 0, -0.28, 0.1, -0.52, 0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 1, 10, 2,
R_CUBIC_TO, 0.28, 0, 0.52, 0.1, 0.71, 0.29,
R_CUBIC_TO, 0.2, 0.19, 0.29, 0.43, 0.29, 0.71,
R_V_LINE_TO, 1.11,
R_CUBIC_TO, 1.18, 0.22, 2.14, 0.79, 2.89, 1.71,
CUBIC_TO, 14.63, 6.73, 15, 7.79, 15, 9,
R_V_LINE_TO, 5,
R_H_LINE_TO, 1,
R_V_LINE_TO, 1.5,
CLOSE,
R_MOVE_TO, 6, -5.75,
CLOSE,
MOVE_TO, 10, 18,
R_CUBIC_TO, -0.41, 0, -0.77, -0.15, -1.06, -0.44,
ARC_TO, 1.44, 1.44, 0, 0, 1, 8.5, 16.5,
R_H_LINE_TO, 3,
R_CUBIC_TO, 0, 0.42, -0.15, 0.77, -0.44, 1.06,
ARC_TO, 1.45, 1.45, 0, 0, 1, 10, 18,
CLOSE,
MOVE_TO, 6.5, 14,
R_H_LINE_TO, 7,
V_LINE_TO, 9,
R_CUBIC_TO, 0, -0.97, -0.34, -1.8, -1.02, -2.48,
R_CUBIC_TO, -0.68, -0.68, -1.51, -1.02, -2.48, -1.02,
R_CUBIC_TO, -0.97, 0, -1.8, 0.34, -2.48, 1.02,
CUBIC_TO, 6.84, 7.2, 6.5, 8.03, 6.5, 9,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kPriceTrackingEnabledRefreshRepList, kPriceTrackingEnabledRefreshIcon, {kPriceTrackingEnabledRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kProductPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 8.82, 14.1,
CUBIC_TO, 9.25, 12.52, 10.18, 11.12, 11.48, 10.13,
CUBIC_TO, 12.77, 9.13, 14.36, 8.59, 16, 8.59,
H_LINE_TO, 27.85,
CUBIC_TO, 26.65, 6.68, 25.02, 5.09, 23.08, 3.95,
CUBIC_TO, 21.14, 2.81, 18.96, 2.16, 16.71, 2.04,
CUBIC_TO, 14.47, 1.93, 12.23, 2.36, 10.18, 3.3,
CUBIC_TO, 8.14, 4.23, 6.35, 5.65, 4.97, 7.43,
LINE_TO, 8.82, 14.1,
CLOSE,
NEW_PATH,
MOVE_TO, 17.92, 23.2,
CUBIC_TO, 16.34, 23.63, 14.66, 23.53, 13.15, 22.9,
CUBIC_TO, 11.64, 22.28, 10.38, 21.16, 9.56, 19.74,
LINE_TO, 9.56, 19.75,
LINE_TO, 3.63, 9.48,
CUBIC_TO, 2.58, 11.47, 2.02, 13.68, 2, 15.93,
CUBIC_TO, 1.98, 18.18, 2.51, 20.4, 3.54, 22.4,
CUBIC_TO, 4.56, 24.4, 6.05, 26.13, 7.89, 27.43,
CUBIC_TO, 9.72, 28.73, 11.84, 29.57, 14.07, 29.88,
LINE_TO, 17.92, 23.2,
CLOSE,
NEW_PATH,
MOVE_TO, 21.27, 10.78,
CUBIC_TO, 22.42, 11.93, 23.16, 13.44, 23.38, 15.06,
CUBIC_TO, 23.59, 16.68, 23.26, 18.33, 22.44, 19.74,
LINE_TO, 22.44, 19.75,
LINE_TO, 16.52, 30,
CUBIC_TO, 18.77, 29.92, 20.97, 29.3, 22.92, 28.19,
CUBIC_TO, 24.88, 27.08, 26.53, 25.52, 27.76, 23.63,
CUBIC_TO, 28.98, 21.74, 29.73, 19.59, 29.94, 17.35,
CUBIC_TO, 30.15, 15.11, 29.82, 12.86, 28.97, 10.78,
H_LINE_TO, 21.27,
CLOSE,
NEW_PATH,
MOVE_TO, 16, 21.28,
CUBIC_TO, 18.9, 21.28, 21.25, 18.93, 21.25, 16.03,
CUBIC_TO, 21.25, 13.13, 18.9, 10.78, 16, 10.78,
CUBIC_TO, 13.1, 10.78, 10.75, 13.13, 10.75, 16.03,
CUBIC_TO, 10.75, 18.93, 13.1, 21.28, 16, 21.28,
CLOSE,
NEW_PATH)
VECTOR_ICON_REP_TEMPLATE(kProduct16Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 10.93, 5.38,
CUBIC_TO, 11.49, 5.99, 11.83, 6.77, 11.92, 7.59,
CUBIC_TO, 12, 8.42, 11.82, 9.25, 11.41, 9.97,
H_LINE_TO, 11.41,
LINE_TO, 8.52, 14.98,
CUBIC_TO, 9.62, 14.9, 10.68, 14.56, 11.62, 13.99,
CUBIC_TO, 12.57, 13.42, 13.36, 12.63, 13.94, 11.7,
CUBIC_TO, 14.53, 10.76, 14.88, 9.7, 14.97, 8.6,
CUBIC_TO, 15.07, 7.5, 14.9, 6.4, 14.49, 5.38,
H_LINE_TO, 10.93,
CLOSE,
NEW_PATH,
MOVE_TO, 4.26, 6.77,
CUBIC_TO, 4.52, 5.98, 5.02, 5.3, 5.69, 4.81,
CUBIC_TO, 6.36, 4.32, 7.17, 4.06, 8, 4.06,
H_LINE_TO, 13.79,
CUBIC_TO, 13.17, 3.15, 12.34, 2.4, 11.37, 1.87,
CUBIC_TO, 10.41, 1.34, 9.33, 1.04, 8.23, 1,
CUBIC_TO, 7.13, 0.97, 6.03, 1.19, 5.03, 1.66,
CUBIC_TO, 4.04, 2.13, 3.16, 2.82, 2.48, 3.69,
LINE_TO, 4.26, 6.77,
CLOSE,
NEW_PATH,
MOVE_TO, 8.81, 11.85,
CUBIC_TO, 7.99, 12.02, 7.15, 11.93, 6.39, 11.59,
CUBIC_TO, 5.64, 11.26, 5.01, 10.69, 4.59, 9.97,
V_LINE_TO, 9.97,
LINE_TO, 1.7, 4.96,
CUBIC_TO, 1.22, 5.95, 0.98, 7.04, 1, 8.14,
CUBIC_TO, 1.02, 9.25, 1.31, 10.33, 1.83, 11.3,
CUBIC_TO, 2.35, 12.27, 3.09, 13.11, 3.99, 13.74,
CUBIC_TO, 4.9, 14.37, 5.94, 14.78, 7.03, 14.93,
LINE_TO, 8.81, 11.85,
CLOSE,
NEW_PATH,
MOVE_TO, 8, 10.63,
CUBIC_TO, 9.45, 10.63, 10.63, 9.45, 10.63, 8,
CUBIC_TO, 10.63, 6.55, 9.45, 5.38, 8, 5.38,
CUBIC_TO, 6.55, 5.38, 5.38, 6.55, 5.38, 8,
CUBIC_TO, 5.38, 9.45, 6.55, 10.63, 8, 10.63,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kProductRepList, kProductIcon, {kProductPath}, {kProduct16Path})
VECTOR_ICON_REP_TEMPLATE(kProductChromeRefreshPath, CANVAS_DIMENSIONS, 15,
MOVE_TO, 4.92, 7.5,
R_CUBIC_TO, 0, 0.71, 0.25, 1.31, 0.76, 1.82,
R_CUBIC_TO, 0.51, 0.51, 1.12, 0.76, 1.82, 0.76,
R_CUBIC_TO, 0.7, 0, 1.31, -0.25, 1.82, -0.76,
R_CUBIC_TO, 0.51, -0.51, 0.76, -1.12, 0.76, -1.82,
R_CUBIC_TO, 0, -0.7, -0.25, -1.31, -0.76, -1.82,
R_ARC_TO, 2.49, 2.49, 0, 0, 0, -1.82, -0.76,
R_CUBIC_TO, -0.7, 0, -1.31, 0.25, -1.82, 0.76,
R_ARC_TO, 2.49, 2.49, 0, 0, 0, -0.76, 1.82,
CLOSE,
MOVE_TO, 7.5, 11.48,
R_CUBIC_TO, 0.14, 0, 0.28, 0, 0.41, -0.02,
R_CUBIC_TO, 0.13, -0.01, 0.26, -0.04, 0.39, -0.07,
LINE_TO, 6.77, 14.06,
R_CUBIC_TO, -1.65, -0.19, -3.04, -0.89, -4.15, -2.12,
CUBIC_TO, 1.5, 10.71, 0.94, 9.24, 0.94, 7.55,
R_CUBIC_TO, 0, -0.46, 0.05, -0.9, 0.13, -1.33,
R_CUBIC_TO, 0.08, -0.44, 0.22, -0.85, 0.39, -1.25,
R_LINE_TO, 2.63, 4.55,
R_CUBIC_TO, 0.34, 0.59, 0.81, 1.07, 1.41, 1.43,
R_CUBIC_TO, 0.6, 0.36, 1.26, 0.54, 2.01, 0.54,
CLOSE,
R_MOVE_TO, 0, -7.87,
R_CUBIC_TO, -0.87, 0, -1.65, 0.25, -2.33, 0.77,
R_ARC_TO, 3.95, 3.95, 0, 0, 0, -1.42, 1.94,
LINE_TO, 2.21, 3.66,
R_ARC_TO, 6.79, 6.79, 0, 0, 1, 2.27, -1.94,
CUBIC_TO, 5.4, 1.22, 6.4, 0.98, 7.5, 0.98,
R_CUBIC_TO, 1.1, 0, 2.08, 0.24, 2.99, 0.72,
ARC_TO, 6.66, 6.66, 0, 0, 1, 12.76, 3.6,
H_LINE_TO, 7.51,
R_LINE_TO, -0.01, 0.01,
CLOSE,
R_MOVE_TO, 6.01, 1.31,
R_CUBIC_TO, 0.19, 0.4, 0.32, 0.83, 0.41, 1.27,
R_CUBIC_TO, 0.09, 0.44, 0.15, 0.89, 0.15, 1.36,
R_CUBIC_TO, 0, 1.7, -0.55, 3.16, -1.68, 4.38,
R_CUBIC_TO, -1.11, 1.23, -2.47, 1.93, -4.1, 2.13,
R_LINE_TO, 2.63, -4.55,
R_CUBIC_TO, 0.17, -0.28, 0.29, -0.59, 0.38, -0.92,
R_CUBIC_TO, 0.09, -0.34, 0.15, -0.69, 0.15, -1.05,
R_CUBIC_TO, 0, -0.52, -0.09, -0.99, -0.28, -1.42,
R_ARC_TO, 3.96, 3.96, 0, 0, 0, -0.74, -1.2,
R_H_LINE_TO, 3.08,
R_V_LINE_TO, 0.01,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kProductChromeRefreshRepList, kProductChromeRefreshIcon, {kProductChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kProductSpecificationsAddPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.17, 18,
CUBIC_TO, 3.71, 18, 3.32, 17.84, 2.99, 17.51,
CUBIC_TO, 2.66, 17.19, 2.5, 16.79, 2.5, 16.34,
V_LINE_TO, 4.67,
CUBIC_TO, 2.5, 4.21, 2.66, 3.82, 2.99, 3.49,
CUBIC_TO, 3.32, 3.17, 3.71, 3, 4.17, 3,
H_LINE_TO, 10.02,
CUBIC_TO, 9.87, 3.25, 9.73, 3.52, 9.6, 3.79,
CUBIC_TO, 9.48, 4.07, 9.38, 4.36, 9.31, 4.67,
H_LINE_TO, 4.17,
V_LINE_TO, 7.17,
H_LINE_TO, 9.31,
CUBIC_TO, 9.38, 7.47, 9.48, 7.77, 9.59, 8.04,
CUBIC_TO, 9.71, 8.32, 9.85, 8.59, 10.02, 8.84,
H_LINE_TO, 7.92,
V_LINE_TO, 16.34,
H_LINE_TO, 12.08,
V_LINE_TO, 10.73,
CUBIC_TO, 12.35, 10.87, 12.62, 10.99, 12.9, 11.08,
CUBIC_TO, 13.17, 11.17, 13.46, 11.23, 13.75, 11.27,
V_LINE_TO, 16.34,
H_LINE_TO, 15.83,
V_LINE_TO, 11.19,
CUBIC_TO, 16.14, 11.12, 16.43, 11.02, 16.71, 10.9,
CUBIC_TO, 16.99, 10.77, 17.25, 10.63, 17.5, 10.48,
V_LINE_TO, 16.34,
CUBIC_TO, 17.5, 16.79, 17.34, 17.19, 17.01, 17.51,
CUBIC_TO, 16.68, 17.84, 16.29, 18, 15.83, 18,
H_LINE_TO, 4.17,
CLOSE,
MOVE_TO, 4.17, 16.34,
H_LINE_TO, 6.25,
V_LINE_TO, 8.84,
H_LINE_TO, 4.17,
V_LINE_TO, 16.34,
CLOSE,
MOVE_TO, 4.17, 18,
H_LINE_TO, 6.25,
H_LINE_TO, 2.5,
H_LINE_TO, 4.17,
CLOSE,
MOVE_TO, 14.58, 10.5,
CUBIC_TO, 14.58, 9.22, 14.14, 8.14, 13.25, 7.25,
CUBIC_TO, 12.36, 6.36, 11.28, 5.92, 10, 5.92,
CUBIC_TO, 11.28, 5.92, 12.36, 5.47, 13.25, 4.59,
CUBIC_TO, 14.14, 3.7, 14.58, 2.61, 14.58, 1.34,
CUBIC_TO, 14.58, 2.61, 15.03, 3.7, 15.92, 4.59,
CUBIC_TO, 16.81, 5.47, 17.89, 5.92, 19.17, 5.92,
CUBIC_TO, 17.89, 5.92, 16.81, 6.36, 15.92, 7.25,
CUBIC_TO, 15.03, 8.14, 14.58, 9.22, 14.58, 10.5,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kProductSpecificationsAddRepList, kProductSpecificationsAddIcon, {kProductSpecificationsAddPath})
VECTOR_ICON_REP_TEMPLATE(kProductSpecificationsAddedPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 4.17, 18.5,
CUBIC_TO, 3.71, 18.5, 3.32, 18.34, 2.99, 18.01,
CUBIC_TO, 2.66, 17.69, 2.5, 17.29, 2.5, 16.84,
V_LINE_TO, 5.17,
CUBIC_TO, 2.5, 4.71, 2.66, 4.32, 2.99, 3.99,
CUBIC_TO, 3.32, 3.67, 3.71, 3.5, 4.17, 3.5,
H_LINE_TO, 10.02,
CUBIC_TO, 9.87, 3.75, 9.73, 4.02, 9.6, 4.29,
CUBIC_TO, 9.48, 4.57, 9.38, 4.86, 9.31, 5.17,
H_LINE_TO, 4.17,
V_LINE_TO, 7.67,
H_LINE_TO, 9.31,
CUBIC_TO, 9.38, 7.97, 9.48, 8.27, 9.59, 8.54,
CUBIC_TO, 9.71, 8.82, 9.85, 9.09, 10.02, 9.34,
H_LINE_TO, 7.92,
V_LINE_TO, 16.84,
H_LINE_TO, 12.08,
V_LINE_TO, 11.23,
CUBIC_TO, 12.35, 11.37, 12.62, 11.48, 12.9, 11.57,
CUBIC_TO, 13.17, 11.67, 13.46, 11.73, 13.75, 11.77,
V_LINE_TO, 16.84,
H_LINE_TO, 15.83,
V_LINE_TO, 11.69,
CUBIC_TO, 16.14, 11.62, 16.43, 11.52, 16.71, 11.4,
CUBIC_TO, 16.99, 11.27, 17.25, 11.13, 17.5, 10.98,
V_LINE_TO, 16.84,
CUBIC_TO, 17.5, 17.29, 17.34, 17.69, 17.01, 18.01,
CUBIC_TO, 16.68, 18.34, 16.29, 18.5, 15.83, 18.5,
H_LINE_TO, 4.17,
CLOSE,
MOVE_TO, 4.17, 16.84,
H_LINE_TO, 6.25,
V_LINE_TO, 9.34,
H_LINE_TO, 4.17,
V_LINE_TO, 16.84,
CLOSE,
MOVE_TO, 4.17, 18.5,
H_LINE_TO, 6.25,
H_LINE_TO, 2.5,
H_LINE_TO, 4.17,
CLOSE,
NEW_PATH,
FILL_RULE_NONZERO,
MOVE_TO, 14.16, 9.61,
LINE_TO, 11.25, 6.7,
LINE_TO, 12.69, 5.24,
LINE_TO, 14.16, 6.7,
LINE_TO, 17.78, 3.05,
LINE_TO, 19.25, 4.52,
LINE_TO, 14.16, 9.61,
CLOSE,
NEW_PATH)
VECTOR_ICON_TEMPLATE_CC(kProductSpecificationsAddedRepList, kProductSpecificationsAddedIcon, {kProductSpecificationsAddedPath})
VECTOR_ICON_REP_TEMPLATE(kSearchSparkPath, CANVAS_DIMENSIONS, 960,
FILL_RULE_NONZERO,
MOVE_TO, 784, 840,
LINE_TO, 532, 588,
R_QUADRATIC_TO, -30, 24, -69, 38,
R_QUADRATIC_TO, -39, 14, -83, 14,
R_QUADRATIC_TO, -109, 0, -184.5, -75.5,
QUADRATIC_TO_SHORTHAND, 120, 380,
R_QUADRATIC_TO, 0, -109, 75.5, -184.5,
QUADRATIC_TO_SHORTHAND, 380, 120,
R_QUADRATIC_TO, 31, 0, 60, 6.5,
R_QUADRATIC_TO, 29, 6.5, 55, 19.5,
R_LINE_TO, -62, 62,
R_QUADRATIC_TO, -13, -4, -26, -6,
R_QUADRATIC_TO, -13, -2, -27, -2,
R_QUADRATIC_TO, -75, 0, -127.5, 52.5,
QUADRATIC_TO_SHORTHAND, 200, 380,
R_QUADRATIC_TO, 0, 75, 52.5, 127.5,
QUADRATIC_TO_SHORTHAND, 380, 560,
R_QUADRATIC_TO, 70, 0, 120.5, -45.5,
QUADRATIC_TO_SHORTHAND, 559, 400,
R_H_LINE_TO, 80,
R_QUADRATIC_TO, -3, 38, -16.5, 72,
QUADRATIC_TO_SHORTHAND, 588, 532,
R_LINE_TO, 252, 252,
R_LINE_TO, -56, 56,
CLOSE,
R_MOVE_TO, -84, -360,
R_QUADRATIC_TO, 0, -92, -64, -156,
R_QUADRATIC_TO, -64, -64, -156, -64,
R_QUADRATIC_TO, 92, 0, 156, -64,
R_QUADRATIC_TO, 64, -64, 64, -156,
R_QUADRATIC_TO, 0, 92, 64, 156,
R_QUADRATIC_TO, 64, 64, 156, 64,
R_QUADRATIC_TO, -92, 0, -156, 64,
R_QUADRATIC_TO, -64, 64, -64, 156,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSearchSparkRepList, kSearchSparkIcon, {kSearchSparkPath})
VECTOR_ICON_REP_TEMPLATE(kSecurePageInfoChromeRefreshPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 11.66, 13.77,
R_CUBIC_TO, -0.69, 0, -1.28, -0.24, -1.75, -0.71,
R_ARC_TO, 2.38, 2.38, 0, 0, 1, -0.72, -1.75,
R_CUBIC_TO, 0, -0.69, 0.24, -1.28, 0.72, -1.75,
R_CUBIC_TO, 0.48, -0.48, 1.06, -0.72, 1.75, -0.72,
R_CUBIC_TO, 0.69, 0, 1.27, 0.24, 1.75, 0.72,
R_ARC_TO, 2.39, 2.39, 0, 0, 1, 0.72, 1.75,
R_CUBIC_TO, 0, 0.69, -0.24, 1.27, -0.72, 1.75,
R_ARC_TO, 2.39, 2.39, 0, 0, 1, -1.75, 0.71,
CLOSE,
R_MOVE_TO, 0, -1.34,
R_CUBIC_TO, 0.31, 0, 0.58, -0.11, 0.8, -0.33,
R_ARC_TO, 1.1, 1.1, 0, 0, 0, 0.33, -0.8,
R_CUBIC_TO, 0, -0.31, -0.11, -0.58, -0.33, -0.8,
R_ARC_TO, 1.09, 1.09, 0, 0, 0, -0.8, -0.33,
R_CUBIC_TO, -0.31, 0, -0.58, 0.11, -0.8, 0.33,
R_ARC_TO, 1.09, 1.09, 0, 0, 0, -0.33, 0.8,
R_CUBIC_TO, 0, 0.31, 0.11, 0.58, 0.33, 0.8,
R_CUBIC_TO, 0.22, 0.22, 0.49, 0.33, 0.8, 0.33,
CLOSE,
R_MOVE_TO, -9.16, -0.44,
R_V_LINE_TO, -1.38,
R_H_LINE_TO, 5.49,
R_V_LINE_TO, 1.38,
CLOSE,
R_MOVE_TO, 1.83, -4.83,
R_ARC_TO, 2.38, 2.38, 0, 0, 1, -1.75, -0.72,
R_ARC_TO, 2.39, 2.39, 0, 0, 1, -0.72, -1.75,
R_CUBIC_TO, 0, -0.69, 0.24, -1.27, 0.72, -1.75,
R_ARC_TO, 2.39, 2.39, 0, 0, 1, 1.75, -0.71,
R_CUBIC_TO, 0.69, 0, 1.28, 0.24, 1.75, 0.71,
R_CUBIC_TO, 0.48, 0.48, 0.72, 1.06, 0.72, 1.75,
R_CUBIC_TO, 0, 0.69, -0.24, 1.28, -0.72, 1.75,
R_CUBIC_TO, -0.48, 0.48, -1.06, 0.72, -1.75, 0.72,
CLOSE,
R_MOVE_TO, 0, -1.34,
R_CUBIC_TO, 0.31, 0, 0.58, -0.11, 0.8, -0.33,
R_CUBIC_TO, 0.22, -0.22, 0.33, -0.48, 0.33, -0.8,
R_CUBIC_TO, 0, -0.31, -0.11, -0.58, -0.33, -0.8,
R_ARC_TO, 1.1, 1.1, 0, 0, 0, -0.8, -0.33,
R_CUBIC_TO, -0.31, 0, -0.58, 0.11, -0.8, 0.33,
R_ARC_TO, 1.1, 1.1, 0, 0, 0, -0.33, 0.8,
R_CUBIC_TO, 0, 0.31, 0.11, 0.58, 0.33, 0.8,
R_CUBIC_TO, 0.22, 0.22, 0.49, 0.33, 0.8, 0.33,
CLOSE,
R_MOVE_TO, 3.67, -0.44,
V_LINE_TO, 4,
R_H_LINE_TO, 5.49,
R_V_LINE_TO, 1.38,
CLOSE,
R_MOVE_TO, 3.66, 5.92,
CLOSE,
R_MOVE_TO, -7.33, -6.61,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSecurePageInfoChromeRefreshRepList, kSecurePageInfoChromeRefreshIcon, {kSecurePageInfoChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kShareChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 14.5, 18,
R_ARC_TO, 2.4, 2.4, 0, 0, 1, -1.77, -0.73,
ARC_TO, 2.4, 2.4, 0, 0, 1, 12, 15.5,
R_CUBIC_TO, 0, -0.11, 0.01, -0.21, 0.02, -0.3,
R_CUBIC_TO, 0.02, -0.09, 0.04, -0.19, 0.06, -0.3,
R_LINE_TO, -4.96, -3.02,
R_ARC_TO, 1.78, 1.78, 0, 0, 1, -0.74, 0.48,
R_ARC_TO, 2.69, 2.69, 0, 0, 1, -0.89, 0.14,
R_ARC_TO, 2.4, 2.4, 0, 0, 1, -1.77, -0.73,
ARC_TO, 2.4, 2.4, 0, 0, 1, 3, 10,
R_CUBIC_TO, 0, -0.69, 0.24, -1.28, 0.73, -1.77,
ARC_TO, 2.4, 2.4, 0, 0, 1, 5.5, 7.5,
R_CUBIC_TO, 0.31, 0, 0.6, 0.05, 0.89, 0.16,
R_CUBIC_TO, 0.28, 0.11, 0.53, 0.26, 0.74, 0.47,
R_LINE_TO, 4.96, -3.02,
R_ARC_TO, 4.75, 4.75, 0, 0, 1, -0.06, -0.3,
ARC_TO, 2.33, 2.33, 0, 0, 1, 12, 4.5,
R_CUBIC_TO, 0, -0.69, 0.24, -1.28, 0.73, -1.77,
ARC_TO, 2.4, 2.4, 0, 0, 1, 14.5, 2,
R_CUBIC_TO, 0.7, 0, 1.29, 0.24, 1.77, 0.73,
R_CUBIC_TO, 0.49, 0.49, 0.73, 1.08, 0.73, 1.77,
R_CUBIC_TO, 0, 0.7, -0.24, 1.29, -0.73, 1.77,
ARC_TO, 2.4, 2.4, 0, 0, 1, 14.5, 7,
R_CUBIC_TO, -0.31, 0, -0.6, -0.05, -0.89, -0.14,
R_ARC_TO, 1.78, 1.78, 0, 0, 1, -0.74, -0.48,
R_LINE_TO, -4.96, 3.02,
R_CUBIC_TO, 0.03, 0.11, 0.05, 0.21, 0.06, 0.3,
R_ARC_TO, 2.33, 2.33, 0, 0, 1, 0, 0.6,
R_CUBIC_TO, -0.01, 0.09, -0.04, 0.19, -0.06, 0.3,
R_LINE_TO, 4.96, 3.02,
R_CUBIC_TO, 0.21, -0.23, 0.45, -0.4, 0.74, -0.49,
R_CUBIC_TO, 0.28, -0.09, 0.58, -0.14, 0.89, -0.14,
R_CUBIC_TO, 0.7, 0, 1.29, 0.24, 1.77, 0.73,
R_CUBIC_TO, 0.49, 0.49, 0.73, 1.08, 0.73, 1.77,
R_CUBIC_TO, 0, 0.7, -0.24, 1.29, -0.73, 1.77,
R_ARC_TO, 2.4, 2.4, 0, 0, 1, -1.77, 0.73,
CLOSE,
R_MOVE_TO, 0, -12.5,
R_CUBIC_TO, 0.28, 0, 0.52, -0.1, 0.71, -0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, 0.29, -0.71,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, -0.71,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, -0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, 0.71,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE,
R_MOVE_TO, -9, 5.5,
R_CUBIC_TO, 0.28, 0, 0.52, -0.1, 0.71, -0.29,
ARC_TO, 0.96, 0.96, 0, 0, 0, 6.5, 10,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, -0.71,
ARC_TO, 0.96, 0.96, 0, 0, 0, 5.5, 9,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, 0.71,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE,
R_MOVE_TO, 9, 5.5,
R_CUBIC_TO, 0.28, 0, 0.52, -0.1, 0.71, -0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, 0.29, -0.71,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, -0.71,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, -0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.71, 0.29,
R_ARC_TO, 0.96, 0.96, 0, 0, 0, -0.29, 0.71,
R_CUBIC_TO, 0, 0.28, 0.1, 0.52, 0.29, 0.71,
R_CUBIC_TO, 0.19, 0.19, 0.43, 0.29, 0.71, 0.29,
CLOSE,
R_MOVE_TO, 0, -12,
CLOSE,
R_MOVE_TO, -9, 5.5,
CLOSE,
R_MOVE_TO, 9, 5.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kShareChromeRefreshRepList, kShareChromeRefreshIcon, {kShareChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSparkPath, CANVAS_DIMENSIONS, 16,
FILL_RULE_NONZERO,
MOVE_TO, 8, 14.54f,
R_ARC_TO, 0.24f, 0.24f, 0, 0, 1, -0.17f, -0.07f,
R_ARC_TO, 0.39f, 0.39f, 0, 0, 1, -0.1f, -0.17f,
R_ARC_TO, 8.57f, 8.57f, 0, 0, 0, -0.85f, -2.07f,
R_ARC_TO, 8.35f, 8.35f, 0, 0, 0, -1.33f, -1.78f,
ARC_TO, 8.02f, 8.02f, 0, 0, 0, 3.77f, 9.1f,
R_ARC_TO, 8.86f, 8.86f, 0, 0, 0, -2.07f, -0.83f,
R_ARC_TO, 0.39f, 0.39f, 0, 0, 1, -0.17f, -0.1f,
ARC_TO, 0.24f, 0.24f, 0, 0, 1, 1.47f, 8,
R_CUBIC_TO, 0, -0.07f, 0.02f, -0.12f, 0.07f, -0.17f,
R_ARC_TO, 0.39f, 0.39f, 0, 0, 1, 0.17f, -0.1f,
R_ARC_TO, 8.73f, 8.73f, 0, 0, 0, 2.06f, -0.83f,
ARC_TO, 8.55f, 8.55f, 0, 0, 0, 5.55f, 5.55f,
R_ARC_TO, 7.63f, 7.63f, 0, 0, 0, 1.34f, -1.77f,
R_ARC_TO, 8.98f, 8.98f, 0, 0, 0, 0.84f, -2.07f,
R_ARC_TO, 0.39f, 0.39f, 0, 0, 1, 0.1f, -0.17f,
ARC_TO, 0.24f, 0.24f, 0, 0, 1, 8, 1.47f,
R_CUBIC_TO, 0.07f, 0, 0.13f, 0.02f, 0.17f, 0.07f,
R_ARC_TO, 0.36f, 0.36f, 0, 0, 1, 0.1f, 0.17f,
R_CUBIC_TO, 0.18f, 0.71f, 0.46f, 1.4f, 0.83f, 2.07f,
R_ARC_TO, 8.02f, 8.02f, 0, 0, 0, 3.13f, 3.13f,
R_ARC_TO, 8.86f, 8.86f, 0, 0, 0, 2.07f, 0.84f,
R_ARC_TO, 0.39f, 0.39f, 0, 0, 1, 0.17f, 0.1f,
R_ARC_TO, 0.24f, 0.24f, 0, 0, 1, 0.07f, 0.17f,
R_CUBIC_TO, 0, 0.07f, -0.02f, 0.13f, -0.07f, 0.17f,
R_ARC_TO, 0.39f, 0.39f, 0, 0, 1, -0.17f, 0.1f,
R_ARC_TO, 8.98f, 8.98f, 0, 0, 0, -2.07f, 0.84f,
R_ARC_TO, 7.63f, 7.63f, 0, 0, 0, -1.77f, 1.34f,
R_ARC_TO, 8.55f, 8.55f, 0, 0, 0, -1.34f, 1.79f,
R_ARC_TO, 8.73f, 8.73f, 0, 0, 0, -0.83f, 2.06f,
R_ARC_TO, 0.39f, 0.39f, 0, 0, 1, -0.1f, 0.17f,
R_ARC_TO, 0.24f, 0.24f, 0, 0, 1, -0.17f, 0.07f,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSparkRepList, kSparkIcon, {kSparkPath})
VECTOR_ICON_REP_TEMPLATE(kStarActiveChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
R_MOVE_TO, 5.06f, 17,
R_LINE_TO, 1.31f, -5.54f,
LINE_TO, 2, 7.73f,
R_LINE_TO, 5.75f, -0.5f,
LINE_TO, 10, 2,
R_LINE_TO, 2.25f, 5.25f,
R_LINE_TO, 5.75f, 0.48f,
R_LINE_TO, -4.37f, 3.73f,
LINE_TO, 14.94f, 17,
LINE_TO, 10, 14.06f,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStarActiveChromeRefreshRepList, kStarActiveChromeRefreshIcon, {kStarActiveChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kStarChromeRefreshPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 7.33f, 13.9f,
LINE_TO, 10, 12.31f,
R_LINE_TO, 2.69f, 1.58f,
R_LINE_TO, -0.71f, -3,
R_LINE_TO, 2.31f, -1.98f,
R_LINE_TO, -3.06f, -0.27f,
LINE_TO, 10, 5.79f,
LINE_TO, 8.77f, 8.65f,
R_LINE_TO, -3.06f, 0.27f,
R_LINE_TO, 2.34f, 1.98f,
CLOSE,
MOVE_TO, 5.06f, 17,
R_LINE_TO, 1.31f, -5.54f,
LINE_TO, 2, 7.73f,
R_LINE_TO, 5.75f, -0.5f,
LINE_TO, 10, 2,
R_LINE_TO, 2.25f, 5.25f,
R_LINE_TO, 5.75f, 0.48f,
R_LINE_TO, -4.37f, 3.73f,
LINE_TO, 14.94f, 17,
LINE_TO, 10, 14.06f,
CLOSE,
MOVE_TO, 10, 10.06f,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kStarChromeRefreshRepList, kStarChromeRefreshIcon, {kStarChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kSubdirectoryArrowRightPath, CANVAS_DIMENSIONS, 24,
FILL_RULE_NONZERO,
R_MOVE_TO, 14, 21,
R_LINE_TO, -1.43, -1.43,
LINE_TO, 16.18, 16,
H_LINE_TO, 5,
V_LINE_TO, 4,
R_H_LINE_TO, 2,
R_V_LINE_TO, 10,
R_H_LINE_TO, 9.18,
R_LINE_TO, -3.6, -3.6,
R_LINE_TO, 1.4, -1.42,
LINE_TO, 20, 15,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSubdirectoryArrowRightRepList, kSubdirectoryArrowRightIcon, {kSubdirectoryArrowRightPath})
VECTOR_ICON_REP_TEMPLATE(kSummarizeAutoPath, CANVAS_DIMENSIONS, 20,
FILL_RULE_NONZERO,
MOVE_TO, 6.75, 14,
CUBIC_TO, 6.96, 14, 7.14, 13.93, 7.28, 13.79,
CUBIC_TO, 7.43, 13.64, 7.5, 13.46, 7.5, 13.25,
CUBIC_TO, 7.5, 13.04, 7.43, 12.86, 7.29, 12.72,
CUBIC_TO, 7.14, 12.57, 6.96, 12.5, 6.75, 12.5,
CUBIC_TO, 6.54, 12.5, 6.36, 12.57, 6.22, 12.71,
CUBIC_TO, 6.07, 12.86, 6, 13.04, 6, 13.25,
CUBIC_TO, 6, 13.46, 6.07, 13.64, 6.21, 13.78,
CUBIC_TO, 6.36, 13.93, 6.54, 14, 6.75, 14,
CLOSE,
MOVE_TO, 6.75, 10.75,
CUBIC_TO, 6.96, 10.75, 7.14, 10.68, 7.28, 10.54,
CUBIC_TO, 7.43, 10.39, 7.5, 10.21, 7.5, 10,
CUBIC_TO, 7.5, 9.79, 7.43, 9.61, 7.29, 9.47,
CUBIC_TO, 7.14, 9.32, 6.96, 9.25, 6.75, 9.25,
CUBIC_TO, 6.54, 9.25, 6.36, 9.32, 6.22, 9.46,
CUBIC_TO, 6.07, 9.61, 6, 9.79, 6, 10,
CUBIC_TO, 6, 10.21, 6.07, 10.39, 6.21, 10.53,
CUBIC_TO, 6.36, 10.68, 6.54, 10.75, 6.75, 10.75,
CLOSE,
MOVE_TO, 6.75, 7.5,
CUBIC_TO, 6.96, 7.5, 7.14, 7.43, 7.28, 7.29,
CUBIC_TO, 7.43, 7.14, 7.5, 6.96, 7.5, 6.75,
CUBIC_TO, 7.5, 6.54, 7.43, 6.36, 7.29, 6.22,
CUBIC_TO, 7.14, 6.07, 6.96, 6, 6.75, 6,
CUBIC_TO, 6.54, 6, 6.36, 6.07, 6.22, 6.21,
CUBIC_TO, 6.07, 6.36, 6, 6.54, 6, 6.75,
CUBIC_TO, 6, 6.96, 6.07, 7.14, 6.21, 7.28,
CUBIC_TO, 6.36, 7.43, 6.54, 7.5, 6.75, 7.5,
CLOSE,
MOVE_TO, 9, 14,
LINE_TO, 14, 14,
LINE_TO, 14, 12.5,
LINE_TO, 9, 12.5,
CLOSE,
MOVE_TO, 9, 10.75,
LINE_TO, 13, 10.75,
LINE_TO, 13, 9.25,
LINE_TO, 9, 9.25,
CLOSE,
MOVE_TO, 4.5, 17,
CUBIC_TO, 4.09, 17, 3.73, 16.85, 3.44, 16.55,
CUBIC_TO, 3.15, 16.25, 3, 15.9, 3, 15.5,
LINE_TO, 3, 4.5,
CUBIC_TO, 3, 4.1, 3.15, 3.75, 3.44, 3.45,
CUBIC_TO, 3.73, 3.15, 4.09, 3, 4.5, 3,
LINE_TO, 11, 3,
LINE_TO, 11, 4.5,
LINE_TO, 4.5, 4.5,
LINE_TO, 4.5, 15.5,
LINE_TO, 15.5, 15.5,
LINE_TO, 15.5, 9,
LINE_TO, 17, 9,
LINE_TO, 17, 15.5,
CUBIC_TO, 17, 15.9, 16.85, 16.25, 16.56, 16.55,
CUBIC_TO, 16.27, 16.85, 15.91, 17, 15.5, 17,
CLOSE,
MOVE_TO, 14.5, 10,
CUBIC_TO, 14.5, 8.75, 14.06, 7.68, 13.19, 6.81,
CUBIC_TO, 12.32, 5.94, 11.25, 5.5, 10, 5.5,
CUBIC_TO, 11.25, 5.5, 12.32, 5.06, 13.19, 4.19,
CUBIC_TO, 14.06, 3.32, 14.5, 2.25, 14.5, 1,
CUBIC_TO, 14.5, 2.25, 14.94, 3.32, 15.81, 4.19,
CUBIC_TO, 16.68, 5.06, 17.75, 5.5, 19, 5.5,
CUBIC_TO, 17.75, 5.5, 16.68, 5.94, 15.81, 6.81,
CUBIC_TO, 14.94, 7.68, 14.5, 8.75, 14.5, 10,
CLOSE,
MOVE_TO, 10, 10,
CLOSE,
MOVE_TO, 10, 10,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSummarizeAutoRepList, kSummarizeAutoIcon, {kSummarizeAutoPath})
VECTOR_ICON_REP_TEMPLATE(kSwitchPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 25.33, 5.33,
CUBIC_TO, 26.8, 5.33, 28, 6.53, 28, 8,
R_V_LINE_TO, 16,
R_CUBIC_TO, 0, 1.47, -1.2, 2.67, -2.67, 2.67,
H_LINE_TO, 6.67,
ARC_TO, 2.68, 2.68, 0, 0, 1, 4, 24,
V_LINE_TO, 8,
R_CUBIC_TO, 0, -1.47, 1.2, -2.67, 2.67, -2.67,
R_H_LINE_TO, 18.67,
CLOSE,
R_MOVE_TO, 0, 18.67,
V_LINE_TO, 13.33,
R_H_LINE_TO, -8,
V_LINE_TO, 8,
H_LINE_TO, 6.67,
R_V_LINE_TO, 16,
R_H_LINE_TO, 18.67,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kSwitch16Path, CANVAS_DIMENSIONS, 16,
R_MOVE_TO, 13.44, 2,
R_CUBIC_TO, 0.86, 0, 1.56, 0.68, 1.56, 1.5,
R_V_LINE_TO, 9,
R_CUBIC_TO, 0, 0.83, -0.7, 1.5, -1.56, 1.5,
R_H_LINE_TO, -10.89,
R_CUBIC_TO, -0.86, 0, -1.56, -0.67, -1.56, -1.5,
R_V_LINE_TO, -9,
R_CUBIC_TO, 0, -0.82, 0.7, -1.5, 1.56, -1.5,
CLOSE,
R_MOVE_TO, -0.44, 10,
R_V_LINE_TO, -5,
R_H_LINE_TO, -4,
R_V_LINE_TO, -3,
R_H_LINE_TO, -6,
R_V_LINE_TO, 8,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSwitchRepList, kSwitchIcon, {kSwitchPath}, {kSwitch16Path})
VECTOR_ICON_REP_TEMPLATE(kSwitchCr2023Path, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2.85, 11.55,
R_H_LINE_TO, 10.3,
V_LINE_TO, 7.2,
H_LINE_TO, 8.8,
V_LINE_TO, 4.45,
H_LINE_TO, 2.85,
CLOSE,
R_MOVE_TO, 0, 1.38,
R_CUBIC_TO, -0.38, 0, -0.71, -0.13, -0.98, -0.4,
R_ARC_TO, 1.34, 1.34, 0, 0, 1, -0.4, -0.98,
V_LINE_TO, 4.44,
R_CUBIC_TO, 0, -0.38, 0.13, -0.71, 0.4, -0.98,
R_CUBIC_TO, 0.27, -0.27, 0.6, -0.4, 0.98, -0.4,
R_H_LINE_TO, 10.31,
R_CUBIC_TO, 0.38, 0, 0.71, 0.13, 0.98, 0.4,
R_CUBIC_TO, 0.27, 0.27, 0.4, 0.6, 0.4, 0.98,
R_V_LINE_TO, 7.11,
R_CUBIC_TO, 0, 0.38, -0.13, 0.71, -0.4, 0.98,
R_CUBIC_TO, -0.27, 0.27, -0.6, 0.4, -0.98, 0.4,
CLOSE,
R_MOVE_TO, 0, -1.38,
V_LINE_TO, 4.45,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kSwitchCr2023RepList, kSwitchCr2023Icon, {kSwitchCr2023Path})
VECTOR_ICON_REP_TEMPLATE(kTrendingUpChromeRefreshPath, CANVAS_DIMENSIONS, 16,
R_MOVE_TO, 2.47, 12.09,
R_LINE_TO, -0.98, -0.98,
R_LINE_TO, 4.82, -4.81,
R_LINE_TO, 2.53, 2.53,
R_LINE_TO, 3.31, -3.3,
R_H_LINE_TO, -1.91,
V_LINE_TO, 4.16,
R_H_LINE_TO, 4.27,
R_V_LINE_TO, 4.27,
R_H_LINE_TO, -1.38,
V_LINE_TO, 6.52,
R_LINE_TO, -4.29, 4.28,
R_LINE_TO, -2.53, -2.53,
CLOSE,
R_MOVE_TO, 0, 0,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kTrendingUpChromeRefreshRepList, kTrendingUpChromeRefreshIcon, {kTrendingUpChromeRefreshPath})
VECTOR_ICON_REP_TEMPLATE(kShareMacChromeRefreshPath, CANVAS_DIMENSIONS, 20,
MOVE_TO, 5.49, 19,
R_CUBIC_TO, -0.41, 0, -0.76, -0.15, -1.06, -0.44,
R_CUBIC_TO, -0.29, -0.29, -0.44, -0.65, -0.44, -1.06,
R_V_LINE_TO, -9,
R_CUBIC_TO, 0, -0.41, 0.15, -0.77, 0.44, -1.06,
R_CUBIC_TO, 0.29, -0.29, 0.65, -0.44, 1.06, -0.44,
R_H_LINE_TO, 2.5,
R_V_LINE_TO, 1.5,
R_H_LINE_TO, -2.5,
R_V_LINE_TO, 9,
R_H_LINE_TO, 9.01,
R_V_LINE_TO, -9,
H_LINE_TO, 12,
V_LINE_TO, 7,
R_H_LINE_TO, 2.5,
R_CUBIC_TO, 0.42, 0, 0.77, 0.15, 1.06, 0.44,
R_CUBIC_TO, 0.29, 0.29, 0.44, 0.65, 0.44, 1.06,
R_V_LINE_TO, 9,
R_CUBIC_TO, 0, 0.41, -0.15, 0.77, -0.44, 1.06,
R_CUBIC_TO, -0.29, 0.29, -0.65, 0.44, -1.06, 0.44,
H_LINE_TO, 5.49,
CLOSE,
R_MOVE_TO, 3.76, -6,
V_LINE_TO, 3.88,
LINE_TO, 8.06, 5.07,
LINE_TO, 7, 4.01,
R_LINE_TO, 3, -3,
R_LINE_TO, 3, 3,
R_LINE_TO, -1.06, 1.06,
R_LINE_TO, -1.19, -1.19,
V_LINE_TO, 13,
R_H_LINE_TO, -1.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kShareMacChromeRefreshRepList, kShareMacChromeRefreshIcon, {kShareMacChromeRefreshPath})

}
