// components/omnibox/browser/searchbox.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/omnibox/browser/searchbox.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/omnibox/browser/searchbox.mojom-params-data.h"
#include "components/omnibox/browser/searchbox.mojom-shared-message-ids.h"

#include "components/omnibox/browser/searchbox.mojom-import-headers.h"
#include "components/omnibox/browser/searchbox.mojom-test-utils.h"


namespace searchbox::mojom {
ACMatchClassification::ACMatchClassification()
    : offset(),
      style() {}

ACMatchClassification::ACMatchClassification(
    uint32_t offset_in,
    int32_t style_in)
    : offset(std::move(offset_in)),
      style(std::move(style_in)) {}

ACMatchClassification::~ACMatchClassification() = default;
size_t ACMatchClassification::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->offset);
  seed = mojo::internal::Hash(seed, this->style);
  return seed;
}

void ACMatchClassification::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "style"), this->style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ACMatchClassification::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Action::Action()
    : hint(),
      suggestion_contents(),
      icon_path(),
      a11y_label() {}

Action::Action(
    const std::string& hint_in,
    const std::string& suggestion_contents_in,
    const std::string& icon_path_in,
    const std::string& a11y_label_in)
    : hint(std::move(hint_in)),
      suggestion_contents(std::move(suggestion_contents_in)),
      icon_path(std::move(icon_path_in)),
      a11y_label(std::move(a11y_label_in)) {}

Action::~Action() = default;
size_t Action::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->hint);
  seed = mojo::internal::Hash(seed, this->suggestion_contents);
  seed = mojo::internal::Hash(seed, this->icon_path);
  seed = mojo::internal::Hash(seed, this->a11y_label);
  return seed;
}

void Action::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hint"), this->hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion_contents"), this->suggestion_contents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_path"), this->icon_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "a11y_label"), this->a11y_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Action::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SuggestionAnswer::SuggestionAnswer()
    : first_line(),
      second_line() {}

SuggestionAnswer::SuggestionAnswer(
    const ::std::u16string& first_line_in,
    const ::std::u16string& second_line_in)
    : first_line(std::move(first_line_in)),
      second_line(std::move(second_line_in)) {}

SuggestionAnswer::~SuggestionAnswer() = default;

void SuggestionAnswer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_line"), this->first_line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "second_line"), this->second_line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SuggestionAnswer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutocompleteMatch::AutocompleteMatch()
    : is_hidden(),
      a11y_label(),
      allowed_to_be_default_match(),
      actions(),
      answer(),
      contents(),
      contents_class(),
      description(),
      description_class(),
      destination_url(),
      inline_autocompletion(),
      fill_into_edit(),
      is_weather_answer_suggestion(),
      icon_path(),
      icon_url(),
      image_dominant_color(),
      image_url(),
      is_noncanned_aim_suggestion(),
      is_rich_suggestion(),
      is_search_type(),
      is_enterprise_search_aggregator_people_type(),
      type(),
      remove_button_a11y_label(),
      swap_contents_and_description(),
      suggestion_group_id(),
      supports_deletion(),
      tail_suggest_common_prefix(),
      has_instant_keyword(),
      keyword_chip_hint(),
      keyword_chip_a11y() {}

AutocompleteMatch::AutocompleteMatch(
    bool is_hidden_in,
    const ::std::u16string& a11y_label_in,
    bool allowed_to_be_default_match_in,
    std::vector<ActionPtr> actions_in,
    SuggestionAnswerPtr answer_in,
    const ::std::u16string& contents_in,
    std::vector<ACMatchClassificationPtr> contents_class_in,
    const ::std::u16string& description_in,
    std::vector<ACMatchClassificationPtr> description_class_in,
    const ::GURL& destination_url_in,
    const ::std::u16string& inline_autocompletion_in,
    const ::std::u16string& fill_into_edit_in,
    std::optional<bool> is_weather_answer_suggestion_in,
    const std::string& icon_path_in,
    const ::GURL& icon_url_in,
    const std::string& image_dominant_color_in,
    const std::string& image_url_in,
    bool is_noncanned_aim_suggestion_in,
    bool is_rich_suggestion_in,
    bool is_search_type_in,
    bool is_enterprise_search_aggregator_people_type_in,
    const std::string& type_in,
    const ::std::u16string& remove_button_a11y_label_in,
    bool swap_contents_and_description_in,
    int32_t suggestion_group_id_in,
    bool supports_deletion_in,
    const std::optional<::std::u16string>& tail_suggest_common_prefix_in,
    bool has_instant_keyword_in,
    const std::string& keyword_chip_hint_in,
    const std::string& keyword_chip_a11y_in)
    : is_hidden(std::move(is_hidden_in)),
      a11y_label(std::move(a11y_label_in)),
      allowed_to_be_default_match(std::move(allowed_to_be_default_match_in)),
      actions(std::move(actions_in)),
      answer(std::move(answer_in)),
      contents(std::move(contents_in)),
      contents_class(std::move(contents_class_in)),
      description(std::move(description_in)),
      description_class(std::move(description_class_in)),
      destination_url(std::move(destination_url_in)),
      inline_autocompletion(std::move(inline_autocompletion_in)),
      fill_into_edit(std::move(fill_into_edit_in)),
      is_weather_answer_suggestion(std::move(is_weather_answer_suggestion_in)),
      icon_path(std::move(icon_path_in)),
      icon_url(std::move(icon_url_in)),
      image_dominant_color(std::move(image_dominant_color_in)),
      image_url(std::move(image_url_in)),
      is_noncanned_aim_suggestion(std::move(is_noncanned_aim_suggestion_in)),
      is_rich_suggestion(std::move(is_rich_suggestion_in)),
      is_search_type(std::move(is_search_type_in)),
      is_enterprise_search_aggregator_people_type(std::move(is_enterprise_search_aggregator_people_type_in)),
      type(std::move(type_in)),
      remove_button_a11y_label(std::move(remove_button_a11y_label_in)),
      swap_contents_and_description(std::move(swap_contents_and_description_in)),
      suggestion_group_id(std::move(suggestion_group_id_in)),
      supports_deletion(std::move(supports_deletion_in)),
      tail_suggest_common_prefix(std::move(tail_suggest_common_prefix_in)),
      has_instant_keyword(std::move(has_instant_keyword_in)),
      keyword_chip_hint(std::move(keyword_chip_hint_in)),
      keyword_chip_a11y(std::move(keyword_chip_a11y_in)) {}

AutocompleteMatch::~AutocompleteMatch() = default;

void AutocompleteMatch::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_hidden"), this->is_hidden,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "a11y_label"), this->a11y_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowed_to_be_default_match"), this->allowed_to_be_default_match,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actions"), this->actions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ActionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "answer"), this->answer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SuggestionAnswerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents"), this->contents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents_class"), this->contents_class,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ACMatchClassificationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description_class"), this->description_class,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ACMatchClassificationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination_url"), this->destination_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inline_autocompletion"), this->inline_autocompletion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fill_into_edit"), this->fill_into_edit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_weather_answer_suggestion"), this->is_weather_answer_suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_path"), this->icon_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_url"), this->icon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_dominant_color"), this->image_dominant_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_url"), this->image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_noncanned_aim_suggestion"), this->is_noncanned_aim_suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_rich_suggestion"), this->is_rich_suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_search_type"), this->is_search_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enterprise_search_aggregator_people_type"), this->is_enterprise_search_aggregator_people_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remove_button_a11y_label"), this->remove_button_a11y_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_contents_and_description"), this->swap_contents_and_description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion_group_id"), this->suggestion_group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_deletion"), this->supports_deletion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tail_suggest_common_prefix"), this->tail_suggest_common_prefix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_instant_keyword"), this->has_instant_keyword,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyword_chip_hint"), this->keyword_chip_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyword_chip_a11y"), this->keyword_chip_a11y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutocompleteMatch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabInfo::TabInfo()
    : tab_id(),
      title(),
      url(),
      show_in_current_tab_chip(),
      show_in_previous_tab_chip(),
      last_active() {}

TabInfo::TabInfo(
    int32_t tab_id_in,
    const std::string& title_in,
    const ::GURL& url_in,
    bool show_in_current_tab_chip_in,
    bool show_in_previous_tab_chip_in,
    ::base::TimeTicks last_active_in)
    : tab_id(std::move(tab_id_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      show_in_current_tab_chip(std::move(show_in_current_tab_chip_in)),
      show_in_previous_tab_chip(std::move(show_in_previous_tab_chip_in)),
      last_active(std::move(last_active_in)) {}

TabInfo::~TabInfo() = default;

void TabInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_in_current_tab_chip"), this->show_in_current_tab_chip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_in_previous_tab_chip"), this->show_in_previous_tab_chip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active"), this->last_active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileAttachment::FileAttachment()
    : uuid(),
      name(),
      mime_type(),
      image_data_url() {}

FileAttachment::FileAttachment(
    const ::base::UnguessableToken& uuid_in,
    const std::string& name_in,
    const std::string& mime_type_in,
    const std::optional<std::string>& image_data_url_in)
    : uuid(std::move(uuid_in)),
      name(std::move(name_in)),
      mime_type(std::move(mime_type_in)),
      image_data_url(std::move(image_data_url_in)) {}

FileAttachment::~FileAttachment() = default;

void FileAttachment::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_data_url"), this->image_data_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileAttachment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabAttachment::TabAttachment()
    : tab_id(),
      title(),
      url() {}

TabAttachment::TabAttachment(
    int32_t tab_id_in,
    const std::string& title_in,
    const ::GURL& url_in)
    : tab_id(std::move(tab_id_in)),
      title(std::move(title_in)),
      url(std::move(url_in)) {}

TabAttachment::~TabAttachment() = default;

void TabAttachment::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabAttachment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchContext::SearchContext()
    : input(),
      attachments(),
      tool_mode() {}

SearchContext::SearchContext(
    const std::string& input_in,
    std::vector<SearchContextAttachmentPtr> attachments_in,
    ToolMode tool_mode_in)
    : input(std::move(input_in)),
      attachments(std::move(attachments_in)),
      tool_mode(std::move(tool_mode_in)) {}

SearchContext::~SearchContext() = default;

void SearchContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input"), this->input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attachments"), this->attachments,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SearchContextAttachmentPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tool_mode"), this->tool_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ToolMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectedFileInfo::SelectedFileInfo()
    : file_name(),
      mime_type(),
      image_data_url(),
      is_deletable(),
      selection_time() {}

SelectedFileInfo::SelectedFileInfo(
    const std::string& file_name_in,
    const std::string& mime_type_in,
    const std::optional<std::string>& image_data_url_in,
    bool is_deletable_in,
    ::base::Time selection_time_in)
    : file_name(std::move(file_name_in)),
      mime_type(std::move(mime_type_in)),
      image_data_url(std::move(image_data_url_in)),
      is_deletable(std::move(is_deletable_in)),
      selection_time(std::move(selection_time_in)) {}

SelectedFileInfo::~SelectedFileInfo() = default;

void SelectedFileInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_name"), this->file_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_data_url"), this->image_data_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_deletable"), this->is_deletable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_time"), this->selection_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectedFileInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SuggestionGroup::SuggestionGroup()
    : header(),
      render_type(RenderType::kDefaultVertical),
      side_type(SideType::kDefaultPrimary) {}

SuggestionGroup::SuggestionGroup(
    const ::std::u16string& header_in,
    RenderType render_type_in,
    SideType side_type_in)
    : header(std::move(header_in)),
      render_type(std::move(render_type_in)),
      side_type(std::move(side_type_in)) {}

SuggestionGroup::~SuggestionGroup() = default;

void SuggestionGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header"), this->header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_type"), this->render_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RenderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "side_type"), this->side_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SideType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SuggestionGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutocompleteResult::AutocompleteResult()
    : input(),
      suggestion_groups_map(),
      matches(),
      smart_compose_inline_hint() {}

AutocompleteResult::AutocompleteResult(
    const ::std::u16string& input_in,
    base::flat_map<int32_t, SuggestionGroupPtr> suggestion_groups_map_in,
    std::vector<AutocompleteMatchPtr> matches_in,
    const std::optional<::std::u16string>& smart_compose_inline_hint_in)
    : input(std::move(input_in)),
      suggestion_groups_map(std::move(suggestion_groups_map_in)),
      matches(std::move(matches_in)),
      smart_compose_inline_hint(std::move(smart_compose_inline_hint_in)) {}

AutocompleteResult::~AutocompleteResult() = default;

void AutocompleteResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input"), this->input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion_groups_map"), this->suggestion_groups_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<int32_t, SuggestionGroupPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matches"), this->matches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AutocompleteMatchPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "smart_compose_inline_hint"), this->smart_compose_inline_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutocompleteResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OmniboxPopupSelection::OmniboxPopupSelection()
    : line(),
      state(),
      action_index() {}

OmniboxPopupSelection::OmniboxPopupSelection(
    uint8_t line_in,
    SelectionLineState state_in,
    uint8_t action_index_in)
    : line(std::move(line_in)),
      state(std::move(state_in)),
      action_index(std::move(action_index_in)) {}

OmniboxPopupSelection::~OmniboxPopupSelection() = default;
size_t OmniboxPopupSelection::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->line);
  seed = mojo::internal::Hash(seed, this->state);
  seed = mojo::internal::Hash(seed, this->action_index);
  return seed;
}

void OmniboxPopupSelection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "line"), this->line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SelectionLineState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action_index"), this->action_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OmniboxPopupSelection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PlaceholderConfig::PlaceholderConfig()
    : texts(),
      change_text_animation_interval(),
      fade_text_animation_duration() {}

PlaceholderConfig::PlaceholderConfig(
    std::vector<::std::u16string> texts_in,
    ::base::TimeDelta change_text_animation_interval_in,
    ::base::TimeDelta fade_text_animation_duration_in)
    : texts(std::move(texts_in)),
      change_text_animation_interval(std::move(change_text_animation_interval_in)),
      fade_text_animation_duration(std::move(fade_text_animation_duration_in)) {}

PlaceholderConfig::~PlaceholderConfig() = default;

void PlaceholderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texts"), this->texts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "change_text_animation_interval"), this->change_text_animation_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fade_text_animation_duration"), this->fade_text_animation_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PlaceholderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchContextAttachmentPtr
SearchContextAttachment::NewFileAttachment(
    FileAttachmentPtr value) {
  return SearchContextAttachmentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFileAttachment)>,
      std::move(value));
}

SearchContextAttachmentPtr
SearchContextAttachment::NewTabAttachment(
    TabAttachmentPtr value) {
  return SearchContextAttachmentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTabAttachment)>,
      std::move(value));
}

SearchContextAttachment::SearchContextAttachment(
    std::in_place_index_t<static_cast<size_t>(Tag::kFileAttachment)>,
    FileAttachmentPtr value)
    : tag_(Tag::kFileAttachment),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFileAttachment)>,
            std::move(value)) {}

SearchContextAttachment::SearchContextAttachment(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabAttachment)>,
    TabAttachmentPtr value)
    : tag_(Tag::kTabAttachment),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTabAttachment)>,
            std::move(value)) {}
SearchContextAttachment::~SearchContextAttachment() {
  DestroyActive();
}

void SearchContextAttachment::set_file_attachment(FileAttachmentPtr file_attachment) {
  if (tag_ == Tag::kFileAttachment) {
    data_.file_attachment = std::move(file_attachment);
  } else {
    DestroyActive();
    tag_ = Tag::kFileAttachment;
    new (&data_.file_attachment) FileAttachmentPtr(
        std::move(file_attachment));
  }
}

void SearchContextAttachment::set_tab_attachment(TabAttachmentPtr tab_attachment) {
  if (tag_ == Tag::kTabAttachment) {
    data_.tab_attachment = std::move(tab_attachment);
  } else {
    DestroyActive();
    tag_ = Tag::kTabAttachment;
    new (&data_.tab_attachment) TabAttachmentPtr(
        std::move(tab_attachment));
  }
}


SearchContextAttachment::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFileAttachment)>,
    FileAttachmentPtr value)
    : file_attachment(std::move(value)) {}

SearchContextAttachment::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabAttachment)>,
    TabAttachmentPtr value)
    : tab_attachment(std::move(value)) {}

void SearchContextAttachment::DestroyActive() {
  switch (tag_) {

    case Tag::kFileAttachment:
      std::destroy_at(&data_.file_attachment);
      break;
    case Tag::kTabAttachment:
      std::destroy_at(&data_.tab_attachment);
      break;
  }
}

bool SearchContextAttachment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kSetPage: {
      return &PageHandler::SetPage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnFocusChanged: {
      return &PageHandler::OnFocusChanged_Sym::IPCStableHash;
    }
    case messages::PageHandler::kQueryAutocomplete: {
      return &PageHandler::QueryAutocomplete_Sym::IPCStableHash;
    }
    case messages::PageHandler::kStopAutocomplete: {
      return &PageHandler::StopAutocomplete_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenAutocompleteMatch: {
      return &PageHandler::OpenAutocompleteMatch_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnNavigationLikely: {
      return &PageHandler::OnNavigationLikely_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeleteAutocompleteMatch: {
      return &PageHandler::DeleteAutocompleteMatch_Sym::IPCStableHash;
    }
    case messages::PageHandler::kActivateKeyword: {
      return &PageHandler::ActivateKeyword_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowContextMenu: {
      return &PageHandler::ShowContextMenu_Sym::IPCStableHash;
    }
    case messages::PageHandler::kExecuteAction: {
      return &PageHandler::ExecuteAction_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnThumbnailRemoved: {
      return &PageHandler::OnThumbnailRemoved_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetPlaceholderConfig: {
      return &PageHandler::GetPlaceholderConfig_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetRecentTabs: {
      return &PageHandler::GetRecentTabs_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTabPreview: {
      return &PageHandler::GetTabPreview_Sym::IPCStableHash;
    }
    case messages::PageHandler::kNotifySessionStarted: {
      return &PageHandler::NotifySessionStarted_Sym::IPCStableHash;
    }
    case messages::PageHandler::kNotifySessionAbandoned: {
      return &PageHandler::NotifySessionAbandoned_Sym::IPCStableHash;
    }
    case messages::PageHandler::kAddFileContext: {
      return &PageHandler::AddFileContext_Sym::IPCStableHash;
    }
    case messages::PageHandler::kAddTabContext: {
      return &PageHandler::AddTabContext_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeleteContext: {
      return &PageHandler::DeleteContext_Sym::IPCStableHash;
    }
    case messages::PageHandler::kClearFiles: {
      return &PageHandler::ClearFiles_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSubmitQuery: {
      return &PageHandler::SubmitQuery_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenLensSearch: {
      return &PageHandler::OpenLensSearch_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kSetPage:
            return "Receive searchbox::mojom::PageHandler::SetPage";
      case messages::PageHandler::kOnFocusChanged:
            return "Receive searchbox::mojom::PageHandler::OnFocusChanged";
      case messages::PageHandler::kQueryAutocomplete:
            return "Receive searchbox::mojom::PageHandler::QueryAutocomplete";
      case messages::PageHandler::kStopAutocomplete:
            return "Receive searchbox::mojom::PageHandler::StopAutocomplete";
      case messages::PageHandler::kOpenAutocompleteMatch:
            return "Receive searchbox::mojom::PageHandler::OpenAutocompleteMatch";
      case messages::PageHandler::kOnNavigationLikely:
            return "Receive searchbox::mojom::PageHandler::OnNavigationLikely";
      case messages::PageHandler::kDeleteAutocompleteMatch:
            return "Receive searchbox::mojom::PageHandler::DeleteAutocompleteMatch";
      case messages::PageHandler::kActivateKeyword:
            return "Receive searchbox::mojom::PageHandler::ActivateKeyword";
      case messages::PageHandler::kShowContextMenu:
            return "Receive searchbox::mojom::PageHandler::ShowContextMenu";
      case messages::PageHandler::kExecuteAction:
            return "Receive searchbox::mojom::PageHandler::ExecuteAction";
      case messages::PageHandler::kOnThumbnailRemoved:
            return "Receive searchbox::mojom::PageHandler::OnThumbnailRemoved";
      case messages::PageHandler::kGetPlaceholderConfig:
            return "Receive searchbox::mojom::PageHandler::GetPlaceholderConfig";
      case messages::PageHandler::kGetRecentTabs:
            return "Receive searchbox::mojom::PageHandler::GetRecentTabs";
      case messages::PageHandler::kGetTabPreview:
            return "Receive searchbox::mojom::PageHandler::GetTabPreview";
      case messages::PageHandler::kNotifySessionStarted:
            return "Receive searchbox::mojom::PageHandler::NotifySessionStarted";
      case messages::PageHandler::kNotifySessionAbandoned:
            return "Receive searchbox::mojom::PageHandler::NotifySessionAbandoned";
      case messages::PageHandler::kAddFileContext:
            return "Receive searchbox::mojom::PageHandler::AddFileContext";
      case messages::PageHandler::kAddTabContext:
            return "Receive searchbox::mojom::PageHandler::AddTabContext";
      case messages::PageHandler::kDeleteContext:
            return "Receive searchbox::mojom::PageHandler::DeleteContext";
      case messages::PageHandler::kClearFiles:
            return "Receive searchbox::mojom::PageHandler::ClearFiles";
      case messages::PageHandler::kSubmitQuery:
            return "Receive searchbox::mojom::PageHandler::SubmitQuery";
      case messages::PageHandler::kOpenLensSearch:
            return "Receive searchbox::mojom::PageHandler::OpenLensSearch";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kSetPage:
            return "Receive reply searchbox::mojom::PageHandler::SetPage";
      case messages::PageHandler::kOnFocusChanged:
            return "Receive reply searchbox::mojom::PageHandler::OnFocusChanged";
      case messages::PageHandler::kQueryAutocomplete:
            return "Receive reply searchbox::mojom::PageHandler::QueryAutocomplete";
      case messages::PageHandler::kStopAutocomplete:
            return "Receive reply searchbox::mojom::PageHandler::StopAutocomplete";
      case messages::PageHandler::kOpenAutocompleteMatch:
            return "Receive reply searchbox::mojom::PageHandler::OpenAutocompleteMatch";
      case messages::PageHandler::kOnNavigationLikely:
            return "Receive reply searchbox::mojom::PageHandler::OnNavigationLikely";
      case messages::PageHandler::kDeleteAutocompleteMatch:
            return "Receive reply searchbox::mojom::PageHandler::DeleteAutocompleteMatch";
      case messages::PageHandler::kActivateKeyword:
            return "Receive reply searchbox::mojom::PageHandler::ActivateKeyword";
      case messages::PageHandler::kShowContextMenu:
            return "Receive reply searchbox::mojom::PageHandler::ShowContextMenu";
      case messages::PageHandler::kExecuteAction:
            return "Receive reply searchbox::mojom::PageHandler::ExecuteAction";
      case messages::PageHandler::kOnThumbnailRemoved:
            return "Receive reply searchbox::mojom::PageHandler::OnThumbnailRemoved";
      case messages::PageHandler::kGetPlaceholderConfig:
            return "Receive reply searchbox::mojom::PageHandler::GetPlaceholderConfig";
      case messages::PageHandler::kGetRecentTabs:
            return "Receive reply searchbox::mojom::PageHandler::GetRecentTabs";
      case messages::PageHandler::kGetTabPreview:
            return "Receive reply searchbox::mojom::PageHandler::GetTabPreview";
      case messages::PageHandler::kNotifySessionStarted:
            return "Receive reply searchbox::mojom::PageHandler::NotifySessionStarted";
      case messages::PageHandler::kNotifySessionAbandoned:
            return "Receive reply searchbox::mojom::PageHandler::NotifySessionAbandoned";
      case messages::PageHandler::kAddFileContext:
            return "Receive reply searchbox::mojom::PageHandler::AddFileContext";
      case messages::PageHandler::kAddTabContext:
            return "Receive reply searchbox::mojom::PageHandler::AddTabContext";
      case messages::PageHandler::kDeleteContext:
            return "Receive reply searchbox::mojom::PageHandler::DeleteContext";
      case messages::PageHandler::kClearFiles:
            return "Receive reply searchbox::mojom::PageHandler::ClearFiles";
      case messages::PageHandler::kSubmitQuery:
            return "Receive reply searchbox::mojom::PageHandler::SubmitQuery";
      case messages::PageHandler::kOpenLensSearch:
            return "Receive reply searchbox::mojom::PageHandler::OpenLensSearch";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::SetPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc31f6158;  // IPCStableHash for searchbox::mojom::PageHandler::SetPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnFocusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd69941f2;  // IPCStableHash for searchbox::mojom::PageHandler::OnFocusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::QueryAutocomplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9f535c9;  // IPCStableHash for searchbox::mojom::PageHandler::QueryAutocomplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::StopAutocomplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x674077cc;  // IPCStableHash for searchbox::mojom::PageHandler::StopAutocomplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenAutocompleteMatch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x72b86ca8;  // IPCStableHash for searchbox::mojom::PageHandler::OpenAutocompleteMatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnNavigationLikely_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xffb7c9bd;  // IPCStableHash for searchbox::mojom::PageHandler::OnNavigationLikely
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeleteAutocompleteMatch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x969b114e;  // IPCStableHash for searchbox::mojom::PageHandler::DeleteAutocompleteMatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ActivateKeyword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd595b4d6;  // IPCStableHash for searchbox::mojom::PageHandler::ActivateKeyword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52eae0ec;  // IPCStableHash for searchbox::mojom::PageHandler::ShowContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ExecuteAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55c5733d;  // IPCStableHash for searchbox::mojom::PageHandler::ExecuteAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnThumbnailRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14921ab7;  // IPCStableHash for searchbox::mojom::PageHandler::OnThumbnailRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetPlaceholderConfig_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd08ee52d;  // IPCStableHash for searchbox::mojom::PageHandler::GetPlaceholderConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetRecentTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x934a47ac;  // IPCStableHash for searchbox::mojom::PageHandler::GetRecentTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTabPreview_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x804d3c1a;  // IPCStableHash for searchbox::mojom::PageHandler::GetTabPreview
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::NotifySessionStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47c3112d;  // IPCStableHash for searchbox::mojom::PageHandler::NotifySessionStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::NotifySessionAbandoned_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d29ee81;  // IPCStableHash for searchbox::mojom::PageHandler::NotifySessionAbandoned
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::AddFileContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95b871ea;  // IPCStableHash for searchbox::mojom::PageHandler::AddFileContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::AddTabContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa642c873;  // IPCStableHash for searchbox::mojom::PageHandler::AddTabContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeleteContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9de81c0;  // IPCStableHash for searchbox::mojom::PageHandler::DeleteContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ClearFiles_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1629e704;  // IPCStableHash for searchbox::mojom::PageHandler::ClearFiles
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SubmitQuery_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ff74501;  // IPCStableHash for searchbox::mojom::PageHandler::SubmitQuery
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenLensSearch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f65c264;  // IPCStableHash for searchbox::mojom::PageHandler::OpenLensSearch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetPlaceholderConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetPlaceholderConfig_ForwardToCallback(
      PageHandler::GetPlaceholderConfigCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetPlaceholderConfig_ForwardToCallback(const PageHandler_GetPlaceholderConfig_ForwardToCallback&) = delete;
  PageHandler_GetPlaceholderConfig_ForwardToCallback& operator=(const PageHandler_GetPlaceholderConfig_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetPlaceholderConfigCallback callback_;
};

class PageHandler_GetRecentTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetRecentTabs_ForwardToCallback(
      PageHandler::GetRecentTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetRecentTabs_ForwardToCallback(const PageHandler_GetRecentTabs_ForwardToCallback&) = delete;
  PageHandler_GetRecentTabs_ForwardToCallback& operator=(const PageHandler_GetRecentTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetRecentTabsCallback callback_;
};

class PageHandler_GetTabPreview_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabPreview_ForwardToCallback(
      PageHandler::GetTabPreviewCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabPreview_ForwardToCallback(const PageHandler_GetTabPreview_ForwardToCallback&) = delete;
  PageHandler_GetTabPreview_ForwardToCallback& operator=(const PageHandler_GetTabPreview_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabPreviewCallback callback_;
};

class PageHandler_AddFileContext_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_AddFileContext_ForwardToCallback(
      PageHandler::AddFileContextCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_AddFileContext_ForwardToCallback(const PageHandler_AddFileContext_ForwardToCallback&) = delete;
  PageHandler_AddFileContext_ForwardToCallback& operator=(const PageHandler_AddFileContext_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::AddFileContextCallback callback_;
};

class PageHandler_AddTabContext_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_AddTabContext_ForwardToCallback(
      PageHandler::AddTabContextCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_AddTabContext_ForwardToCallback(const PageHandler_AddTabContext_ForwardToCallback&) = delete;
  PageHandler_AddTabContext_ForwardToCallback& operator=(const PageHandler_AddTabContext_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::AddTabContextCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::SetPage(
    ::mojo::PendingRemote<Page> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::SetPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_SetPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::searchbox::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandler.SetPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnFocusChanged(
    bool in_focused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::OnFocusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focused"), in_focused,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnFocusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_OnFocusChanged_Params_Data> params(
          message);
  params.Allocate();

  params->focused = in_focused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnFocusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::QueryAutocomplete(
    const ::std::u16string& in_input, bool in_prevent_inline_autocomplete) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::QueryAutocomplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prevent_inline_autocomplete"), in_prevent_inline_autocomplete,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kQueryAutocomplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_QueryAutocomplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in PageHandler.QueryAutocomplete request");

  params->prevent_inline_autocomplete = in_prevent_inline_autocomplete;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("QueryAutocomplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::StopAutocomplete(
    bool in_clear_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::StopAutocomplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clear_result"), in_clear_result,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStopAutocomplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_StopAutocomplete_Params_Data> params(
          message);
  params.Allocate();

  params->clear_result = in_clear_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StopAutocomplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenAutocompleteMatch(
    uint8_t in_line, const ::GURL& in_url, bool in_are_matches_showing, uint8_t in_mouse_button, bool in_alt_key, bool in_ctrl_key, bool in_meta_key, bool in_shift_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::OpenAutocompleteMatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line"), in_line,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("are_matches_showing"), in_are_matches_showing,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mouse_button"), in_mouse_button,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alt_key"), in_alt_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ctrl_key"), in_ctrl_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("meta_key"), in_meta_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shift_key"), in_shift_key,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenAutocompleteMatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_OpenAutocompleteMatch_Params_Data> params(
          message);
  params.Allocate();

  params->line = in_line;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.OpenAutocompleteMatch request");

  params->are_matches_showing = in_are_matches_showing;

  params->mouse_button = in_mouse_button;

  params->alt_key = in_alt_key;

  params->ctrl_key = in_ctrl_key;

  params->meta_key = in_meta_key;

  params->shift_key = in_shift_key;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenAutocompleteMatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnNavigationLikely(
    uint8_t in_line, const ::GURL& in_url, ::omnibox::mojom::NavigationPredictor in_navigation_predictor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::OnNavigationLikely", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line"), in_line,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_predictor"), in_navigation_predictor,
                        "<value of type ::omnibox::mojom::NavigationPredictor>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnNavigationLikely), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_OnNavigationLikely_Params_Data> params(
          message);
  params.Allocate();

  params->line = in_line;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.OnNavigationLikely request");

  
  mojo::internal::Serialize<::omnibox::mojom::NavigationPredictor>(
    in_navigation_predictor,
    &params->navigation_predictor);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnNavigationLikely");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::DeleteAutocompleteMatch(
    uint8_t in_line, const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::DeleteAutocompleteMatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line"), in_line,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteAutocompleteMatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_DeleteAutocompleteMatch_Params_Data> params(
          message);
  params.Allocate();

  params->line = in_line;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.DeleteAutocompleteMatch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteAutocompleteMatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ActivateKeyword(
    uint8_t in_line, const ::GURL& in_url, ::base::TimeTicks in_match_selection_timestamp, bool in_is_mouse_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::ActivateKeyword", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line"), in_line,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("match_selection_timestamp"), in_match_selection_timestamp,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_mouse_event"), in_is_mouse_event,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kActivateKeyword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_ActivateKeyword_Params_Data> params(
          message);
  params.Allocate();

  params->line = in_line;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.ActivateKeyword request");
  mojo::internal::MessageFragment<
      typename decltype(params->match_selection_timestamp)::BaseType> match_selection_timestamp_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_match_selection_timestamp,
    match_selection_timestamp_fragment);

  params->match_selection_timestamp.Set(
      match_selection_timestamp_fragment.is_null() ? nullptr : match_selection_timestamp_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->match_selection_timestamp.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null match_selection_timestamp in PageHandler.ActivateKeyword request");

  params->is_mouse_event = in_is_mouse_event;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ActivateKeyword");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowContextMenu(
    const ::gfx::Point& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::ShowContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_ShowContextMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in PageHandler.ShowContextMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ExecuteAction(
    uint8_t in_line, uint8_t in_action_index, const ::GURL& in_url, ::base::TimeTicks in_match_selection_timestamp, uint8_t in_mouse_button, bool in_alt_key, bool in_ctrl_key, bool in_meta_key, bool in_shift_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::ExecuteAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line"), in_line,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_index"), in_action_index,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("match_selection_timestamp"), in_match_selection_timestamp,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mouse_button"), in_mouse_button,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alt_key"), in_alt_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ctrl_key"), in_ctrl_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("meta_key"), in_meta_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shift_key"), in_shift_key,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kExecuteAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_ExecuteAction_Params_Data> params(
          message);
  params.Allocate();

  params->line = in_line;

  params->action_index = in_action_index;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.ExecuteAction request");
  mojo::internal::MessageFragment<
      typename decltype(params->match_selection_timestamp)::BaseType> match_selection_timestamp_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_match_selection_timestamp,
    match_selection_timestamp_fragment);

  params->match_selection_timestamp.Set(
      match_selection_timestamp_fragment.is_null() ? nullptr : match_selection_timestamp_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->match_selection_timestamp.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null match_selection_timestamp in PageHandler.ExecuteAction request");

  params->mouse_button = in_mouse_button;

  params->alt_key = in_alt_key;

  params->ctrl_key = in_ctrl_key;

  params->meta_key = in_meta_key;

  params->shift_key = in_shift_key;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ExecuteAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnThumbnailRemoved(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::PageHandler::OnThumbnailRemoved");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnThumbnailRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_OnThumbnailRemoved_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnThumbnailRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetPlaceholderConfig(
    GetPlaceholderConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::PageHandler::GetPlaceholderConfig");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetPlaceholderConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_GetPlaceholderConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetPlaceholderConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetPlaceholderConfig_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetRecentTabs(
    GetRecentTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::PageHandler::GetRecentTabs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetRecentTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_GetRecentTabs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetRecentTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetRecentTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTabPreview(
    int32_t in_tab_id, GetTabPreviewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::GetTabPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_GetTabPreview_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabPreview");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabPreview_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::NotifySessionStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::PageHandler::NotifySessionStarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kNotifySessionStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_NotifySessionStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("NotifySessionStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::NotifySessionAbandoned(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::PageHandler::NotifySessionAbandoned");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kNotifySessionAbandoned), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_NotifySessionAbandoned_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("NotifySessionAbandoned");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::AddFileContext(
    SelectedFileInfoPtr in_file_info, ::mojo_base::BigBuffer in_file_bytes, AddFileContextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::AddFileContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_info"), in_file_info,
                        "<value of type SelectedFileInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_bytes"), in_file_bytes,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAddFileContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_AddFileContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_info)::BaseType> file_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::SelectedFileInfoDataView>(
    in_file_info,
    file_info_fragment);

  params->file_info.Set(
      file_info_fragment.is_null() ? nullptr : file_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_info in PageHandler.AddFileContext request");
  mojo::internal::MessageFragment<decltype(params->file_bytes)>
      file_bytes_fragment(params.message());
  file_bytes_fragment.Claim(&params->file_bytes);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_file_bytes,
    file_bytes_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_bytes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_bytes in PageHandler.AddFileContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("AddFileContext");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_AddFileContext_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::AddTabContext(
    int32_t in_tab_id, bool in_delay_upload, AddTabContextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::AddTabContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delay_upload"), in_delay_upload,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAddTabContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_AddTabContext_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->delay_upload = in_delay_upload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("AddTabContext");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_AddTabContext_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::DeleteContext(
    const ::base::UnguessableToken& in_token, bool in_from_automatic_chip) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::DeleteContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("from_automatic_chip"), in_from_automatic_chip,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_DeleteContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in PageHandler.DeleteContext request");

  params->from_automatic_chip = in_from_automatic_chip;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ClearFiles(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::PageHandler::ClearFiles");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClearFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_ClearFiles_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ClearFiles");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SubmitQuery(
    const std::string& in_query_text, uint8_t in_mouse_button, bool in_alt_key, bool in_ctrl_key, bool in_meta_key, bool in_shift_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::PageHandler::SubmitQuery", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_text"), in_query_text,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mouse_button"), in_mouse_button,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alt_key"), in_alt_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ctrl_key"), in_ctrl_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("meta_key"), in_meta_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shift_key"), in_shift_key,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSubmitQuery), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_SubmitQuery_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query_text)::BaseType> query_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query_text,
    query_text_fragment);

  params->query_text.Set(
      query_text_fragment.is_null() ? nullptr : query_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query_text in PageHandler.SubmitQuery request");

  params->mouse_button = in_mouse_button;

  params->alt_key = in_alt_key;

  params->ctrl_key = in_ctrl_key;

  params->meta_key = in_meta_key;

  params->shift_key = in_shift_key;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SubmitQuery");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenLensSearch(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::PageHandler::OpenLensSearch");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenLensSearch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_OpenLensSearch_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenLensSearch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetPlaceholderConfig_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetPlaceholderConfigCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetPlaceholderConfig_ProxyToResponder> proxy(
        new PageHandler_GetPlaceholderConfig_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetPlaceholderConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetPlaceholderConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetPlaceholderConfig_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetPlaceholderConfigCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PlaceholderConfigPtr in_config);
};

bool PageHandler_GetPlaceholderConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetPlaceholderConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetPlaceholderConfig_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.11
  bool success = true;
  PlaceholderConfigPtr p_config{};
  PageHandler_GetPlaceholderConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_config));
  }
  return true;
}

void PageHandler_GetPlaceholderConfig_ProxyToResponder::Run(
    PlaceholderConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply searchbox::mojom::PageHandler::GetPlaceholderConfig", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type PlaceholderConfigPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetPlaceholderConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_GetPlaceholderConfig_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::PlaceholderConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetPlaceholderConfig");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetRecentTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetRecentTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetRecentTabs_ProxyToResponder> proxy(
        new PageHandler_GetRecentTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetRecentTabs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetRecentTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetRecentTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetRecentTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<TabInfoPtr> in_tabs);
};

bool PageHandler_GetRecentTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetRecentTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetRecentTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.12
  bool success = true;
  std::vector<TabInfoPtr> p_tabs{};
  PageHandler_GetRecentTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTabs(&p_tabs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tabs));
  }
  return true;
}

void PageHandler_GetRecentTabs_ProxyToResponder::Run(
    std::vector<TabInfoPtr> in_tabs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply searchbox::mojom::PageHandler::GetRecentTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tabs"), in_tabs,
                        "<value of type std::vector<TabInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetRecentTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_GetRecentTabs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tabs)::BaseType>
      tabs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::searchbox::mojom::TabInfoDataView>>(
    in_tabs,
    tabs_fragment,
    &tabs_validate_params);

  params->tabs.Set(
      tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tabs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tabs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetRecentTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTabPreview_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabPreviewCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabPreview_ProxyToResponder> proxy(
        new PageHandler_GetTabPreview_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabPreview_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabPreview_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabPreview_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabPreviewCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_preview_data_url);
};

bool PageHandler_GetTabPreview_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabPreview_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabPreview_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.13
  bool success = true;
  std::optional<std::string> p_preview_data_url{};
  PageHandler_GetTabPreview_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPreviewDataUrl(&p_preview_data_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_preview_data_url));
  }
  return true;
}

void PageHandler_GetTabPreview_ProxyToResponder::Run(
    const std::optional<std::string>& in_preview_data_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply searchbox::mojom::PageHandler::GetTabPreview", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview_data_url"), in_preview_data_url,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_GetTabPreview_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->preview_data_url)::BaseType> preview_data_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_preview_data_url,
    preview_data_url_fragment);

  params->preview_data_url.Set(
      preview_data_url_fragment.is_null() ? nullptr : preview_data_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabPreview");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_AddFileContext_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::AddFileContextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_AddFileContext_ProxyToResponder> proxy(
        new PageHandler_AddFileContext_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_AddFileContext_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_AddFileContext_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_AddFileContext_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::AddFileContextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_token);
};

bool PageHandler_AddFileContext_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_AddFileContext_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_AddFileContext_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.16
  bool success = true;
  ::base::UnguessableToken p_token{};
  PageHandler_AddFileContext_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_token));
  }
  return true;
}

void PageHandler_AddFileContext_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply searchbox::mojom::PageHandler::AddFileContext", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAddFileContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_AddFileContext_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("AddFileContext");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_AddTabContext_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::AddTabContextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_AddTabContext_ProxyToResponder> proxy(
        new PageHandler_AddTabContext_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_AddTabContext_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_AddTabContext_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_AddTabContext_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::AddTabContextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::UnguessableToken>& in_token);
};

bool PageHandler_AddTabContext_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_AddTabContext_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_AddTabContext_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.17
  bool success = true;
  std::optional<::base::UnguessableToken> p_token{};
  PageHandler_AddTabContext_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_token));
  }
  return true;
}

void PageHandler_AddTabContext_ProxyToResponder::Run(
    const std::optional<::base::UnguessableToken>& in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply searchbox::mojom::PageHandler::AddTabContext", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAddTabContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::PageHandler_AddTabContext_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("AddTabContext");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kSetPage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      PageHandler_SetPage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPage(        
        std::move(p_page));
      return true;
    }
    case messages::PageHandler::kOnFocusChanged: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnFocusChanged_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnFocusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      bool p_focused{};
      PageHandler_OnFocusChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_focused = input_data_view.focused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFocusChanged(        
        std::move(p_focused));
      return true;
    }
    case messages::PageHandler::kQueryAutocomplete: {
      DCHECK(message->is_serialized());
      internal::PageHandler_QueryAutocomplete_Params_Data* params =
          reinterpret_cast<internal::PageHandler_QueryAutocomplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      ::std::u16string p_input{};
      bool p_prevent_inline_autocomplete{};
      PageHandler_QueryAutocomplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success)
        p_prevent_inline_autocomplete = input_data_view.prevent_inline_autocomplete();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryAutocomplete(        
        std::move(p_input), 
        std::move(p_prevent_inline_autocomplete));
      return true;
    }
    case messages::PageHandler::kStopAutocomplete: {
      DCHECK(message->is_serialized());
      internal::PageHandler_StopAutocomplete_Params_Data* params =
          reinterpret_cast<internal::PageHandler_StopAutocomplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      bool p_clear_result{};
      PageHandler_StopAutocomplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_clear_result = input_data_view.clear_result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopAutocomplete(        
        std::move(p_clear_result));
      return true;
    }
    case messages::PageHandler::kOpenAutocompleteMatch: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenAutocompleteMatch_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenAutocompleteMatch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      uint8_t p_line{};
      ::GURL p_url{};
      bool p_are_matches_showing{};
      uint8_t p_mouse_button{};
      bool p_alt_key{};
      bool p_ctrl_key{};
      bool p_meta_key{};
      bool p_shift_key{};
      PageHandler_OpenAutocompleteMatch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line = input_data_view.line();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_are_matches_showing = input_data_view.are_matches_showing();
      if (success)
        p_mouse_button = input_data_view.mouse_button();
      if (success)
        p_alt_key = input_data_view.alt_key();
      if (success)
        p_ctrl_key = input_data_view.ctrl_key();
      if (success)
        p_meta_key = input_data_view.meta_key();
      if (success)
        p_shift_key = input_data_view.shift_key();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenAutocompleteMatch(        
        std::move(p_line), 
        std::move(p_url), 
        std::move(p_are_matches_showing), 
        std::move(p_mouse_button), 
        std::move(p_alt_key), 
        std::move(p_ctrl_key), 
        std::move(p_meta_key), 
        std::move(p_shift_key));
      return true;
    }
    case messages::PageHandler::kOnNavigationLikely: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnNavigationLikely_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnNavigationLikely_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      uint8_t p_line{};
      ::GURL p_url{};
      ::omnibox::mojom::NavigationPredictor p_navigation_predictor{};
      PageHandler_OnNavigationLikely_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line = input_data_view.line();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNavigationPredictor(&p_navigation_predictor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNavigationLikely(        
        std::move(p_line), 
        std::move(p_url), 
        std::move(p_navigation_predictor));
      return true;
    }
    case messages::PageHandler::kDeleteAutocompleteMatch: {
      DCHECK(message->is_serialized());
      internal::PageHandler_DeleteAutocompleteMatch_Params_Data* params =
          reinterpret_cast<internal::PageHandler_DeleteAutocompleteMatch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      uint8_t p_line{};
      ::GURL p_url{};
      PageHandler_DeleteAutocompleteMatch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line = input_data_view.line();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteAutocompleteMatch(        
        std::move(p_line), 
        std::move(p_url));
      return true;
    }
    case messages::PageHandler::kActivateKeyword: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ActivateKeyword_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ActivateKeyword_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      uint8_t p_line{};
      ::GURL p_url{};
      ::base::TimeTicks p_match_selection_timestamp{};
      bool p_is_mouse_event{};
      PageHandler_ActivateKeyword_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line = input_data_view.line();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadMatchSelectionTimestamp(&p_match_selection_timestamp))
        success = false;
      if (success)
        p_is_mouse_event = input_data_view.is_mouse_event();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateKeyword(        
        std::move(p_line), 
        std::move(p_url), 
        std::move(p_match_selection_timestamp), 
        std::move(p_is_mouse_event));
      return true;
    }
    case messages::PageHandler::kShowContextMenu: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      ::gfx::Point p_point{};
      PageHandler_ShowContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(        
        std::move(p_point));
      return true;
    }
    case messages::PageHandler::kExecuteAction: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ExecuteAction_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ExecuteAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      uint8_t p_line{};
      uint8_t p_action_index{};
      ::GURL p_url{};
      ::base::TimeTicks p_match_selection_timestamp{};
      uint8_t p_mouse_button{};
      bool p_alt_key{};
      bool p_ctrl_key{};
      bool p_meta_key{};
      bool p_shift_key{};
      PageHandler_ExecuteAction_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line = input_data_view.line();
      if (success)
        p_action_index = input_data_view.action_index();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadMatchSelectionTimestamp(&p_match_selection_timestamp))
        success = false;
      if (success)
        p_mouse_button = input_data_view.mouse_button();
      if (success)
        p_alt_key = input_data_view.alt_key();
      if (success)
        p_ctrl_key = input_data_view.ctrl_key();
      if (success)
        p_meta_key = input_data_view.meta_key();
      if (success)
        p_shift_key = input_data_view.shift_key();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteAction(        
        std::move(p_line), 
        std::move(p_action_index), 
        std::move(p_url), 
        std::move(p_match_selection_timestamp), 
        std::move(p_mouse_button), 
        std::move(p_alt_key), 
        std::move(p_ctrl_key), 
        std::move(p_meta_key), 
        std::move(p_shift_key));
      return true;
    }
    case messages::PageHandler::kOnThumbnailRemoved: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnThumbnailRemoved_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnThumbnailRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      PageHandler_OnThumbnailRemoved_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnThumbnailRemoved(        );
      return true;
    }
    case messages::PageHandler::kGetPlaceholderConfig: {
      break;
    }
    case messages::PageHandler::kGetRecentTabs: {
      break;
    }
    case messages::PageHandler::kGetTabPreview: {
      break;
    }
    case messages::PageHandler::kNotifySessionStarted: {
      DCHECK(message->is_serialized());
      internal::PageHandler_NotifySessionStarted_Params_Data* params =
          reinterpret_cast<internal::PageHandler_NotifySessionStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      PageHandler_NotifySessionStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifySessionStarted(        );
      return true;
    }
    case messages::PageHandler::kNotifySessionAbandoned: {
      DCHECK(message->is_serialized());
      internal::PageHandler_NotifySessionAbandoned_Params_Data* params =
          reinterpret_cast<internal::PageHandler_NotifySessionAbandoned_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      PageHandler_NotifySessionAbandoned_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifySessionAbandoned(        );
      return true;
    }
    case messages::PageHandler::kAddFileContext: {
      break;
    }
    case messages::PageHandler::kAddTabContext: {
      break;
    }
    case messages::PageHandler::kDeleteContext: {
      DCHECK(message->is_serialized());
      internal::PageHandler_DeleteContext_Params_Data* params =
          reinterpret_cast<internal::PageHandler_DeleteContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.18
      bool success = true;
      ::base::UnguessableToken p_token{};
      bool p_from_automatic_chip{};
      PageHandler_DeleteContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success)
        p_from_automatic_chip = input_data_view.from_automatic_chip();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteContext(        
        std::move(p_token), 
        std::move(p_from_automatic_chip));
      return true;
    }
    case messages::PageHandler::kClearFiles: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ClearFiles_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ClearFiles_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.19
      bool success = true;
      PageHandler_ClearFiles_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearFiles(        );
      return true;
    }
    case messages::PageHandler::kSubmitQuery: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SubmitQuery_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SubmitQuery_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.20
      bool success = true;
      std::string p_query_text{};
      uint8_t p_mouse_button{};
      bool p_alt_key{};
      bool p_ctrl_key{};
      bool p_meta_key{};
      bool p_shift_key{};
      PageHandler_SubmitQuery_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQueryText(&p_query_text))
        success = false;
      if (success)
        p_mouse_button = input_data_view.mouse_button();
      if (success)
        p_alt_key = input_data_view.alt_key();
      if (success)
        p_ctrl_key = input_data_view.ctrl_key();
      if (success)
        p_meta_key = input_data_view.meta_key();
      if (success)
        p_shift_key = input_data_view.shift_key();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitQuery(        
        std::move(p_query_text), 
        std::move(p_mouse_button), 
        std::move(p_alt_key), 
        std::move(p_ctrl_key), 
        std::move(p_meta_key), 
        std::move(p_shift_key));
      return true;
    }
    case messages::PageHandler::kOpenLensSearch: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenLensSearch_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenLensSearch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.21
      bool success = true;
      PageHandler_OpenLensSearch_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenLensSearch(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kSetPage: {
      break;
    }
    case messages::PageHandler::kOnFocusChanged: {
      break;
    }
    case messages::PageHandler::kQueryAutocomplete: {
      break;
    }
    case messages::PageHandler::kStopAutocomplete: {
      break;
    }
    case messages::PageHandler::kOpenAutocompleteMatch: {
      break;
    }
    case messages::PageHandler::kOnNavigationLikely: {
      break;
    }
    case messages::PageHandler::kDeleteAutocompleteMatch: {
      break;
    }
    case messages::PageHandler::kActivateKeyword: {
      break;
    }
    case messages::PageHandler::kShowContextMenu: {
      break;
    }
    case messages::PageHandler::kExecuteAction: {
      break;
    }
    case messages::PageHandler::kOnThumbnailRemoved: {
      break;
    }
    case messages::PageHandler::kGetPlaceholderConfig: {
      internal::PageHandler_GetPlaceholderConfig_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetPlaceholderConfig_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      PageHandler_GetPlaceholderConfig_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      auto callback =
          PageHandler_GetPlaceholderConfig_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPlaceholderConfig(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetRecentTabs: {
      internal::PageHandler_GetRecentTabs_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetRecentTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      PageHandler_GetRecentTabs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      auto callback =
          PageHandler_GetRecentTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRecentTabs(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTabPreview: {
      internal::PageHandler_GetTabPreview_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabPreview_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      int32_t p_tab_id{};
      PageHandler_GetTabPreview_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabPreview_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabPreview(        
        std::move(p_tab_id), std::move(callback));
      return true;
    }
    case messages::PageHandler::kNotifySessionStarted: {
      break;
    }
    case messages::PageHandler::kNotifySessionAbandoned: {
      break;
    }
    case messages::PageHandler::kAddFileContext: {
      internal::PageHandler_AddFileContext_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_AddFileContext_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.16
      bool success = true;
      SelectedFileInfoPtr p_file_info{};
      ::mojo_base::BigBuffer p_file_bytes{};
      PageHandler_AddFileContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFileInfo(&p_file_info))
        success = false;
      if (success && !input_data_view.ReadFileBytes(&p_file_bytes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 16, false);
        return false;
      }
      auto callback =
          PageHandler_AddFileContext_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFileContext(        
        std::move(p_file_info), 
        std::move(p_file_bytes), std::move(callback));
      return true;
    }
    case messages::PageHandler::kAddTabContext: {
      internal::PageHandler_AddTabContext_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_AddTabContext_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.17
      bool success = true;
      int32_t p_tab_id{};
      bool p_delay_upload{};
      PageHandler_AddTabContext_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_delay_upload = input_data_view.delay_upload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 17, false);
        return false;
      }
      auto callback =
          PageHandler_AddTabContext_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddTabContext(        
        std::move(p_tab_id), 
        std::move(p_delay_upload), std::move(callback));
      return true;
    }
    case messages::PageHandler::kDeleteContext: {
      break;
    }
    case messages::PageHandler::kClearFiles: {
      break;
    }
    case messages::PageHandler::kSubmitQuery: {
      break;
    }
    case messages::PageHandler::kOpenLensSearch: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_SetPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnFocusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_QueryAutocomplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_StopAutocomplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenAutocompleteMatch_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnNavigationLikely_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_DeleteAutocompleteMatch_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ActivateKeyword_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ExecuteAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnThumbnailRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetPlaceholderConfig_Params_Data::Validate,
     &internal::PageHandler_GetPlaceholderConfig_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetRecentTabs_Params_Data::Validate,
     &internal::PageHandler_GetRecentTabs_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTabPreview_Params_Data::Validate,
     &internal::PageHandler_GetTabPreview_ResponseParams_Data::Validate},
    { &internal::PageHandler_NotifySessionStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_NotifySessionAbandoned_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_AddFileContext_Params_Data::Validate,
     &internal::PageHandler_AddFileContext_ResponseParams_Data::Validate},
    { &internal::PageHandler_AddTabContext_Params_Data::Validate,
     &internal::PageHandler_AddTabContext_ResponseParams_Data::Validate},
    { &internal::PageHandler_DeleteContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ClearFiles_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SubmitQuery_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenLensSearch_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::searchbox::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::searchbox::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kAutocompleteResultChanged: {
      return &Page::AutocompleteResultChanged_Sym::IPCStableHash;
    }
    case messages::Page::kUpdateSelection: {
      return &Page::UpdateSelection_Sym::IPCStableHash;
    }
    case messages::Page::kSetKeywordSelected: {
      return &Page::SetKeywordSelected_Sym::IPCStableHash;
    }
    case messages::Page::kOnShow: {
      return &Page::OnShow_Sym::IPCStableHash;
    }
    case messages::Page::kSetInputText: {
      return &Page::SetInputText_Sym::IPCStableHash;
    }
    case messages::Page::kSetThumbnail: {
      return &Page::SetThumbnail_Sym::IPCStableHash;
    }
    case messages::Page::kOnContextualInputStatusChanged: {
      return &Page::OnContextualInputStatusChanged_Sym::IPCStableHash;
    }
    case messages::Page::kOnTabStripChanged: {
      return &Page::OnTabStripChanged_Sym::IPCStableHash;
    }
    case messages::Page::kAddFileContext: {
      return &Page::AddFileContext_Sym::IPCStableHash;
    }
    case messages::Page::kUpdateAutoSuggestedTabContext: {
      return &Page::UpdateAutoSuggestedTabContext_Sym::IPCStableHash;
    }
    case messages::Page::kUpdateLensSearchEligibility: {
      return &Page::UpdateLensSearchEligibility_Sym::IPCStableHash;
    }
    case messages::Page::kUpdateContentSharingPolicy: {
      return &Page::UpdateContentSharingPolicy_Sym::IPCStableHash;
    }
    case messages::Page::kUpdateAimEligibility: {
      return &Page::UpdateAimEligibility_Sym::IPCStableHash;
    }
    case messages::Page::kOnShowAiModePrefChanged: {
      return &Page::OnShowAiModePrefChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kAutocompleteResultChanged:
            return "Receive searchbox::mojom::Page::AutocompleteResultChanged";
      case messages::Page::kUpdateSelection:
            return "Receive searchbox::mojom::Page::UpdateSelection";
      case messages::Page::kSetKeywordSelected:
            return "Receive searchbox::mojom::Page::SetKeywordSelected";
      case messages::Page::kOnShow:
            return "Receive searchbox::mojom::Page::OnShow";
      case messages::Page::kSetInputText:
            return "Receive searchbox::mojom::Page::SetInputText";
      case messages::Page::kSetThumbnail:
            return "Receive searchbox::mojom::Page::SetThumbnail";
      case messages::Page::kOnContextualInputStatusChanged:
            return "Receive searchbox::mojom::Page::OnContextualInputStatusChanged";
      case messages::Page::kOnTabStripChanged:
            return "Receive searchbox::mojom::Page::OnTabStripChanged";
      case messages::Page::kAddFileContext:
            return "Receive searchbox::mojom::Page::AddFileContext";
      case messages::Page::kUpdateAutoSuggestedTabContext:
            return "Receive searchbox::mojom::Page::UpdateAutoSuggestedTabContext";
      case messages::Page::kUpdateLensSearchEligibility:
            return "Receive searchbox::mojom::Page::UpdateLensSearchEligibility";
      case messages::Page::kUpdateContentSharingPolicy:
            return "Receive searchbox::mojom::Page::UpdateContentSharingPolicy";
      case messages::Page::kUpdateAimEligibility:
            return "Receive searchbox::mojom::Page::UpdateAimEligibility";
      case messages::Page::kOnShowAiModePrefChanged:
            return "Receive searchbox::mojom::Page::OnShowAiModePrefChanged";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kAutocompleteResultChanged:
            return "Receive reply searchbox::mojom::Page::AutocompleteResultChanged";
      case messages::Page::kUpdateSelection:
            return "Receive reply searchbox::mojom::Page::UpdateSelection";
      case messages::Page::kSetKeywordSelected:
            return "Receive reply searchbox::mojom::Page::SetKeywordSelected";
      case messages::Page::kOnShow:
            return "Receive reply searchbox::mojom::Page::OnShow";
      case messages::Page::kSetInputText:
            return "Receive reply searchbox::mojom::Page::SetInputText";
      case messages::Page::kSetThumbnail:
            return "Receive reply searchbox::mojom::Page::SetThumbnail";
      case messages::Page::kOnContextualInputStatusChanged:
            return "Receive reply searchbox::mojom::Page::OnContextualInputStatusChanged";
      case messages::Page::kOnTabStripChanged:
            return "Receive reply searchbox::mojom::Page::OnTabStripChanged";
      case messages::Page::kAddFileContext:
            return "Receive reply searchbox::mojom::Page::AddFileContext";
      case messages::Page::kUpdateAutoSuggestedTabContext:
            return "Receive reply searchbox::mojom::Page::UpdateAutoSuggestedTabContext";
      case messages::Page::kUpdateLensSearchEligibility:
            return "Receive reply searchbox::mojom::Page::UpdateLensSearchEligibility";
      case messages::Page::kUpdateContentSharingPolicy:
            return "Receive reply searchbox::mojom::Page::UpdateContentSharingPolicy";
      case messages::Page::kUpdateAimEligibility:
            return "Receive reply searchbox::mojom::Page::UpdateAimEligibility";
      case messages::Page::kOnShowAiModePrefChanged:
            return "Receive reply searchbox::mojom::Page::OnShowAiModePrefChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::AutocompleteResultChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b5727d3;  // IPCStableHash for searchbox::mojom::Page::AutocompleteResultChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::UpdateSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c7adb12;  // IPCStableHash for searchbox::mojom::Page::UpdateSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetKeywordSelected_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54e25a4d;  // IPCStableHash for searchbox::mojom::Page::SetKeywordSelected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnShow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a323825;  // IPCStableHash for searchbox::mojom::Page::OnShow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetInputText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c13d576;  // IPCStableHash for searchbox::mojom::Page::SetInputText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetThumbnail_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe735810;  // IPCStableHash for searchbox::mojom::Page::SetThumbnail
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnContextualInputStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e45290a;  // IPCStableHash for searchbox::mojom::Page::OnContextualInputStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnTabStripChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb733355;  // IPCStableHash for searchbox::mojom::Page::OnTabStripChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::AddFileContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5212bef8;  // IPCStableHash for searchbox::mojom::Page::AddFileContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::UpdateAutoSuggestedTabContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc626d1e9;  // IPCStableHash for searchbox::mojom::Page::UpdateAutoSuggestedTabContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::UpdateLensSearchEligibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8dc555ae;  // IPCStableHash for searchbox::mojom::Page::UpdateLensSearchEligibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::UpdateContentSharingPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xefeecd7f;  // IPCStableHash for searchbox::mojom::Page::UpdateContentSharingPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::UpdateAimEligibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60238770;  // IPCStableHash for searchbox::mojom::Page::UpdateAimEligibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnShowAiModePrefChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0caed946;  // IPCStableHash for searchbox::mojom::Page::OnShowAiModePrefChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::AutocompleteResultChanged(
    AutocompleteResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::AutocompleteResultChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type AutocompleteResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kAutocompleteResultChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_AutocompleteResultChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::AutocompleteResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in Page.AutocompleteResultChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("AutocompleteResultChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::UpdateSelection(
    OmniboxPopupSelectionPtr in_old_selection, OmniboxPopupSelectionPtr in_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::UpdateSelection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_selection"), in_old_selection,
                        "<value of type OmniboxPopupSelectionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection"), in_selection,
                        "<value of type OmniboxPopupSelectionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kUpdateSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_UpdateSelection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_selection)::BaseType> old_selection_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::OmniboxPopupSelectionDataView>(
    in_old_selection,
    old_selection_fragment);

  params->old_selection.Set(
      old_selection_fragment.is_null() ? nullptr : old_selection_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->old_selection.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null old_selection in Page.UpdateSelection request");
  mojo::internal::MessageFragment<
      typename decltype(params->selection)::BaseType> selection_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::OmniboxPopupSelectionDataView>(
    in_selection,
    selection_fragment);

  params->selection.Set(
      selection_fragment.is_null() ? nullptr : selection_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->selection.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null selection in Page.UpdateSelection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("UpdateSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetKeywordSelected(
    bool in_is_keyword_selected) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::SetKeywordSelected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_keyword_selected"), in_is_keyword_selected,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetKeywordSelected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_SetKeywordSelected_Params_Data> params(
          message);
  params.Allocate();

  params->is_keyword_selected = in_is_keyword_selected;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetKeywordSelected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnShow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::Page::OnShow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_OnShow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnShow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetInputText(
    const std::string& in_input) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::SetInputText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetInputText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_SetInputText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in Page.SetInputText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetInputText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetThumbnail(
    const std::string& in_thumbnail_url, bool in_is_deletable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::SetThumbnail", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thumbnail_url"), in_thumbnail_url,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_deletable"), in_is_deletable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetThumbnail), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_SetThumbnail_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->thumbnail_url)::BaseType> thumbnail_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_thumbnail_url,
    thumbnail_url_fragment);

  params->thumbnail_url.Set(
      thumbnail_url_fragment.is_null() ? nullptr : thumbnail_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->thumbnail_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null thumbnail_url in Page.SetThumbnail request");

  params->is_deletable = in_is_deletable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetThumbnail");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnContextualInputStatusChanged(
    const ::base::UnguessableToken& in_token, ::composebox_query::mojom::FileUploadStatus in_status, std::optional<::composebox_query::mojom::FileUploadErrorType> in_error_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::OnContextualInputStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::composebox_query::mojom::FileUploadStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_type"), in_error_type,
                        "<value of type std::optional<::composebox_query::mojom::FileUploadErrorType>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnContextualInputStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_OnContextualInputStatusChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in Page.OnContextualInputStatusChanged request");

  
  mojo::internal::Serialize<::composebox_query::mojom::FileUploadStatus>(
    in_status,
    &params->status);
  params->error_type_$flag = in_error_type.has_value();
  if (in_error_type.has_value()) {
    
    mojo::internal::Serialize<::composebox_query::mojom::FileUploadErrorType>(
      in_error_type.value(),
      &params->error_type_$value);
  } else {
    params->error_type_$value =
        static_cast<int32_t>(::composebox_query::mojom::FileUploadErrorType::kMinValue);
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnContextualInputStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnTabStripChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send searchbox::mojom::Page::OnTabStripChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnTabStripChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_OnTabStripChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnTabStripChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::AddFileContext(
    const ::base::UnguessableToken& in_token, SelectedFileInfoPtr in_file_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::AddFileContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_info"), in_file_info,
                        "<value of type SelectedFileInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kAddFileContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_AddFileContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in Page.AddFileContext request");
  mojo::internal::MessageFragment<
      typename decltype(params->file_info)::BaseType> file_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::SelectedFileInfoDataView>(
    in_file_info,
    file_info_fragment);

  params->file_info.Set(
      file_info_fragment.is_null() ? nullptr : file_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_info in Page.AddFileContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("AddFileContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::UpdateAutoSuggestedTabContext(
    TabInfoPtr in_tab) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::UpdateAutoSuggestedTabContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab"), in_tab,
                        "<value of type TabInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kUpdateAutoSuggestedTabContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_UpdateAutoSuggestedTabContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab)::BaseType> tab_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::TabInfoDataView>(
    in_tab,
    tab_fragment);

  params->tab.Set(
      tab_fragment.is_null() ? nullptr : tab_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("UpdateAutoSuggestedTabContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::UpdateLensSearchEligibility(
    bool in_eligible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::UpdateLensSearchEligibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("eligible"), in_eligible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kUpdateLensSearchEligibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_UpdateLensSearchEligibility_Params_Data> params(
          message);
  params.Allocate();

  params->eligible = in_eligible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("UpdateLensSearchEligibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::UpdateContentSharingPolicy(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::UpdateContentSharingPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kUpdateContentSharingPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_UpdateContentSharingPolicy_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("UpdateContentSharingPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::UpdateAimEligibility(
    bool in_eligible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::UpdateAimEligibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("eligible"), in_eligible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kUpdateAimEligibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_UpdateAimEligibility_Params_Data> params(
          message);
  params.Allocate();

  params->eligible = in_eligible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("UpdateAimEligibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnShowAiModePrefChanged(
    bool in_canShow) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send searchbox::mojom::Page::OnShowAiModePrefChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("canShow"), in_canShow,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnShowAiModePrefChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::searchbox::mojom::internal::Page_OnShowAiModePrefChanged_Params_Data> params(
          message);
  params.Allocate();

  params->canShow = in_canShow;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnShowAiModePrefChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kAutocompleteResultChanged: {
      DCHECK(message->is_serialized());
      internal::Page_AutocompleteResultChanged_Params_Data* params =
          reinterpret_cast<internal::Page_AutocompleteResultChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      AutocompleteResultPtr p_result{};
      Page_AutocompleteResultChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AutocompleteResultChanged(        
        std::move(p_result));
      return true;
    }
    case messages::Page::kUpdateSelection: {
      DCHECK(message->is_serialized());
      internal::Page_UpdateSelection_Params_Data* params =
          reinterpret_cast<internal::Page_UpdateSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      OmniboxPopupSelectionPtr p_old_selection{};
      OmniboxPopupSelectionPtr p_selection{};
      Page_UpdateSelection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOldSelection(&p_old_selection))
        success = false;
      if (success && !input_data_view.ReadSelection(&p_selection))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSelection(        
        std::move(p_old_selection), 
        std::move(p_selection));
      return true;
    }
    case messages::Page::kSetKeywordSelected: {
      DCHECK(message->is_serialized());
      internal::Page_SetKeywordSelected_Params_Data* params =
          reinterpret_cast<internal::Page_SetKeywordSelected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      bool p_is_keyword_selected{};
      Page_SetKeywordSelected_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_keyword_selected = input_data_view.is_keyword_selected();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetKeywordSelected(        
        std::move(p_is_keyword_selected));
      return true;
    }
    case messages::Page::kOnShow: {
      DCHECK(message->is_serialized());
      internal::Page_OnShow_Params_Data* params =
          reinterpret_cast<internal::Page_OnShow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      Page_OnShow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShow(        );
      return true;
    }
    case messages::Page::kSetInputText: {
      DCHECK(message->is_serialized());
      internal::Page_SetInputText_Params_Data* params =
          reinterpret_cast<internal::Page_SetInputText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.4
      bool success = true;
      std::string p_input{};
      Page_SetInputText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInputText(        
        std::move(p_input));
      return true;
    }
    case messages::Page::kSetThumbnail: {
      DCHECK(message->is_serialized());
      internal::Page_SetThumbnail_Params_Data* params =
          reinterpret_cast<internal::Page_SetThumbnail_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.5
      bool success = true;
      std::string p_thumbnail_url{};
      bool p_is_deletable{};
      Page_SetThumbnail_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThumbnailUrl(&p_thumbnail_url))
        success = false;
      if (success)
        p_is_deletable = input_data_view.is_deletable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetThumbnail(        
        std::move(p_thumbnail_url), 
        std::move(p_is_deletable));
      return true;
    }
    case messages::Page::kOnContextualInputStatusChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnContextualInputStatusChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnContextualInputStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.6
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::composebox_query::mojom::FileUploadStatus p_status{};
      std::optional<::composebox_query::mojom::FileUploadErrorType> p_error_type{};
      Page_OnContextualInputStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (success && !input_data_view.ReadErrorType(&p_error_type)) {
        success = false;
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnContextualInputStatusChanged(        
        std::move(p_token), 
        std::move(p_status), 
        std::move(p_error_type));
      return true;
    }
    case messages::Page::kOnTabStripChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnTabStripChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnTabStripChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.7
      bool success = true;
      Page_OnTabStripChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTabStripChanged(        );
      return true;
    }
    case messages::Page::kAddFileContext: {
      DCHECK(message->is_serialized());
      internal::Page_AddFileContext_Params_Data* params =
          reinterpret_cast<internal::Page_AddFileContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.8
      bool success = true;
      ::base::UnguessableToken p_token{};
      SelectedFileInfoPtr p_file_info{};
      Page_AddFileContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadFileInfo(&p_file_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFileContext(        
        std::move(p_token), 
        std::move(p_file_info));
      return true;
    }
    case messages::Page::kUpdateAutoSuggestedTabContext: {
      DCHECK(message->is_serialized());
      internal::Page_UpdateAutoSuggestedTabContext_Params_Data* params =
          reinterpret_cast<internal::Page_UpdateAutoSuggestedTabContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.9
      bool success = true;
      TabInfoPtr p_tab{};
      Page_UpdateAutoSuggestedTabContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTab(&p_tab))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAutoSuggestedTabContext(        
        std::move(p_tab));
      return true;
    }
    case messages::Page::kUpdateLensSearchEligibility: {
      DCHECK(message->is_serialized());
      internal::Page_UpdateLensSearchEligibility_Params_Data* params =
          reinterpret_cast<internal::Page_UpdateLensSearchEligibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.10
      bool success = true;
      bool p_eligible{};
      Page_UpdateLensSearchEligibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_eligible = input_data_view.eligible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateLensSearchEligibility(        
        std::move(p_eligible));
      return true;
    }
    case messages::Page::kUpdateContentSharingPolicy: {
      DCHECK(message->is_serialized());
      internal::Page_UpdateContentSharingPolicy_Params_Data* params =
          reinterpret_cast<internal::Page_UpdateContentSharingPolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.11
      bool success = true;
      bool p_enabled{};
      Page_UpdateContentSharingPolicy_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateContentSharingPolicy(        
        std::move(p_enabled));
      return true;
    }
    case messages::Page::kUpdateAimEligibility: {
      DCHECK(message->is_serialized());
      internal::Page_UpdateAimEligibility_Params_Data* params =
          reinterpret_cast<internal::Page_UpdateAimEligibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.12
      bool success = true;
      bool p_eligible{};
      Page_UpdateAimEligibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_eligible = input_data_view.eligible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAimEligibility(        
        std::move(p_eligible));
      return true;
    }
    case messages::Page::kOnShowAiModePrefChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnShowAiModePrefChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnShowAiModePrefChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.13
      bool success = true;
      bool p_canShow{};
      Page_OnShowAiModePrefChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_canShow = input_data_view.canShow();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShowAiModePrefChanged(        
        std::move(p_canShow));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kAutocompleteResultChanged: {
      break;
    }
    case messages::Page::kUpdateSelection: {
      break;
    }
    case messages::Page::kSetKeywordSelected: {
      break;
    }
    case messages::Page::kOnShow: {
      break;
    }
    case messages::Page::kSetInputText: {
      break;
    }
    case messages::Page::kSetThumbnail: {
      break;
    }
    case messages::Page::kOnContextualInputStatusChanged: {
      break;
    }
    case messages::Page::kOnTabStripChanged: {
      break;
    }
    case messages::Page::kAddFileContext: {
      break;
    }
    case messages::Page::kUpdateAutoSuggestedTabContext: {
      break;
    }
    case messages::Page::kUpdateLensSearchEligibility: {
      break;
    }
    case messages::Page::kUpdateContentSharingPolicy: {
      break;
    }
    case messages::Page::kUpdateAimEligibility: {
      break;
    }
    case messages::Page::kOnShowAiModePrefChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_AutocompleteResultChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_UpdateSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetKeywordSelected_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnShow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetInputText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetThumbnail_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnContextualInputStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnTabStripChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_AddFileContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_UpdateAutoSuggestedTabContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_UpdateLensSearchEligibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_UpdateContentSharingPolicy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_UpdateAimEligibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnShowAiModePrefChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::searchbox::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // searchbox::mojom


namespace mojo {


// static
bool StructTraits<::searchbox::mojom::ACMatchClassification::DataView, ::searchbox::mojom::ACMatchClassificationPtr>::Read(
    ::searchbox::mojom::ACMatchClassification::DataView input,
    ::searchbox::mojom::ACMatchClassificationPtr* output) {
  bool success = true;
  ::searchbox::mojom::ACMatchClassificationPtr result(::searchbox::mojom::ACMatchClassification::New());
  
      if (success)
        result->offset = input.offset();
      if (success)
        result->style = input.style();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::Action::DataView, ::searchbox::mojom::ActionPtr>::Read(
    ::searchbox::mojom::Action::DataView input,
    ::searchbox::mojom::ActionPtr* output) {
  bool success = true;
  ::searchbox::mojom::ActionPtr result(::searchbox::mojom::Action::New());
  
      if (success && !input.ReadHint(&result->hint))
        success = false;
      if (success && !input.ReadSuggestionContents(&result->suggestion_contents))
        success = false;
      if (success && !input.ReadIconPath(&result->icon_path))
        success = false;
      if (success && !input.ReadA11yLabel(&result->a11y_label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::SuggestionAnswer::DataView, ::searchbox::mojom::SuggestionAnswerPtr>::Read(
    ::searchbox::mojom::SuggestionAnswer::DataView input,
    ::searchbox::mojom::SuggestionAnswerPtr* output) {
  bool success = true;
  ::searchbox::mojom::SuggestionAnswerPtr result(::searchbox::mojom::SuggestionAnswer::New());
  
      if (success && !input.ReadFirstLine(&result->first_line))
        success = false;
      if (success && !input.ReadSecondLine(&result->second_line))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::AutocompleteMatch::DataView, ::searchbox::mojom::AutocompleteMatchPtr>::Read(
    ::searchbox::mojom::AutocompleteMatch::DataView input,
    ::searchbox::mojom::AutocompleteMatchPtr* output) {
  bool success = true;
  ::searchbox::mojom::AutocompleteMatchPtr result(::searchbox::mojom::AutocompleteMatch::New());
  
      if (success)
        result->is_hidden = input.is_hidden();
      if (success && !input.ReadA11yLabel(&result->a11y_label))
        success = false;
      if (success)
        result->allowed_to_be_default_match = input.allowed_to_be_default_match();
      if (success && !input.ReadActions(&result->actions))
        success = false;
      if (success && !input.ReadAnswer(&result->answer))
        success = false;
      if (success && !input.ReadContents(&result->contents))
        success = false;
      if (success && !input.ReadContentsClass(&result->contents_class))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadDescriptionClass(&result->description_class))
        success = false;
      if (success && !input.ReadDestinationUrl(&result->destination_url))
        success = false;
      if (success && !input.ReadInlineAutocompletion(&result->inline_autocompletion))
        success = false;
      if (success && !input.ReadFillIntoEdit(&result->fill_into_edit))
        success = false;
      if (success) {
        result->is_weather_answer_suggestion = input.is_weather_answer_suggestion();
      }
      if (success && !input.ReadIconPath(&result->icon_path))
        success = false;
      if (success && !input.ReadIconUrl(&result->icon_url))
        success = false;
      if (success && !input.ReadImageDominantColor(&result->image_dominant_color))
        success = false;
      if (success && !input.ReadImageUrl(&result->image_url))
        success = false;
      if (success)
        result->is_noncanned_aim_suggestion = input.is_noncanned_aim_suggestion();
      if (success)
        result->is_rich_suggestion = input.is_rich_suggestion();
      if (success)
        result->is_search_type = input.is_search_type();
      if (success)
        result->is_enterprise_search_aggregator_people_type = input.is_enterprise_search_aggregator_people_type();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadRemoveButtonA11yLabel(&result->remove_button_a11y_label))
        success = false;
      if (success)
        result->swap_contents_and_description = input.swap_contents_and_description();
      if (success)
        result->suggestion_group_id = input.suggestion_group_id();
      if (success)
        result->supports_deletion = input.supports_deletion();
      if (success && !input.ReadTailSuggestCommonPrefix(&result->tail_suggest_common_prefix))
        success = false;
      if (success)
        result->has_instant_keyword = input.has_instant_keyword();
      if (success && !input.ReadKeywordChipHint(&result->keyword_chip_hint))
        success = false;
      if (success && !input.ReadKeywordChipA11y(&result->keyword_chip_a11y))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::TabInfo::DataView, ::searchbox::mojom::TabInfoPtr>::Read(
    ::searchbox::mojom::TabInfo::DataView input,
    ::searchbox::mojom::TabInfoPtr* output) {
  bool success = true;
  ::searchbox::mojom::TabInfoPtr result(::searchbox::mojom::TabInfo::New());
  
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->show_in_current_tab_chip = input.show_in_current_tab_chip();
      if (success)
        result->show_in_previous_tab_chip = input.show_in_previous_tab_chip();
      if (success && !input.ReadLastActive(&result->last_active))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::FileAttachment::DataView, ::searchbox::mojom::FileAttachmentPtr>::Read(
    ::searchbox::mojom::FileAttachment::DataView input,
    ::searchbox::mojom::FileAttachmentPtr* output) {
  bool success = true;
  ::searchbox::mojom::FileAttachmentPtr result(::searchbox::mojom::FileAttachment::New());
  
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadImageDataUrl(&result->image_data_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::TabAttachment::DataView, ::searchbox::mojom::TabAttachmentPtr>::Read(
    ::searchbox::mojom::TabAttachment::DataView input,
    ::searchbox::mojom::TabAttachmentPtr* output) {
  bool success = true;
  ::searchbox::mojom::TabAttachmentPtr result(::searchbox::mojom::TabAttachment::New());
  
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::SearchContext::DataView, ::searchbox::mojom::SearchContextPtr>::Read(
    ::searchbox::mojom::SearchContext::DataView input,
    ::searchbox::mojom::SearchContextPtr* output) {
  bool success = true;
  ::searchbox::mojom::SearchContextPtr result(::searchbox::mojom::SearchContext::New());
  
      if (success && !input.ReadInput(&result->input))
        success = false;
      if (success && !input.ReadAttachments(&result->attachments))
        success = false;
      if (success && !input.ReadToolMode(&result->tool_mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::SelectedFileInfo::DataView, ::searchbox::mojom::SelectedFileInfoPtr>::Read(
    ::searchbox::mojom::SelectedFileInfo::DataView input,
    ::searchbox::mojom::SelectedFileInfoPtr* output) {
  bool success = true;
  ::searchbox::mojom::SelectedFileInfoPtr result(::searchbox::mojom::SelectedFileInfo::New());
  
      if (success && !input.ReadFileName(&result->file_name))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadImageDataUrl(&result->image_data_url))
        success = false;
      if (success)
        result->is_deletable = input.is_deletable();
      if (success && !input.ReadSelectionTime(&result->selection_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::SuggestionGroup::DataView, ::searchbox::mojom::SuggestionGroupPtr>::Read(
    ::searchbox::mojom::SuggestionGroup::DataView input,
    ::searchbox::mojom::SuggestionGroupPtr* output) {
  bool success = true;
  ::searchbox::mojom::SuggestionGroupPtr result(::searchbox::mojom::SuggestionGroup::New());
  
      if (success && !input.ReadHeader(&result->header))
        success = false;
      if (success && !input.ReadRenderType(&result->render_type))
        success = false;
      if (success && !input.ReadSideType(&result->side_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::AutocompleteResult::DataView, ::searchbox::mojom::AutocompleteResultPtr>::Read(
    ::searchbox::mojom::AutocompleteResult::DataView input,
    ::searchbox::mojom::AutocompleteResultPtr* output) {
  bool success = true;
  ::searchbox::mojom::AutocompleteResultPtr result(::searchbox::mojom::AutocompleteResult::New());
  
      if (success && !input.ReadInput(&result->input))
        success = false;
      if (success && !input.ReadSuggestionGroupsMap(&result->suggestion_groups_map))
        success = false;
      if (success && !input.ReadMatches(&result->matches))
        success = false;
      if (success && !input.ReadSmartComposeInlineHint(&result->smart_compose_inline_hint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::OmniboxPopupSelection::DataView, ::searchbox::mojom::OmniboxPopupSelectionPtr>::Read(
    ::searchbox::mojom::OmniboxPopupSelection::DataView input,
    ::searchbox::mojom::OmniboxPopupSelectionPtr* output) {
  bool success = true;
  ::searchbox::mojom::OmniboxPopupSelectionPtr result(::searchbox::mojom::OmniboxPopupSelection::New());
  
      if (success)
        result->line = input.line();
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->action_index = input.action_index();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::searchbox::mojom::PlaceholderConfig::DataView, ::searchbox::mojom::PlaceholderConfigPtr>::Read(
    ::searchbox::mojom::PlaceholderConfig::DataView input,
    ::searchbox::mojom::PlaceholderConfigPtr* output) {
  bool success = true;
  ::searchbox::mojom::PlaceholderConfigPtr result(::searchbox::mojom::PlaceholderConfig::New());
  
      if (success && !input.ReadTexts(&result->texts))
        success = false;
      if (success && !input.ReadChangeTextAnimationInterval(&result->change_text_animation_interval))
        success = false;
      if (success && !input.ReadFadeTextAnimationDuration(&result->fade_text_animation_duration))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::searchbox::mojom::SearchContextAttachment::DataView, ::searchbox::mojom::SearchContextAttachmentPtr>::Read(
    ::searchbox::mojom::SearchContextAttachment::DataView input,
    ::searchbox::mojom::SearchContextAttachmentPtr* output) {
  using UnionType = ::searchbox::mojom::SearchContextAttachment;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFileAttachment: {
      ::searchbox::mojom::FileAttachmentPtr result_file_attachment{};
      if (!input.ReadFileAttachment(&result_file_attachment))
        return false;

      *output = UnionType::NewFileAttachment(
          std::move(result_file_attachment));
      break;
    }
    case Tag::kTabAttachment: {
      ::searchbox::mojom::TabAttachmentPtr result_tab_attachment{};
      if (!input.ReadTabAttachment(&result_tab_attachment))
        return false;

      *output = UnionType::NewTabAttachment(
          std::move(result_tab_attachment));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace searchbox::mojom {


void PageHandlerInterceptorForTesting::SetPage(::mojo::PendingRemote<Page> page) {
  GetForwardingInterface()->SetPage(
    std::move(page)
    );
}
void PageHandlerInterceptorForTesting::OnFocusChanged(bool focused) {
  GetForwardingInterface()->OnFocusChanged(
    std::move(focused)
    );
}
void PageHandlerInterceptorForTesting::QueryAutocomplete(const ::std::u16string& input, bool prevent_inline_autocomplete) {
  GetForwardingInterface()->QueryAutocomplete(
    std::move(input)
    , 
    std::move(prevent_inline_autocomplete)
    );
}
void PageHandlerInterceptorForTesting::StopAutocomplete(bool clear_result) {
  GetForwardingInterface()->StopAutocomplete(
    std::move(clear_result)
    );
}
void PageHandlerInterceptorForTesting::OpenAutocompleteMatch(uint8_t line, const ::GURL& url, bool are_matches_showing, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) {
  GetForwardingInterface()->OpenAutocompleteMatch(
    std::move(line)
    , 
    std::move(url)
    , 
    std::move(are_matches_showing)
    , 
    std::move(mouse_button)
    , 
    std::move(alt_key)
    , 
    std::move(ctrl_key)
    , 
    std::move(meta_key)
    , 
    std::move(shift_key)
    );
}
void PageHandlerInterceptorForTesting::OnNavigationLikely(uint8_t line, const ::GURL& url, ::omnibox::mojom::NavigationPredictor navigation_predictor) {
  GetForwardingInterface()->OnNavigationLikely(
    std::move(line)
    , 
    std::move(url)
    , 
    std::move(navigation_predictor)
    );
}
void PageHandlerInterceptorForTesting::DeleteAutocompleteMatch(uint8_t line, const ::GURL& url) {
  GetForwardingInterface()->DeleteAutocompleteMatch(
    std::move(line)
    , 
    std::move(url)
    );
}
void PageHandlerInterceptorForTesting::ActivateKeyword(uint8_t line, const ::GURL& url, ::base::TimeTicks match_selection_timestamp, bool is_mouse_event) {
  GetForwardingInterface()->ActivateKeyword(
    std::move(line)
    , 
    std::move(url)
    , 
    std::move(match_selection_timestamp)
    , 
    std::move(is_mouse_event)
    );
}
void PageHandlerInterceptorForTesting::ShowContextMenu(const ::gfx::Point& point) {
  GetForwardingInterface()->ShowContextMenu(
    std::move(point)
    );
}
void PageHandlerInterceptorForTesting::ExecuteAction(uint8_t line, uint8_t action_index, const ::GURL& url, ::base::TimeTicks match_selection_timestamp, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) {
  GetForwardingInterface()->ExecuteAction(
    std::move(line)
    , 
    std::move(action_index)
    , 
    std::move(url)
    , 
    std::move(match_selection_timestamp)
    , 
    std::move(mouse_button)
    , 
    std::move(alt_key)
    , 
    std::move(ctrl_key)
    , 
    std::move(meta_key)
    , 
    std::move(shift_key)
    );
}
void PageHandlerInterceptorForTesting::OnThumbnailRemoved() {
  GetForwardingInterface()->OnThumbnailRemoved();
}
void PageHandlerInterceptorForTesting::GetPlaceholderConfig(GetPlaceholderConfigCallback callback) {
  GetForwardingInterface()->GetPlaceholderConfig(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetRecentTabs(GetRecentTabsCallback callback) {
  GetForwardingInterface()->GetRecentTabs(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTabPreview(int32_t tab_id, GetTabPreviewCallback callback) {
  GetForwardingInterface()->GetTabPreview(
    std::move(tab_id)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::NotifySessionStarted() {
  GetForwardingInterface()->NotifySessionStarted();
}
void PageHandlerInterceptorForTesting::NotifySessionAbandoned() {
  GetForwardingInterface()->NotifySessionAbandoned();
}
void PageHandlerInterceptorForTesting::AddFileContext(SelectedFileInfoPtr file_info, ::mojo_base::BigBuffer file_bytes, AddFileContextCallback callback) {
  GetForwardingInterface()->AddFileContext(
    std::move(file_info)
    , 
    std::move(file_bytes)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::AddTabContext(int32_t tab_id, bool delay_upload, AddTabContextCallback callback) {
  GetForwardingInterface()->AddTabContext(
    std::move(tab_id)
    , 
    std::move(delay_upload)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::DeleteContext(const ::base::UnguessableToken& token, bool from_automatic_chip) {
  GetForwardingInterface()->DeleteContext(
    std::move(token)
    , 
    std::move(from_automatic_chip)
    );
}
void PageHandlerInterceptorForTesting::ClearFiles() {
  GetForwardingInterface()->ClearFiles();
}
void PageHandlerInterceptorForTesting::SubmitQuery(const std::string& query_text, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) {
  GetForwardingInterface()->SubmitQuery(
    std::move(query_text)
    , 
    std::move(mouse_button)
    , 
    std::move(alt_key)
    , 
    std::move(ctrl_key)
    , 
    std::move(meta_key)
    , 
    std::move(shift_key)
    );
}
void PageHandlerInterceptorForTesting::OpenLensSearch() {
  GetForwardingInterface()->OpenLensSearch();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetPlaceholderConfig(
    PlaceholderConfigPtr* out_config) {
  base::RunLoop loop;
  proxy_->GetPlaceholderConfig(
      base::BindOnce(
          [](base::RunLoop* loop,
             PlaceholderConfigPtr* out_config
,
             PlaceholderConfigPtr config) {*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_config));
  loop.Run();
}

PlaceholderConfigPtr PageHandlerAsyncWaiter::GetPlaceholderConfig(
    ) {
  PlaceholderConfigPtr async_wait_result;
  GetPlaceholderConfig(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetRecentTabs(
    std::vector<TabInfoPtr>* out_tabs) {
  base::RunLoop loop;
  proxy_->GetRecentTabs(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<TabInfoPtr>* out_tabs
,
             std::vector<TabInfoPtr> tabs) {*out_tabs = std::move(tabs);
            loop->Quit();
          },
          &loop,
          out_tabs));
  loop.Run();
}

std::vector<TabInfoPtr> PageHandlerAsyncWaiter::GetRecentTabs(
    ) {
  std::vector<TabInfoPtr> async_wait_result;
  GetRecentTabs(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTabPreview(
    int32_t tab_id, std::optional<std::string>* out_preview_data_url) {
  base::RunLoop loop;
  proxy_->GetTabPreview(
      std::move(tab_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_preview_data_url
,
             const std::optional<std::string>& preview_data_url) {*out_preview_data_url = std::move(preview_data_url);
            loop->Quit();
          },
          &loop,
          out_preview_data_url));
  loop.Run();
}

std::optional<std::string> PageHandlerAsyncWaiter::GetTabPreview(
    int32_t tab_id) {
  std::optional<std::string> async_wait_result;
  GetTabPreview(std::move(tab_id),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::AddFileContext(
    SelectedFileInfoPtr file_info, ::mojo_base::BigBuffer file_bytes, ::base::UnguessableToken* out_token) {
  base::RunLoop loop;
  proxy_->AddFileContext(
      std::move(file_info),
      std::move(file_bytes),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_token
,
             const ::base::UnguessableToken& token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

::base::UnguessableToken PageHandlerAsyncWaiter::AddFileContext(
    SelectedFileInfoPtr file_info, ::mojo_base::BigBuffer file_bytes) {
  ::base::UnguessableToken async_wait_result;
  AddFileContext(std::move(file_info),std::move(file_bytes),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::AddTabContext(
    int32_t tab_id, bool delay_upload, std::optional<::base::UnguessableToken>* out_token) {
  base::RunLoop loop;
  proxy_->AddTabContext(
      std::move(tab_id),
      std::move(delay_upload),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::UnguessableToken>* out_token
,
             const std::optional<::base::UnguessableToken>& token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

std::optional<::base::UnguessableToken> PageHandlerAsyncWaiter::AddTabContext(
    int32_t tab_id, bool delay_upload) {
  std::optional<::base::UnguessableToken> async_wait_result;
  AddTabContext(std::move(tab_id),std::move(delay_upload),&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::AutocompleteResultChanged(AutocompleteResultPtr result) {
  GetForwardingInterface()->AutocompleteResultChanged(
    std::move(result)
    );
}
void PageInterceptorForTesting::UpdateSelection(OmniboxPopupSelectionPtr old_selection, OmniboxPopupSelectionPtr selection) {
  GetForwardingInterface()->UpdateSelection(
    std::move(old_selection)
    , 
    std::move(selection)
    );
}
void PageInterceptorForTesting::SetKeywordSelected(bool is_keyword_selected) {
  GetForwardingInterface()->SetKeywordSelected(
    std::move(is_keyword_selected)
    );
}
void PageInterceptorForTesting::OnShow() {
  GetForwardingInterface()->OnShow();
}
void PageInterceptorForTesting::SetInputText(const std::string& input) {
  GetForwardingInterface()->SetInputText(
    std::move(input)
    );
}
void PageInterceptorForTesting::SetThumbnail(const std::string& thumbnail_url, bool is_deletable) {
  GetForwardingInterface()->SetThumbnail(
    std::move(thumbnail_url)
    , 
    std::move(is_deletable)
    );
}
void PageInterceptorForTesting::OnContextualInputStatusChanged(const ::base::UnguessableToken& token, ::composebox_query::mojom::FileUploadStatus status, std::optional<::composebox_query::mojom::FileUploadErrorType> error_type) {
  GetForwardingInterface()->OnContextualInputStatusChanged(
    std::move(token)
    , 
    std::move(status)
    , 
    std::move(error_type)
    );
}
void PageInterceptorForTesting::OnTabStripChanged() {
  GetForwardingInterface()->OnTabStripChanged();
}
void PageInterceptorForTesting::AddFileContext(const ::base::UnguessableToken& token, SelectedFileInfoPtr file_info) {
  GetForwardingInterface()->AddFileContext(
    std::move(token)
    , 
    std::move(file_info)
    );
}
void PageInterceptorForTesting::UpdateAutoSuggestedTabContext(TabInfoPtr tab) {
  GetForwardingInterface()->UpdateAutoSuggestedTabContext(
    std::move(tab)
    );
}
void PageInterceptorForTesting::UpdateLensSearchEligibility(bool eligible) {
  GetForwardingInterface()->UpdateLensSearchEligibility(
    std::move(eligible)
    );
}
void PageInterceptorForTesting::UpdateContentSharingPolicy(bool enabled) {
  GetForwardingInterface()->UpdateContentSharingPolicy(
    std::move(enabled)
    );
}
void PageInterceptorForTesting::UpdateAimEligibility(bool eligible) {
  GetForwardingInterface()->UpdateAimEligibility(
    std::move(eligible)
    );
}
void PageInterceptorForTesting::OnShowAiModePrefChanged(bool canShow) {
  GetForwardingInterface()->OnShowAiModePrefChanged(
    std::move(canShow)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // searchbox::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif