// components/omnibox/browser/searchbox.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/c/system/macros.h"
#include "components/omnibox/browser/omnibox.mojom-shared-internal.h"
#include "components/omnibox/composebox/composebox_query.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace searchbox::mojom {
namespace internal {
class ACMatchClassification_Data;
class Action_Data;
class SuggestionAnswer_Data;
class AutocompleteMatch_Data;
class TabInfo_Data;
class FileAttachment_Data;
class TabAttachment_Data;
class SearchContext_Data;
class SelectedFileInfo_Data;
class SuggestionGroup_Data;
class AutocompleteResult_Data;
class OmniboxPopupSelection_Data;
class PlaceholderConfig_Data;
class SearchContextAttachment_Data;

struct ToolMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SideType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct RenderType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SelectionLineState_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  SearchContextAttachment_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  SearchContextAttachment_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~SearchContextAttachment_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<SearchContextAttachment_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class SearchContextAttachment_Tag : uint32_t {

    
    kFileAttachment,
    
    kTabAttachment,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::FileAttachment_Data> f_file_attachment;
    mojo::internal::Pointer<internal::TabAttachment_Data> f_tab_attachment;
    uint64_t unknown;
  };

  uint32_t size;
  SearchContextAttachment_Tag tag;
  Union_ data;
};
static_assert(sizeof(SearchContextAttachment_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(SearchContextAttachment_Data)");
class  ACMatchClassification_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t offset;
  int32_t style;

 private:
  friend class mojo::internal::MessageFragment<ACMatchClassification_Data>;

  ACMatchClassification_Data();
  ~ACMatchClassification_Data() = delete;
};
static_assert(sizeof(ACMatchClassification_Data) == 16,
              "Bad sizeof(ACMatchClassification_Data)");
// Used by ACMatchClassification::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ACMatchClassification_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ACMatchClassification_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ACMatchClassification_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ACMatchClassification_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ACMatchClassification_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Action_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> hint;
  mojo::internal::Pointer<mojo::internal::String_Data> suggestion_contents;
  mojo::internal::Pointer<mojo::internal::String_Data> icon_path;
  mojo::internal::Pointer<mojo::internal::String_Data> a11y_label;

 private:
  friend class mojo::internal::MessageFragment<Action_Data>;

  Action_Data();
  ~Action_Data() = delete;
};
static_assert(sizeof(Action_Data) == 40,
              "Bad sizeof(Action_Data)");
// Used by Action::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Action_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Action_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Action_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Action_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Action_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SuggestionAnswer_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> first_line;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> second_line;

 private:
  friend class mojo::internal::MessageFragment<SuggestionAnswer_Data>;

  SuggestionAnswer_Data();
  ~SuggestionAnswer_Data() = delete;
};
static_assert(sizeof(SuggestionAnswer_Data) == 24,
              "Bad sizeof(SuggestionAnswer_Data)");
// Used by SuggestionAnswer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SuggestionAnswer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SuggestionAnswer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SuggestionAnswer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SuggestionAnswer_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SuggestionAnswer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AutocompleteMatch_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_hidden : 1;
  uint8_t allowed_to_be_default_match : 1;
  uint8_t is_weather_answer_suggestion_$flag : 1;
  uint8_t is_weather_answer_suggestion_$value : 1;
  uint8_t is_noncanned_aim_suggestion : 1;
  uint8_t is_rich_suggestion : 1;
  uint8_t is_search_type : 1;
  uint8_t is_enterprise_search_aggregator_people_type : 1;
  uint8_t swap_contents_and_description : 1;
  uint8_t supports_deletion : 1;
  uint8_t has_instant_keyword : 1;
  uint8_t pad10_[2];
  int32_t suggestion_group_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> a11y_label;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Action_Data>>> actions;
  mojo::internal::Pointer<internal::SuggestionAnswer_Data> answer;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> contents;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ACMatchClassification_Data>>> contents_class;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> description;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ACMatchClassification_Data>>> description_class;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> destination_url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> inline_autocompletion;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> fill_into_edit;
  mojo::internal::Pointer<mojo::internal::String_Data> icon_path;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> icon_url;
  mojo::internal::Pointer<mojo::internal::String_Data> image_dominant_color;
  mojo::internal::Pointer<mojo::internal::String_Data> image_url;
  mojo::internal::Pointer<mojo::internal::String_Data> type;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> remove_button_a11y_label;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> tail_suggest_common_prefix;
  mojo::internal::Pointer<mojo::internal::String_Data> keyword_chip_hint;
  mojo::internal::Pointer<mojo::internal::String_Data> keyword_chip_a11y;

 private:
  friend class mojo::internal::MessageFragment<AutocompleteMatch_Data>;

  AutocompleteMatch_Data();
  ~AutocompleteMatch_Data() = delete;
};
static_assert(sizeof(AutocompleteMatch_Data) == 168,
              "Bad sizeof(AutocompleteMatch_Data)");
// Used by AutocompleteMatch::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AutocompleteMatch_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AutocompleteMatch_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AutocompleteMatch_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AutocompleteMatch_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AutocompleteMatch_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t tab_id;
  uint8_t show_in_current_tab_chip : 1;
  uint8_t show_in_previous_tab_chip : 1;
  uint8_t pad2_[3];
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> last_active;

 private:
  friend class mojo::internal::MessageFragment<TabInfo_Data>;

  TabInfo_Data();
  ~TabInfo_Data() = delete;
};
static_assert(sizeof(TabInfo_Data) == 40,
              "Bad sizeof(TabInfo_Data)");
// Used by TabInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  FileAttachment_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> uuid;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Pointer<mojo::internal::String_Data> mime_type;
  mojo::internal::Pointer<mojo::internal::String_Data> image_data_url;

 private:
  friend class mojo::internal::MessageFragment<FileAttachment_Data>;

  FileAttachment_Data();
  ~FileAttachment_Data() = delete;
};
static_assert(sizeof(FileAttachment_Data) == 40,
              "Bad sizeof(FileAttachment_Data)");
// Used by FileAttachment::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct FileAttachment_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  FileAttachment_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~FileAttachment_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<FileAttachment_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    FileAttachment_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabAttachment_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t tab_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<TabAttachment_Data>;

  TabAttachment_Data();
  ~TabAttachment_Data() = delete;
};
static_assert(sizeof(TabAttachment_Data) == 32,
              "Bad sizeof(TabAttachment_Data)");
// Used by TabAttachment::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabAttachment_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabAttachment_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabAttachment_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabAttachment_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabAttachment_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SearchContext_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> input;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::SearchContextAttachment_Data>> attachments;
  int32_t tool_mode;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SearchContext_Data>;

  SearchContext_Data();
  ~SearchContext_Data() = delete;
};
static_assert(sizeof(SearchContext_Data) == 32,
              "Bad sizeof(SearchContext_Data)");
// Used by SearchContext::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SearchContext_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SearchContext_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SearchContext_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SearchContext_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SearchContext_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SelectedFileInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> file_name;
  mojo::internal::Pointer<mojo::internal::String_Data> mime_type;
  mojo::internal::Pointer<mojo::internal::String_Data> image_data_url;
  uint8_t is_deletable : 1;
  uint8_t pad3_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::JSTime_Data> selection_time;

 private:
  friend class mojo::internal::MessageFragment<SelectedFileInfo_Data>;

  SelectedFileInfo_Data();
  ~SelectedFileInfo_Data() = delete;
};
static_assert(sizeof(SelectedFileInfo_Data) == 48,
              "Bad sizeof(SelectedFileInfo_Data)");
// Used by SelectedFileInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SelectedFileInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SelectedFileInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SelectedFileInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SelectedFileInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SelectedFileInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SuggestionGroup_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> header;
  int32_t render_type;
  int32_t side_type;

 private:
  friend class mojo::internal::MessageFragment<SuggestionGroup_Data>;

  SuggestionGroup_Data();
  ~SuggestionGroup_Data() = delete;
};
static_assert(sizeof(SuggestionGroup_Data) == 24,
              "Bad sizeof(SuggestionGroup_Data)");
// Used by SuggestionGroup::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SuggestionGroup_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SuggestionGroup_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SuggestionGroup_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SuggestionGroup_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SuggestionGroup_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AutocompleteResult_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> input;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, mojo::internal::Pointer<internal::SuggestionGroup_Data>>> suggestion_groups_map;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::AutocompleteMatch_Data>>> matches;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> smart_compose_inline_hint;

 private:
  friend class mojo::internal::MessageFragment<AutocompleteResult_Data>;

  AutocompleteResult_Data();
  ~AutocompleteResult_Data() = delete;
};
static_assert(sizeof(AutocompleteResult_Data) == 40,
              "Bad sizeof(AutocompleteResult_Data)");
// Used by AutocompleteResult::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AutocompleteResult_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AutocompleteResult_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AutocompleteResult_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AutocompleteResult_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AutocompleteResult_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  OmniboxPopupSelection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t line;
  uint8_t action_index;
  uint8_t pad1_[2];
  int32_t state;

 private:
  friend class mojo::internal::MessageFragment<OmniboxPopupSelection_Data>;

  OmniboxPopupSelection_Data();
  ~OmniboxPopupSelection_Data() = delete;
};
static_assert(sizeof(OmniboxPopupSelection_Data) == 16,
              "Bad sizeof(OmniboxPopupSelection_Data)");
// Used by OmniboxPopupSelection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct OmniboxPopupSelection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  OmniboxPopupSelection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~OmniboxPopupSelection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<OmniboxPopupSelection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    OmniboxPopupSelection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PlaceholderConfig_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> texts;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> change_text_animation_interval;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> fade_text_animation_duration;

 private:
  friend class mojo::internal::MessageFragment<PlaceholderConfig_Data>;

  PlaceholderConfig_Data();
  ~PlaceholderConfig_Data() = delete;
};
static_assert(sizeof(PlaceholderConfig_Data) == 32,
              "Bad sizeof(PlaceholderConfig_Data)");
// Used by PlaceholderConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PlaceholderConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PlaceholderConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PlaceholderConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PlaceholderConfig_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PlaceholderConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // searchbox::mojom

#endif  // COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_SHARED_INTERNAL_H_