// components/omnibox/browser/searchbox.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_SEND_VALIDATION_H_

#include "components/omnibox/browser/searchbox.mojom-shared-internal.h"
#include "components/omnibox/browser/omnibox.mojom-shared.h"
#include "components/omnibox/composebox/composebox_query.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/omnibox/browser/searchbox.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::searchbox::mojom::ToolMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::searchbox::mojom::SideType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::searchbox::mojom::RenderType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::searchbox::mojom::SelectionLineState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::ACMatchClassificationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::ACMatchClassificationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::ACMatchClassification_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->offset = Traits::offset(input);

      fragment->style = Traits::style(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::ActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::ActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::Action_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::hint(input)) in_hint = Traits::hint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hint)::BaseType> hint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_hint,
        hint_fragment);

      fragment->hint.Set(
          hint_fragment.is_null() ? nullptr : hint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hint in Action struct");

      decltype(Traits::suggestion_contents(input)) in_suggestion_contents = Traits::suggestion_contents(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->suggestion_contents)::BaseType> suggestion_contents_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_suggestion_contents,
        suggestion_contents_fragment);

      fragment->suggestion_contents.Set(
          suggestion_contents_fragment.is_null() ? nullptr : suggestion_contents_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->suggestion_contents.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestion_contents in Action struct");

      decltype(Traits::icon_path(input)) in_icon_path = Traits::icon_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icon_path)::BaseType> icon_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_icon_path,
        icon_path_fragment);

      fragment->icon_path.Set(
          icon_path_fragment.is_null() ? nullptr : icon_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icon_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon_path in Action struct");

      decltype(Traits::a11y_label(input)) in_a11y_label = Traits::a11y_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->a11y_label)::BaseType> a11y_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_a11y_label,
        a11y_label_fragment);

      fragment->a11y_label.Set(
          a11y_label_fragment.is_null() ? nullptr : a11y_label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->a11y_label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null a11y_label in Action struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::SuggestionAnswerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::SuggestionAnswerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::SuggestionAnswer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::first_line(input)) in_first_line = Traits::first_line(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_line)::BaseType> first_line_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_first_line,
        first_line_fragment);

      fragment->first_line.Set(
          first_line_fragment.is_null() ? nullptr : first_line_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->first_line.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null first_line in SuggestionAnswer struct");

      decltype(Traits::second_line(input)) in_second_line = Traits::second_line(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->second_line)::BaseType> second_line_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_second_line,
        second_line_fragment);

      fragment->second_line.Set(
          second_line_fragment.is_null() ? nullptr : second_line_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->second_line.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null second_line in SuggestionAnswer struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::AutocompleteMatchDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::AutocompleteMatchDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::AutocompleteMatch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_hidden = Traits::is_hidden(input);

      decltype(Traits::a11y_label(input)) in_a11y_label = Traits::a11y_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->a11y_label)::BaseType> a11y_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_a11y_label,
        a11y_label_fragment);

      fragment->a11y_label.Set(
          a11y_label_fragment.is_null() ? nullptr : a11y_label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->a11y_label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null a11y_label in AutocompleteMatch struct");

      fragment->allowed_to_be_default_match = Traits::allowed_to_be_default_match(input);

      decltype(Traits::actions(input)) in_actions = Traits::actions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->actions)::BaseType>
          actions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& actions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::searchbox::mojom::ActionDataView>, send_validation>(
        in_actions,
        actions_fragment,
        &actions_validate_params);

      fragment->actions.Set(
          actions_fragment.is_null() ? nullptr : actions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->actions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null actions in AutocompleteMatch struct");

      decltype(Traits::answer(input)) in_answer = Traits::answer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->answer)::BaseType> answer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::searchbox::mojom::SuggestionAnswerDataView, send_validation>(
        in_answer,
        answer_fragment);

      fragment->answer.Set(
          answer_fragment.is_null() ? nullptr : answer_fragment.data());

      decltype(Traits::contents(input)) in_contents = Traits::contents(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->contents)::BaseType> contents_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_contents,
        contents_fragment);

      fragment->contents.Set(
          contents_fragment.is_null() ? nullptr : contents_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->contents.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contents in AutocompleteMatch struct");

      decltype(Traits::contents_class(input)) in_contents_class = Traits::contents_class(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->contents_class)::BaseType>
          contents_class_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& contents_class_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::searchbox::mojom::ACMatchClassificationDataView>, send_validation>(
        in_contents_class,
        contents_class_fragment,
        &contents_class_validate_params);

      fragment->contents_class.Set(
          contents_class_fragment.is_null() ? nullptr : contents_class_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->contents_class.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contents_class in AutocompleteMatch struct");

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->description.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in AutocompleteMatch struct");

      decltype(Traits::description_class(input)) in_description_class = Traits::description_class(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description_class)::BaseType>
          description_class_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& description_class_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::searchbox::mojom::ACMatchClassificationDataView>, send_validation>(
        in_description_class,
        description_class_fragment,
        &description_class_validate_params);

      fragment->description_class.Set(
          description_class_fragment.is_null() ? nullptr : description_class_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->description_class.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description_class in AutocompleteMatch struct");

      decltype(Traits::destination_url(input)) in_destination_url = Traits::destination_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->destination_url)::BaseType> destination_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_destination_url,
        destination_url_fragment);

      fragment->destination_url.Set(
          destination_url_fragment.is_null() ? nullptr : destination_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->destination_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null destination_url in AutocompleteMatch struct");

      decltype(Traits::inline_autocompletion(input)) in_inline_autocompletion = Traits::inline_autocompletion(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->inline_autocompletion)::BaseType> inline_autocompletion_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_inline_autocompletion,
        inline_autocompletion_fragment);

      fragment->inline_autocompletion.Set(
          inline_autocompletion_fragment.is_null() ? nullptr : inline_autocompletion_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->inline_autocompletion.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null inline_autocompletion in AutocompleteMatch struct");

      decltype(Traits::fill_into_edit(input)) in_fill_into_edit = Traits::fill_into_edit(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fill_into_edit)::BaseType> fill_into_edit_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_fill_into_edit,
        fill_into_edit_fragment);

      fragment->fill_into_edit.Set(
          fill_into_edit_fragment.is_null() ? nullptr : fill_into_edit_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fill_into_edit.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fill_into_edit in AutocompleteMatch struct");
      fragment->is_weather_answer_suggestion_$flag = Traits::is_weather_answer_suggestion(input).has_value();
      if (Traits::is_weather_answer_suggestion(input).has_value()) {
        fragment->is_weather_answer_suggestion_$value = Traits::is_weather_answer_suggestion(input).value();
      }

      decltype(Traits::icon_path(input)) in_icon_path = Traits::icon_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icon_path)::BaseType> icon_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_icon_path,
        icon_path_fragment);

      fragment->icon_path.Set(
          icon_path_fragment.is_null() ? nullptr : icon_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icon_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon_path in AutocompleteMatch struct");

      decltype(Traits::icon_url(input)) in_icon_url = Traits::icon_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icon_url)::BaseType> icon_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_icon_url,
        icon_url_fragment);

      fragment->icon_url.Set(
          icon_url_fragment.is_null() ? nullptr : icon_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icon_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon_url in AutocompleteMatch struct");

      decltype(Traits::image_dominant_color(input)) in_image_dominant_color = Traits::image_dominant_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_dominant_color)::BaseType> image_dominant_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_image_dominant_color,
        image_dominant_color_fragment);

      fragment->image_dominant_color.Set(
          image_dominant_color_fragment.is_null() ? nullptr : image_dominant_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_dominant_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_dominant_color in AutocompleteMatch struct");

      decltype(Traits::image_url(input)) in_image_url = Traits::image_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_url)::BaseType> image_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_image_url,
        image_url_fragment);

      fragment->image_url.Set(
          image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_url in AutocompleteMatch struct");

      fragment->is_noncanned_aim_suggestion = Traits::is_noncanned_aim_suggestion(input);

      fragment->is_rich_suggestion = Traits::is_rich_suggestion(input);

      fragment->is_search_type = Traits::is_search_type(input);

      fragment->is_enterprise_search_aggregator_people_type = Traits::is_enterprise_search_aggregator_people_type(input);

      decltype(Traits::type(input)) in_type = Traits::type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->type)::BaseType> type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_type,
        type_fragment);

      fragment->type.Set(
          type_fragment.is_null() ? nullptr : type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null type in AutocompleteMatch struct");

      decltype(Traits::remove_button_a11y_label(input)) in_remove_button_a11y_label = Traits::remove_button_a11y_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->remove_button_a11y_label)::BaseType> remove_button_a11y_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_remove_button_a11y_label,
        remove_button_a11y_label_fragment);

      fragment->remove_button_a11y_label.Set(
          remove_button_a11y_label_fragment.is_null() ? nullptr : remove_button_a11y_label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->remove_button_a11y_label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null remove_button_a11y_label in AutocompleteMatch struct");

      fragment->swap_contents_and_description = Traits::swap_contents_and_description(input);

      fragment->suggestion_group_id = Traits::suggestion_group_id(input);

      fragment->supports_deletion = Traits::supports_deletion(input);

      decltype(Traits::tail_suggest_common_prefix(input)) in_tail_suggest_common_prefix = Traits::tail_suggest_common_prefix(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tail_suggest_common_prefix)::BaseType> tail_suggest_common_prefix_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_tail_suggest_common_prefix,
        tail_suggest_common_prefix_fragment);

      fragment->tail_suggest_common_prefix.Set(
          tail_suggest_common_prefix_fragment.is_null() ? nullptr : tail_suggest_common_prefix_fragment.data());

      fragment->has_instant_keyword = Traits::has_instant_keyword(input);

      decltype(Traits::keyword_chip_hint(input)) in_keyword_chip_hint = Traits::keyword_chip_hint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keyword_chip_hint)::BaseType> keyword_chip_hint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_keyword_chip_hint,
        keyword_chip_hint_fragment);

      fragment->keyword_chip_hint.Set(
          keyword_chip_hint_fragment.is_null() ? nullptr : keyword_chip_hint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->keyword_chip_hint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keyword_chip_hint in AutocompleteMatch struct");

      decltype(Traits::keyword_chip_a11y(input)) in_keyword_chip_a11y = Traits::keyword_chip_a11y(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keyword_chip_a11y)::BaseType> keyword_chip_a11y_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_keyword_chip_a11y,
        keyword_chip_a11y_fragment);

      fragment->keyword_chip_a11y.Set(
          keyword_chip_a11y_fragment.is_null() ? nullptr : keyword_chip_a11y_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->keyword_chip_a11y.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keyword_chip_a11y in AutocompleteMatch struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::TabInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::TabInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::TabInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->tab_id = Traits::tab_id(input);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in TabInfo struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in TabInfo struct");

      fragment->show_in_current_tab_chip = Traits::show_in_current_tab_chip(input);

      fragment->show_in_previous_tab_chip = Traits::show_in_previous_tab_chip(input);

      decltype(Traits::last_active(input)) in_last_active = Traits::last_active(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_active)::BaseType> last_active_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_last_active,
        last_active_fragment);

      fragment->last_active.Set(
          last_active_fragment.is_null() ? nullptr : last_active_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_active.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_active in TabInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::FileAttachmentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::FileAttachmentDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::FileAttachment_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uuid)::BaseType> uuid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_uuid,
        uuid_fragment);

      fragment->uuid.Set(
          uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uuid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in FileAttachment struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FileAttachment struct");

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in FileAttachment struct");

      decltype(Traits::image_data_url(input)) in_image_data_url = Traits::image_data_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_data_url)::BaseType> image_data_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_image_data_url,
        image_data_url_fragment);

      fragment->image_data_url.Set(
          image_data_url_fragment.is_null() ? nullptr : image_data_url_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::TabAttachmentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::TabAttachmentDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::TabAttachment_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->tab_id = Traits::tab_id(input);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in TabAttachment struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in TabAttachment struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::SearchContextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::SearchContextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::SearchContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::input(input)) in_input = Traits::input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input)::BaseType> input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_input,
        input_fragment);

      fragment->input.Set(
          input_fragment.is_null() ? nullptr : input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input in SearchContext struct");

      decltype(Traits::attachments(input)) in_attachments = Traits::attachments(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attachments)::BaseType>
          attachments_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& attachments_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::searchbox::mojom::SearchContextAttachmentDataView>, send_validation>(
        in_attachments,
        attachments_fragment,
        &attachments_validate_params);

      fragment->attachments.Set(
          attachments_fragment.is_null() ? nullptr : attachments_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attachments.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attachments in SearchContext struct");

      
      mojo::internal::Serialize<::searchbox::mojom::ToolMode>(
        Traits::tool_mode(input),
        &fragment->tool_mode);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::SelectedFileInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::SelectedFileInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::SelectedFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::file_name(input)) in_file_name = Traits::file_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_name)::BaseType> file_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_file_name,
        file_name_fragment);

      fragment->file_name.Set(
          file_name_fragment.is_null() ? nullptr : file_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_name in SelectedFileInfo struct");

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in SelectedFileInfo struct");

      decltype(Traits::image_data_url(input)) in_image_data_url = Traits::image_data_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_data_url)::BaseType> image_data_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_image_data_url,
        image_data_url_fragment);

      fragment->image_data_url.Set(
          image_data_url_fragment.is_null() ? nullptr : image_data_url_fragment.data());

      fragment->is_deletable = Traits::is_deletable(input);

      decltype(Traits::selection_time(input)) in_selection_time = Traits::selection_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->selection_time)::BaseType> selection_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::JSTimeDataView, send_validation>(
        in_selection_time,
        selection_time_fragment);

      fragment->selection_time.Set(
          selection_time_fragment.is_null() ? nullptr : selection_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->selection_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selection_time in SelectedFileInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::SuggestionGroupDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::SuggestionGroupDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::SuggestionGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::header(input)) in_header = Traits::header(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->header)::BaseType> header_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_header,
        header_fragment);

      fragment->header.Set(
          header_fragment.is_null() ? nullptr : header_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->header.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header in SuggestionGroup struct");

      
      mojo::internal::Serialize<::searchbox::mojom::RenderType>(
        Traits::render_type(input),
        &fragment->render_type);

      
      mojo::internal::Serialize<::searchbox::mojom::SideType>(
        Traits::side_type(input),
        &fragment->side_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::AutocompleteResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::AutocompleteResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::AutocompleteResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::input(input)) in_input = Traits::input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input)::BaseType> input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_input,
        input_fragment);

      fragment->input.Set(
          input_fragment.is_null() ? nullptr : input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input in AutocompleteResult struct");

      decltype(Traits::suggestion_groups_map(input)) in_suggestion_groups_map = Traits::suggestion_groups_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->suggestion_groups_map)::BaseType>
          suggestion_groups_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& suggestion_groups_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<int32_t, ::searchbox::mojom::SuggestionGroupDataView>, send_validation>(
        in_suggestion_groups_map,
        suggestion_groups_map_fragment,
        &suggestion_groups_map_validate_params);

      fragment->suggestion_groups_map.Set(
          suggestion_groups_map_fragment.is_null() ? nullptr : suggestion_groups_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->suggestion_groups_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestion_groups_map in AutocompleteResult struct");

      decltype(Traits::matches(input)) in_matches = Traits::matches(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->matches)::BaseType>
          matches_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& matches_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::searchbox::mojom::AutocompleteMatchDataView>, send_validation>(
        in_matches,
        matches_fragment,
        &matches_validate_params);

      fragment->matches.Set(
          matches_fragment.is_null() ? nullptr : matches_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->matches.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null matches in AutocompleteResult struct");

      decltype(Traits::smart_compose_inline_hint(input)) in_smart_compose_inline_hint = Traits::smart_compose_inline_hint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->smart_compose_inline_hint)::BaseType> smart_compose_inline_hint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_smart_compose_inline_hint,
        smart_compose_inline_hint_fragment);

      fragment->smart_compose_inline_hint.Set(
          smart_compose_inline_hint_fragment.is_null() ? nullptr : smart_compose_inline_hint_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::OmniboxPopupSelectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::OmniboxPopupSelectionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::OmniboxPopupSelection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->line = Traits::line(input);

      
      mojo::internal::Serialize<::searchbox::mojom::SelectionLineState>(
        Traits::state(input),
        &fragment->state);

      fragment->action_index = Traits::action_index(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::PlaceholderConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::searchbox::mojom::PlaceholderConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::searchbox::mojom::internal::PlaceholderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::texts(input)) in_texts = Traits::texts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->texts)::BaseType>
          texts_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& texts_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_texts,
        texts_fragment,
        &texts_validate_params);

      fragment->texts.Set(
          texts_fragment.is_null() ? nullptr : texts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->texts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null texts in PlaceholderConfig struct");

      decltype(Traits::change_text_animation_interval(input)) in_change_text_animation_interval = Traits::change_text_animation_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->change_text_animation_interval)::BaseType> change_text_animation_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_change_text_animation_interval,
        change_text_animation_interval_fragment);

      fragment->change_text_animation_interval.Set(
          change_text_animation_interval_fragment.is_null() ? nullptr : change_text_animation_interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->change_text_animation_interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null change_text_animation_interval in PlaceholderConfig struct");

      decltype(Traits::fade_text_animation_duration(input)) in_fade_text_animation_duration = Traits::fade_text_animation_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fade_text_animation_duration)::BaseType> fade_text_animation_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_fade_text_animation_duration,
        fade_text_animation_duration_fragment);

      fragment->fade_text_animation_duration.Set(
          fade_text_animation_duration_fragment.is_null() ? nullptr : fade_text_animation_duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fade_text_animation_duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fade_text_animation_duration in PlaceholderConfig struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::searchbox::mojom::SearchContextAttachmentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::searchbox::mojom::SearchContextAttachmentDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::searchbox::mojom::internal::SearchContextAttachment_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::searchbox::mojom::SearchContextAttachmentDataView::Tag::kFileAttachment: {
    decltype(Traits::file_attachment(input))
    in_file_attachment = Traits::file_attachment(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file_attachment)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::searchbox::mojom::FileAttachmentDataView, send_validation>(
  in_file_attachment,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file_attachment in SearchContextAttachment union");
    fragment->data.f_file_attachment.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::searchbox::mojom::SearchContextAttachmentDataView::Tag::kTabAttachment: {
    decltype(Traits::tab_attachment(input))
    in_tab_attachment = Traits::tab_attachment(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_attachment)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::searchbox::mojom::TabAttachmentDataView, send_validation>(
  in_tab_attachment,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_attachment in SearchContextAttachment union");
    fragment->data.f_tab_attachment.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_SEND_VALIDATION_H_