// components/network_hints/common/network_hints.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_H_
#define COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/network_hints/common/network_hints.mojom-features.h"  // IWYU pragma: export
#include "components/network_hints/common/network_hints.mojom-shared.h"  // IWYU pragma: export
#include "components/network_hints/common/network_hints.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/scheme_host_port.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network_hints::mojom {

class NetworkHintsHandlerProxy;

template <typename ImplRefTraits>
class NetworkHintsHandlerStub;

class NetworkHintsHandlerRequestValidator;


class NetworkHintsHandler
    : public NetworkHintsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network_hints.mojom.NetworkHintsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkHintsHandlerInterfaceBase;
  using Proxy_ = NetworkHintsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkHintsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = NetworkHintsHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPrefetchDNSMinVersion = 0,
    kPreconnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PrefetchDNS_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Preconnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetworkHintsHandler() = default;

  virtual void PrefetchDNS(const std::vector<::url::SchemeHostPort>& url_list) = 0;

  virtual void Preconnect(const ::url::SchemeHostPort& url, bool allow_credentials) = 0;
};



class  NetworkHintsHandlerProxy
    : public NetworkHintsHandler {
 public:
  using InterfaceType = NetworkHintsHandler;

  explicit NetworkHintsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PrefetchDNS(const std::vector<::url::SchemeHostPort>& url_list) final;
  
  void Preconnect(const ::url::SchemeHostPort& url, bool allow_credentials) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkHintsHandlerStubDispatch {
 public:
  static bool Accept(NetworkHintsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkHintsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkHintsHandler>>
class NetworkHintsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkHintsHandlerStub() = default;
  ~NetworkHintsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkHintsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkHintsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkHintsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // network_hints::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_NETWORK_HINTS_COMMON_NETWORK_HINTS_MOJOM_H_