// components/mirroring/mojom/session_parameters.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "services/network/public/mojom/ip_address.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace mirroring::mojom {
namespace internal {
class SessionParameters_Data;

struct SessionType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  SessionParameters_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t is_remote_playback : 1;
  uint8_t force_letterboxing : 1;
  uint8_t enable_rtcp_reporting : 1;
  uint8_t pad3_[3];
  mojo::internal::Pointer<::network::mojom::internal::IPAddress_Data> receiver_address;
  mojo::internal::Pointer<mojo::internal::String_Data> receiver_friendly_name;
  mojo::internal::Pointer<mojo::internal::String_Data> source_id;
  mojo::internal::Pointer<mojo::internal::String_Data> destination_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> target_playout_delay;

 private:
  friend class mojo::internal::MessageFragment<SessionParameters_Data>;

  SessionParameters_Data();
  ~SessionParameters_Data() = delete;
};
static_assert(sizeof(SessionParameters_Data) == 56,
              "Bad sizeof(SessionParameters_Data)");
// Used by SessionParameters::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SessionParameters_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SessionParameters_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SessionParameters_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SessionParameters_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SessionParameters_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // mirroring::mojom

#endif  // COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SHARED_INTERNAL_H_