// components/mirroring/mojom/session_parameters.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SEND_VALIDATION_H_

#include "components/mirroring/mojom/session_parameters.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "components/mirroring/mojom/session_parameters.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::mirroring::mojom::SessionType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mirroring::mojom::SessionParametersDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mirroring::mojom::SessionParametersDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mirroring::mojom::internal::SessionParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::mirroring::mojom::SessionType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::receiver_address(input)) in_receiver_address = Traits::receiver_address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->receiver_address)::BaseType> receiver_address_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPAddressDataView, send_validation>(
        in_receiver_address,
        receiver_address_fragment);

      fragment->receiver_address.Set(
          receiver_address_fragment.is_null() ? nullptr : receiver_address_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->receiver_address.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null receiver_address in SessionParameters struct");

      decltype(Traits::receiver_friendly_name(input)) in_receiver_friendly_name = Traits::receiver_friendly_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->receiver_friendly_name)::BaseType> receiver_friendly_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_receiver_friendly_name,
        receiver_friendly_name_fragment);

      fragment->receiver_friendly_name.Set(
          receiver_friendly_name_fragment.is_null() ? nullptr : receiver_friendly_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->receiver_friendly_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null receiver_friendly_name in SessionParameters struct");

      decltype(Traits::source_id(input)) in_source_id = Traits::source_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_id)::BaseType> source_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_source_id,
        source_id_fragment);

      fragment->source_id.Set(
          source_id_fragment.is_null() ? nullptr : source_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_id in SessionParameters struct");

      decltype(Traits::destination_id(input)) in_destination_id = Traits::destination_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->destination_id)::BaseType> destination_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_destination_id,
        destination_id_fragment);

      fragment->destination_id.Set(
          destination_id_fragment.is_null() ? nullptr : destination_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->destination_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null destination_id in SessionParameters struct");

      decltype(Traits::target_playout_delay(input)) in_target_playout_delay = Traits::target_playout_delay(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->target_playout_delay)::BaseType> target_playout_delay_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_target_playout_delay,
        target_playout_delay_fragment);

      fragment->target_playout_delay.Set(
          target_playout_delay_fragment.is_null() ? nullptr : target_playout_delay_fragment.data());

      fragment->is_remote_playback = Traits::is_remote_playback(input);

      fragment->force_letterboxing = Traits::force_letterboxing(input);

      fragment->enable_rtcp_reporting = Traits::enable_rtcp_reporting(input);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_SEND_VALIDATION_H_