// components/mirroring/mojom/session_parameters.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/mirroring/mojom/session_parameters.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace mirroring::mojom {
class SessionParametersDataView;



}  // mirroring::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mirroring::mojom::SessionParametersDataView> {
  using Data = ::mirroring::mojom::internal::SessionParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mirroring::mojom {


enum class SessionType : int32_t {
  
  AUDIO_ONLY = 0,
  
  VIDEO_ONLY = 1,
  
  AUDIO_AND_VIDEO = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SessionType value);
inline bool IsKnownEnumValue(SessionType value) {
  return internal::SessionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SessionParametersDataView {
 public:
  SessionParametersDataView() = default;

  SessionParametersDataView(
      internal::SessionParameters_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::mirroring::mojom::SessionType>(
        data_value, output);
  }
  SessionType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mirroring::mojom::SessionType>(data_->type));
  }
  inline void GetReceiverAddressDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReceiverAddress(UserType* output) {
    
    auto* pointer = data_->receiver_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
  inline void GetReceiverFriendlyNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReceiverFriendlyName(UserType* output) {
    
    auto* pointer = data_->receiver_friendly_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceId(UserType* output) {
    
    auto* pointer = data_->source_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDestinationIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestinationId(UserType* output) {
    
    auto* pointer = data_->destination_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTargetPlayoutDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetPlayoutDelay(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `target_playout_delay` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTargetPlayoutDelay` instead "
    "of `ReadTargetPlayoutDelay if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->target_playout_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool is_remote_playback() const {
    return data_->is_remote_playback;
  }
  bool force_letterboxing() const {
    return data_->force_letterboxing;
  }
  bool enable_rtcp_reporting() const {
    return data_->enable_rtcp_reporting;
  }
 private:
  internal::SessionParameters_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mirroring::mojom

#endif  // COMPONENTS_MIRRORING_MOJOM_SESSION_PARAMETERS_MOJOM_DATA_VIEW_H_