// components/mirroring/mojom/cast_message_channel.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_SHARED_H_
#define COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/mirroring/mojom/cast_message_channel.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/mirroring/mojom/cast_message_channel.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mirroring::mojom::CastMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mirroring::mojom::CastMessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mirroring::mojom::internal::CastMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::message_namespace(input)) in_message_namespace = Traits::message_namespace(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message_namespace)::BaseType> message_namespace_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message_namespace,
      message_namespace_fragment);

    fragment->message_namespace.Set(
        message_namespace_fragment.is_null() ? nullptr : message_namespace_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message_namespace.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message_namespace in CastMessage struct");

    decltype(Traits::json_format_data(input)) in_json_format_data = Traits::json_format_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->json_format_data)::BaseType> json_format_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_json_format_data,
      json_format_data_fragment);

    fragment->json_format_data.Set(
        json_format_data_fragment.is_null() ? nullptr : json_format_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->json_format_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null json_format_data in CastMessage struct");
  }

  static bool Deserialize(::mirroring::mojom::internal::CastMessage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mirroring::mojom::CastMessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mirroring::mojom {

inline void CastMessageDataView::GetMessageNamespaceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message_namespace.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CastMessageDataView::GetJsonFormatDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->json_format_data.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // mirroring::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_SHARED_H_