// components/mirroring/mojom/cast_message_channel.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/mirroring/mojom/cast_message_channel.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/mirroring/mojom/cast_message_channel.mojom-params-data.h"
namespace mirroring {
namespace mojom {

namespace internal {


// static
bool CastMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CastMessage_Data* object =
      static_cast<const CastMessage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message_namespace, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_namespace_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message_namespace, validation_context,
                                         &message_namespace_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->json_format_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& json_format_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->json_format_data, validation_context,
                                         &json_format_data_validate_params)) {
    return false;
  }

  return true;
}

CastMessage_Data::CastMessage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CastMessageChannel_OnMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CastMessageChannel_OnMessage_Params_Data* object =
      static_cast<const CastMessageChannel_OnMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

CastMessageChannel_OnMessage_Params_Data::CastMessageChannel_OnMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace mirroring