// components/mirroring/mojom/cast_message_channel.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_DATA_VIEW_H_
#define COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/mirroring/mojom/cast_message_channel.mojom-shared-internal.h"


namespace mirroring::mojom {
class CastMessageDataView;



}  // mirroring::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mirroring::mojom::CastMessageDataView> {
  using Data = ::mirroring::mojom::internal::CastMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mirroring::mojom {
// Interface base classes. They are used for type safety check.
class CastMessageChannelInterfaceBase {};

using CastMessageChannelPtrDataView =
    mojo::InterfacePtrDataView<CastMessageChannelInterfaceBase>;
using CastMessageChannelRequestDataView =
    mojo::InterfaceRequestDataView<CastMessageChannelInterfaceBase>;
using CastMessageChannelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CastMessageChannelInterfaceBase>;
using CastMessageChannelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CastMessageChannelInterfaceBase>;


class CastMessageDataView {
 public:
  CastMessageDataView() = default;

  CastMessageDataView(
      internal::CastMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageNamespaceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessageNamespace(UserType* output) {
    
    auto* pointer = data_->message_namespace.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetJsonFormatDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJsonFormatData(UserType* output) {
    
    auto* pointer = data_->json_format_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CastMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mirroring::mojom

#endif  // COMPONENTS_MIRRORING_MOJOM_CAST_MESSAGE_CHANNEL_MOJOM_DATA_VIEW_H_