// components/metrics/structured/mojom/event.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_H_
#define COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/metrics/structured/mojom/event.mojom-features.h"  // IWYU pragma: export
#include "components/metrics/structured/mojom/event.mojom-shared.h"  // IWYU pragma: export
#include "components/metrics/structured/mojom/event.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>




#include "components/metrics/structured/mojom/event_mojom_traits.h"




namespace metrics::structured::mojom {






class  MetricValue {
 public:
  using DataView = MetricValueDataView;
  using Data_ = internal::MetricValue_Data;
  using Tag = Data_::MetricValue_Tag;

  template <typename... Args>
  static MetricValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |hmac_value|.
  static MetricValuePtr NewHmacValue(
      const std::string& value);
  // Construct an instance holding |long_value|.
  static MetricValuePtr NewLongValue(
      int64_t value);
  // Construct an instance holding |int_value|.
  static MetricValuePtr NewIntValue(
      int32_t value);
  // Construct an instance holding |double_value|.
  static MetricValuePtr NewDoubleValue(
      double value);
  // Construct an instance holding |raw_str_value|.
  static MetricValuePtr NewRawStrValue(
      const std::string& value);
  // Construct an instance holding |bool_value|.
  static MetricValuePtr NewBoolValue(
      bool value);

  template <typename U>
  static MetricValuePtr From(const U& u) {
    return mojo::TypeConverter<MetricValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MetricValue>::Convert(*this);
  }
  ~MetricValue();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  MetricValue(const MetricValue& other) = delete;
  MetricValue& operator=(const MetricValue& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MetricValuePtr>
  MetricValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MetricValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, MetricValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_hmac_value() const { return tag_ == Tag::kHmacValue; }
  const std::string& get_hmac_value() const {
    CHECK(tag_ == Tag::kHmacValue);
    return data_.hmac_value;
  }
  std::string& get_hmac_value() {
    CHECK(tag_ == Tag::kHmacValue);
    return data_.hmac_value;
  }
  void set_hmac_value(const std::string& hmac_value);

  bool is_long_value() const { return tag_ == Tag::kLongValue; }
  int64_t get_long_value() const {
    CHECK(tag_ == Tag::kLongValue);
    return data_.long_value;
  }
  void set_long_value(int64_t long_value);

  bool is_int_value() const { return tag_ == Tag::kIntValue; }
  int32_t get_int_value() const {
    CHECK(tag_ == Tag::kIntValue);
    return data_.int_value;
  }
  void set_int_value(int32_t int_value);

  bool is_double_value() const { return tag_ == Tag::kDoubleValue; }
  double get_double_value() const {
    CHECK(tag_ == Tag::kDoubleValue);
    return data_.double_value;
  }
  void set_double_value(double double_value);

  bool is_raw_str_value() const { return tag_ == Tag::kRawStrValue; }
  const std::string& get_raw_str_value() const {
    CHECK(tag_ == Tag::kRawStrValue);
    return data_.raw_str_value;
  }
  std::string& get_raw_str_value() {
    CHECK(tag_ == Tag::kRawStrValue);
    return data_.raw_str_value;
  }
  void set_raw_str_value(const std::string& raw_str_value);

  bool is_bool_value() const { return tag_ == Tag::kBoolValue; }
  bool get_bool_value() const {
    CHECK(tag_ == Tag::kBoolValue);
    return data_.bool_value;
  }
  void set_bool_value(bool bool_value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MetricValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MetricValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kHmacValue)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLongValue)>,
        int64_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDoubleValue)>,
        double value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRawStrValue)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
        bool value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string hmac_value;
    int64_t long_value;
    int32_t int_value;
    double double_value;
    std::string raw_str_value;
    bool bool_value;
  };

  MetricValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kHmacValue)>,
      const std::string& value);
  MetricValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kLongValue)>,
      int64_t value);
  MetricValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
      int32_t value);
  MetricValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kDoubleValue)>,
      double value);
  MetricValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kRawStrValue)>,
      const std::string& value);
  MetricValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
      bool value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  Event {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Event, T>::value>;
  using DataView = EventDataView;
  using Data_ = internal::Event_Data;

  template <typename... Args>
  static EventPtr New(Args&&... args) {
    return EventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventPtr From(const U& u) {
    return mojo::TypeConverter<EventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Event>::Convert(*this);
  }


  Event();

  Event(
      const std::string& project_name,
      const std::string& event_name,
      base::flat_map<std::string, MetricValuePtr> metrics);

  Event(
      const std::string& project_name,
      const std::string& event_name,
      base::flat_map<std::string, MetricValuePtr> metrics,
      std::optional<::base::TimeDelta> system_uptime,
      bool is_event_sequence);

Event(const Event&) = delete;
Event& operator=(const Event&) = delete;

  ~Event();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventPtr>
  EventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Event::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Event::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Event::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Event::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Event::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Event::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Event_UnserializedMessageContext<
            UserType, Event::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Event::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Event::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Event_UnserializedMessageContext<
            UserType, Event::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Event::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string project_name;
  
  std::string event_name;
  
  base::flat_map<std::string, MetricValuePtr> metrics;
  
  std::optional<::base::TimeDelta> system_uptime;
  
  bool is_event_sequence;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Event::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
MetricValuePtr MetricValue::Clone() const {
  switch (tag_) {
    case Tag::kHmacValue:
      return NewHmacValue(
          mojo::Clone(data_.hmac_value));
    case Tag::kLongValue:
      return NewLongValue(
          mojo::Clone(data_.long_value));
    case Tag::kIntValue:
      return NewIntValue(
          mojo::Clone(data_.int_value));
    case Tag::kDoubleValue:
      return NewDoubleValue(
          mojo::Clone(data_.double_value));
    case Tag::kRawStrValue:
      return NewRawStrValue(
          mojo::Clone(data_.raw_str_value));
    case Tag::kBoolValue:
      return NewBoolValue(
          mojo::Clone(data_.bool_value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MetricValue>::value>::type*>
bool MetricValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kHmacValue:
      return mojo::Equals(data_.hmac_value, other.data_.hmac_value);
    case Tag::kLongValue:
      return mojo::Equals(data_.long_value, other.data_.long_value);
    case Tag::kIntValue:
      return mojo::Equals(data_.int_value, other.data_.int_value);
    case Tag::kDoubleValue:
      return mojo::Equals(data_.double_value, other.data_.double_value);
    case Tag::kRawStrValue:
      return mojo::Equals(data_.raw_str_value, other.data_.raw_str_value);
    case Tag::kBoolValue:
      return mojo::Equals(data_.bool_value, other.data_.bool_value);
  }

  return false;
}
template <typename StructPtrType>
EventPtr Event::Clone() const {
  return New(
      mojo::Clone(project_name),
      mojo::Clone(event_name),
      mojo::Clone(metrics),
      mojo::Clone(system_uptime),
      mojo::Clone(is_event_sequence)
  );
}

template <typename T, Event::EnableIfSame<T>*>
bool Event::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->project_name, other_struct.project_name))
    return false;
  if (!mojo::Equals(this->event_name, other_struct.event_name))
    return false;
  if (!mojo::Equals(this->metrics, other_struct.metrics))
    return false;
  if (!mojo::Equals(this->system_uptime, other_struct.system_uptime))
    return false;
  if (!mojo::Equals(this->is_event_sequence, other_struct.is_event_sequence))
    return false;
  return true;
}

template <typename T, Event::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.project_name < rhs.project_name)
    return true;
  if (rhs.project_name < lhs.project_name)
    return false;
  if (lhs.event_name < rhs.event_name)
    return true;
  if (rhs.event_name < lhs.event_name)
    return false;
  if (lhs.metrics < rhs.metrics)
    return true;
  if (rhs.metrics < lhs.metrics)
    return false;
  if (lhs.system_uptime < rhs.system_uptime)
    return true;
  if (rhs.system_uptime < lhs.system_uptime)
    return false;
  if (lhs.is_event_sequence < rhs.is_event_sequence)
    return true;
  if (rhs.is_event_sequence < lhs.is_event_sequence)
    return false;
  return false;
}


}  // metrics::structured::mojom

namespace mojo {


template <>
struct  StructTraits<::metrics::structured::mojom::Event::DataView,
                                         ::metrics::structured::mojom::EventPtr> {
  static bool IsNull(const ::metrics::structured::mojom::EventPtr& input) { return !input; }
  static void SetToNull(::metrics::structured::mojom::EventPtr* output) { output->reset(); }

  static const decltype(::metrics::structured::mojom::Event::project_name)& project_name(
      const ::metrics::structured::mojom::EventPtr& input) {
    return input->project_name;
  }

  static const decltype(::metrics::structured::mojom::Event::event_name)& event_name(
      const ::metrics::structured::mojom::EventPtr& input) {
    return input->event_name;
  }

  static const decltype(::metrics::structured::mojom::Event::metrics)& metrics(
      const ::metrics::structured::mojom::EventPtr& input) {
    return input->metrics;
  }

  static const decltype(::metrics::structured::mojom::Event::system_uptime)& system_uptime(
      const ::metrics::structured::mojom::EventPtr& input) {
    return input->system_uptime;
  }

  static decltype(::metrics::structured::mojom::Event::is_event_sequence) is_event_sequence(
      const ::metrics::structured::mojom::EventPtr& input) {
    return input->is_event_sequence;
  }

  static bool Read(::metrics::structured::mojom::Event::DataView input, ::metrics::structured::mojom::EventPtr* output);
};


template <>
struct  UnionTraits<::metrics::structured::mojom::MetricValue::DataView,
                                        ::metrics::structured::mojom::MetricValuePtr> {
  static bool IsNull(const ::metrics::structured::mojom::MetricValuePtr& input) { return !input; }
  static void SetToNull(::metrics::structured::mojom::MetricValuePtr* output) { output->reset(); }

  static ::metrics::structured::mojom::MetricValue::Tag GetTag(const ::metrics::structured::mojom::MetricValuePtr& input) {
    return input->which();
  }

  static const std::string& hmac_value(const ::metrics::structured::mojom::MetricValuePtr& input) {
    return input->get_hmac_value();
  }

  static  int64_t long_value(const ::metrics::structured::mojom::MetricValuePtr& input) {
    return input->get_long_value();
  }

  static  int32_t int_value(const ::metrics::structured::mojom::MetricValuePtr& input) {
    return input->get_int_value();
  }

  static  double double_value(const ::metrics::structured::mojom::MetricValuePtr& input) {
    return input->get_double_value();
  }

  static const std::string& raw_str_value(const ::metrics::structured::mojom::MetricValuePtr& input) {
    return input->get_raw_str_value();
  }

  static  bool bool_value(const ::metrics::structured::mojom::MetricValuePtr& input) {
    return input->get_bool_value();
  }

  static bool Read(::metrics::structured::mojom::MetricValue::DataView input, ::metrics::structured::mojom::MetricValuePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_H_