// components/metrics/structured/mojom/event.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/metrics/structured/mojom/event.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/metrics/structured/mojom/event.mojom-params-data.h"
namespace metrics {
namespace structured {
namespace mojom {

namespace internal {
// static
bool MetricValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MetricValue_Data* object = static_cast<const MetricValue_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MetricValue_Tag::kHmacValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_hmac_value, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& hmac_value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_hmac_value, validation_context,
                                             &hmac_value_validate_params)) {
        return false;
      }
      return true;
    }
    case MetricValue_Tag::kLongValue: {

      return true;
    }
    case MetricValue_Tag::kIntValue: {

      return true;
    }
    case MetricValue_Tag::kDoubleValue: {

      return true;
    }
    case MetricValue_Tag::kRawStrValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_raw_str_value, 5, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& raw_str_value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_raw_str_value, validation_context,
                                             &raw_str_value_validate_params)) {
        return false;
      }
      return true;
    }
    case MetricValue_Tag::kBoolValue: {

      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MetricValue");
      return false;
    }
  }
}


// static
bool Event_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 32 },
    { 1, 48 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Event_Data* object =
      static_cast<const Event_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->project_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& project_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->project_name, validation_context,
                                         &project_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_name, validation_context,
                                         &event_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metrics, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->metrics, validation_context,
                                         &metrics_validate_params)) {
    return false;
  }
  if (object->header_.version < 1)
    return true;

  if (!mojo::internal::ValidateStruct(object->system_uptime, validation_context))
    return false;

  return true;
}

Event_Data::Event_Data()
    : header_({sizeof(*this), 1}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace structured
}  // namespace metrics