// components/metrics/structured/mojom/event.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_SEND_VALIDATION_H_

#include "components/metrics/structured/mojom/event.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "components/metrics/structured/mojom/event.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::metrics::structured::mojom::EventDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::metrics::structured::mojom::EventDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::metrics::structured::mojom::internal::Event_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::project_name(input)) in_project_name = Traits::project_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->project_name)::BaseType> project_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_project_name,
        project_name_fragment);

      fragment->project_name.Set(
          project_name_fragment.is_null() ? nullptr : project_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->project_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null project_name in Event struct");

      decltype(Traits::event_name(input)) in_event_name = Traits::event_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_name)::BaseType> event_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_event_name,
        event_name_fragment);

      fragment->event_name.Set(
          event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_name in Event struct");

      decltype(Traits::metrics(input)) in_metrics = Traits::metrics(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metrics)::BaseType>
          metrics_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::metrics::structured::mojom::MetricValueDataView>, send_validation>(
        in_metrics,
        metrics_fragment,
        &metrics_validate_params);

      fragment->metrics.Set(
          metrics_fragment.is_null() ? nullptr : metrics_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->metrics.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metrics in Event struct");

      decltype(Traits::system_uptime(input)) in_system_uptime = Traits::system_uptime(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->system_uptime)::BaseType> system_uptime_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_system_uptime,
        system_uptime_fragment);

      fragment->system_uptime.Set(
          system_uptime_fragment.is_null() ? nullptr : system_uptime_fragment.data());

      fragment->is_event_sequence = Traits::is_event_sequence(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::metrics::structured::mojom::MetricValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::metrics::structured::mojom::MetricValueDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::metrics::structured::mojom::internal::MetricValue_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::metrics::structured::mojom::MetricValueDataView::Tag::kHmacValue: {
    decltype(Traits::hmac_value(input))
    in_hmac_value = Traits::hmac_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_hmac_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_hmac_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null hmac_value in MetricValue union");
    fragment->data.f_hmac_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::metrics::structured::mojom::MetricValueDataView::Tag::kLongValue: {
    decltype(Traits::long_value(input))
    in_long_value = Traits::long_value(input);
    fragment->data.f_long_value = in_long_value;
    break;
  }
  case ::metrics::structured::mojom::MetricValueDataView::Tag::kIntValue: {
    decltype(Traits::int_value(input))
    in_int_value = Traits::int_value(input);
    fragment->data.f_int_value = in_int_value;
    break;
  }
  case ::metrics::structured::mojom::MetricValueDataView::Tag::kDoubleValue: {
    decltype(Traits::double_value(input))
    in_double_value = Traits::double_value(input);
    fragment->data.f_double_value = in_double_value;
    break;
  }
  case ::metrics::structured::mojom::MetricValueDataView::Tag::kRawStrValue: {
    decltype(Traits::raw_str_value(input))
    in_raw_str_value = Traits::raw_str_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_raw_str_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_raw_str_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null raw_str_value in MetricValue union");
    fragment->data.f_raw_str_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::metrics::structured::mojom::MetricValueDataView::Tag::kBoolValue: {
    decltype(Traits::bool_value(input))
    in_bool_value = Traits::bool_value(input);
    fragment->data.f_bool_value = in_bool_value;
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_METRICS_STRUCTURED_MOJOM_EVENT_MOJOM_SEND_VALIDATION_H_