// components/metrics/private_metrics/mojom/private_metrics_interface.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_PRIVATE_METRICS_MOJOM_PRIVATE_METRICS_INTERFACE_MOJOM_H_
#define COMPONENTS_METRICS_PRIVATE_METRICS_MOJOM_PRIVATE_METRICS_INTERFACE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/metrics/private_metrics/mojom/private_metrics_interface.mojom-features.h"  // IWYU pragma: export
#include "components/metrics/private_metrics/mojom/private_metrics_interface.mojom-shared.h"  // IWYU pragma: export
#include "components/metrics/private_metrics/mojom/private_metrics_interface.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace metrics::private_metrics::mojom {








class  PrivateMetricsEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrivateMetricsEntry, T>::value>;
  using DataView = PrivateMetricsEntryDataView;
  using Data_ = internal::PrivateMetricsEntry_Data;
  using Type = PrivateMetricsEntry_Type;

  template <typename... Args>
  static PrivateMetricsEntryPtr New(Args&&... args) {
    return PrivateMetricsEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrivateMetricsEntryPtr From(const U& u) {
    return mojo::TypeConverter<PrivateMetricsEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrivateMetricsEntry>::Convert(*this);
  }


  PrivateMetricsEntry();

  PrivateMetricsEntry(
      uint64_t event_hash,
      std::optional<uint64_t> content_hash,
      std::optional<uint64_t> source_id,
      const base::flat_map<std::string, bool>& studies_of_interest,
      const base::flat_map<uint64_t, int64_t>& metrics,
      PrivateMetricsEntry::Type type);


  ~PrivateMetricsEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrivateMetricsEntryPtr>
  PrivateMetricsEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrivateMetricsEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrivateMetricsEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrivateMetricsEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateMetricsEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateMetricsEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrivateMetricsEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrivateMetricsEntry_UnserializedMessageContext<
            UserType, PrivateMetricsEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrivateMetricsEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrivateMetricsEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrivateMetricsEntry_UnserializedMessageContext<
            UserType, PrivateMetricsEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrivateMetricsEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t event_hash;
  
  std::optional<uint64_t> content_hash;
  
  std::optional<uint64_t> source_id;
  
  base::flat_map<std::string, bool> studies_of_interest;
  
  base::flat_map<uint64_t, int64_t> metrics;
  
  PrivateMetricsEntry::Type type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrivateMetricsEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrivateMetricsEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrivateMetricsEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrivateMetricsEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PrivateMetricsEntryPtr PrivateMetricsEntry::Clone() const {
  return New(
      mojo::Clone(event_hash),
      mojo::Clone(content_hash),
      mojo::Clone(source_id),
      mojo::Clone(studies_of_interest),
      mojo::Clone(metrics),
      mojo::Clone(type)
  );
}

template <typename T, PrivateMetricsEntry::EnableIfSame<T>*>
bool PrivateMetricsEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->event_hash, other_struct.event_hash))
    return false;
  if (!mojo::Equals(this->content_hash, other_struct.content_hash))
    return false;
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->studies_of_interest, other_struct.studies_of_interest))
    return false;
  if (!mojo::Equals(this->metrics, other_struct.metrics))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, PrivateMetricsEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.event_hash < rhs.event_hash)
    return true;
  if (rhs.event_hash < lhs.event_hash)
    return false;
  if (lhs.content_hash < rhs.content_hash)
    return true;
  if (rhs.content_hash < lhs.content_hash)
    return false;
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.studies_of_interest < rhs.studies_of_interest)
    return true;
  if (rhs.studies_of_interest < lhs.studies_of_interest)
    return false;
  if (lhs.metrics < rhs.metrics)
    return true;
  if (rhs.metrics < lhs.metrics)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}


}  // metrics::private_metrics::mojom

namespace mojo {


template <>
struct  StructTraits<::metrics::private_metrics::mojom::PrivateMetricsEntry::DataView,
                                         ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr> {
  static bool IsNull(const ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr& input) { return !input; }
  static void SetToNull(::metrics::private_metrics::mojom::PrivateMetricsEntryPtr* output) { output->reset(); }

  static decltype(::metrics::private_metrics::mojom::PrivateMetricsEntry::event_hash) event_hash(
      const ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr& input) {
    return input->event_hash;
  }

  static decltype(::metrics::private_metrics::mojom::PrivateMetricsEntry::content_hash) content_hash(
      const ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr& input) {
    return input->content_hash;
  }

  static decltype(::metrics::private_metrics::mojom::PrivateMetricsEntry::source_id) source_id(
      const ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr& input) {
    return input->source_id;
  }

  static const decltype(::metrics::private_metrics::mojom::PrivateMetricsEntry::studies_of_interest)& studies_of_interest(
      const ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr& input) {
    return input->studies_of_interest;
  }

  static const decltype(::metrics::private_metrics::mojom::PrivateMetricsEntry::metrics)& metrics(
      const ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr& input) {
    return input->metrics;
  }

  static decltype(::metrics::private_metrics::mojom::PrivateMetricsEntry::type) type(
      const ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr& input) {
    return input->type;
  }

  static bool Read(::metrics::private_metrics::mojom::PrivateMetricsEntry::DataView input, ::metrics::private_metrics::mojom::PrivateMetricsEntryPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_METRICS_PRIVATE_METRICS_MOJOM_PRIVATE_METRICS_INTERFACE_MOJOM_H_