// components/metrics/dwa/mojom/dwa_interface.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_SHARED_H_
#define COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/metrics/dwa/mojom/dwa_interface.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/metrics/dwa/mojom/dwa_interface.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::metrics::dwa::mojom::DwaEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::metrics::dwa::mojom::DwaEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::metrics::dwa::mojom::internal::DwaEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->event_hash = Traits::event_hash(input);

    fragment->content_hash = Traits::content_hash(input);

    decltype(Traits::studies_of_interest(input)) in_studies_of_interest = Traits::studies_of_interest(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->studies_of_interest)::BaseType>
        studies_of_interest_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& studies_of_interest_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, bool>>(
      in_studies_of_interest,
      studies_of_interest_fragment,
      &studies_of_interest_validate_params);

    fragment->studies_of_interest.Set(
        studies_of_interest_fragment.is_null() ? nullptr : studies_of_interest_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->studies_of_interest.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null studies_of_interest in DwaEntry struct");

    decltype(Traits::metrics(input)) in_metrics = Traits::metrics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metrics)::BaseType>
        metrics_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint64_t, int64_t>>(
      in_metrics,
      metrics_fragment,
      &metrics_validate_params);

    fragment->metrics.Set(
        metrics_fragment.is_null() ? nullptr : metrics_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->metrics.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metrics in DwaEntry struct");
  }

  static bool Deserialize(::metrics::dwa::mojom::internal::DwaEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::metrics::dwa::mojom::DwaEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace metrics::dwa::mojom {

inline void DwaEntryDataView::GetStudiesOfInterestDataView(
    mojo::MapDataView<mojo::StringDataView, bool>* output) {
  auto pointer = data_->studies_of_interest.Get();
  *output = mojo::MapDataView<mojo::StringDataView, bool>(pointer, message_);
}
inline void DwaEntryDataView::GetMetricsDataView(
    mojo::MapDataView<uint64_t, int64_t>* output) {
  auto pointer = data_->metrics.Get();
  *output = mojo::MapDataView<uint64_t, int64_t>(pointer, message_);
}



}  // metrics::dwa::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_METRICS_DWA_MOJOM_DWA_INTERFACE_MOJOM_SHARED_H_