// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"chrome://resources/cr_elements/cr_tab_box/cr_tab_box.js";import"./field_trials.js";import"./private_metrics.js";import{assert}from"chrome://resources/js/assert.js";import{addWebUiListener}from"chrome://resources/js/cr.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{getTemplate}from"./app.html.js";import{MetricsInternalsBrowserProxyImpl}from"./browser_proxy.js";import{getEventsPeekString,logEventToString,sizeToString,timestampToString,umaLogTypeToString}from"./log_utils.js";const EMPTY_LOG={type:"N/A",hash:"N/A",timestamp:"",size:-1,events:[]};const VALUE_LENGTH_LIMIT=64;export class MetricsInternalsAppElement extends CustomElement{static get is(){return"metrics-internals-app"}static get template(){return getTemplate()}initPromise;browserProxy_=MetricsInternalsBrowserProxyImpl.getInstance();previousVariationsSummaryData_="";previousUmaSummaryData_="";constructor(){super();this.initPromise=this.init_()}getUmaLogsExportContent(){return this.browserProxy_.getUmaLogData(true)}async init_(){this.syncTabsWithUrlHash_();await this.updateVariationsSummary_();setInterval((()=>this.updateVariationsSummary_()),3e3);await this.updateStoredSeedInfo_("Latest");const fetchStoredLatestSeedInfoButton=this.getRequiredElement("#fetch-stored-latest-seed-info");assert(fetchStoredLatestSeedInfoButton);fetchStoredLatestSeedInfoButton.addEventListener("click",(()=>this.updateStoredSeedInfo_("Latest")));await this.updateStoredSeedInfo_("Safe");const fetchStoredSafeSeedInfoButton=this.getRequiredElement("#fetch-stored-safe-seed-info");assert(fetchStoredSafeSeedInfoButton);fetchStoredSafeSeedInfoButton.addEventListener("click",(()=>this.updateStoredSeedInfo_("Safe")));await this.updateUmaSummary_();setInterval((()=>this.updateUmaSummary_()),3e3);const umaTableCaption=this.getRequiredElement("#uma-table-caption");const isUsingMetricsServiceObserver=await this.browserProxy_.isUsingMetricsServiceObserver();let firstPartOfCaption=isUsingMetricsServiceObserver?"List of all UMA logs closed since browser startup.":"List of UMA logs closed since opening this page. Starting the browser         with the --export-uma-logs-to-file command line flag will instead show         all logs closed since browser startup.";firstPartOfCaption+=" See ";const linkInCaptionNode=document.createElement("a");linkInCaptionNode.appendChild(document.createTextNode("documentation"));linkInCaptionNode.href="https://chromium.googlesource.com/chromium/src/components/metrics/+/HEAD/debug/README.md";linkInCaptionNode.target="_blank";const secondPartOfCaption=" for more information about this debug page and tools for working          with the exported logs.";umaTableCaption.appendChild(document.createTextNode(firstPartOfCaption));umaTableCaption.appendChild(linkInCaptionNode);umaTableCaption.appendChild(document.createTextNode(secondPartOfCaption));addWebUiListener("uma-log-created-or-event",(()=>this.updateUmaLogsData_()));await this.updateUmaLogsData_();const exportUmaLogsButton=this.getRequiredElement("#export-uma-logs");exportUmaLogsButton.addEventListener("click",(()=>this.exportUmaLogs_()));if(!loadTimeData.getBoolean("enablePrivateMetricsTab")){this.getRequiredElement("#private-metrics-tab").style.display="none";this.getRequiredElement("#private-metrics-panel").style.display="none"}}syncTabsWithUrlHash_(){const tabUrlHashes=["#uma","#variations","#field-trials","#private-metrics"];const tabBox=this.shadowRoot.querySelector("cr-tab-box");tabBox.addEventListener("selected-index-change",(e=>{window.location.hash=tabUrlHashes[e.detail]||""}));if(window.location.hash.startsWith("#")){const entryIndex=tabUrlHashes.indexOf(window.location.hash);if(entryIndex>=0){tabBox.setAttribute("selected-index",String(entryIndex))}}}toggleEventsExpand_(e){let umaLogEventsDiv=e.target;while(!umaLogEventsDiv.classList.contains("uma-log-events")){umaLogEventsDiv=umaLogEventsDiv.parentElement}umaLogEventsDiv.classList.toggle("uma-log-events-expanded")}updateSummaryTable_(tableBody,summary){tableBody.replaceChildren();const template=this.getRequiredElement("#summary-row-template");for(const info of summary){const row=template.content.cloneNode(true);const[key,value]=row.querySelectorAll("td");assert(key);key.textContent=info.key;assert(value);value.textContent=info.value;tableBody.appendChild(row)}}updateSeedInfoTable_(tableBody,summary){tableBody.replaceChildren();const template=this.getRequiredElement("#seed-info-row-template");for(const info of summary){const row=template.content.cloneNode(true);const[key,value,copy]=row.querySelectorAll("td");assert(key);key.textContent=info.key;assert(value);if(info.value.length>VALUE_LENGTH_LIMIT){value.textContent=info.value.substring(0,VALUE_LENGTH_LIMIT)+"..."}else{value.textContent=info.value}assert(copy);const copyButton=copy.querySelector("button");assert(copyButton);copyButton.addEventListener("click",(()=>{navigator.clipboard.writeText(info.value)}));tableBody.appendChild(row)}}async updateVariationsSummary_(){const summary=await this.browserProxy_.fetchVariationsSummary();const newDataString=summary.toString();if(newDataString===this.previousVariationsSummaryData_){return}this.previousVariationsSummaryData_=newDataString;const variationsSummaryTableBody=this.getRequiredElement("#variations-summary-body");this.updateSummaryTable_(variationsSummaryTableBody,summary)}async updateStoredSeedInfo_(seedType){const seedTypeKey=seedType.toLowerCase();const refreshButton=this.getRequiredElement(`#fetch-stored-${seedTypeKey}-seed-info`);assert(refreshButton);refreshButton.setAttribute("disabled","");const storedSeedInfo=await this.browserProxy_.fetchStoredSeedInfo(seedType);const storedSeedInfoTableBody=this.getRequiredElement(`#stored-${seedTypeKey}-seed-info-body`);this.updateSeedInfoTable_(storedSeedInfoTableBody,storedSeedInfo);refreshButton.removeAttribute("disabled")}async updateUmaSummary_(){const summary=await this.browserProxy_.fetchUmaSummary();const umaSummaryTableBody=this.$("#uma-summary-body");const newDataString=summary.toString();if(newDataString===this.previousUmaSummaryData_){return}this.previousUmaSummaryData_=newDataString;this.updateSummaryTable_(umaSummaryTableBody,summary)}updateLogsTable_(tableBody,logs){tableBody.replaceChildren();const template=this.getRequiredElement("#uma-log-row-template");for(const log of logs.slice(0).reverse()){const row=template.content.cloneNode(true);const[type,hash,timestamp,size,events]=row.querySelectorAll("td");assert(type);type.textContent=umaLogTypeToString(log.type);assert(hash);hash.textContent=log.hash;assert(timestamp);timestamp.textContent=timestampToString(log.timestamp);assert(size);size.textContent=sizeToString(log.size);assert(events);const eventsPeekDiv=events.querySelector(".uma-log-events-peek");assert(eventsPeekDiv);eventsPeekDiv.addEventListener("click",this.toggleEventsExpand_,false);const eventsPeekText=events.querySelector(".uma-log-events-peek-text");assert(eventsPeekText);eventsPeekText.textContent=getEventsPeekString(log.events);const eventsText=events.querySelector(".uma-log-events-text");assert(eventsText);for(const event of log.events.slice(0).reverse()){const div=document.createElement("div");div.textContent=logEventToString(event);eventsText.appendChild(div)}tableBody.appendChild(row)}}async updateUmaLogsData_(){const logsData=await this.browserProxy_.getUmaLogData(false);const logs=JSON.parse(logsData);if(!logs.logs.length){logs.logs=[EMPTY_LOG]}const umaLogsTableBody=this.getRequiredElement("#uma-logs-body");this.updateLogsTable_(umaLogsTableBody,logs.logs)}async exportUmaLogs_(){const logsData=await this.getUmaLogsExportContent();const file=new Blob([logsData],{type:"text/plain"});const a=document.createElement("a");a.href=URL.createObjectURL(file);a.download=`uma_logs_${(new Date).getTime()}.json`;a.click()}}customElements.define(MetricsInternalsAppElement.is,MetricsInternalsAppElement);